<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Antoine Angnieux <aangenieux@clever-age.com>                |
// +----------------------------------------------------------------------+
//
// Base class for Document business persistence abstraction.
//

if (defined("_BD_DOCUMENT")) return;
    define("_BD_DOCUMENT", "1");

require_once "PEAR.php";
require_once "DB.php";

require_once dirname(__FILE__)."/metier.php";

//Clever-Age Maciek: non, on ne se sert plus des filtres, on passe par BD_Metier instead
//require_once dirname(__FILE__)."/../../inc_filtres.php3";
//require_once dirname(__FILE__)."/../../inc_meta.php3";

define("DOCUMENTS_ALL_FIELDS", " id_document, id_vignette, id_type, titre, date_heure, descriptif, fichier, taille, "
                            ."largeur, hauteur, mode_spip, inclus, maj ");

/**
 * BD_document is a base class for document business persistence abstraction implementations, and must be
 * inherited by all such.
 * @package	BD
 * @author  Antoine Angnieux <aangenieux@clever-age.com>
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @access	public
 */
class BD_document extends BD_metier {

    // {{{ properties

    /**
     * Document ID.
     * @var     int
     * @access  private
     */
    var $_documentId;

    /**
     * Vignette ID.
     * @var     int
     * @access  private
     */
    var $_vignetteId;

    /**
     * Type ID.
     * @var     int
     * @access  private
     */
    var $_typeId;

    /**
     * Title.
     * @var     String
     * @access  private
     */
    var $_titre;

    /**
     * Date.
     * @var     Date
     * @access  private
     */
    var $_date;

    /**
     * Abstract.
     * @var     String
     * @access  private
     */
    var $_descriptif;

    /**
     * File name.
     * @var     String
     * @access  private
     */
    var $_fichier;
    
    /**
     * Le contenu du fichier. 
     * Initialisation tardive (a la demande uniquement).
     * @var     array
     * @access  private
     */
     var $_fichierContenu;

    /**
     * Size.
     * @var     int
     * @access  private
     */
    var $_taille;

    /**
     * Width.
     * @var     int
     * @access  private
     */
    var $_largeur;

    /**
     * Height.
     * @var     int
     * @access  private
     */
    var $_hauteur;

    /**
     * Mode.
     * @var     String
     * @access  private
     */
    var $_mode;

    /**
     * Included.
     * @var     String
     * @access  private
     */
    var $_inclus;

    /**
     * Update date.
     * @var     Date
     * @access  private
     */
    var $_maj;

    /**
     * Document extension.
     * @var     Date
     * @access  private
     */
    var $_extension;

    // }}}

    // {{{ factory()
    function &factory($dbParameters = null, $dbOptions = null) {
        if(file_exists(dirname(__FILE__)."/".$dbParameters->_dbEngine."/document_".$dbParameters->_dbEngine.".php") == false) {
            include_once(dirname(__FILE__)."/common/document_common.php");
            $classname = "BD_document_common";
        }
        else {
            include_once(dirname(__FILE__)."/".$dbParameters->_dbEngine."/document_".$dbParameters->_dbEngine.".php");
            $classname = "BD_document_".$dbParameters->_dbEngine;
        }
        if (!class_exists($classname)) {
            return PEAR::raiseError("Cannot instanciate class $classname", null,
                                    null, null, null, null, false);
        }

        $obj =& new $classname;
        $result = $obj->setDbParameters($dbParameters);
        if ($dbOptions != null) {
            $obj->setDbOptions($dbOptions);
        }
        if (PEAR::isError($result)) {
            return $result;
        } else {
            return $obj;
        }
    }

    // }}}

    // {{{ constructor

    /**
     * DB_document constructor.
     *
     * @access public
     */

    function BD_document() {
    }

    // }}}

    // {{{ getDocumentId()

    /**
     * Returns the Document ID
     * @return  int
     * @access  public
     */

    function getDocumentId() {
        return $this->_documentId;
    }

    // }}}

    // {{{ setDocumentId()

    /**
     * Sets the Document ID
     * @param   int
     * @access  public
     */

    function setDocumentId($documentId) {
        $this->_documentId = $documentId;
    }

    // }}}

    // {{{ getDocumentId()

    /**
     * Returns the Vignette ID
     * @return  int
     * @access  public
     */

    function getVignetteId() {
        return $this->_vignetteId;
    }

    // }}}

    // {{{ setVignetteId()

    /**
     * Sets the Vignette ID
     * @param   int
     * @access  public
     */

    function setVignetteId($vignetteId) {
        $this->_vignetteId = $vignetteId;
    }

    // }}}

    // {{{ getTypeId()

    /**
     * Returns the Type ID
     * @return  int
     * @access  public
     */

    function getTypeId() {
        return $this->_typeId;
    }

    // }}}

    // {{{ setTypeId()

    /**
     * Sets the Type ID
     * @param   int
     * @access  public
     */

    function setTypeId($typeId) {
        $this->_typeId = $typeId;
    }

    // }}}

    // {{{ getTitre()

    /**
     * Returns the document title
     * @return  String
     * @access  public
     */

    function getTitre() {
        return $this->_titre;
    }

    // }}}

    // {{{ setTitre()

    /**
     * Sets the document title
     * @param   String
     * @access  public
     */

    function setTitre($titre) {
        $this->_titre = $this->corriger_caracteres($titre);
    }

    // }}}

    // {{{ getDate()

    /**
     * Returns the document date
     * @return  Date
     * @access  public
     */

    function getDate() {
        return $this->_date;
    }

    // }}}

    // {{{ setDate()

    /**
     * Sets the document date
     * @param   Date
     * @access  public
     */

    function setDate($date) {
        $this->_date = $date;
    }

    // }}}

    // {{{ getDescriptif()

    /**
     * Returns the document abstract
     * @return  String
     * @access  public
     */

    function getDescriptif() {
        return $this->_descriptif;
    }

    // }}}

    // {{{ setDescriptif()

    /**
     * Sets the document abstract
     * @param   String
     * @access  public
     */

    function setDescriptif($descriptif) {
        $this->_descriptif = $this->corriger_caracteres($descriptif);
    }

    // }}}

    // {{{ getFichier()

    /**
     * Returns the document file
     * @return  String
     * @access  public
     */

    function getFichier() {
        return $this->_fichier;
    }

    // }}}

    // {{{ setFichier()

    /**
     * Sets the document file
     * @param   String
     * @access  public
     */

    function setFichier($fichier) {
        $this->_fichier = $this->corriger_caracteres($fichier);
    }

    // }}}

    // {{{ getFichierContenu()

    /**
     * Returns the array corresponing to the content
     * of the file referenced by this object or the 
     * "FALSE" in the case of failure.
     * This function supposes that the object
     * is already initialised with the correct data
     * (namely the file name)
     * @return  array
     * @access  public
     */

    function getFichierContenu() {
        if (isset($this->_fichierContenu))
            return $this->_fichierContenu;


        //on traite tous les fichiers "binairement"
        $fic = dirname(__FILE__)."/../../../".$this->_fichier;
        $fp   = fopen($fic, 'rb');
        if (!is_resource($fp))
        {
            return FALSE;
        }
        $this->_fichierContenu = fread($fp, $this->_taille);
        return $this->_fichierContenu;
    }

    // }}}

    // {{{ setFichierContenu()

    /**
     * Sets the document file content
     * @param   String
     * @access  public
     */

    function setFichierContenu($fichierContenu) {
        $this->_fichierContenu = $fichierContenu;
        $this->_taille = strlen($fichierContenu);
    }

    // }}}
    
    // {{{ getFichierContenu()

    /**
     * Returns the array corresponing to the content
     * of the file referenced by this object or the 
     * "FALSE" in the case of failure.
     * This function supposes that the object
     * is already initialised with the correct data
     * (namely the file name)
     * @return  array
     * @access  public
     */

    function getFichierContenuBase64() {
        $this->getFichierContenu();
        if (isset($this->_fichierContenu))
            return chunk_split(base64_encode($this->_fichierContenu));
        else
            return FALSE;
    }

    // }}}

    // {{{ setFichierContenu()

    /**
     * Sets the document file content. No verification is performed,
     * the data must be correctly encoded into base64
     * @param   String
     * @access  public
     */
    function setFichierContenuBase64($fichierContenuBase64) {
        $this->setFichierContenu(base64_decode($fichierContenuBase64));
    }

    // }}}
    
    
    // {{{ getTaille()

    /**
     * Returns the document file size
     * @return  int
     * @access  public
     */

    function getTaille() {
        return $this->_taille;
    }

    // }}}

    // {{{ setTaille()

    /**
     * Sets the document file size
     * @param   int
     * @access  public
     */

    function setTaille($taille) {
        $this->_taille = $taille;
    }

    // {{{ getDate()

    /**
     * Returns the document width
     * @return  int
     * @access  public
     */

    function getLargeur() {
        return $this->_largeur;
    }

    // }}}

    // {{{ setLargeur()

    /**
     * Sets the document width
     * @param   int
     * @access  public
     */

    function setLargeur($largeur) {
        $this->_largeur = $largeur;
    }

    // {{{ getHauteur()

    /**
     * Returns the document height
     * @return  int
     * @access  public
     */

    function getHauteur() {
        return $this->_hauteur;
    }

    // }}}

    // {{{ setHauteur()

    /**
     * Sets the document height
     * @param   int
     * @access  public
     */

    function setHauteur($hauteur) {
        $this->_hauteur = $hauteur;
    }

    // {{{ getMode()

    /**
     * Returns the document mode
     * @return  String
     * @access  public
     */

    function getMode() {
        return $this->_mode;
    }

    // }}}

    // {{{ setMode()

    /**
     * Sets the document mode
     * @param   String
     * @access  public
     */

    function setMode($mode) {
        if($mode == 'vignette' OR $mode == 'document')
            $this->_mode = $mode;
        else
            $this->_mode = 'vignette';
    }

    // {{{ getInclus()

    /**
     * Returns included
     * @return  String
     * @access  public
     */

    function getInclus() {
        return $this->_inclus;
    }

    // }}}

    // {{{ setInclus()

    /**
     * Sets included
     * @param   String
     * @access  public
     */

    function setInclus($inclus) {
        $this->_inclus = $inclus;
    }

    // {{{ getDate()

    /**
     * Returns the document update date
     * @return  Date
     * @access  public
     */

    function getMaj() {
        return $this->_maj;
    }

    // }}}

    // {{{ setMaj()

    /**
     * Sets the document update date
     * @param   Date
     * @access  public
     */

    function setMaj($maj) {
        $this->_maj = $maj;
    }


    // {{{ create()

    function create() {
        $db = &$this->_getDB();
        $string_prefix = $GLOBALS['table_prefix']."_documents";
        $documentId = $db->nextId($string_prefix, true);
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_document : create()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $this->_documentId = $documentId;

        /*
        if ($this->_date == "NOW()") $dateValue = "NOW()"; else $dateValue = "'".$db->quoteString($this->_date)."'";
        */

        if ($this->_vignetteId == null) $this->_vignetteId = 0;
        if ($this->_typeId == null) $this->_typeId = 0;
        if ($this->_taille == null) $this->_taille = 0;
        if ($this->_largeur == null) $this->_largeur = 0;
        if ($this->_hauteur == null) $this->_hauteur = 0;
	if ($this->_descriptif == null) $this->_descriptif = '';

        $maDate = new Date();
	    $this->setDate($maDate->getDate(DATE_FORMAT_ISO));

        $query = "INSERT INTO ".$GLOBALS['table_prefix']."_documents (".DOCUMENTS_ALL_FIELDS.") VALUES "
                ."(".$this->_documentId.", "
                .$this->_vignetteId.", "
                .$this->_typeId.", "
                ."'".$db->quoteString($this->_titre)."', "
                ."'".$db->quoteString($this->_date)."', "
                ."'".$db->quoteString($this->_descriptif)."', "
                ."'".$db->quoteString($this->_fichier)."', "
                .$this->_taille.", "
                .$this->_largeur.", "
                .$this->_hauteur.", "
                ."'".$db->quoteString($this->_mode)."', "
                ."'".$db->quoteString($this->_inclus)."', "
                ."'".$db->quoteString($this->_maj)."')";


         
         
        //echo "<br>$query<br>";
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_document : create()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ update()

    function update() {
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_document : update()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        $maDate = new Date();
	    $this->setMaj($maDate->getDate(DATE_FORMAT_ISO));

        if ($this->_vignetteId == null) $this->_vignetteId = 0;
        if ($this->_typeId == null) $this->_typeId = 0;
        if ($this->_taille == null) $this->_taille = 0;
        if ($this->_largeur == null) $this->_largeur = 0;
        if ($this->_hauteur == null) $this->_hauteur = 0;

        $query = "UPDATE ".$GLOBALS['table_prefix']."_documents "
                ."SET id_vignette = ".$this->_vignetteId.", "
                ."id_type = ".$this->_typeId.", titre = '".$db->quoteString($this->_titre)."', "
                ."date_heure = '".$db->quoteString($this->_date)."', "
                ."descriptif = '".$db->quoteString($this->_descriptif)."', fichier = '".$db->quoteString($this->_fichier)."', "
                ."taille = ".$this->_taille.", largeur = ".$this->_largeur.", "
                ."hauteur = ".$this->_hauteur.", mode_spip = '".$db->quoteString($this->_mode)."', "
                ."inclus = '".$db->quoteString($this->_inclus)."', maj = '".$db->quoteString($this->_maj)."' "
                ."WHERE id_document = ".$this->_documentId;

        //echo "<br>$query";

         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_document : update()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

    }

    // }}}

    // {{{ load()

    function load($idDocument) {
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_document : load()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT".DOCUMENTS_ALL_FIELDS."FROM ".$GLOBALS['table_prefix']."_documents WHERE id_document = $idDocument";
        //echo "<br>$query<br>";
         
        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_document : load()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
            if ($row = $result->fetchRow()) {

                $maDate = new Date($row['maj']);
                $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);                
                $this->_fetchData($row);
            } else {
                return PEAR::raiseError("[".get_class($this).": load($idDocument)] Aucun document ne correspond  cet ID!", null,
                                    null, null, null, null, false);
            }
            $result->free();
        }
    }

    // }}}

    // {{{ delete()

    function delete($idDocument) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_document : delete()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_documents WHERE id_document = $idDocument";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_document : delete()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ _fetchData()

    /**
     * This method fetches a resultset row into the current instance
     *
     * @param   $row    resultset row
     * @access  private
     */
    function _fetchData($row) {
        $this->setDocumentId($row['id_document']);
        $this->setVignetteId($row['id_vignette']);
        $this->setTypeId($row['id_type']);
        $this->setTitre($row['titre']);
        $this->setDate($row['date_heure']);
        $this->setDescriptif($row['descriptif']);
        $this->setFichier($row['fichier']);
        $this->setTaille($row['taille']);
        $this->setLargeur($row['largeur']);
        $this->setHauteur($row['hauteur']);
        $this->setMode($row['mode_spip']);
        $this->setInclus($row['inclus']);
        $this->setMaj($row['maj']);
    }

    // }}}

    // {{{ deleteMajDate($majdate)

    /**
     * This method is used to delete all documents former to mydate
     * @param $mydate
     * @access  public
     */


    function deleteMajDate($mydate) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_document : deleteMajDate()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $dateTmp = new Date($mydate);
        $mydate = $dateTmp->getDate(DATE_FORMAT_ISO);

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_documents WHERE maj < '$mydate'";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_document : deleteMajDate()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ deleteLink($link, $id_objet)

    /**
     * This method is used to delete a specific document.
     *
     * @return Array of Forum
     * @param $link  represents the object attached to document $id_objet
     * @param $id_objet  represents the document to delete
     * @access public
     */

    function deleteLink($link, $id_objet) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_document : deleteLink()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_documents_".$link."s WHERE id_".$link."=$id_objet";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_document : deleteLink()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ linkToObject()

    /**
     * This method links a document to an article
     *
     * @param   $idArticle  id of the article to which the document must be linked
     * @return  mixed       void if OK, PEAR::Error otherwise
     * @access  public
     */
    function linkToObject($objectId, $type) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_document : linkToObject()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "INSERT INTO ".$GLOBALS['table_prefix']."_documents_".$type."s (id_document, id_$type) VALUES (".$this->_documentId.", $objectId)";
         
        //echo '<br>' . $query . '<br>';
        $result = $db->query($query);


        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_document : linkToObject".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ unlinkVignette()

    /**
     * This method unlink all documents using the vignette which ID is passed
     *
     * @param   int $idVignette of vignette to unlink
     * @return  mixed void if OK, PEAR::Error otherwise
     * @access  public
     */
    function unlinkVignette($idVignette) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_document : unlinkVignette()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "UPDATE ".$GLOBALS['table_prefix']."_documents SET id_vignette=0 WHERE id_vignette=$idVignette";
         
        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_document : unlinkVignette()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

    }


    // }}}

    // {{{ unlinkAll()

    /**
     * This method deletes all link to the current document (rubrique, article, breve)
     *
     * @return  mixed void if OK, PEAR::Error otherwise
     * @access  public
     */
    function unlinkAll() {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_document : unlinkAll()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_documents_articles WHERE id_document=".$this->_documentId;
         
        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_document : unlinkAll()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_documents_rubriques WHERE id_document=".$this->_documentId;
         
        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_document : unlinkAll()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_documents_breves WHERE id_document=".$this->_documentId;
         
        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_document : unlinkAll()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ updateInclusForDocumentIds($inclus, $ze_docs)

    /**
     * This method updates include value to the list of document
     *
     * @return  mixed void if OK, PEAR::Error otherwise
     * @access  public
     */
    function updateInclusForDocumentIds($inclus, $ze_docs) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_document : updateInclusForDocumentIds()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "UPDATE ".$GLOBALS['table_prefix']."_documents SET inclus='$inclus' WHERE id_document IN ($ze_docs)";
         
        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_document : updateInclusForDocumentIds()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ getAllDocumentRubrique($documentId = null, $coll = null)

    /**
     * This method creates an array of document attached to a heading
     *
     * param  $documentId  id of the document which the document must be attached
     * param  $coll  id of the heading which the document must be attached
     * @return  Array   wished array
     * @access  public
     */

    function getAllDocumentRubrique($documentId = null, $coll = null) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_document : getAllDocumentRubrique()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT * FROM ".$GLOBALS['table_prefix']."_documents_rubriques";
        if($documentId != null && $coll != null) $query .= " WHERE id_document=$documentId AND id_rubrique=$coll";
         
        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_document : getAllDocumentRubrique()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $result->fetchRow()) {
            $documents[] = $row;
        }

        $result->free();

        return $documents;
    }

    // }}}

    // {{{ getAllDocumentArticle($documentId = null, $coll = null)

    /**
     * This method creates an array of document attached to an Article
     *
     * param  $documentId  id of the document which the document must be attached
     * param  $coll  id of the article which the document must be attached
     * @return  Array   wished array
     * @access  public
     */

    function getAllDocumentArticle($documentId = null, $coll = null) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_document : getAllDocumentArticle()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT * FROM ".$GLOBALS['table_prefix']."_documents_articles";
        if($documentId != null && $coll != null) $query .= " WHERE id_document=$documentId AND id_article=$coll";
         
        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_document : getAllDocumentArticle()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $result->fetchRow()) {
            $documents[] = $row;
        }

        $result->free();

        return $documents;
    }

    // }}}

    // {{{ getAlldocumentIdsForArticleId($articleId)

    /**
     * This method creates an array of document Ids attached to an article
     *
     * param  $articleId  id of the article which documents must be attached
     * @return  Array   wished array of document Ids
     * @access  public
     */

    function getAlldocumentIdsForArticleId($articleId) {
        $documentIds = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_document : getAlldocumentIdsForArticleId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT docs.id_document FROM ".$GLOBALS['table_prefix']."_documents docs, ".$GLOBALS['table_prefix']."_documents_articles lien WHERE lien.id_article=$articleId AND lien.id_document=docs.id_document";
         
        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_document : getAlldocumentIdsForArticleId()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $result->fetchRow()) {    $documentIds[] = $row['id_document'];}
        $result->free();
        return $documentIds;
    }

    // }}}
    
    
    // {{{ getAlldocumentIdsForRubriqueId($articleId)

    /**
     * This method creates an array of document Ids attached to a rubrique
     *
     * param  $rubriqueId  id of the rubrique which documents must be attached
     * @return  Array   wished array of document Ids
     * @access  public
     */

    function getAlldocumentIdsForRubriqueId($rubriqueId) {
        $documentIds = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_document : getAlldocumentIdsForRubriqueId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT docs.id_document FROM ".$GLOBALS['table_prefix']."_documents docs, ".$GLOBALS['table_prefix']."_documents_rubriques lien WHERE lien.id_rubrique=$rubriqueId AND lien.id_document=docs.id_document";
         
        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_document : getAlldocumentIdsForRubriqueId()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $result->fetchRow()) {    $documentIds[] = $row['id_document'];}
        $result->free();
        return $documentIds;
    }

    // }}}
    
    

    // {{{ getAllDocumentRubriqueForMode($mode)

    /**
     * Returns an array of Document in mode $mode.
     *
     *
     * @return an array of Document rubrique informations
     * @param $mode  represents desired mode
     * @access public
     */

    function getAllDocumentRubriqueForMode($mode) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_document : getAllDocumentRubriqueForMode()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT docs.id_document AS id_doc, docs.id_type AS type, docs.fichier AS fichier, docs.date_heure AS date_heure, docs.titre AS titre, docs.descriptif AS descriptif, lien.id_rubrique AS id_rub, rubrique.titre AS titre_rub
	          FROM ".$GLOBALS['table_prefix']."_documents docs, ".$GLOBALS['table_prefix']."_documents_rubriques lien, ".$GLOBALS['table_prefix']."_rubriques rubrique
	          WHERE docs.id_document = lien.id_document AND rubrique.id_rubrique = lien.id_rubrique AND docs.mode_spip = '$mode' ORDER BY docs.date_heure DESC";
         
        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_document : getAllDocumentRubriqueForMode()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $result->fetchRow()) {
            $documents[] = $row;
        }

        $result->free();

        return $documents;
    }

    // }}}

    // {{{ getAllDocumentIdForLinkId($link, $linkId)

     /**
     * This method creates an array of Document Ids attached to a link id.
     *
     * param  $link  type of the document attached
     * param  $linkId  type Id of the document attached
     * @return  Array   wished array of document Ids
     * @access  public
     */

    function getAllDocumentIdForLinkId($link, $linkId) {
        $linkIds = array();

        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_document : getAllDocumentIdForLinkId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT id_document FROM ".$GLOBALS['table_prefix']."_documents_".$link."s WHERE  id_".$link."=$linkId";
         
        //echo $query.'<br>';
        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_document : getAllDocumentIdForLinkId()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $result->fetchRow()) {
            $linkIds[] = $row['id_document'];
        }

        $result->free();

        return $linkIds;
    }

    // }}}

    // {{{ getRubriqueIds()

     /**
     * This method creates an array of distinct rubrique Ids.
     *
     * @return  Array   wished array of rubrique Ids
     * @access  public
     */

    function getRubriqueIds() {
        $rubriqueIds = array();

        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_document : getRubriqueIds()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT DISTINCT id_rubrique FROM ".$GLOBALS['table_prefix']."_documents_rubriques";
         
        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_document : getRubriqueIds()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $result->fetchRow()) {
            $rubriqueIds[] = $row['id_rubrique'];
        }

        $result->free();

        return $rubriqueIds;
    }

    // }}}

    // {{{ getVignetteIdsForDocumentId($document_lies)



     /**
     * This method creates an array of distinct Vignette Ids attached to documents.
     *
     * @return  Array   wished array of Vignette Ids
     * @param $document_lies represents the list of documents ids
     * @access  public
     */

    function getVignetteIdsForDocumentId($document_lies) {
        $vignetteIds = array();

        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_document : getVignetteIdsForDocumentId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT DISTINCT id_vignette FROM ".$GLOBALS['table_prefix']."_documents WHERE id_document in (".join(',', $document_lies).")";
         
        //echo "<br><br>$query<br><br>";

        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_document : getVignetteIdsForDocumentId()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $result->fetchRow()) {
            $vignetteIds[] = $row['id_vignette'];
        }

        $result->free();

        return $vignetteIds;
    }

    // }}}

    // {{{ getAllForDocumentIdAndObjectId()

    function linkExistForDocumentIdAndObjectId($documentId, $objectId, $type) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_document : linkExistForDocumentIdAndObjectId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT * FROM ".$GLOBALS['table_prefix']."_documents_".$type."s WHERE id_document=$documentId AND id_$type=$objectId";
        //echo $query;
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_document : linkExistForDocumentIdAndObjectId".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        return (($result->numRows()) > 0);
    }

    // }}}


    function getAllForVignetteId($vignetteId) {
        $documents = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_document : getAllForVignetteId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT * FROM ".$GLOBALS['table_prefix']."_documents WHERE id_vignette=$vignetteId";
        //echo $query;
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_document : getAllForVignetteId".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $result->fetchRow()) {
            $resultDocument = &BD_document::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultDocument->_fetchData($row);
            $documents[] = &$resultDocument;
        }
        return $documents;
    }

    // }}}

    // {{{ getAllDistinctRubriqueId()

    /**
     * This method is used to get heading ID in the table of document
     * @access  public
     * @param   String $statut
     */

    function getAllDistinctRubriqueId() {
        $rubriqueIds = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_document : getAllDistinctRubriqueId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

		$query = "SELECT DISTINCT id_rubrique FROM ".$GLOBALS['table_prefix']."_documents_rubriques";
		 
		$result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_document : getAllDistinctRubriqueId()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $result->fetchRow()) {
            $rubriqueIds[] = $row['id_rubrique'];
        }
        $result->free();
        return $rubriqueIds;
    }

    // }}}

    // {{{ getMaxDateHeure($id_rubrique)

    function getMaxDateHeure($id_rubrique) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_document : getMaxDateHeure()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        $query = "SELECT MAX(date_heure) AS date_h FROM ".$GLOBALS['table_prefix']."_documents doc, ".$GLOBALS['table_prefix']."_documents_rubriques lien WHERE doc.id_document= lien.id_document AND lien.id_rubrique='$id_rubrique'";
		 
		$result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_document : getMaxDateHeure()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        if ($row = $result->fetchRow()) {
            $result->free();
            if ($row["date_h"] == null) {
                return new Date('1970-01-01 00:00:00');
            }
            else {
                return new Date($row["date_h"]);
            }
        }
        $result->free();
    }

    // }}}

    // {{{ getAllDocuments()
	// Retourne le nombre de documents tlchargs sur le site (tous les documents mis en base)
    function getCountDocuments() {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_document : getCountDocuments()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        //modification omansour
        $query = "SELECT COUNT(id_document) AS compteur FROM ".$GLOBALS['table_prefix']."_documents"; 
        //$query = "SELECT ".DOCUMENTS_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_documents";

        $result = $db->query($query);
        
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_document : getCountDocuments()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else{    
            if ($row = $result->fetchRow()) {
                $nb_doc = intval($row["compteur"]);
            }
            return($nb_doc);
            
        }
            
   }

    // }}}
    
    
    // {{{ getAllDocumentIds() 
    
    /**
    * retourne un tableau avec tous les document Ids
    **/
    
    function getAllDocumentIds() {
         $db = &$this->_getDB();
         
         $query = "SELECT id_document FROM ".$GLOBALS['table_prefix']."_documents";
         
         $result = $db->query($query);
        
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_document : getAllDocumentIds()] ".$result->getMessage()."", PEAR_LOG_ALERT,
                null, null, null, null, false);
        } else{ 
            $tab = array();   
            while ($row = $result->fetchRow()) {
                $tab[] = $row['id_document'];
            }
            return $tab;
        }
    
    }
    
    // }}}


    // {{{
    function saveData() {
        $mode = 'w';

        if ( $this->getTaille() ) {
            if ( $fhandler = fopen('../'.$this->getFichier(), $mode) ){
                flock($fhandler, LOCK_EX);

                fwrite($fhandler, $this->getFichierContenu());

                flock($fhandler, LOCK_UN);
            } else {
                return false;
            }
            fclose($fhandler);
        } else {
            return false;
        }

    }
    // }}}

}
?>
