<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Erwan LE BESCOND <elebescond@clever-age.com>                |
// +----------------------------------------------------------------------+
//
// Base class for Forum business persistence abstraction.
//
if (defined("_BD_FORUM")) return;
    define("_BD_FORUM", "1");

require_once "PEAR.php";
require_once (dirname(__FILE__)."/inc_rubrique_factory.php");
require_once "DB.php";
require_once dirname(__FILE__)."/metier.php";

define("FORUM_ALL_FIELDS", " id_forum, id_parent, id_rubrique, id_article, id_breve, date_heure, titre, texte, "
                            ."auteur, email_auteur, nom_site, url_site, statut, ip, maj, id_auteur, "
                            ."id_message, id_syndic, profil_auteur, alerte_mail ");

/**
 * BD_forum is a base class for forum business persistence abstraction implementations, and must be
 * inherited by all such.
 * @package	BD
 * @author  Antoine Angnieux <aangenieux@clever-age.com>
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @access	public
 */
class BD_forum extends BD_metier {
    // {{{ properties

    /**
    * Forum ID.
    * @var     int
    * @access  private
    */
    var $_forumId;

    /**
    * Parent ID.
    * @var     int
    * @access  private
    */
    var $_parentId;

    /**
    * Rubrique ID.
    * @var     int
    * @access  private
    */
    var $_rubriqueId;

    /**
    * Article ID.
    * @var     int
    * @access  private
    */
    var $_articleId;

    /**
    * Breve ID.
    * @var     int
    * @access  private
    */
    var $_breveId;

    /**
    * Time.
    * @var     Date
    * @access  private
    */
    var $_dateHeure;

    /**
    * Title.
    * @var     String
    * @access  private
    */
    var $_titre;

    /**
    * Text.
    * @var     String
    * @access  private
    */
    var $_texte;

    /**
    * Author.
    * @var     String
    * @access  private
    */
    var $_auteur;

    var $id_forums;
     /**
    * Email Author.
    * @var     int
    * @access  public
    */
    /**
    * Email Author.
    * @var     String
    * @access  private
    */
    var $_emailAuteur;

    /**
    * Site name.
    * @var     String
    * @access  private
    */
    var $_nomSite;

    /**
    * Site url.
    * @var     String
    * @access  private
    */
    var $_urlSite;

    /**
    * Statute.
    * @var     String
    * @access  private
    */
    var $_statut;

    /**
    * IP.
    * @var     String
    * @access  private
    */
    var $_ip;

    /**
    * Last Update.
    * @var     Date
    * @access  private
    */
    var $_majDate;

    /**
    * Author ID.
    * @var     int
    * @access  private
    */
    var $_auteurId;

    /**
    * Message ID.
    * @var     int
    * @access  private
    */
    var $_messageId;

    /**
    * Syndic ID.
    * @var     int
    * @access  private
    */
    var $_syndicId;

    /**
    * profilAuteur.
    * @var     Int
    * @access  private
    */
    var $_profilAuteur;

    /**
    * alerte email.
    * @var     String
    * @access  private
    */
    var $_emailAlerte;

    // }}}

    // {{{ factory()
    function &factory($dbParameters = null, $dbOptions = null) {
        if(file_exists(dirname(__FILE__)."/".$dbParameters->_dbEngine."/forum_".$dbParameters->_dbEngine.".php") == false) {
            include_once(dirname(__FILE__)."/common/forum_common.php");
            $classname = "BD_forum_common";
        }
        else {
            include_once(dirname(__FILE__)."/".$dbParameters->_dbEngine."/forum_".$dbParameters->_dbEngine.".php");
            $classname = "BD_forum_".$dbParameters->_dbEngine;
        }
        if (!class_exists($classname)) {
            return PEAR::raiseError("Cannot instanciate class $classname", null,
                                    null, null, null, null, false);
        }

        $obj =& new $classname;
        $result = $obj->setDbParameters($dbParameters);
        if ($dbOptions != null) {
            $obj->setDbOptions($dbOptions);
        }
        if (PEAR::isError($result)) {
            return $result;
        } else {
            return $obj;
        }
    }

    // }}}

    // {{{ constructor

    /**
     * DB_forum constructor.
     *
     * @access public
     */

    function BD_forum() {
    }

    // }}}

    // {{{ getForumId()

    /**
     * Returns the Forum ID
     * @return  int
     * @access  public
     */

    function getForumId() {
        return $this->_forumId;
    }

    // }}}

    // {{{ setForumId()

    /**
     * Sets the Forum ID
     * @param  int
     * @access  public
     */

    function setForumId($forumId) {
        $this->_forumId = $forumId;
    }

    // }}}

    // {{{ getParentId()

    /**
     * Returns the Parent's ID
     * @return  int
     * @access  public
     */

    function getParentId() {
        return $this->_parentId;
    }

    // }}}

    // {{{ setParentId()

    /**
     * Sets the Forum's ID
     * @param  int
     * @access  public
     */

    function setParentId($parentId) {
        $this->_parentId = $parentId;
    }

    // }}}

    // {{{ getRubriqueId()

    /**
     * Returns the Heading's ID
     * @return  int
     * @access  public
     */

    function getRubriqueId() {
        return $this->_rubriqueId;
    }

    // }}}

    // {{{ setRubriqueId()

    /**
     * Sets the Heading's ID
     * @param  int
     * @access  public
     */

    function setRubriqueId($rubriqueId) {
        $this->_rubriqueId = $rubriqueId;
    }

    // }}}

    // {{{ getArticleId()

    /**
     * Returns the Article's ID
     * @return  int
     * @access  public
     */

    function getArticleId() {
        return $this->_articleId;
    }

    // }}}

    // {{{ setArticleId()

    /**
     * Sets the Article's ID
     * @param int
     * @access  public
     */

    function setArticleId($articleId) {
        $this->_articleId = $articleId;
    }

    // }}}

    /**
     * Returns the Breve's ID
     * @return  int
     * @access  public
     */

    // {{{ getBreveId()

    function getBreveId() {
        return $this->_breveId;
    }

    // }}}

    // {{{ setBreveId()

    /**
     * Sets the Breve's ID
     * @param  int
     * @access  public
     */

    function setBreveId($breveId) {
        $this->_breveId = $breveId;
    }

    // }}}

    // {{{ getDateHeure()

    /**
     * Returns the creation date
     * @return Date
     * @access  public
     */

    function getDateHeure() {
        return $this->_dateHeure;
    }

    // }}}

    // {{{ setDateHeure()

    /**
     * Returns the creation date
     * @return  Date
     * @access  public
     */

    function setDateHeure($dateHeure) {
        $this->_dateHeure = $dateHeure;
    }

    // }}}

    // {{{ getTitre()

    /**
     * Returns the Title
     * @return  String
     * @access  public
     */

    function getTitre() {
        return $this->_titre;
    }

    // }}}

    // {{{ setTitre()

    /**
     * Sets the Title
     * @param  String
     * @access  public
     */

    function setTitre($titre) {
        $this->_titre = corriger_caracteres($titre);
    }

    // }}}

    // {{{ getTexte()

    /**
     * Returns the Text
     * @return  String
     * @access  public
     */

    function getTexte() {
        return $this->_texte;
    }

    // }}}

    // {{{ setTexte()

    /**
     * Sets the Text
     * @param  String
     * @access  public
     */

    function setTexte($texte) {
        $this->_texte = corriger_caracteres($texte);
    }

    // }}}

    // {{{ getAuteur()

    /**
     * Returns the Author
     * @return  String
     * @access  public
     */

    function getAuteur() {
        return $this->_auteur;
    }

    // }}}

    // {{{ setAuteur()

    /**
     * Sets the Author
     * @param  String
     * @access  public
     */

    function setAuteur($auteur) {
        $this->_auteur = corriger_caracteres($auteur);
    }

    // }}}

    // {{{ getEmailAuteur()

    /**
     * Returns the Author's email
     * @return  String
     * @access  public
     */

    function getEmailAuteur() {
        return $this->_emailAuteur;
    }

    // }}}

    // {{{ setEmailAuteur()

    /**
     * Sets the Author's email
     * @param  String
     * @access  public
     */

    function setEmailAuteur($emailAuteur) {
        $this->_emailAuteur = corriger_caracteres($emailAuteur);
    }

    // }}}

    // {{{ getNomSite()

    /**
     * Returns the Site's name
     * @return  String
     * @access  public
     */

    function getNomSite() {
        return $this->_nomSite;
    }

    // }}}

    // {{{ setNomSite()

    /**
     * Returns the Site's name
     * @param  String
     * @access  public
     */

    function setNomSite($nomSite) {
        $this->_nomSite = corriger_caracteres($nomSite);
    }

    // }}}

    // {{{ getUrlSite()

    /**
     * Returns the Site's URL
     * @return  String
     * @access  public
     */

    function getUrlSite() {
        return $this->_urlSite;
    }

    // }}}

    // {{{ setUrlSite()

    /**
     * Sets the Site's URL
     * @param  String
     * @access  public
     */

    function setUrlSite($urlSite) {
        $this->_urlSite = corriger_caracteres($urlSite);
    }

    // }}}

    /**
     * Returns the Statute
     * @return  String
     * @access  public
     */

    // {{{ getStatut()

    function getStatut() {
        return $this->_statut;
    }

    // }}}

    // {{{ setStatut()

    /**
     * Sets the Statute
     * @param  String
     * @access  public
     */

    function setStatut($statut) {
        $this->_statut = corriger_caracteres($statut);
    }

    // }}}

    // {{{ getIp()

    /**
     * Returns the IP
     * @return  String
     * @access  public
     */

    function getIp() {
        return $this->_ip;
    }

    // }}}

    // {{{ setIp()

    /**
     * Sets the IP
     * @param  String
     * @access  public
     */

    function setIp($ip) {
        $this->_ip = corriger_caracteres($ip);
    }

    // }}}

    // {{{ getMajDate()

    /**
     * Returns the last update
     * @return  Date
     * @access  public
     */

    function getMajDate() {
        return $this->_majDate;
    }

    // }}}

    // {{{ setMajDate()

    /**
     * Sets the last update
     * @param  Date
     * @access  public
     */

    function setMajDate($majDate) {
        $this->_majDate = $majDate;
    }

    // }}}

    // {{{ getAuteurId()

    /**
     * Returns the Author's ID
     * @return  int
     * @access  public
     */

    function getAuteurId() {
        return $this->_auteurId;
    }

    // }}}

    // {{{ setAuteurId()

    /**
     * Sets the Author's ID
     * @param  int
     * @access  public
     */

    function setAuteurId($auteurId) {
        $this->_auteurId = $auteurId;
    }

    // }}}

    // {{{ getMessageId()

    /**
     * Returns the Message's ID
     * @return  int
     * @access  public
     */

    function getMessageId() {
        return $this->_messageId;
    }

    // }}}

    // {{{ setMessageId()

    /**
     * Returns the Message's ID
     * @param  int
     * @access  public
     */

    function setMessageId($messageId) {
        $this->_messageId = $messageId;
    }

    // }}}

    // {{{ getSyndicId()

    /**
     * Returns the Syndic's ID
     * @return  int
     * @access  public
     */

    function getSyndicId() {
        return $this->_syndicId;
    }

    // }}}

    // {{{ setSyndicId()

    /**
     * Sets the Syndic's ID
     * @param  int
     * @access  public
     */

    function setSyndicId($syndicId) {
        $this->_syndicId = $syndicId;
    }

    // {{{ getProfilAuteur()

    /**
     * Returns the profilAuteur
     * @return  Int
     * @access  public
     */

    function getProfilAuteur() {
        return $this->_profilAuteur;
    }

    // }}}

    // {{{ setProfilAuteur()

    /**
     * Sets the ProfilAuteur
     * @param  Int
     * @access  public
     */

    function setProfilAuteur($profilAuteur) {
        $this->_profilAuteur = $profilAuteur;
    }

    // }}}

    // {{{ getEmailAlerte()

    /**
     * Returns the _emailAlerte
     * @return  String
     * @access  public
     */

    function getEmailAlerte() {
        return $this->_emailAlerte;
    }

    // }}}

    // {{{ setEmailAlerte()

    /**
     * Sets the _emailAlerte
     * @param  String
     * @access  public
     */

    function setEmailAlerte($emailAlerte) {
        $this->_emailAlerte = $emailAlerte;
    }

    // }}}

    // {{{ create()

    /**
     * This method is used to create a new forum in the database
     * @access public
     */

    function create() {
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_forum : create()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        
        $string_prefix = $GLOBALS['table_prefix']."_forum";
        $forumId = $db->nextId($string_prefix, true);
        if (DB::isError($forumId)) {
            return PEAR::raiseError("[".get_class($this)." DB_forum : create()] ".$forumId->getMessage()."", null,
                null, null, null, null, false);
        }

        $this->_forumId = $forumId;

        //if ($this->_dateHeure == "NOW()") $dateValue = "NOW()"; else $dateValue = "'".$db->quoteString($this->_dateHeure)."'";

        $maDate = new Date();
	    $this->setDateHeure($maDate->getDate(DATE_FORMAT_ISO));

        if($this->_parentId == null) $this->_parentId = 0;
        if($this->_rubriqueId == null) $this->_rubriqueId = 0;
        if($this->_articleId == null) $this->_articleId = 0;
        if($this->_breveId == null) $this->_breveId = 0;
        if($this->_auteurId == null) $this->_auteurId = 0;
        if($this->_messageId == null) $this->_messageId = 0;
        if($this->_syndicId == null) $this->_syndicId = 0;



        $query = "INSERT INTO ".$GLOBALS['table_prefix']."_forum (".FORUM_ALL_FIELDS.") VALUES "
                ."(".$this->_forumId.", "
                ."".$this->_parentId.", "
                ."".$this->_rubriqueId.", "
                ."".$this->_articleId.", "
                ."".$this->_breveId.", "
                ."'".$db->quoteString($this->_dateHeure)."', "
                ."'".$db->quoteString($this->_titre)."', "
                ."'".$db->quoteString($this->_texte)."', "
                ."'".$db->quoteString($this->_auteur)."', "
                ."'".$db->quoteString($this->_emailAuteur)."', "
                ."'".$db->quoteString($this->_nomSite)."', "
                ."'".$db->quoteString($this->_urlSite)."', "
                ."'".$db->quoteString($this->_statut)."', "
                ."'".$db->quoteString($this->_ip)."', "
                ."'".$db->quoteString($this->_majDate)."', "
                ."".$this->_auteurId.", "
                ."".$this->_messageId.", "
                ."".$this->_syndicId.", "
                ."".$this->_profilAuteur.", "
                ."'".$db->quoteString($this->_emailAlerte)."')";

         
        //echo '<br>' . $query . '<br>';
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_forum : create()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ update()

    /**
     * This method is used to update this forum in the database
     * @access public
     */

    function update() {
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_forum : update()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        //if ($this->_dateHeure == "NOW()") $dateValue = "NOW()"; else $dateValue = "'".$db->quoteString($this->_dateHeure)."'";

        $maDate = new Date();
	    $this->setMajDate($maDate->getDate(DATE_FORMAT_ISO));

        $query = "UPDATE ".$GLOBALS['table_prefix']."_forum "
                ."SET id_parent = ".$this->_parentId.", "
                ."id_rubrique = ".$this->_rubriqueId.", id_article = ".$this->_articleId.", "
                ."id_breve = ".$this->_breveId.", date_heure = '".$db->quoteString($this->_dateHeure)."', "
                ."titre = '".$db->quoteString($this->_titre)."', texte = '".$db->quoteString($this->_texte)."', "
                ."auteur = '".$db->quoteString($this->_auteur)."', email_auteur = '".$this->_emailAuteur."', "
                ."nom_site = '".$db->quoteString($this->_nomSite)."', url_site = '".$db->quoteString($this->_urlSite)."', "
                ."statut = '".$db->quoteString($this->_statut)."', ip = '".$db->quoteString($this->_ip)."', "
                ."maj = '".$db->quoteString($this->_majDate)."', id_auteur = ".$this->_auteurId.", "
                ."id_message = ".$this->_messageId.", id_syndic = ".$this->_syndicId.", "
                ."profil_auteur = " . $this->_profilAuteur . ", alerte_mail = '".$db->quoteString($this->_emailAlerte)."' "
                ."WHERE id_forum = ".$this->_forumId;

         
        //echo '<br>' . $query . '<br>';
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_forum : update()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

    }

    // }}}

    // {{{ load()

    /**
     * This method is used to load a forum from the database
     * @access  public
     * @param   int $idForum id of forum to load
     */

    function load($idForum) {
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_forum : load()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT".FORUM_ALL_FIELDS."FROM ".$GLOBALS['table_prefix']."_forum WHERE id_forum = $idForum";

         

        //echo "<br><br>$query<br><br>";

        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_forum : load()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
            if ($row = $result->fetchRow()) {

                $maDate = new Date($row['maj']);
                $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

                $this->_fetchData($row);
            } else {
                return PEAR::raiseError("[".get_class($this)." DB_forum : load($idForum)] Aucun forum ne correspond pas  cet ID!", null,
                                    null, null, null, null, false);
            }
            $result->free();
        }
    }

    // }}}

    // {{{ delete()

    /**
     * This method is used to delete a forum from the database
     * @access  public
     * @param   int $idForum of forum to delete
     */

    function delete($idForum) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_forum : delete()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_forum WHERE id_forum = $idForum";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_forum : delete()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ _fetchData()

    /**
     * This method is used to fetch result set fields into the object fields
     *
     * @param   $row    resultset row
     * @access  private
     */

    function _fetchData($row) {
        $this->setForumId($row['id_forum']);
        $this->setParentId($row['id_parent']);
        $this->setRubriqueId($row['id_rubrique']);
        $this->setArticleId($row['id_article']);
        $this->setBreveId($row['id_breve']);
        $this->setDateHeure($row['date_heure']);
        $this->setTitre($row['titre']);
        $this->setTexte($row['texte']);
        $this->setAuteur($row['auteur']);
        $this->setEmailAuteur($row['email_auteur']);
        $this->setNomSite($row['nom_site']);
        $this->setUrlSite($row['url_site']);
        $this->setStatut($row['statut']);
        $this->setIp($row['ip']);
        $this->setMajDate($row['maj']);
        $this->setAuteurId($row['id_auteur']);
        $this->setMessageId($row['id_message']);
        $this->setSyndicId($row['id_syndic']);
        $this->setProfilAuteur($row['profil_auteur']);
        $this->setEmailAlerte($row['alerte_mail']);
    }

    // }}}

    // {{{ addForumCache($valeurs)

    function addForumCache($valeurs) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_forum : addForumCache()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        //echo "<br>Details du parametre de la methode addForumCache()<br>";
        $query = "INSERT INTO ".$GLOBALS['table_prefix']."_forum_cache (id_article, id_rubrique, id_breve, id_forum, fichier) VALUES ($valeurs)";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_forum : addForumCache()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ deleteAllExceptArticleIds($articles)

    function deleteAllExceptArticleIds($articles) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_forum : deleteAllExceptArticleIds()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_forum WHERE id_article NOT IN (0,$articles)";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_forum : deleteAllExceptArticleIds()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ deleteAllExceptBreveIds($breves)

    function deleteAllExceptBreveIds($breves) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_forum : deleteAllExceptBreveIds()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_forum WHERE id_breve NOT IN (0,$breves)";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_forum : deleteAllExceptBreveIds()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ deleteAllExceptMessageIds($messages)

    function deleteAllExceptMessageIds($messages) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_forum : deleteAllExceptMessageIds()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_forum WHERE id_message NOT IN (0,$messages)";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_forum : deleteAllExceptMessageIds()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ deleteAllExceptParentIds($parents)

    function deleteAllExceptParentIds($parents) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_forum : deleteAllExceptParentIds()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_forum WHERE id_parent NOT IN (0,$parents)";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_forum : deleteAllExceptParentIds()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ deleteAllExceptRubriqueIds($rubriques)

    function deleteAllExceptRubriqueIds($rubriques) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_forum : deleteAllExceptRubriqueIds()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_forum WHERE id_rubrique NOT IN (0,$rubriques)";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_forum : deleteAllExceptRubriqueIds()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ deleteForMessageId($messageId)

    function deleteForMessageId($messageId) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_forum : deleteForMessageId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_forum WHERE id_message=$messageId";
        //echo $query;
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_forum : deleteForMessageId()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ deleteCacheForFichier($fichier)

    function deleteCacheForFichier($fichier) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_forum : deleteCacheForFichier()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_forum_cache WHERE fichier='$fichier'";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_forum : deleteCacheForFichier()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ getAllForForumType($page, $limitdeb, $limitnb)

    /**
     * Returns an array of Forum.
     *
     * @return Array of Forum
     * @param $page
     * @param $limitedeb
     * @param $limitnb
     * @param $page
     * @access public
     */

    function &getAllForForumType($page, $limitdeb, $limitnb, $order = null, $statut = null, $ageMessage = null, $id_current_forum = null, $type_forum = null) {
        $forums = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_forum : getAllForForumType()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT * FROM ".$GLOBALS['table_prefix']."_forum WHERE ";
        switch ($page) {
            case 'public':

                if ($statut) {
                    $statut = explode(",", $statut);
                    $query .= "statut IN ('" . join("','",$statut) . "')";
                }
                else $query .= "statut IN ('publie', 'off', 'prop', 'poubelle')";

	        break;
            case 'interne':
	            $query .= "statut IN ('prive', 'privrac', 'privoff', 'privadm')";
	        break;
            case 'vide':
	            $query .= "statut IN ('publie', 'off', 'prive', 'privrac', 'privoff', 'privadm') AND texte like ''";
	        break;
            default:
	            $query .= "NULL IS NOT NULL";
	        break;

            /*
            case 'public':
	            $query .= "statut IN ('publie', 'off', 'prop') AND texte NOT LIKE ''";
	        break;
            case 'interne':
	            $query .= "statut IN ('prive', 'privrac', 'privoff', 'privadm') AND texte NOT LIKE ''";
	        break;
            case 'vide':
	            $query .= "statut IN ('publie', 'off', 'prive', 'privrac', 'privoff', 'privadm') AND texte LIKE ''";
	        break;
            default:
	            $query .= "0=1";
	        break;
	        */

        }

        if ($id_current_forum && $type_forum) $query .= " AND id_$type_forum = $id_current_forum ";

        if($ageMessage) $query .= " AND date_heure>='" . $ageMessage->getDate() . "'";


        switch ($order) {
            case 'date_heure':
                $query .= " ORDER BY date_heure";
            break;
            case 'auteur':
                $query .= " ORDER BY auteur";
            break;
            case 'email_auteur':
                $query .= " ORDER BY email_auteur";
            break;

            default:
                $query .= " ORDER BY date_heure";
            break;
        }

         
        //echo "<br><br>".$query."<br><br>";

        $queryResult = $db->limitQuery($query, $limitdeb, $limitnb);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_forum : getAllForForumType()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $queryResult->fetchRow()) {
            $resultForum = &BD_forum::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultForum->_fetchData($row);
            $forums[] = &$resultForum;
        }
        $queryResult->free();
        return $forums;
    }

    // }}}

    // {{{ getAllForStatut($statut)

    /**
     * Returns an array of Forum.
     *
     * @return Array of Forum
     * @param $statut
     * @access public
     */

    function &getAllForStatut($statut) {
        $forums = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_forum : getAllForStatut()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT * FROM ".$GLOBALS['table_prefix']."_forum WHERE statut='$statut'";
         
        //echo "<br><br>$query<br><br>";

        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_forum : getAllForStatut()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $queryResult->fetchRow()) {
            $resultForum = &BD_forum::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultForum->_fetchData($row);
            $forums[] = &$resultForum;
        }
        $queryResult->free();
        return $forums;
    }

    // }}}


    // {{{ getAllEmptyMessagesForStatut($statut)

    /**
     * Returns an array of Forum.
     *
     * @return Array of Forum
     * @param $statut
     * @access public
     */

    function &getAllEmptyMessagesForStatut($statut) {
        $forums = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_forum : getAllEmptyMessagesForStatut()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT * FROM ".$GLOBALS['table_prefix']."_forum WHERE statut='$statut' AND OCTET_LENGTH(`texte`) <= 0";
         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_forum : getAllEmptyMessagesForStatut()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $queryResult->fetchRow()) {
            $resultForum = &BD_forum::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultForum->_fetchData($row);
            $forums[] = &$resultForum;
        }
        $queryResult->free();
        return $forums;
    }

    // }}}

    // {{{ getAllForumIds()

    /**
     * Returns an array of Forum ID.
     *
     *
     * @return an array of Forum ID
     * @access public
     */

    function getAllForumIds() {
        $forumIds = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_forum : getAllForumIds()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT id_forum FROM ".$GLOBALS['table_prefix']."_forum";
         
        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_forum : getAllForumIds()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $result->fetchRow()) {    $forumIds[] = $row['id_forum'];}
        $result->free();
        return $forumIds;
    }

    // }}}

    // {{{ getAllRootMessagesForCurrentForum($id_curent_forum, $type, $maDate = null)

    /**
     * Returns an array of Root Forum.
     *
     *
     * @return an array of Root Forum
     * @access public
     */

    function getAllRootMessagesForCurrentForum($id_current_forum, $type, $maDate = null) {
        $forums = array();

        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_forum : getAllRootMessagesForCurrentForum()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT " . FORUM_ALL_FIELDS . " FROM ".$GLOBALS['table_prefix']."_forum WHERE id_$type=$id_current_forum AND id_parent=0";
        if($maDate) $query .= " AND date_heure>='" . $maDate->getDate(DATE_FORMAT_ISO) . "'";
         
        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_forum : getAllRootMessagesForCurrentForum()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $result->fetchRow()) {
            $resultForum = &BD_forum::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultForum->_fetchData($row);
            $forums[] = &$resultForum;
        }
        $result->free();
        return $forums;
    }

    // }}}

    // {{{ getAllMessagesForParentId($parentId, $maDate = null)

    function getAllMessagesForParentId($parentId, $maDate = null) {
        $forums = array();

        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_forum : getAllMessagesForParentId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT " . FORUM_ALL_FIELDS . " FROM ".$GLOBALS['table_prefix']."_forum WHERE id_parent=$parentId";
        if($maDate) $query .= " AND date_heure>='" . $maDate->getDate(DATE_FORMAT_ISO) . "'";
         
        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_forum : getAllMessagesForParentId()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $result->fetchRow()) {
            $resultForum = &BD_forum::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultForum->_fetchData($row);
            $forums[] = &$resultForum;
        }
        $result->free();
        return $forums;
    }

    // }}}

    // {{{ howManyPostByForumId($parentId)

    function howManyPostByForumId($parentId) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_forum : howManyPostByForumId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT COUNT(*) as count FROM ".$GLOBALS['table_prefix']."_forum WHERE id_parent=$parentId";
         
        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_forum : howManyPostByForumId()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

        if ($row = $result->fetchRow()) {
            return $row['count'];
        }
        $result->free();
        return 0;
    }

    // }}}

    // {{{ howManyPostByForumIdAndStatut($parentId, $statut)

    function howManyPostByForumsIdAndStatut($statut) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_forum : howManyPostByForumIdAndStatut()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT COUNT(*) AS cnt FROM ".$GLOBALS['table_prefix']."_forum WHERE statut='$statut' AND id_parent=0";

        //echo '<br />' . $query . '<br />';
         
        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_forum : howManyPostByForumIdAndStatut()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

        if ($row = $result->fetchRow()) {
            return $row['count'];
        }
        $result->free();
        return 0;
    }

    // }}}

    // {{{ deleteFichier($forum_id_article, $forum_id_rubrique, $forum_id_breve, $forum_id_parent, $CacheDirectory)

    /**
     * delete cache files.
     *
     *
     * @delete cache files
     * @access public
     */

    function deleteFichier($forum_id_article, $forum_id_rubrique, $forum_id_breve, $forum_id_parent, $CacheDirectory) {
        $fichiers = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_forum : deleteFichier()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        
        unset($where);
	    if ($forum_id_article) $where[] = "id_article=$forum_id_article";
	    if ($forum_id_rubrique) $where[] = "id_rubrique=$forum_id_rubrique";
	    if ($forum_id_breve) $where[] = "id_breve=$forum_id_breve";
	    if ($forum_id_parent) $where[] = "id_forum=$forum_id_parent";
	    if ($where) {
            $query = "SELECT fichier FROM ".$GLOBALS['table_prefix']."_forum_cache WHERE ".join(' OR ', $where);
	    	 
	    	$result = $db->query($query);
            if (DB::isError($result)) {
                return PEAR::raiseError("[".get_class($this)." DB_forum : deleteFichier()] ".$result->getMessage()."", null,
                    null, null, null, null, false);
            }
		    while ($row = $result->fetchRow()) {
    			$fichier = $row["fichier"];
	            @unlink("$CacheDirectory/$fichier");
				@unlink("$CacheDirectory/$fichier.NEW");
			    $fichiers[] = "'".$fichier."'";
		    }
            $result->free();
            if ($fichiers) {
			    $fichiers = join(',', $fichiers);
			    $query = "DELETE FROM ".$GLOBALS['table_prefix']."_forum_cache WHERE fichier IN ($fichiers)";
			     
			    $db->query($query);
		    }
        }

    }

    // }}}

    // {{{ deleteMajDate($majDate)

    /**
     * This method is used to delete all articles former to mydate
     * @access  public
     */

    function deleteMajDate($mydate) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_forum : deleteMajDate()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $dateTmp = new Date($mydate);
        $mydate = $dateTmp->getDate(DATE_FORMAT_ISO);

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_forum WHERE maj < '$mydate'";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_forum : deleteMajDate()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ howManyForumForArticleIdAndStatuts($id_article, $statuts)

    /**
     * This method returns the number of message for a published, off or proposed article
     * @return int
     * @param id_article
     * @param statuts
     * @access public
     */
    function howManyForumForArticleIdAndStatuts($articleId, $statuts, $parentId = -1) {
        $howManyForum = 0;
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_forum : howManyForumForArticleIdAndStatuts()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

		$query = "SELECT count(*) AS count FROM ".$GLOBALS['table_prefix']."_forum WHERE id_article=$articleId AND statut IN ($statuts)";
        //echo '<br>'.$query.'<br>';
        if($parentId != -1)   {
            $query .= " AND id_parent=$parentId";
        }

        //echo "<br><br>$query<br><br>";

        $result = $db->getOne($query);

        if (DB::isError($result)) {
            return 0;
        }
        else {
            $howManyForum = $result;
        }
        return $howManyForum;
    }

    // }}}

	// {{{ howManyForumForArticleId($id_article)

    /**
     * This method returns the number of message for a article
     * @return int
     * @param id_article
     * @access public
     */
    function howManyForumForArticleId($articleId) {
        $howManyForum = 0;
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_forum : howManyForumForArticleId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

		$query = "SELECT count(*) AS count FROM ".$GLOBALS['table_prefix']."_forum WHERE id_article=$articleId";

        //echo "<br><br>$query<br><br>";

        $result = $db->getOne($query);

        if (DB::isError($result)) {
            return 0;
        }
        else {
            $howManyForum = $result;
        }
        return $howManyForum;
    }

    // }}}

	// {{{ howManyForumForBreveId($id_breve)

    /**
     * This method returns the number of message for a breve
     * @return int
     * @param id_breve
     * @access public
     */
    function howManyForumForBreveId($breveId) {
        $howManyForum = 0;
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_forum : howManyForumForBreveId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

		$query = "SELECT count(*) AS count FROM ".$GLOBALS['table_prefix']."_forum WHERE id_breve=$breveId";

        //echo "<br><br>$query<br><br>";

        $result = $db->getOne($query);

        if (DB::isError($result)) {
            return 0;
        }
        else {
            $howManyForum = $result;
        }
        return $howManyForum;
    }

    // }}}

	// {{{ howManyForumForRubriqueId($id_rubrique)

    /**
     * This method returns the number of message for a rubrique
     * @return int
     * @param id_rubrique
     * @access public
     */
    function howManyForumForRubriqueId($rubriqueId) {
        $howManyForum = 0;
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_forum : howManyForumForRubriqueId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

		$query = "SELECT count(*) AS count FROM ".$GLOBALS['table_prefix']."_forum WHERE id_rubrique=$rubriqueId";

        //echo "<br><br>$query<br><br>";

        $result = $db->getOne($query);

        if (DB::isError($result)) {
            return 0;
        }
        else {
            $howManyForum = $result;
        }
        return $howManyForum;
    }

    // }}}

    // {{{ howManyForumForRubriqueIdAndStatuts($id_rubrique, $statuts)

    /**
     * This method returns the number of message for a published, off or proposed rubrique
     * @return int
     * @param id_rubrique
     * @param statuts
     * @access public
     */
    function howManyForumForRubriqueIdAndStatuts($rubriqueId, $statuts, $parentId = -1) {
        $howManyForum = 0;
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_forum : howManyForumForRubriqueIdAndStatuts()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

		$query = "SELECT count(*) AS count FROM ".$GLOBALS['table_prefix']."_forum WHERE id_rubrique=$rubriqueId AND statut IN ($statuts)";
        //echo '<br>'.$query.'<br>';
        if($parentId != -1)   {
            $query .= " AND id_parent=$parentId";
        }

        //echo "<br><br>$query<br><br>";

        $result = $db->getOne($query);

        if (DB::isError($result)) {
            return 0;
        }
        else {
            $howManyForum = $result;
        }
        return $howManyForum;
    }

    // }}}

    // {{{ howManyForumForBreveIdAndStatuts($id_breve, $statuts)

    /**
     * This method returns the number of message for a published, off or proposed breve
     * @return int
     * @param id_breve
     * @param statuts
     * @access public
     */
    function howManyForumForBreveIdAndStatuts($breveId, $statuts, $parentId = -1) {
        $howManyForum = 0;
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_forum : howManyForumForBreveIdAndStatuts()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

		$query = "SELECT count(*) AS count FROM ".$GLOBALS['table_prefix']."_forum WHERE id_breve=$breveId AND statut IN ($statuts)";
        //echo '<br>'.$query.'<br>';
        if($parentId != -1)   {
            $query .= " AND id_parent=$parentId";
        }

        //echo "<br><br>$query<br><br>";

        $result = $db->getOne($query);

        if (DB::isError($result)) {
            return 0;
        }
        else {
            $howManyForum = $result;
        }
        return $howManyForum;
    }

    // }}}

    // {{{ howManyForumForStatut2($statut)

    /**
     * This method returns the number of statut message
     * @return int
     * @param statut
     * @access public
     */
    function howManyForumForStatut2($statut) {
        $howManyForum = 0;
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_forum : howManyForumForStatut()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

		$query = "SELECT id_rubrique, id_article, id_breve FROM ".$GLOBALS['table_prefix']."_forum WHERE statut='$statut'";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_forum : howManyForumForStatut()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $result->fetchRow()) {
            if($row['id_article']!=0) {
                $type_forum = 'article';
                $id_current_forum = $row['id_article'];
            }
            if($row['id_rubrique']!=0) {
                $type_forum = 'rubrique';
                $id_current_forum = $row['id_rubrique'];
            }
            if($row['id_breve']!=0) {
                $type_forum = 'breve';
                $id_current_forum = $row['id_breve'];
            }
			$authorization = &recuperer_instance_authorization('controlerForum2', $GLOBALS['connect_id_auteur'], array('type_forum' => $type_forum, 'id_current_forum' => $id_current_forum));
            if($authorization->isAuthorizedAction()) {
                $howManyForum++;
            }
        }
        return $howManyForum;
    }

    // }}}

    // {{{ howManyForumForStatut($statut)

    /**
     * This method returns the number of statut message
     * @return int
     * @param statut
     * @access public
     */
    function howManyForumForStatut($statut) {
        $howManyForum = 0;
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_forum : howManyForumForStatut()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

		$query = "SELECT count(*) AS compte FROM ".$GLOBALS['table_prefix']."_forum WHERE statut='$statut'";

        $result = $db->getOne($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_forum : howManyForumForStatut()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
            $howManyForum = $result;
        }
        return $howManyForum;
    }

    // }}}

    // {{{ deleteExpiredCache()

    /**
     * delete expired cache file
     * @access public
     */
    function deleteExpiredCache() {
        $fichiers = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_forum : deleteExpiredCache()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $maDate = new Date();
        $maDate->subtractSeconds(14*24*3600);
        //$query = "SELECT fichier FROM ".$GLOBALS['table_prefix']."_forum_cache WHERE maj < DATE_SUB(NOW(), INTERVAL 14 DAY)";
        $query = "SELECT fichier FROM ".$GLOBALS['table_prefix']."_forum_cache WHERE maj < '".$maDate->getDate(DATE_FORMAT_ISO)."'";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_forum : deleteExpiredCache()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

		while ($row = $result->fetchRow()) {
    	    $fichier = $row['fichier'];
			if (!file_exists("CACHE/$fichier")) $fichiers[] = "'$fichier'";
        }

        $result->free();

        if ($fichiers) {
			$query = "DELETE FROM ".$GLOBALS['table_prefix']."_forum_cache WHERE fichier IN (".join(',', $fichiers).")";
			 
			$db->query($query);
		}
    }

    // }}}

    // {{{ deleteAllCache()

    /**
     * delete cache file
     * @access public
     */
    function deleteAllCache() {
        $fichiers = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_forum : deleteAllCache()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_forum_cache";
         
		$result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_forum : deleteAllCache()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ deleteForStatutAndMaj($statut, $mydate)

    function deleteForStatutAndMaj($statut, $mydate) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_forum : deleteForStatutAndMaj()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_forum WHERE statut='$statut' AND  maj<'$mydate'";
        //$query = "DELETE FROM ".$GLOBALS['table_prefix']."_forum WHERE statut='$statut' AND  date_heure<DATE_SUB(NOW(),INTERVAL 1 DAY)";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_forum : deleteForStatutAndMaj()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}



    // {{{ getMessageWayForStatut($id_current_forum, $type_forum, $statut)

    function getMessageWayForStatut($id_current_forum, $type_forum, $statut) {
        $ids = array();

        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_forum : getMessageWayForStatut()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $statut = explode(",", $statut);
        $query = "SELECT id_forum, id_parent FROM ".$GLOBALS['table_prefix']."_forum WHERE statut IN ('" . join("','", $statut) . "') AND id_$type_forum=$id_current_forum";
        //echo $query.'<br>';
         
        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_forum : getMessageWayForStatut()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $result->fetchRow()) {
            $ids[] = $row['id_forum'];
            $ids[] = $row['id_parent'];
            while($row['id_parent'] != 0) {
                $query = "SELECT id_parent FROM ".$GLOBALS['table_prefix']."_forum WHERE id_forum=" . $row['id_parent'];
                //echo $query.'<br>';
                 
                $result2 = $db->query($query);
                if (DB::isError($result2)) {
                    return PEAR::raiseError("[".get_class($this)." DB_forum : getMessageWayForStatut()] ".$result->getMessage()."", null,
                        null, null, null, null, false);
                }
                if($row = $result2->fetchRow()) {
                    if($row['id_parent']) $ids[] = $row['id_parent'];
                }
                $result2->free();
            }
        }
        $result->free();

        return array_unique($ids);
    }

    // }}}

    // {{{ search($recherche, $typeRecherche)

    /**
     * Returns an array of Forum.
     *
     * @return Array of Forum
     * @param $page
     * @param $limitedeb
     * @param $limitnb
     * @param $page
     * @access public
     */

    function &search($recherche, $typeRecherche, $id_current_forum = null, $type_forum = null) {
		$forums = array();
		$db = &$this->_getDB();
		if (DB::isError($db)) {
			return PEAR::raiseError("[".get_class($this)." DB_forum : search()] ".$db->getMessage()."", null,
			null, null, null, null, false);
		}

		$recherche = $db->quoteString($recherche);
		$recherche = corriger_caracteres($recherche);

		if(ereg('danstouslesforums', $typeRecherche))	{
			$id_current_forum = null;
			$type_forum = null;

			$query = "SELECT ".$GLOBALS['table_prefix']."_forum.id_forum, ".$GLOBALS['table_prefix']."_forum.id_parent, ".$GLOBALS['table_prefix']."_forum.id_rubrique, ".$GLOBALS['table_prefix']."_forum.id_article, ".$GLOBALS['table_prefix']."_forum.id_breve, ".$GLOBALS['table_prefix']."_forum.date_heure, ".$GLOBALS['table_prefix']."_forum.titre, ".$GLOBALS['table_prefix']."_forum.texte, ".$GLOBALS['table_prefix']."_forum.auteur, ".$GLOBALS['table_prefix']."_forum.email_auteur, ".$GLOBALS['table_prefix']."_forum.nom_site, ".$GLOBALS['table_prefix']."_forum.url_site, ".$GLOBALS['table_prefix']."_forum.statut, ".$GLOBALS['table_prefix']."_forum.ip, ".$GLOBALS['table_prefix']."_forum.id_auteur FROM ".$GLOBALS['table_prefix']."_forum, ".$GLOBALS['table_prefix']."_rubriques WHERE 1=1 ";

			if(ereg('sujet,message', $typeRecherche))
					$query .= " AND ".$GLOBALS['table_prefix']."_forum.id_rubrique=".$GLOBALS['table_prefix']."_rubriques.id_rubrique AND (".$GLOBALS['table_prefix']."_forum.titre like '%" . $recherche . "%' OR ".$GLOBALS['table_prefix']."_forum.texte like '%" . $recherche . "%') ";

   			else {
			    if(ereg('sujet', $typeRecherche))
		            $query .= " AND ".$GLOBALS['table_prefix']."_forum.id_rubrique=".$GLOBALS['table_prefix']."_rubriques.id_rubrique AND ".$GLOBALS['table_prefix']."_forum.titre like '%" . $recherche . "%' ";
			    if(ereg('message', $typeRecherche))
		            $query .= " AND ".$GLOBALS['table_prefix']."_forum.id_rubrique=".$GLOBALS['table_prefix']."_rubriques.id_rubrique AND ".$GLOBALS['table_prefix']."_forum.texte like '%" . $recherche . "%' ";
			}
			$query .= " AND ".$GLOBALS['table_prefix']."_forum.statut IN ('publie','prop','off','poubelle')";
             
			//echo '<br>'.$query.'<br>';

			$queryResult = $db->query($query);

			if (DB::isError($queryResult)) {
				return PEAR::raiseError("[".get_class($this)." DB_forum : search()] ".$queryResult->getMessage()."", null,
				null, null, null, null, false);
			}

			while ($row = $queryResult->fetchRow()) {
				$resultForum = &BD_forum::factory($this->getDbParameters(), $this->getDbOptions());
				$resultForum->_fetchData($row);
				$forums[] = &$resultForum;
			}
			$queryResult->free();

			//$query = 'SELECT DISTINCT(".$GLOBALS['table_prefix']."_forum.id_forum), ".$GLOBALS['table_prefix']."_forum.id_parent, ".$GLOBALS['table_prefix']."_forum.id_rubrique, ".$GLOBALS['table_prefix']."_forum.id_article, ".$GLOBALS['table_prefix']."_forum.id_breve, ".$GLOBALS['table_prefix']."_forum.date_heure, ".$GLOBALS['table_prefix']."_forum.titre, ".$GLOBALS['table_prefix']."_forum.texte, ".$GLOBALS['table_prefix']."_forum.auteur, ".$GLOBALS['table_prefix']."_forum.email_auteur, ".$GLOBALS['table_prefix']."_forum.nom_site, ".$GLOBALS['table_prefix']."_forum.url_site, ".$GLOBALS['table_prefix']."_forum.statut, ".$GLOBALS['table_prefix']."_forum.ip, ".$GLOBALS['table_prefix']."_forum.id_auteur FROM ".$GLOBALS['table_prefix']."_forum, ".$GLOBALS['table_prefix']."_articles WHERE 1=1 ';
	  		$query = "SELECT ".$GLOBALS['table_prefix']."_forum.id_forum, ".$GLOBALS['table_prefix']."_forum.id_parent, ".$GLOBALS['table_prefix']."_forum.id_rubrique, ".$GLOBALS['table_prefix']."_forum.id_article, ".$GLOBALS['table_prefix']."_forum.id_breve, ".$GLOBALS['table_prefix']."_forum.date_heure, ".$GLOBALS['table_prefix']."_forum.titre, ".$GLOBALS['table_prefix']."_forum.texte, ".$GLOBALS['table_prefix']."_forum.auteur, ".$GLOBALS['table_prefix']."_forum.email_auteur, ".$GLOBALS['table_prefix']."_forum.nom_site, ".$GLOBALS['table_prefix']."_forum.url_site, ".$GLOBALS['table_prefix']."_forum.statut, ".$GLOBALS['table_prefix']."_forum.ip, ".$GLOBALS['table_prefix']."_forum.id_auteur FROM ".$GLOBALS['table_prefix']."_forum, ".$GLOBALS['table_prefix']."_articles WHERE 1=1 ";
	    	if(ereg('sujet,message,danstouslesforums', $typeRecherche))
            	$query .= " AND ".$GLOBALS['table_prefix']."_forum.id_article=".$GLOBALS['table_prefix']."_articles.id_article AND (".$GLOBALS['table_prefix']."_forum.titre like '%" . $recherche . "%' OR ".$GLOBALS['table_prefix']."_forum.texte like '%" . $recherche . "%') ";

        	else {
	        if(ereg('sujet,danstouslesforums', $typeRecherche))
                $query .= " AND ".$GLOBALS['table_prefix']."_forum.id_article=".$GLOBALS['table_prefix']."_articles.id_article AND ".$GLOBALS['table_prefix']."_forum.titre like '%" . $recherche . "%' ";
	        if(ereg('message,danstouslesforums', $typeRecherche))
                $query .= "AND ".$GLOBALS['table_prefix']."_forum.id_article=".$GLOBALS['table_prefix']."_articles.id_article AND ".$GLOBALS['table_prefix']."_forum.texte like '%" . $recherche . "%' ";
        }
        $query .= " AND ".$GLOBALS['table_prefix']."_forum.statut IN ('publie','prop','off','poubelle')";
         
        //echo '<br>'.$query.'<br>';

        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_forum : search()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

        	while ($row = $queryResult->fetchRow()) {
            	$resultForum = &BD_forum::factory($this->getDbParameters(), $this->getDbOptions());
				$resultForum->_fetchData($row);
            	$forums[] = &$resultForum;
        	}
        $queryResult->free();

        $query = "SELECT ".$GLOBALS['table_prefix']."_forum.id_forum, ".$GLOBALS['table_prefix']."_forum.id_parent, ".$GLOBALS['table_prefix']."_forum.id_rubrique, ".$GLOBALS['table_prefix']."_forum.id_article, ".$GLOBALS['table_prefix']."_forum.id_breve, ".$GLOBALS['table_prefix']."_forum.date_heure, ".$GLOBALS['table_prefix']."_forum.titre, ".$GLOBALS['table_prefix']."_forum.texte, ".$GLOBALS['table_prefix']."_forum.auteur, ".$GLOBALS['table_prefix']."_forum.email_auteur, ".$GLOBALS['table_prefix']."_forum.nom_site, ".$GLOBALS['table_prefix']."_forum.url_site, ".$GLOBALS['table_prefix']."_forum.statut, ".$GLOBALS['table_prefix']."_forum.ip, ".$GLOBALS['table_prefix']."_forum.id_auteur FROM ".$GLOBALS['table_prefix']."_forum, ".$GLOBALS['table_prefix']."_breves WHERE 1=1 ";

	    if(ereg('sujet,message,danstouslesforums', $typeRecherche))
            $query .= "AND ".$GLOBALS['table_prefix']."_forum.id_breve=".$GLOBALS['table_prefix']."_breves.id_breve AND (".$GLOBALS['table_prefix']."_forum.titre like '%" . $recherche . "%' OR ".$GLOBALS['table_prefix']."_forum.texte like '%" . $recherche . "%') ";

        else {
	        if(ereg('sujet,danstouslesforums', $typeRecherche))
                $query .= " AND ".$GLOBALS['table_prefix']."_forum.id_breve=".$GLOBALS['table_prefix']."_breves.id_breve AND ".$GLOBALS['table_prefix']."_forum.titre like '%" . $recherche . "%' ";

	        if(ereg('message,danstouslesforums', $typeRecherche))
                $query .= " AND ".$GLOBALS['table_prefix']."_forum.id_breve=".$GLOBALS['table_prefix']."_breves.id_breve AND ".$GLOBALS['table_prefix']."_forum.texte like '%" . $recherche . "%' ";

        }
        $query .= " AND ".$GLOBALS['table_prefix']."_forum.statut IN ('publie','prop','off','poubelle')";
         
		//echo '<br>'.$query.'<br>';

        $queryResult = $db->query($query);


        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_forum : search()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $queryResult->fetchRow()) {
            $resultForum = &BD_forum::factory($this->getDbParameters(), $this->getDbOptions());
            $resultForum->_fetchData($row);
            $forums[] = &$resultForum;
        }
        $queryResult->free();
	}

	if(!ereg('danstouslesforums', $typeRecherche)) {
		if($id_current_forum != null) {
			switch ($type_forum) {

				case 'rubrique':
					$query = "SELECT ".$GLOBALS['table_prefix']."_forum.id_forum, ".$GLOBALS['table_prefix']."_forum.id_parent, ".$GLOBALS['table_prefix']."_forum.id_rubrique, ".$GLOBALS['table_prefix']."_forum.id_article, ".$GLOBALS['table_prefix']."_forum.id_breve, ".$GLOBALS['table_prefix']."_forum.date_heure, ".$GLOBALS['table_prefix']."_forum.titre, ".$GLOBALS['table_prefix']."_forum.texte, ".$GLOBALS['table_prefix']."_forum.auteur, ".$GLOBALS['table_prefix']."_forum.email_auteur, ".$GLOBALS['table_prefix']."_forum.nom_site, ".$GLOBALS['table_prefix']."_forum.url_site, ".$GLOBALS['table_prefix']."_forum.statut, ".$GLOBALS['table_prefix']."_forum.ip, ".$GLOBALS['table_prefix']."_forum.id_auteur FROM ".$GLOBALS['table_prefix']."_forum, ".$GLOBALS['table_prefix']."_rubriques WHERE 1=1 ";
					if(ereg('sujet,message', $typeRecherche))
	            		$query .= " AND ".$GLOBALS['table_prefix']."_forum.id_rubrique=".$GLOBALS['table_prefix']."_rubriques.id_rubrique AND (".$GLOBALS['table_prefix']."_forum.titre like '%" . $recherche . "%' OR ".$GLOBALS['table_prefix']."_forum.texte like '%" . $recherche . "%') ";
					else {
		        		if(ereg('sujet', $typeRecherche))
	                		$query .= " AND ".$GLOBALS['table_prefix']."_forum.id_rubrique=".$GLOBALS['table_prefix']."_rubriques.id_rubrique AND ".$GLOBALS['table_prefix']."_forum.titre like '%" . $recherche . "%' ";
						if(ereg('message', $typeRecherche))
	                		$query .= " AND ".$GLOBALS['table_prefix']."_forum.id_rubrique=".$GLOBALS['table_prefix']."_rubriques.id_rubrique AND ".$GLOBALS['table_prefix']."_forum.texte like '%" . $recherche . "%' ";
					}
					$query .= ' AND id_forum = '.$id_current_forum;
	        	break;

				case 'breve':
	        		$query = "SELECT ".$GLOBALS['table_prefix']."_forum.id_forum, ".$GLOBALS['table_prefix']."_forum.id_parent, ".$GLOBALS['table_prefix']."_forum.id_rubrique, ".$GLOBALS['table_prefix']."_forum.id_article, ".$GLOBALS['table_prefix']."_forum.id_breve, ".$GLOBALS['table_prefix']."_forum.date_heure, ".$GLOBALS['table_prefix']."_forum.titre, ".$GLOBALS['table_prefix']."_forum.texte, ".$GLOBALS['table_prefix']."_forum.auteur, ".$GLOBALS['table_prefix']."_forum.email_auteur, ".$GLOBALS['table_prefix']."_forum.nom_site, ".$GLOBALS['table_prefix']."_forum.url_site, ".$GLOBALS['table_prefix']."_forum.statut, ".$GLOBALS['table_prefix']."_forum.ip, ".$GLOBALS['table_prefix']."_forum.id_auteur FROM ".$GLOBALS['table_prefix']."_forum, ".$GLOBALS['table_prefix']."_breves WHERE 1=1 ";
					if(ereg('sujet,message', $typeRecherche))
						$query .= "AND ".$GLOBALS['table_prefix']."_forum.id_breve=".$GLOBALS['table_prefix']."_breves.id_breve AND (".$GLOBALS['table_prefix']."_forum.titre like '%" . $recherche . "%' OR ".$GLOBALS['table_prefix']."_forum.texte like '%" . $recherche . "%') ";
					else {
		        		if(ereg('sujet', $typeRecherche))
	                		$query .= " AND ".$GLOBALS['table_prefix']."_forum.id_breve=".$GLOBALS['table_prefix']."_breves.id_breve AND ".$GLOBALS['table_prefix']."_forum.titre like '%". $recherche . "%' ";
						if(ereg('message', $typeRecherche))
	                		$query .= " AND ".$GLOBALS['table_prefix']."_forum.id_breve=".$GLOBALS['table_prefix']."_breves.id_breve AND ".$GLOBALS['table_prefix']."_forum.texte like '%" . $recherche . "%' ";
					}
					$query .= " AND ".$GLOBALS['table_prefix']."_forum.id_breve = ".$id_current_forum;
	        	break;

	        	case 'article':
	        		//echo "c'est un article";
	        		$query = "SELECT ".$GLOBALS['table_prefix']."_forum.id_forum, ".$GLOBALS['table_prefix']."_forum.id_parent, ".$GLOBALS['table_prefix']."_forum.id_rubrique, ".$GLOBALS['table_prefix']."_forum.id_article, ".$GLOBALS['table_prefix']."_forum.id_breve, ".$GLOBALS['table_prefix']."_forum.date_heure, ".$GLOBALS['table_prefix']."_forum.titre, ".$GLOBALS['table_prefix']."_forum.texte, ".$GLOBALS['table_prefix']."_forum.auteur, ".$GLOBALS['table_prefix']."_forum.email_auteur, ".$GLOBALS['table_prefix']."_forum.nom_site, ".$GLOBALS['table_prefix']."_forum.url_site, ".$GLOBALS['table_prefix']."_forum.statut, ".$GLOBALS['table_prefix']."_forum.ip, ".$GLOBALS['table_prefix']."_forum.id_auteur FROM ".$GLOBALS['table_prefix']."_forum, ".$GLOBALS['table_prefix']."_articles WHERE 1=1 ";
					if(ereg('sujet,message', $typeRecherche)) {
						$query .= " AND ".$GLOBALS['table_prefix']."_forum.id_article=".$GLOBALS['table_prefix']."_articles.id_article AND (".$GLOBALS['table_prefix']."_forum.titre like '%" . $recherche . "%' OR ".$GLOBALS['table_prefix']."_forum.texte like '%" . $recherche . "%') ";
					}
					else {
		        		if(ereg('sujet', $typeRecherche))
	                		$query .= " AND ".$GLOBALS['table_prefix']."_forum.id_article=".$GLOBALS['table_prefix']."_articles.id_article AND ".$GLOBALS['table_prefix']."_forum.titre like '%" . $recherche . "%' ";
						if(ereg('message', $typeRecherche))
	                		$query .= " AND ".$GLOBALS['table_prefix']."_forum.id_article=".$GLOBALS['table_prefix']."_articles.id_article AND ".$GLOBALS['table_prefix']."_forum.texte like '%" . $recherche . "%' ";
					}
	        		$query .= " AND ".$GLOBALS['table_prefix']."_forum.id_article = ".$id_current_forum;
	        	break;
			}

	 	$query .= " AND ".$GLOBALS['table_prefix']."_forum.statut IN ('publie','prop','off','poubelle')";
         
        //echo '<br>'.$query.'<br>';

        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_forum : search()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $queryResult->fetchRow()) {
            $resultForum = &BD_forum::factory($this->getDbParameters(), $this->getDbOptions());

            $resultForum->_fetchData($row);
            $forums[] = &$resultForum;
        }

        $queryResult->free();
	}
	}

	 return $forums;
}

    // }}}

    // {{{ changeStatutOK($forumId, $statut)

    /**
     * Returns an boolean.
     *
     * @return boolean
     * @param $forumId
     * @param $statut
     * @access public
     */

    function changeStatutOK($forumId, $statut) {
        $forums = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_forum : changeStatutOK()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        if($statut == 'publie') {
            $query = "SELECT id_parent FROM ".$GLOBALS['table_prefix']."_forum WHERE id_forum=" . $forumId;
            $row = $db->getRow($query);

            while ($row['id_parent'] != 0) {
                $query = "SELECT id_parent, statut FROM ".$GLOBALS['table_prefix']."_forum WHERE id_forum=" . $row['id_parent'];
                $row = $db->getRow($query);
                if($row['statut'] != 'publie') return false;
            }
        }

        if($statut == 'poubelle') {
            $query = "SELECT count(*) as cpt FROM "
            .$GLOBALS['table_prefix']."_forum WHERE id_parent=" 
            . $forumId . " AND statut!='poubelle'";
	        //echo '<br>'.$query.'<br>';
            if($db->getOne($query) > 0) return false;
        }

        if($statut == 'off') {
            $query = "SELECT count(*) as cpt FROM ".$GLOBALS['table_prefix']."_forum WHERE id_parent=" . $forumId . " AND statut!='poubelle' AND statut!='off'";
	        //echo '<br>'.$query.'<br>';
            if($db->getOne($query) > 0) return false;
        }
        return true;
    }

    // }}}

    // {{{ getBranch($forumId)

    /**
     * Returns a string.
     *
     * @return String
     * @param $forumId

     * @access public
     */

    function getBranch($forumId, $params = array()) {
        $branch = array();
        $db = &$this->_getDB();

		$affMessage = implode(",", $params['affMessage']);

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_forum : changeStatutOK()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT id_parent FROM ".$GLOBALS['table_prefix']."_forum WHERE id_forum=" . $forumId;
		$row = $db->getRow($query);

        while ($row['id_parent'] != 0) {
            $id_parent = $row['id_parent'];
            $query = "SELECT id_parent, titre FROM ".$GLOBALS['table_prefix']."_forum WHERE id_forum=" . $row['id_parent'];
            $row = $db->getRow($query);
            $branch[] = '<a href="affichage_message.php3?affMessage[]=' . $affMessage . '&id_forum=' . $id_parent . '&id_current_forum=' . $params['id_current_forum'] . '&type_forum=' . $params['type_forum']. '&affType=' . $params['affType'] . '&ageMessage=' . $params['ageMessage'] . '">' . $row['titre'] . '</a>';
        }
        return implode("&nbsp;&nbsp;&nbsp;<img src=\"img_pack/fleche.gif\">&nbsp;&nbsp;&nbsp;", array_reverse($branch));
    }

    // }}}

	// {{{ sendMail($forum)

    function sendMail($forum, $adresseMessage = '') {
		if ($adresseMessage == '')	$adresseMessage = lire_meta('adresse_site');
		$nom_site_spip = lire_meta("nom_site");
		$adresse_site = lire_meta("addresse_site");

		include_ecrire('inc_mail.php3');
		$message = _T('reponse_forum_message', array('email' => $forum->getEmailAuteur(), 'adresse_message' => $adresseMessage, 'titreMessagePere' => $this->getTitre()));


        if($this->getEmailAlerte() == 'oui') {
        	envoyer_mail($this->getEmailAuteur(), '[' . $nom_site_spip . ']  ' . _T('reponse_forum'), $message);
        }
    }

    // }}}
    
    
	// {{{ advertiseAuthorPublished($adresseMessage = '')

    function advertiseAuthorPublished($adresseMessage = '') {
		if ($adresseMessage == '')	$adresseMessage = lire_meta('adresse_site');
		$nom_site_spip = lire_meta("nom_site");
		$adresse_site = lire_meta("addresse_site");

		include_ecrire('inc_mail.php3');
		$message = _T('reponse_forum_publie', array('titre_message' => $this->getTitre(), 'adresse_message' => $adresseMessage));


        if($this->getEmailAlerte() == 'oui') {
        	envoyer_mail($this->getEmailAuteur(), '[' . $nom_site_spip . ']  ' . _T('reponse_forum'), $message);
        }
    }

    // }}}

	// {{{ advertiseAuthorRefused()

    function advertiseAuthorRefused() {
		include_ecrire('inc_mail.php3');
		$message = _T('reponse_forum_refuse', array('titre_message' => $this->getTitre()));


        if($this->getEmailAlerte() == 'oui') {
        	envoyer_mail($this->getEmailAuteur(), '[' . $nom_site_spip . ']  ' . _T('reponse_forum'), $message);
        }
    }

    // }}}

	// {{{ isArchive($articleId, $rubriqueId)

    function isArchive($articleId, $rubriqueId) {
		if($articleId != 0) {
			$articleMetier = &recuperer_instance_article();
			$loadOK = $articleMetier->load($articleId);
			if(PEAR::isError($loadOK)) {
				return false;
			}
			if($articleMetier->getStatut() == 'archi') {
				return false;
			}
			else {
				return true;
			}
		}

		if($rubriqueId != 0) {
			$rubriqueMetier = &recuperer_instance_rubrique();
			$loadOK = $rubriqueMetier->load($rubriqueId);
			if(PEAR::isError($loadOK)) {
				return false;
			}
			if($rubriqueMetier->getStatut() == 'archi') {
				return false;
			}
			else {
				return true;
			}
		}
		return true;
    }

    // }}}

}
?>