<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Erwan LE BESCOND <elebescond@clever-age.com>                |
// +----------------------------------------------------------------------+
//
// Base class for Forum List Data abstraction.
//

/**
 * BD_forumListData is a base class for forum lists data database abstraction implementations, and must be
 * inherited by all such.
 */

if (defined("_BD_FORUMLISTDATA")) return;
    define("_BD_FORUMLISTDATA", "1");

/* Ajout Clever Age / Erwan LE BESCOND */
require_once ("PEAR.php");
require_once (dirname(__FILE__)."/inc_forum_factory.php");
/* fin zone de modification Clever Age */

require_once "PEAR.php";
require_once "DB.php";
require_once dirname(__FILE__)."/objectlistdata.php";
require_once dirname(__FILE__)."/inc_listdata_querytypes_constants.php";

/**
 * This class implements data lists for Forum business data type
 * @package	BD
 * @author  Antoine Angnieux <aangenieux@clever-age.com>
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @access	public
 */
class BD_forumListData extends BD_objectListData {

    /**
     * Create a new forum list data object for the specified database parameters
     * passed
     *
     * @param BD_parameters $dbParameters database configuration object
     * @return mixed a newly created ForumListData object, or a PEAR error code on
     *               error
     * @access public
     */
    function &factory($dbParameters = null) {

        if(file_exists(dirname(__FILE__)."/".$dbParameters->_dbEngine."/forumlistdata_".$dbParameters->_dbEngine.".php") == false) {
            include_once(dirname(__FILE__)."/common/forumlistdata_common.php");
            $classname = "BD_forumlistdata_common";
        }
        else {
            include_once(dirname(__FILE__)."/".$dbParameters->_dbEngine."/forumlistdata_".$dbParameters->_dbEngine.".php");
            $classname = "BD_forumListData_".$dbParameters->_dbEngine;
        }

        if (!class_exists($classname)) {
            return PEAR::raiseError("Cannot instanciate class $classname", null,
                                    null, null, null, null, false);
        }

        $obj =& new $classname;
        $result = $obj->setDbParameters($dbParameters);
        if (PEAR::isError($result)) {
            return $result;
        } else {
            return $obj;
        }
    }

    // {{{ constructor

    /**
     * Abstract Constructor.
     *
     * @access public
     */


    function BD_forumListData() {
        $par = get_parent_class(get_parent_class($this));
        $this->$par();
    }

    // }}}


    // {{{ displayHTMLList($titre_table, $queryType, $afficher_visites = false, $afficher_auteurs = true, $toujours_afficher = false, $afficher_cadre = true)

    /**
     * returns the HTML List for the various forum data lists implementations
     * This method should <b>NEVER<b> be overloaded, otherwise EXTRA-EXTRA-CARE is required
     * while overloading this method.
     *
     * @return String reprensenting the generated HTML list navigation
     * @param $queryType int representing the desired query type (refer to inc_listdata_query_types_contants.php)
     * @param $params array containing the query parameters
     * @param $countQuery boolean : if set to true, the returned query is a count result query for the specified query type.
     * @access public
     */
    function displayHTMLList($queryType, $params = array(), $adresse_retour, $controle = "non", $recurrence = "oui", $firstElement = 0, $lastElement = 0) {
	    global $debut;
	    static $compteur_forum;
	    static $nb_forum;
	    static $i;
	    global $couleur_foncee;
	    global $connect_id_auteur, $connect_activer_messagerie;
	    global $mots_cles_forums;
	    global $spip_lang_rtl;

        $db = &$this->_getDB();
        if (DB::isError($db)) {
            die("Impossible d'obternir une connexion  la base de donnes! ".$db->getMessage());
        }

	    $activer_messagerie = lire_meta("activer_messagerie");

        $requete = $this->_getQuery($queryType, false, $params);

       

        $compteur_forum++;
        if($lastElement > 0) {
            $queryResult = $db->limitQuery($requete, $firstElement, $lastElement, $params);
        }
        else {
            $queryResult = $db->query($requete, $params);
        }

	    if (DB::isError($queryResult)) {
            return $queryResult;
        }

	    $nb_forum[$compteur_forum] = $queryResult->numRows();

	    $i[$compteur_forum] = 1;
	    
 	    while($row = $queryResult->fetchRow()) {
		    $id_forum=$row['id_forum'];
		    $id_parent=$row['id_parent'];
		    $id_rubrique=$row['id_rubrique'];
		    $id_article=$row['id_article'];
		    $id_breve=$row['id_breve'];
		    $id_message=$row['id_message'];
		    $id_syndic=$row['id_syndic'];
		    $date_heure=$row['date_heure'];
		    $titre=$row['titre'];
		    $texte=$row['texte'];
		    $auteur=$row['auteur'];
		    $email_auteur=$row['email_auteur'];
		    $nom_site=$row['nom_site'];
		    $url_site=$row['url_site'];
		    $statut=$row['statut'];
		    $ip=$row["ip"];
		    $id_auteur=$row["id_auteur"];

		    if ($compteur_forum==1){echo "<BR><BR>\n";}

		    $afficher = ($controle=="oui") ? ($statut!="perso") :
    			(($statut=="prive" OR $statut=="privrac" OR $statut=="privadm" OR $statut=="perso")
			    OR ($statut=="publie" AND $id_parent > 0));

		    if ($afficher) {
    			echo "<table width=100% cellpadding=0 cellspacing=0 border=0><tr>";
			    for ($count=2;$count<=$compteur_forum AND $count<20;$count++){
    				$fond[$count]='img_pack/rien.gif';
				    if ($i[$count]!=$nb_forum[$count]){
    					$fond[$count]='img_pack/forum-vert.gif';
				    }
				    $fleche='img_pack/rien.gif';
				    if ($count==$compteur_forum){
    					$fleche="img_pack/forum-droite$spip_lang_rtl.gif";
				    }
				    echo "<td width=10 valign='top' background=$fond[$count]><img src='$fleche' alt='' width=10 height=13 border=0></td>\n";
			    }

			    echo "\n<td width=100% valign='top'>";

			    // Si refuse, cadre rouge
			    if ($statut=="off") {
    				echo "<table width=100% cellpadding=2 cellspacing=0 border=0><tr><td>";
			    }
			    // Si propose, cadre jaune
			    else if ($statut=="prop") {
    				echo "<table width=100% cellpadding=2 cellspacing=0 border=0><tr><td>";
			    }

			    if ($compteur_forum == 1) echo debut_cadre_relief("forum-interne-24.gif");
			    echo "<table width=100% cellpadding=3 cellspacing=0><tr><td bgcolor='$couleur_foncee'><font face='Verdana,Arial,Helvetica,sans-serif' size=2 color='#FFFFFF'><b>".typo($titre)."</b></font></td></tr>";
			    echo "<tr><td bgcolor='#EEEEEE'>";
			    echo "<font size=2 face='Georgia,Garamond,Times,serif'>";
			    echo "<font face='arial,helvetica'>$date_heure</font>";

			    if ($email_auteur) {
    				echo " <a href=\"mailto:$email_auteur?subject=".rawurlencode($titre)."\">$auteur</a>";
			    }
			    else {
    				echo " $auteur";
			    }

			    if ($id_auteur AND $activer_messagerie != "non" AND $connect_activer_messagerie != "non") {
    				$bouton = bouton_imessage($id_auteur,$row_auteur);
	    			if ($bouton) echo "&nbsp;".$bouton;
			    }

			    if ($controle == "oui") {
                    switch ($statut) {
	                    case 'publie':
	                        icone(_T('icone_supprimer_message'), "articles_forum.php3?id_article=$id_article&poub_forum=$id_forum&debut=$debut", "forum-interne-24.gif", "supprimer.gif", "right");
	                        icone(_T('icone_desactiver_message'), "articles_forum.php3?id_article=$id_article&off_forum=$id_forum&debut=$debut", "forum-interne-24.gif", "supprimer_agora.gif", "right");
	                    break;

	                    case 'prop':
                            icone(_T('icone_supprimer_message'), "articles_forum.php3?id_article=$id_article&poub_forum=$id_forum&debut=$debut", "forum-interne-24.gif", "supprimer.gif", "right");
                            icone(_T('icone_desactiver_message'), "articles_forum.php3?id_article=$id_article&off_forum=$id_forum&debut=$debut", "forum-interne-24.gif", "supprimer_agora.gif", "right");
	                        icone(_T('icone_valider_message'), "articles_forum.php3?id_article=$id_article&valid_forum=$id_forum&debut=$debut", "forum-interne-24.gif", "creer.gif", "right", 'non');
	                    break;

	                    case 'off':
	                        icone(_T('icone_supprimer_message'), "articles_forum.php3?id_article=$id_article&poub_forum=$id_forum&debut=$debut", "forum-interne-24.gif", "supprimer.gif", "right");
	    	                icone(_T('icone_valider_message'), "articles_forum.php3?id_article=$id_article&valid_forum=$id_forum&debut=$debut", "forum-interne-24.gif", "creer.gif", "right");
	                    break;
	                }
    				/*
    				if ($statut != "off") {
					    icone (_T('icone_supprimer_message'), "articles_forum.php3?id_article=$id_article&supp_forum=$id_forum&debut=$debut", "forum-interne-24.gif", "supprimer.gif", "right");
				    }
				    else {
    					echo "<br><font color='red'><b>"._T('info_message_supprime')." $ip</b></font>";
					    if ($id_auteur) {
    						echo " - <a href='auteurs_edit.php3?id_auteur=$id_auteur'>"._T('lien_voir_auteur')."</A>";
					    }
				    }
				    if ($statut == "prop" OR $statut == "off") {
    					icone (_T('icone_valider_message'), "articles_forum.php3?id_article=$id_article&valid_forum=$id_forum&debut=$debut", "forum-interne-24.gif", "creer.gif", "right");
				    }
				    */
			    }
			    echo justifier(propre($texte));

			    if (strlen($url_site) > 10 AND $nom_site) {
    				echo "<p align='left'><font face='Verdana,Arial,Helvetica,sans-serif'><b><a href='$url_site'>$nom_site</a></b></font>";
			    }

			    if ($controle != "oui") {
    				echo "<p align='right'><font face='Verdana,Arial,Helvetica,sans-serif' size=1>";
				    $url = "forum_envoi.php3?id_parent=$id_forum&adresse_retour=".rawurlencode($adresse_retour)
    					."&titre_message=".rawurlencode($titre);
				    echo "<b><a href=\"$url\">"._T('lien_repondre_message')."</a></b></font>";
			    }

			    if ($mots_cles_forums == "oui"){
                    $motMetier = &recuperer_instance_mot();
        	        $allMots = $motMetier->getAllFromMotsAndAnotherTable("forum", "id_forum", $id_forum, true);

        	        while (list(,$motMetier) = each($allMots)) {
                        $id_mot = $motMetier->getMotId();
        			    $titre_mot = propre($motMetier->getTitre());
        			    $type_mot = propre($motMetier->getType());
        			    echo "<li> <b>$type_mot :</b> $titre_mot";
                    }
    			}

			    echo "</font>";
			    echo "</td></tr></table>";
			    if ($compteur_forum == 1) echo fin_cadre_relief();
			    if ($statut == "off" OR $statut == "prop") {
    				echo "</td></tr></table>";
			    }
			    echo "</td></tr></table>\n";

			    if ($recurrence == "oui") forum($id_forum,$adresse_retour,$controle);
		    }
		    $i[$compteur_forum]++;
	    }
	    $compteur_forum--;
    }

    // }}}

    // {{{ _fillQueries()

    /**
     * This methods fill the query associative arrays with SQL 92 compliant
     * queries. Each driver that requires specific SQL querying must implement
     * the _adaptQueriesToDriver() method.
     * @access  private
     * @see     _adaptQueriesToDriver()
     */
    function _fillQueries() {
        $this->_queries[FORUM_BY_STATE_AND_ARTICLEID] = "SELECT * FROM ".$GLOBALS['table_prefix']."_forum WHERE statut=? AND id_article=? AND id_parent=0 ORDER BY date_heure DESC";
        $this->_queriesCount[FORUM_BY_STATE_AND_ARTICLEID] = "SELECT COUNT(*) FROM ".$GLOBALS['table_prefix']."_forum WHERE statut=? AND id_article=? AND id_parent=0";
        /*
        $this->_queries[FORUM_BY_STATE_AND_ARTICLEID] = "SELECT * FROM ".$GLOBALS['table_prefix']."_forum WHERE statut=? AND id_article=? AND id_parent=0 ORDER BY date_heure DESC LIMIT ?,?";
        $this->_queriesCount[FORUM_BY_STATE_AND_ARTICLEID] = "SELECT COUNT(*) FROM ".$GLOBALS['table_prefix']."_forum WHERE statut=? AND id_article=? AND id_parent=0 ORDER BY date_heure DESC LIMIT ?,?";
        */
        $this->_queries[FORUM_BY_ARTICLEID] = "SELECT * FROM ".$GLOBALS['table_prefix']."_forum WHERE id_article=? AND id_parent=0 AND statut IN ('publie', 'off', 'prop') ORDER BY date_heure DESC";
        $this->_queriesCount[FORUM_BY_ARTICLEID] = "SELECT COUNT(*) FROM ".$GLOBALS['table_prefix']."_forum WHERE id_article=? AND id_parent=0 AND statut IN ('publie', 'off', 'prop')";

        $this->_queries[FORUM_BY_STATE_AND_BREVEID] = "SELECT * FROM ".$GLOBALS['table_prefix']."_forum WHERE statut=? AND id_breve=? AND id_parent=0 ORDER BY date_heure DESC";
        $this->_queriesCount[FORUM_BY_STATE_AND_BREVEID] = "SELECT COUNT(*) FROM ".$GLOBALS['table_prefix']."_forum WHERE statut=? AND id_breve=? AND id_parent=0";
        /*
        $this->_queries[FORUM_BY_STATE_AND_BREVEID] = "SELECT * FROM ".$GLOBALS['table_prefix']."_forum WHERE statut=? AND id_breve=? AND id_parent=0 ORDER BY date_heure DESC LIMIT 0,20";
        $this->_queriesCount[FORUM_BY_STATE_AND_BREVEID] = "SELECT COUNT(*) FROM ".$GLOBALS['table_prefix']."_forum WHERE statut=? AND id_breve=? AND id_parent=0 ORDER BY date_heure DESC LIMIT 0,20";
        */

        $this->_queries[FORUM_BY_STATE] = "SELECT * FROM ".$GLOBALS['table_prefix']."_forum WHERE statut=? AND id_parent=0 ORDER BY date_heure DESC";
        $this->_queriesCount[FORUM_BY_STATE] = "SELECT COUNT(*) FROM ".$GLOBALS['table_prefix']."_forum WHERE statut=? AND id_parent=0";
        /*
        $this->_queries[FORUM_BY_STATE] = "SELECT * FROM ".$GLOBALS['table_prefix']."_forum WHERE statut=? AND id_parent=0 ORDER BY date_heure DESC LIMIT ?,10";
        $this->_queriesCount[FORUM_BY_STATE] = "SELECT * FROM ".$GLOBALS['table_prefix']."_forum WHERE statut=? AND id_parent=0 ORDER BY date_heure DESC LIMIT ?,10";
        */

        $this->_queries[FORUM_BY_PARENT_ID] = "SELECT * FROM ".$GLOBALS['table_prefix']."_forum WHERE id_parent=? ORDER BY date_heure";
        $this->_queriesCount[FORUM_BY_PARENT_ID] = "SELECT COUNT(*) FROM ".$GLOBALS['table_prefix']."_forum WHERE id_parent=?";

        $this->_queries[FORUM_BY_PARENT_ID_AND_STATUT] = "SELECT * FROM ".$GLOBALS['table_prefix']."_forum WHERE id_parent=? AND statut<>'off' ORDER BY date_heure";
        $this->_queriesCount[FORUM_BY_PARENT_ID_AND_STATUT] = "SELECT COUNT(*) FROM ".$GLOBALS['table_prefix']."_forum WHERE id_parent=? AND statut<>'off'";

        $this->_queries[FORUM_BY_STATE_AND_MESSAGEID] = "SELECT * FROM ".$GLOBALS['table_prefix']."_forum WHERE statut=? AND id_message=? AND id_parent=0 ORDER BY date_heure DESC";
        $this->_queriesCount[FORUM_BY_STATE_AND_MESSAGEID] = "SELECT COUNT(*) FROM ".$GLOBALS['table_prefix']."_forum WHERE statut=? AND id_message=? AND id_parent=0";
        /*
        $this->_queries[FORUM_BY_STATE_AND_MESSAGEID] = "SELECT * FROM ".$GLOBALS['table_prefix']."_forum WHERE statut=? AND id_message=? AND id_parent=0 ORDER BY date_heure DESC LIMIT 0,20";
        $this->_queriesCount[FORUM_BY_STATE_AND_MESSAGEID] = "SELECT * FROM ".$GLOBALS['table_prefix']."_forum WHERE statut=? AND id_message=? AND id_parent=0 ORDER BY date_heure DESC LIMIT 0,20";
        */

        $this->_queries[FORUM_BY_STATE_AND_SYNDICID] = "SELECT * FROM ".$GLOBALS['table_prefix']."_forum WHERE statut=? AND id_message=? AND id_syndic=0 ORDER BY date_heure DESC";
        $this->_queriesCount[FORUM_BY_STATE_AND_SYNDICID] = "SELECT COUNT(*) FROM ".$GLOBALS['table_prefix']."_forum WHERE statut=? AND id_message=? AND id_syndic=0";
        /*
        $this->_queries[FORUM_BY_STATE_AND_SYNDICID] = "SELECT * FROM ".$GLOBALS['table_prefix']."_forum WHERE statut=? AND id_message=? AND id_syndic=0 ORDER BY date_heure DESC LIMIT 0,20";
        $this->_queriesCount[FORUM_BY_STATE_AND_SYNDICID] = "SELECT * FROM ".$GLOBALS['table_prefix']."_forum WHERE statut=? AND id_message=? AND id_syndic=0 ORDER BY date_heure DESC LIMIT 0,20";
        */

    }

    // }}}

}
?>