<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Aurélien Vialet <avialet@clever-age.com>                     |
// +----------------------------------------------------------------------+
//
// Base class for Glossaire business persistence abstraction.
//

/* Ajout Clever Age / Erwan LE BESCOND / Couche m�tier */
require_once (dirname(__FILE__)."/inc_visite_factory.php");
require_once (dirname(__FILE__)."/inc_referer_factory.php");
require_once (dirname(__FILE__)."/inc_auteur_factory.php");
/* fin zone de modification Clever Age */

require_once "PEAR.php";
require_once "DB.php";

require_once dirname(__FILE__)."/metier.php";



define("GLOSSAIRE_ALL_FIELDS", "id, mot, url");



/**
 * BD_glossaire is a base class for glossaire business persistence abstraction implementations, and must be
 * inherited by all such.
 * @package	BD
 * @author  Aurélien Vialet <avialet@clever-age.com>
 * @access	public
 */

class BD_glossaire extends BD_metier {
	
    // {{{ properties


    /**
     * Glossaire ID.
     * @var     int
     * @access  private
     */
    var $_glossaireId;

	/**
	 * Mot
	 * @var		String
	 * @access	private
	 */ 
	var $_mot;
	
	/**
	 * url
	 * @var		String
	 * @access	private
	 */
	var $_url;
	
	// }}}
	
	// {{{ factory()

    /**
     * This method is a factory static method. It should be used to get any
     * specific implementation instance of Glossaire business data type.
     * @param   BD_parameters DB connection parameters
     * @access public
     */
    function &factory($dbParameters, $dbOptions = null) {

        if(file_exists(dirname(__FILE__)."/".$dbParameters->_dbEngine."/glossaire_".$dbParameters->_dbEngine.".php") == false) {
            include_once(dirname(__FILE__)."/common/glossaire_common.php");
            $classname = "BD_glossaire_common";
        }
        else {
            include_once(dirname(__FILE__)."/".$dbParameters->_dbEngine."/glossaire_".$dbParameters->_dbEngine.".php");
            $classname = "BD_glossaire_".$dbParameters->_dbEngine;
        }

        if (!class_exists($classname)) {
            return PEAR::raiseError("Cannot instanciate class $classname", null,
                null, null, null, null, false);
        }

        $obj =& new $classname;
        $result = $obj->setDbParameters($dbParameters);
        if ($dbOptions != null) {
            $obj->setDbOptions($dbOptions);
        }
        if (PEAR::isError($result)) {
            return $result;
        } else {
            return $obj;
        }
    }

    // }}}
    
    // {{{ constructor

    /**
     * DB_glossaire constructor.
     *
     * @access public
     */

    function BD_glossaire() {
    }

    // }}}

    // {{{ getGlossaireId

    function getGlossaireId() {
        return $this->_glossaireId;
    }

    // }}}

    // {{{ setGlossaireId()

    function setGlossaireId($glossaireId) {
        $this->_glossaireId = $glossaireId;
    }
    
    // {{{ getGlossaireMot
    
	function getGlossaireMot() {
		return $this->_mot;
	}
	
	// }}}
	
	// {{{ setGlossaireMot
	
	function setGlossaireMot($mot) {
		$this->_mot = $mot;
	}
	
	// }}}
	
	// {{{ getGlossaireUrl
	
	function getGlossaireUrl() {
		return $this->_url;
	}
	
	// }}}
	
	// {{{ setGlossaireUrl
	
	function setGlossaireUrl($url) {
		$this->_url = $url;
	}
	
	
	// {{{ create()

    /**
     * This method is used to create a new glossaire in the database
     * @access public
     */

    function create() {
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_glossaire : create()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        $string_prefix = $GLOBALS['table_prefix']."_glossaire";
        
        $glossaireId = $db->nextId($string_prefix, true);
        if (DB::isError($glossaireId)) {
            return PEAR::raiseError("[".get_class($this)." DB_glossaire : create()] ".$glossaireId->getMessage()."", null,
                null, null, null, null, false);
        }

        $this->_glossaireId = $glossaireId;

        
        if($this->_mot == null) $this->_glossaireMot = 0;
        if($this->_url == null) $this->_url = 0;
        
       
        $query = "INSERT INTO ".$GLOBALS['table_prefix']."_glossaire (".GLOSSAIRE_ALL_FIELDS.") VALUES "
                ."(".$this->_glossaireId.", "
                ."'".$db->quoteString($this->_mot)."', "
                ."'".$db->quoteString($this->_url)."') ";

        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_glossaire : create()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

    }

    // }}}
    
    
    function update() {
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_glossaire : update()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        
        $maDate = new Date();
	    $this->setMajDate($maDate->getDate(DATE_FORMAT_ISO));

        $query = "UPDATE ".$GLOBALS['table_prefix']."_glossaire "
                ."SET mot = '".$db->quoteString($this->_mot)."', "
                ."url = '".$db->quoteString($this->_url)."' "
                ." WHERE id_glossaire = ".$this->_glossaireId;

        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_glossaire : update()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

    }

    // }}}
    
    // {{{ delete()
    /**
     * This method is used to deleted an glossaire entry from the database
     * @access	public
     * @param 	int $idGlossaire id of glossaire to delete
     */
     
     function delete($idGlossaire) {
     	$db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_glossaire : load()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_glossaire WHERE id = $idGlossaire";
        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_glossaire : load()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
    		//$result->free();
        }
    }
     
	// }}}
    
    // {{{ load()

    /**
     * This method is used to load a glossaire from the database
     * @access  public
     * @param   int $idGlossaire id of glossaire to load
     */

    function load($idGlossaire) {
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_glossaire : load()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT ".GLOSSAIRE_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_glossaire WHERE id = $idGlossaire";
        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_glossaire : load()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
            if ($row = $result->fetchRow()) {
                $this->_fetchData($row);
            } else {
                return PEAR::raiseError("[".get_class($this)." DB_glossaire : load($idGlossaire)] Aucun glossaire ne correspond pas � cet ID!", null,
                                    null, null, null, null, false);
            }
            $result->free();
        }
    }

    // }}}
    
    
    // {{{ _fetchData()

    /**
     * This method is used to fetch result set fields into the object fields
     * @access  private
     * @param   int $row from load function
     */

    function _fetchData($row) {
        $this->setGlossaireId($row['id']);
        $this->setGlossaireMot($row['mot']);
        $this->setGlossaireUrl($row['url']);
    }

    // }}}
    
    
    
    
    
	
}