<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Aurélien Vialet <avialet@clever-age.com>                     |
// +----------------------------------------------------------------------+
//
// 
//

/* Ajout Clever Age / Erwan LE BESCOND / Couche m�tier */
require_once (dirname(__FILE__)."/inc_visite_factory.php");
require_once (dirname(__FILE__)."/inc_referer_factory.php");
require_once (dirname(__FILE__)."/inc_auteur_factory.php");
/* fin zone de modification Clever Age */

require_once "PEAR.php";
require_once "DB.php";

require_once dirname(__FILE__)."/metier.php";

define("GLOSSAIRE_ALL_FIELDS", "id, mot, url");


class BD_glossaire_services extends BD_metier {
	
	 /**
      * _glossaireId
      * @var     array
      * @access  private
      */
     
    var $_glossaireId;
	
	
	/**
	 * _glossaire
	 * @var		array
	 * @access  private
	 */
	 
	var $_glossaire; 
	
	// {{{ factory()

    /**
     * This method is a factory static method. It should be used to get any
     * specific implementation instance of Glossaire business data type.
     * @param   BD_parameters DB connection parameters
     * @access public
     */
    function &factory($dbParameters, $dbOptions = null) {

        if(file_exists(dirname(__FILE__)."/".$dbParameters->_dbEngine."/glossaire_services_".$dbParameters->_dbEngine.".php") == false) {
            include_once(dirname(__FILE__)."/common/glossaire_services_common.php");
            $classname = "BD_glossaire_services_common";
        }
        else {
            include_once(dirname(__FILE__)."/".$dbParameters->_dbEngine."/glossaire_".$dbParameters->_dbEngine.".php");
            $classname = "BD_glossaire_services_".$dbParameters->_dbEngine;
        }

        if (!class_exists($classname)) {
            return PEAR::raiseError("Cannot instanciate class $classname", null,
                null, null, null, null, false);
        }

        $obj =& new $classname;
        $result = $obj->setDbParameters($dbParameters);
        if ($dbOptions != null) {
            $obj->setDbOptions($dbOptions);
        }
        if (PEAR::isError($result)) {
            return $result;
        } else {
            return $obj;
        }
    }

    // }}}
	
	
	// {{{ constructor

    /**
     * DB_glossaire_services constructor.
     *
     * @access public
     */
	function BD_glossaire_services() {
	}
	
	// {{{ getGlossaireId
	function getGlossaireIds() {
		return $this->_glossaireId;
	}
	
	// }}}
	
	// {{{ setGlossaireId
	function setGlossaireIds($glossaireId) {
		$this->_glossaireId = $glossaireId;
	}
	
	// }}}
	
	// function addGlossaireId
	function addGlossaireId($glossaireId) {
		$this->_glossaireId[] = $glossaireId;
	}
	
	
	// {{{ getGlossaire
	function getGlossaire() {
		return $this->_glossaire;
	}
	
	// }}}
	
	// {{{
	function setGlossaire($glossaire) {
		$this->_glossaire = $glossaire;
	}
	// }}}
	
	// {{{ loadGlossairesIds
	function loadGlossaireIds() {
		$db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_glossaire : load()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT id FROM ".$GLOBALS['table_prefix']."_glossaire ORDER BY mot";
         

        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_glossaire : load()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
            while ($row =& $result->fetchRow()) {
                $this->_glossaireId[] = $row['id'];
            }
            $result->free();
        }
	}
	
	// loadAllGlossaire
	function loadAllGlossaire() {
		$db = &$this->_getDB();
		if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_glossaire : load()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT ".GLOSSAIRE_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_glossaire ORDER BY mot";
        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_glossaire : load()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
            while ($row =& $result->fetchRow()) {
                $this->_glossaire[$row['mot']] = $row['url'];
               // echo $row["mot"]."=>".$row["url"];
            }
            $result->free();
        }
        return $this->_glossaire;
	}
	
	
	
	// displayHTMLList
	/**
     * 
     */

    function displayHTMLList() {

		$db = &$this->_getDB();
		if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_glossaire : load()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT ".GLOSSAIRE_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_glossaire ORDER BY mot";
        $result = $db->query($query);

		debut_cadre_relief("glossaire.gif");
		echo "<table width=100% cellpadding=0 cellspacing=0 border=0><tr><td width=100% background=''>";
		echo "<table width=100% cellpadding=3 cellspacing=0 border=0>";

		bandeau_titre_boite(_T('infos_list_mots_glossaire'), true);
		

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_glossaire : load()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
            while ($row =& $result->fetchRow()) {
            	echo '<tr bgcolor="#FFFFFF"><td class="arial2" colspan="1">'.$row['mot'].'</td>'
			    .'<td class="arial2" nowrap>'.$row['url'].'</td></tr>';
                //$this->_glossaire[$row['mot']] = $row['url'];
               // echo $row["mot"]."=>".$row["url"];
            }
            $result->free();
        }
        
        echo "</table></td></tr></table>";
		fin_cadre_relief();
		
		
		/*$db = &$this->_getDB();
		if (DB::isError($db)) {
			die("Impossible d'obternir une connexion  la base de donnes! ".$db->getMessage());
		}
		$result = $db->query($requete, $params);
		if (DB::isError($result)) {
			die("la requete a choue! ".$result->getMessage());
		}
		debut_cadre_relief("newsletter-24.gif");
		echo "<table width=100% cellpadding=0 cellspacing=0 border=0><tr><td width=100% background=''>";
		echo "<table width=100% cellpadding=3 cellspacing=0 border=0>";

		bandeau_titre_boite($titre_table, true);
		while ($row = $result->fetchRow()) {
			echo '<tr bgcolor="#FFFFFF"><td class="arial2" colspan="1"><a href="'.$urlDest.'?id_newsletter='.$row['lst_id'].'" title="'.$row['lst_comment'].'"><img src="img_pack/puce-verte.gif" alt="" width="13" height="14" border="0"></a>&nbsp;&nbsp;<a href="'.$urlDest.'?id_newsletter='.$row['lst_id'].'" title="'.$row['lst_comment'].'">'.$row['lst_name'].'</a></td>'
			    .'<td class="arial2" nowrap>'.$row['lst_nb_articles'].' articles au choix</td></tr>';
		}
		$result->free();
		echo "</table></td></tr></table>";
		fin_cadre_relief();
		return $tous_id;*/
		
    }
    // }}}
	
	
}
?>