<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Erwan LE BESCOND  <elebescond@clever-age.com>                |
// |         Antoine ANGENIEUX <aangenieux@clever-age.com>                |
// +----------------------------------------------------------------------+
//
// Base class for Groupe Mot business persistence abstraction.
//

if (defined("_BD_GROUPE_MOT")) return;
    define("_BD_GROUPE_MOT", "1");

require_once dirname(__FILE__)."/metier.php";
require_once dirname(__FILE__)."/../../inc_version.php3";

define("GROUPE_MOT_ALL_FIELDS", " id_groupe, titre, unseul, obligatoire, articles, breves, rubriques, syndic, auteurs, cm, forum, maj, profils ");
define("GROUPE_MOT_ALL_FIELDS_EXCEPT_MAJ", " id_groupe, titre, unseul, obligatoire, articles, breves, rubriques, syndic, auteurs, cm, forum, profils ");

/**
 * BD_groupe_mot is a base class for groupe_mot business persistence abstraction implementations, and must be
 * inherited by all such.
 * @package	BD
 * @author  Antoine Angnieux <aangenieux@clever-age.com>
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @access	public
 */
class BD_groupe_mot extends BD_metier {

    // {{{ properties

    /**
     * Group ID.
     * @var     int
     * @access  private
     */
    var $_groupeId;

    /**
     * Title.
     * @var     String
     * @access  private
     */
    var $_titre;

    /**
     * 1 Groupe/Item.
     * @var     String
     * @access  private
     */
    var $_unSeul;

    /**
     * Obligatory.
     * @var     String
     * @access  private
     */
    var $_obligatoire;

    /**
     * artiles.
     * @var     String
     * @access  private
     */
    var $_articles;

    /**
     * breves.
     * @var     String
     * @access  private
     */
    var $_breves;

    /**
     * rubriques.
     * @var     String
     * @access  private
     */
    var $_rubriques;

    /**
     * syndic.
     * @var     String
     * @access  private
     */
    var $_syndic;

    /**
     * auteur.
     * @var     String
     * @access  private
     */
    var $_auteurs;

    /**
     * cm.
     * @var     String
     * @access  private
     */
    var $_cm;

    /**
     * forum.
     * @var     int
     * @access  private
     */
    var $_forum;

    /**
     * Update Date.
     * @var     Date
     * @access  private
     */
    var $_majDate;

    /**
     * Profils.
     * @var     int
     * @access  private
     */
    var $_profils;

    // }}}

    // {{{ factory()
    function &factory($dbParameters = null, $dbOptions = null) {
        if(file_exists(dirname(__FILE__)."/".$dbParameters->_dbEngine."/groupe_mot_".$dbParameters->_dbEngine.".php") == false) {
            include_once(dirname(__FILE__)."/common/groupe_mot_common.php");
            $classname = "BD_groupe_mot_common";
        }
        else {
            include_once(dirname(__FILE__)."/".$dbParameters->_dbEngine."/groupe_mot_".$dbParameters->_dbEngine.".php");
            $classname = "BD_groupe_mot_".$dbParameters->_dbEngine;
        }
        if (!class_exists($classname)) {
            return PEAR::raiseError("Cannot instanciate class $classname", null,
                                    null, null, null, null, false);
        }

        $obj =& new $classname;
        $result = $obj->setDbParameters($dbParameters);
        if ($dbOptions != null) {
            $obj->setDbOptions($dbOptions);
        }
        if (PEAR::isError($result)) {
            return $result;
        } else {
            return $obj;
        }
    }

    // }}}

    // {{{ constructor

    /**
     * DB_groupe_mot constructor.
     *
     * @access public
     */

    function BD_groupe_mot() {
    }

    // }}}

    // {{{ getGroupeId()

    /**
     * Returns the Group ID
     * @return  int
     * @access  public
     */

    function getGroupeId() {
        return $this->_groupeId;
    }

    // }}}

    // {{{ setGroupeId()

    /**
     * Sets the Groupe ID
     * @param   int
     * @access  public
     */

    function setGroupeId($groupeId) {
        $this->_groupeId = $groupeId;
    }

    // }}}

    // {{{ getTitre()

    /**
     * Returns the group word title
     * @return  String
     * @access  public
     */

    function getTitre() {
        return $this->_titre;
    }

    // }}}

    // {{{ setTitre()

    /**
     * Sets the groupe word title
     * @param   String
     * @access  public
     */

    function setTitre($titre) {
        $this->_titre = $this->corriger_caracteres($titre);
    }

    // }}}

    // {{{ getUnSeul()

    /**
     * Returns the UnSeul
     * @return  String
     * @access  public
     */

    function getUnSeul() {
        return $this->_unSeul;
    }

    // }}}

    // {{{ setUnSeul()

    /**
     * Sets the UnSeul
     * @param   String
     * @access  public
     */

    function setUnSeul($unSeul) {
        $this->_unSeul = $this->corriger_caracteres($unSeul);
    }

    // }}}

    // {{{ getObligatoire()

    /**
     * Returns the obligatory
     * @return  String
     * @access  public
     */

    function getObligatoire() {
        return $this->_obligatoire;
    }

    // }}}

    // {{{ setObligatoire()

    /**
     * Sets the obligatory
     * @param   String
     * @access  public
     */

    function setObligatoire($obligatoire) {
        $this->_obligatoire = $this->corriger_caracteres($obligatoire);
    }

    // }}}

    // {{{ getCm()

    /**
     * Returns the cm
     * @return  String
     * @access  public
     */

    function getCm() {
        return $this->_cm;
    }

    // }}}

    // {{{ setCm()

    /**
     * Sets the cm
     * @param   String
     * @access  public
     */

    function setCm($cm) {
        $this->_cm = $this->corriger_caracteres($cm);
    }

    // }}}

    // {{{ getArticles()

    /**
     * Returns the articles
     * @return  String
     * @access  public
     */

    function getArticles() {
        return $this->_articles;
    }

    // }}}

    // {{{ setArticles()

    /**
     * Sets the articles
     * @param   String
     * @access  public
     */

    function setArticles($articles) {
        $this->_articles = $this->corriger_caracteres($articles);
    }

    // }}}

    // {{{ getBreves()

    /**
     * Returns the breves
     * @return  String
     * @access  public
     */

    function getBreves() {
        return $this->_breves;
    }

    // }}}

    // {{{ setBreves()

    /**
     * Sets the breves
     * @param   String
     * @access  public
     */

    function setBreves($breves) {
        $this->_breves = $this->corriger_caracteres($breves);
    }

    // }}}


    // {{{ getRubriques()

    /**
     * Returns the rubriques
     * @return  String
     * @access  public
     */

    function getRubriques() {
        return $this->_rubriques;
    }

    // }}}

    // {{{ setRubriques()

    /**
     * Sets the rubriques
     * @param   String
     * @access  public
     */

    function setRubriques($rubriques) {
        $this->_rubriques = $this->corriger_caracteres($rubriques);
    }

    // }}}

    // {{{ getSyndic()

    /**
     * Returns the syndic
     * @return  String
     * @access  public
     */

    function getSyndic() {
        return $this->_syndic;
    }

    // }}}

    // {{{ setSyndic()

    /**
     * Sets the syndic
     * @param   String
     * @access  public
     */

    function setSyndic($syndic) {
        $this->_syndic = $this->corriger_caracteres($syndic);
    }

    // }}}

    // {{{ getSyndic()

    /**
     * Returns the auteurs
     * @return  String
     * @access  public
     */

    function getAuteurs() {
        return $this->_auteurs;
    }

    // }}}

    // {{{ setAuteurs()

    /**
     * Sets the auteurs
     * @param   String
     * @access  public
     */

    function setAuteurs($auteurs) {
        $this->_auteurs = $this->corriger_caracteres($auteurs);
        $this->setCm($this->_auteurs);
    }

    // }}}

    // {{{ getforum()

    /**
     * Returns the forum
     * @return  String
     * @access  public
     */

    function getforum() {
        return $this->_forum;
    }

    // }}}

    // {{{ setforum()

    /**
     * Sets the forum
     * @param   String
     * @access  public
     */

    function setforum($forum) {
        $this->_forum = $this->corriger_caracteres($forum);
    }

    // }}}

    // {{{ getMajDate()

    /**
     * Returns the word update date
     * @return  Date
     * @access  public
     */

    function getMajDate() {
        return $this->_majDate;
    }

    // }}}

    // {{{ setMajDate()

    /**
     * Sets the word update date
     * @param   Date
     * @access  public
     */

    function setMajDate($majDate) {
        $this->_majDate = $majDate;
    }

    // }}}


    // {{{ getProfils()

    /**
     * Returns the profils
     * @return  int
     * @access  public
     */

    function getProfils() {
        return $this->_profils;
    }

    // }}}

    // {{{ setProfils()

    /**
     * Sets the profils
     * @param   int
     * @access  public
     */

    function setProfils($profils) {
        $this->_profils = $profils;
    }

    // }}}



    // {{{ create()

    function create() {
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_groupe_mot : create()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        $string_prefix = $GLOBALS['table_prefix']."_groupes_mots";
        $groupeId = $db->nextId($string_prefix, true);
        if (DB::isError($groupeId)) {
            return PEAR::raiseError("[".get_class($this)." DB_groupe_mot : create()] ".$groupeId->getMessage()."", null,
                                    null, null, null, null, false);
        }

        $this->_groupeId = $groupeId;

        $query = "INSERT INTO ".$GLOBALS['table_prefix']."_groupes_mots (".GROUPE_MOT_ALL_FIELDS_EXCEPT_MAJ.") VALUES "
                ."(".$this->_groupeId.", "
                ."'".$db->quoteString($this->_titre)."', "
                ."'".$db->quoteString($this->_unSeul)."', "
                ."'".$db->quoteString($this->_obligatoire)."', "
                ."'".$db->quoteString($this->_articles)."', "
                ."'".$db->quoteString($this->_breves)."', "
                ."'".$db->quoteString($this->_rubriques)."', "
                ."'".$db->quoteString($this->_syndic)."', "
                ."'".$db->quoteString($this->_auteurs)."', "
                ."'".$db->quoteString($this->_cm)."', "
                ."'".$db->quoteString($this->_forum)."', "
                ."'".$db->quoteString($this->_profils)."') ";

        // echo "--->".$query."<br>";

         

        $result = $db->query($query);
        //var_dump ($result);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_groupe_mot : create()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ update()

    function update() {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_groupe_mot : update()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        $maDate = new Date();
	    $this->setMajDate($maDate->getDate(DATE_FORMAT_ISO));

        $query = "UPDATE ".$GLOBALS['table_prefix']."_groupes_mots "
                ."SET id_groupe = ".$this->_groupeId.", "
                ."titre = '".$db->quoteString($this->_titre)."', unseul = '".$db->quoteString($this->_unSeul)."', "
                ."obligatoire = '".$db->quoteString($this->_obligatoire)."', articles = '".$db->quoteString($this->_articles)."', "
                ."breves = '".$db->quoteString($this->_breves)."', rubriques = '".$db->quoteString($this->_rubriques)."', "
                ."syndic = '".$db->quoteString($this->_syndic)."', auteurs = '".$db->quoteString($this->_auteurs)."', "
                ."cm = '".$db->quoteString($this->_cm)."', forum = '".$db->quoteString($this->_forum)."', "
                ."maj = '".$db->quoteString($this->_majDate)."', profils = ".$this->_profils." "
                ."WHERE id_groupe = ".$this->_groupeId;

         

        $result = $db->query($query);
        if (DB::isError($result)) {
            //echo '<br><b>Erreur fatal dans la requete :</b><br>'.$query;
            return PEAR::raiseError("[".get_class($this)." DB_groupe_mot : update()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

    }

    // }}}

    // {{{ load()

    function load($idGroupe) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_groupe_mot : load()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT ".GROUPE_MOT_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_groupes_mots WHERE id_groupe = $idGroupe";

         
        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_groupe_mot : load()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
            if ($row = $result->fetchRow()) {

                $maDate = new Date($row['maj']);
                $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

                $this->_fetchData($row);
            } else {
                return PEAR::raiseError("[".get_class($this)." DB_groupe_mot : load($idGroupe)] Aucun groupe ne correspond pas  cet ID!", null,
                                    null, null, null, null, false);
            }
            $result->free();
        }
    }

    // }}}

    // {{{ delete()

    function delete($idGroupe) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_groupe_mot : delete()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_groupes_mots WHERE id_groupe = $idGroupe";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_groupe_mot : delete()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ _fetchData()

    function _fetchData($row) {
        $this->setGroupeId($row['id_groupe']);
        $this->setTitre($row['titre']);
        $this->setUnSeul($row['unseul']);
        $this->setObligatoire($row['obligatoire']);
        $this->setArticles($row['articles']);
        $this->setBreves($row['breves']);
        $this->setRubriques($row['rubriques']);
        $this->setSyndic($row['syndic']);
        $this->setAuteurs($row['auteurs']);
        $this->setCm($row['cm']);
        $this->setforum($row['forum']);
        $this->setMajDate($row['maj']);
        $this->setProfils($row['profils']);
    }

    // }}}



    // {{{ deleteForTitleAndNotGroupeId($titre, $id_groupe)

    function deleteForTitleAndNotGroupeId($titre, $id_groupe) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_groupe_mot : deleteForTitleAndNotGroupeId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_groupes_mots WHERE titre='$titre' AND id_groupe<>$id_groupe";
        
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_groupe_mot : deleteForTitleAndNotGroupeId()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ deleteMajDate($myDate)

    /**
     * This method is used to delete all word groups former to mydate
     * @access  public
     */

    function deleteMajDate($myDate) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_groupe_mot : deleteMajDate()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $dateTmp = new Date($mydate);
        $mydate = $dateTmp->getDate(DATE_FORMAT_ISO);

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_groupes_mots WHERE maj < '$myDate'";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_groupe_mot : deleteMajDate()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ getAllGroupe()

    /**
     * Returns an array of Group.
     *
     *
     * @return Array of Group
     * @param $seidObjet
     * @access public
     */

    function &getAllGroupe($critere = 'id_groupe') {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_groupe_mot : getAllGroupe()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT ".GROUPE_MOT_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_groupes_mots ORDER BY $critere";
         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_groupe_mot : getAllGroupe()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultGroupeMot = &BD_groupe_mot::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultGroupeMot->_fetchData($row);

            $result[] = &$resultGroupeMot;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    /**
     * Returns an array of Group.
     *
     *
     * @return Array of Group
     * @param $seidObjet
     * @access public
     */

    function &getAllForTitre($titre) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_groupe_mot : getAllForTitre()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT ".GROUPE_MOT_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_groupes_mots WHERE titre='$titre'";
         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_groupe_mot : getAllForTitre()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultGroupeMot = &BD_groupe_mot::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultGroupeMot->_fetchData($row);

            $result[] = &$resultGroupeMot;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ getAllForforumAndTableAndGroupId($forum, $table, $selectionner_groupe)

    /**
     * Returns an array of Group.
     *
     *
     * @return Array of Group
     * @param $forum
     * @param $table
     * @param $selectionner_groupe
     * @access public
     */

    function &getAllForforumAndTableAndGroupId($forumValue, $table, $selectionner_groupe) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_groupe_mot : getAllForforumAndTableAndGroupId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT ".GROUPE_MOT_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_groupes_mots WHERE forum = $forumValue AND $table = 'oui' $selectionner_groupe";
         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_groupe_mot : getAllForforumAndTableAndGroupId()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultGroupeMot = &BD_groupe_mot::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultGroupeMot->_fetchData($row);

            $result[] = &$resultGroupeMot;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ getAllForTableAndProfil($table, $tableValue, $connect_profil)

    /**
     * Returns an array of Group.
     *
     *
     * @return Array of Group
     * @param $table
     * @param $tableValue
     * @param $connect_profil
     * @access public
     */

    function &getAllForTableAndProfil($table, $tableValue, $connect_profil) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_groupe_mot : getAllForTableAndProfil()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT ".GROUPE_MOT_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_groupes_mots WHERE $table = $tableValue";
         
        // echo "<br><br>$query<br";

        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_groupe_mot : getAllForTableAndProfil()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultGroupeMot = &BD_groupe_mot::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultGroupeMot->_fetchData($row);
            //var_dump ($resultGroupeMot->isManagedByProfil($connect_profil));
            if($resultGroupeMot->isManagedByProfil($connect_profil)) {
                $result[] = &$resultGroupeMot;
            }
        }
        $queryResult->free();
        return $result;
    }

    // }}}


    /**
     * Returns an array of Group.
     * retourne tous les groupes affectable a un objet ... j'me comprend
     *
     * @return Array of Group
     * @param $table
     * @param $tableValue
     * @param $connect_profil
     * @access public
     */

    function &getAllForTable ($table, $tableValue) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_groupe_mot : getAllForTableAndProfil()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT ".GROUPE_MOT_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_groupes_mots WHERE $table = $tableValue";
         
        // echo "<br><br>$query<br";

        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_groupe_mot : getAllForTableAndProfil()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultGroupeMot = &BD_groupe_mot::factory($this->getDbParameters(), $this->getDbOptions());
            $resultGroupeMot->_fetchData($row);
            $result[] = &$resultGroupeMot;
        }
        $queryResult->free();
        return $result;
    }

    // }}}




    // {{{ getAllForTableAndStatutAndObligatoryAndIdGroupe($table, $tableValue, $connect_statut, $connect_statutValue, $obligatoire, $id_groupes_vus)

    /**
     * Returns an array of Group.
     *
     *
     * @return Array of Group
     * @param $table
     * @param $tableValue
     * @param $connect_statut
     * @param $connect_statutValue
     * @param $obligatoire
     * @param $id_groupes_vu
     * @access public
     */

    function &getAllForTableAndStatutAndObligatoryAndIdGroupe($table, $tableValue, $connect_profil, $obligatoire, $id_groupes_vus)    {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_groupe_mot : getAllForTableAndStatutAndObligatoryAndIdGroupe()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT ".GROUPE_MOT_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_groupes_mots WHERE $table = $tableValue AND obligatoire = $obligatoire AND id_groupe NOT IN ($id_groupes_vus)";
         
        //echo "<br>$query<br>";

        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_groupe_mot : getAllForTableAndStatutAndObligatoryAndIdGroupe()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultGroupeMot = &BD_groupe_mot::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultGroupeMot->_fetchData($row);
			if($resultGroupeMot->isManagedByProfil($connect_profil)) {
                $result[] = &$resultGroupeMot;
            }
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ getAllForTableAndStatutAndUnSeulAndIdGroupe($table, $tableValue, $connect_statut, $connect_statutValue, $unSeul, $id_groupes_vus)

    /**
     * Returns an array of Group.
     *
     *
     * @return Array of Group
     * @param $table
     * @param $tableValue
     * @param $connect_statut
     * @param $connect_statutValue
     * @param $unSeul
     * @param $id_groupes_vu
     * @access public
     */

    function &getAllForTableAndStatutAndUnSeulAndIdGroupe($table, $tableValue, $connect_profil, $unSeul, $id_groupes_vus)    {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_groupe_mot : getAllForTableAndStatutAndUnSeulAndIdGroupe()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT ".GROUPE_MOT_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_groupes_mots WHERE $table = $tableValue AND (unseul != $unSeul  OR (unseul = $unSeul AND id_groupe NOT IN ($id_groupes_vus))) ORDER BY titre";
         
        //echo "<br><br>$query<br><br>";

        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_groupe_mot : getAllForTableAndStatutAndUnSeulAndIdGroupe()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultGroupeMot = &BD_groupe_mot::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultGroupeMot->_fetchData($row);
			if($resultGroupeMot->isManagedByProfil($connect_profil)) {
                $result[] = &$resultGroupeMot;
            }
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ howManyInGroup

    /**
     * Returns the number of keywords for a given keyword group
     * @return  int     number of keyword in group
     * @access  public
     */

    function howManyInGroup() {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_groupe_mot : howManyInGroup()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT COUNT(id_mot) FROM ".$GLOBALS['table_prefix']."_mots WHERE id_groupe=".$this->_groupeId;

        $result = $db->getOne($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_groupe_mot : howManyInGroup()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        return $result;

    }

    // }}}

    // {{{ function htmlSelect()

    /**
     * This method returns the html select box for the keyword trees within this group
     * @param   String    selectName  HTML NAME attribute of the SELECT tag
     * @return  String
     * @access  public
     */

    function htmlSelect($id_mot = 'root', $selectName = 'id_mot_subnode') {
        $rootIds = &$this->_getRootIds();
        $allGroupNodes = array();
        $db = &$this->_getNestedSetInstance();

        while (list(, $idRoot) = each($rootIds)) {
            $allGroupNodes[] = $db->getBranch($idRoot);
        }

        $htmlSelect = "<select name='$selectName' class='fondl'>";
        $offset = '&nbsp;&nbsp;';
        $htmlSelect .= '<option value=\'root\' SELECTED>'._T('racine_groupe').'</option>';

        while (list(, $nodes) = each($allGroupNodes)) {
            // Ici, on parcours l'arbre des noeuds, et on gnre la liste
            // en utilisant le 'level' de chaque noeud pour calculer le
            // dcallage
            while (list(, $node) = each ($nodes)) {
                $spacer = '';
                for ($i = 1; $i < $node->level; $i++) {
                    $spacer .= $offset;
                }
                $htmlSelect .= '<option value="'.$node->id.'">'.$spacer.$node->name.'</option>';
            }
        }

        $htmlSelect .= '</select>';

        return $htmlSelect;

    }

    // }}}

    // {{{ getMotArbre()

    /**
     *
     *
     *
     *
     */

    function &getMotArbre() {
        $rootIds = &$this->_getRootIds();
        $allGroupNodes = array();
        $db = &$this->_getNestedSetInstance();

        while (list(, $idRoot) = each($rootIds)) {
            $allGroupNodes[] = $db->getBranch($idRoot);
        }

        return $allGroupNodes;
    }

    // }}}

    // {{{ _getRootIds()

    /**
     * This method returns all root keyword ids within this group
     * @return  array
     * @access  private
     */
    function &_getRootIds() {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_groupe_mot : _getRootIds()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT id_mot, titre FROM ".$GLOBALS['table_prefix']."_mots WHERE id_groupe = ".$this->getGroupeId()." AND id_root = id_mot ORDER BY titre ASC";
         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_groupe_mot : _getRootIds()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $queryResult->fetchRow()) {
            $result[] = $row['id_mot'];
        }

        $queryResult->free();

        return $result;
    }

    // }}}

    // {{{ isManagedByProfil($profil)

    function isManagedByProfil($profil) {
        //echo '--> ' . (intval($this->_profils)&intval($profil));
        $val = (intval($this->_profils)&intval($profil));
        if ($val > 0) return true;
        return false;
    }

    // }}}
    
	// {{{ getAllGroupeAffectedTo($type)

    function getAllGroupeAffectedToPersonnalisation($type, $groupeIds = '') {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_groupe_mot : getAllGroupeAffectedToPersonnalisation()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT ".GROUPE_MOT_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_groupes_mots WHERE $type = 'oui' AND auteurs='oui'";
		if($groupeIds != '') {
			$query .= ' AND id_groupe IN (' . $groupeIds . ')';
		}
         
        //echo "<br><br>$query<br><br>";

        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_groupe_mot : getAllGroupeAffectedToPersonnalisation()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultGroupeMot = &BD_groupe_mot::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultGroupeMot->_fetchData($row);
			$result[] = &$resultGroupeMot;            
        }
        $queryResult->free();
        return $result;
    }

    // }}}

}
?>