<?Php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Julien Guillot <jguillot@clever-age.com>		              |
// +----------------------------------------------------------------------+
//
// Base class for Index Article business persistence abstraction.
// $Id$


require_once "PEAR.php";
require_once "DB.php";
require_once dirname(__FILE__)."/metier.php";
require_once dirname(__FILE__)."/../../inc_filtres.php3";

//define("INDEX_ARTICLES_ALL_FIELDS", " hash, points, id_article ");
define("INDEX_ARTICLES_ALL_FIELDS", " hash, points, id_article, emplacement ");

/**
 * BD_index_articles is a base class for article business persistence abstraction implementations, and must be
 * inherited by all such.
 * @package	BD
 * @author  Antoine Angnieux <aangenieux@clever-age.com>
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @access	public
 */
class BD_index_articles extends BD_metier {
    // {{{ properties

    /**
     * $_hash
     * @var     int
     * @access  private
     */
    var $_hash;
    
    /**
     * $_points
     * @var     int
     * @access  private
     */
    var $_points;
    
    /**
     * $_articleId
     * @var     int
     * @access  private
     */
    var $_articleId;


    /**
     * $_emplacement
     * @var     string
     * @access  private
     */
    var $_emplacement;

    // }}}

    // {{{ factory()

    /**
     * 
     * @param   BD_parameters DB connection parameters
     * @access public
     */

    function &factory($dbParameters = null, $dbOptions = null) {

        if(file_exists(dirname(__FILE__)."/".$dbParameters->_dbEngine."/index_articles_".$dbParameters->_dbEngine.".php") == false) {
            include_once(dirname(__FILE__)."/common/index_articles_common.php");
            $classname = "BD_index_articles_common";
        }
        else {
            include_once(dirname(__FILE__)."/".$dbParameters->_dbEngine."/index_articles_".$dbParameters->_dbEngine.".php");
            $classname = "BD_index_articles_".$dbParameters->_dbEngine;
        }
        if (!class_exists($classname)) {
            return PEAR::raiseError("Cannot instanciate class $classname", null,
                                    null, null, null, null, false);
        }

        $obj =& new $classname;
        $result = $obj->setDbParameters($dbParameters);
        if ($dbOptions != null) {
            $obj->setDbOptions($dbOptions);
        }
        if (PEAR::isError($result)) {
            return $result;
        } else {
            return $obj;
        }
    }

    // }}}

    // {{{ constructor

    /**
     * DB_index_articles constructor.
     *
     * @access public
     */

    function BD_index_articles() {
    }

    // }}}

    // {{{ getHash()

    /**
     * Returns the hash's value
     * @return  int
     * @access  public
     */

    function getHash() {
        return $this->_hash;
    }

    // }}}

    // {{{ setHash()

    /**
     * Sets the hash's value
     * @param  int
     * @access  public
     */

    function setHash($hash) {
        $this->_hash = corriger_caracteres($hash);
    }

	// }}}

    // {{{ getPoints()

    /**
     * Returns the points' value
     * @return  int
     * @access  public
     */

    function getPoints() {
        return $this->_points;
    }
	
	// }}}

    // {{{ setPoints()

    /**
     * Sets the points' value
     * @param  int
     * @access  public
     */

    function setPoints($points) {
        $this->_points = $points;
    }

    // }}}


// {{{ getEmplacement()

    /**
     * Returns the emplacement' value
     * @return  int
     * @access  public
     */

    function getEmplacement() {
        return $this->_emplacement;
    }
    
    // }}}

    // {{{ setEmplacement()

    /**
     * Sets the points' value
     * @param  int
     * @access  public
     */

    function setEmplacement($emplacement) {
        $this->_emplacement = $emplacement;
    }

    // }}}



    
    // {{{ getArticleId()

    /**
     * Returns the article ID
     * @return  int
     * @access  public
     */

    function getArticleId() {
        return $this->_articleId;
    }

    // }}}

    // {{{ setArticleId()

    /**
     * Sets the article ID
     * @param  int
     * @access  public
     */

    function setArticleId($articleId) {
        $this->_articleId = $articleId;
    }

    // }}}
    
    // {{{ setId()

    /**
     * Sets the article ID
     * @param  int
     * @access  public
     */

    function setId($articleId) {
        $this->setArticleId($articleId);
    }

    // }}}


    // {{{ create()

    /**
     * This method is used to create a new index of articles in the database
     * @access public
     */

    function create() {
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_article : create()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "INSERT INTO ".$GLOBALS['table_prefix']."_index_articles (".INDEX_ARTICLES_ALL_FIELDS.") VALUES "
                ."('".$db->quoteString($this->_hash)."', "
                .$this->_points.", "
                .$this->_articleId.", '"
                .$db->quotestring($this->_emplacement).
                "')";

        //echo "<br>".$query."<br>";
         

        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_article : create()] $query ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ load()

    /**
     * This method is used to load an index of articles from the database
     * @access  public
     * @param   int $articleId ID of article to load
     */

    function load($articleId) {
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_article : load()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT".INDEX_ARTICLES_ALL_FIELDS."FROM ".$GLOBALS['table_prefix']."_index_articles WHERE article_id = $articleId";

         
        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_article : load()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
            if ($row = $result->fetchRow()) {
                $this->_fetchData($row);
            } else {
                return PEAR::raiseError("[".get_class($this)." DB_index_articles : load($articleId)] Aucun index d'articles ne correspond  cet ID!", null,
                                    null, null, null, null, false);
            }
            $result->free();
        }
    }

    // }}}

    // {{{ delete()

    /**
     * This method is used to delete the index of articles
     * @access  public
     */

    function delete() {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_article : delete()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_index_articles";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_article : delete()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ deleteIndexArticleForArticleId($id_objet)

    /**
     * This method is used to delete an index of articles from the database
     * @access  public
     * @param   int $id_objet ID of article to delete
     */

    function deleteIndexArticleForArticleId($id_objet) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_article : deleteIndexArticleForArticleId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_index_articles WHERE id_article = $id_objet";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_article : deleteIndexArticleForArticleId()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ _fetchData()

    /**
     * This method is used to fetch result set fields into the object fields
     * @access  private
     * @param   int $row the row to fetch
     */

    function _fetchData($row) {
        $this->setHash($row['hash']);
        $this->setPoints($row['points']);
        $this->setArticleId($row['id_article']);
        $this->setEmplacement($row['emplacement']);
    }

    // }}}

    // {{{ howManyIndexArticle()

    /**
     * This method is used to count how many index of articles exist
     * @access  public
     */

    function howManyIndexArticle() {
        $howManyIndexArticle = 0;
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_article : howManyIndexArticle()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        
		$query = "SELECT COUNT(*) AS cnt FROM ".$GLOBALS['table_prefix']."_index_articles";
         
		$result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_article : howManyIndexArticle()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        if ($row = $result->fetchRow()) {
            $howManyIndexArticle = intval($row["cnt"]);
        }
        $result->free();
        return $howManyIndexArticle;
    }

    // }}}

    // {{{ howManyIndexArticleForArticleId($id_objet)

    /**
     * This method is used to count how many index of articles exist for an article's ID
     * @access  public
     * @param   int $id_objet ID of artciles to see
     */

    function howManyIndexArticleForArticleId($id_objet) {
    	if ((!isset($id_objet)) || ($id_objet < 0)) return 0;
        $howManyIndexArticleForArticleId = 0;
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_article : howManyIndexArticleForArticleId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        
		$query = "SELECT COUNT(*) as compteur FROM ".$GLOBALS['table_prefix']."_index_articles WHERE id_article = $id_objet";
		
		 
		$result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_article : howManyIndexArticleForArticleId()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        if ($row = $result->fetchRow()) {
            $howManyIndexArticleForArticleId = intval($row["compteur"]);
        }

        $result->free();
        return $howManyIndexArticleForArticleId;
    }

    // }}}
}
?>
