<?Php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Julien Guillot <jguillot@clever-age.com>		              |
// +----------------------------------------------------------------------+
//
// Base class for Index Auteur business persistence abstraction.
// $Id$



require_once "PEAR.php";
require_once "DB.php";
require_once dirname(__FILE__)."/metier.php";
require_once dirname(__FILE__)."/../../inc_filtres.php3";

define("INDEX_AUTEURS_ALL_FIELDS", " hash, points, id_auteur, emplacement");

/**
 * BD_index_auteurs is a base class for auteur business persistence abstraction implementations, and must be
 * inherited by all such.
 * @package	BD
 * @author  Antoine Angnieux <aangenieux@clever-age.com>
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @access	public
 */
class BD_index_auteurs extends BD_metier {
    // {{{ properties
    /**
     * $_emplacement
     * @var     string
     * @access  private
     */
    var $_emplacement;

    

    /**
     * $_hash
     * @var     int
     * @access  private
     */
    var $_hash;
    
    /**
     * $_points
     * @var     int
     * @access  private
     */
    var $_points;
    
    /**
     * $_auteurId
     * @var     int
     * @access  private
     */
    var $_auteurId;

    // }}}


    // {{{ getEmplacement()

    /**
     * Returns the emplacement' value
     * @return  int
     * @access  public
     */

    function getEmplacement() {
        return $this->_emplacement;
    }
    
    // }}}

    // {{{ setEmplacement()

    /**
     * Sets the points' value
     * @param  int
     * @access  public
     */

    function setEmplacement($emplacement) {
        $this->_emplacement = $emplacement;
    }

    // }}}

    // {{{ factory()

    function &factory($dbParameters = null, $dbOptions = null) {
        if(file_exists(dirname(__FILE__)."/".$dbParameters->_dbEngine."/index_auteurs_".$dbParameters->_dbEngine.".php") == false) {
            include_once(dirname(__FILE__)."/common/index_auteurs_common.php");
            $classname = "BD_index_auteurs_common";
        }
        else {
            include_once(dirname(__FILE__)."/".$dbParameters->_dbEngine."/index_auteurs_".$dbParameters->_dbEngine.".php");
            $classname = "BD_index_auteurs_".$dbParameters->_dbEngine;
        }

        if (!class_exists($classname)) {
            return PEAR::raiseError("Cannot instanciate class $classname", null,
                                    null, null, null, null, false);
        }

        $obj =& new $classname;
        $result = $obj->setDbParameters($dbParameters);
        if ($dbOptions != null) {
            $obj->setDbOptions($dbOptions);
        }
        if (PEAR::isError($result)) {
            return $result;
        } else {
            return $obj;
        }
    }

    // }}}

    // {{{ constructor

    /**
     * DB_index_auteurs constructor.
     *
     * @access public
     */

    function BD_index_auteurs() {
    }

    // }}}

    // {{{ getHash()

    /**
     * Returns the hash's value
     * @return  int
     * @access  public
     */

    function getHash() {
        return $this->_hash;
    }

    // }}}

    // {{{ setHash()

    /**
     * Sets the hash's value
     * @param  int
     * @access  public
     */

    function setHash($hash) {
        $this->_hash = corriger_caracteres($hash);
    }

	// }}}

    // {{{ getPoints()

    /**
     * Returns the points' value
     * @return  int
     * @access  public
     */

    function getPoints() {
        return $this->_points;
    }
	
	// }}}

    // {{{ setPoints()

    /**
     * Sets the points' value
     * @param  int
     * @access  public
     */

    function setPoints($points) {
        $this->_points = $points;
    }

    // }}}
    
    // {{{ getAuteurId()

    /**
     * Returns the author ID
     * @return  int
     * @access  public
     */

    function getAuteurId() {
        return $this->_auteurId;
    }

    // }}}

    // {{{ setAuteurId()

    /**
     * Sets the author ID
     * @param  int
     * @access  public
     */

    function setAuteurId($auteurId) {
        $this->_auteurId = $auteurId;
    }

    // }}}

    // {{{ setId()

    /**
     * Sets the author ID
     * @param  int
     * @access  public
     */

    function setId($auteurId) {
        $this->setAuteurId($auteurId);
    }

    // }}}

    // {{{ create()

    /**
     * This method is used to create a new index of authors in the database
     * @access public
     */

    function create() {
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_auteur : create()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "INSERT INTO ".$GLOBALS['table_prefix']."_index_auteurs (".INDEX_AUTEURS_ALL_FIELDS.") VALUES "
               ."('".$db->quoteString($this->_hash)."', "
                .$this->_points.", "
                .$this->_auteurId.", '"
                .$db->quotestring($this->_emplacement).
                "')";


         


        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_auteur : create()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ load()

    /**
     * This method is used to load an index of authors from the database
     * @access  public
     * @param   int $auteurId ID of authors to load
     */

    function load($auteurId) {
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_auteur : load()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT".INDEX_AUTEURS_ALL_FIELDS."FROM ".$GLOBALS['table_prefix']."_index_auteurs WHERE id_auteur = $auteurId";

         
        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_auteur : load()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
            if ($row = $result->fetchRow()) {
                $this->_fetchData($row);
            } else {
                return PEAR::raiseError("[".get_class($this)." DB_index_auteurs : load($auteurId)] Aucun index d'auteurs ne correspond  cet ID!", null,
                                    null, null, null, null, false);
            }
            $result->free();
        }
    }

    // }}}

    // {{{ delete()

    /**
     * This method is used to delete the index of authors
     * @access  public
     */

    function delete() {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_auteur : delete()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_index_auteurs";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_auteur : delete()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ deleteIndexAuteurForAuteurId($id_objet)

    /**
     * This method is used to delete an index of authors from the database
     * @access  public
     * @param   int $id_objet ID of authors to delete
     */

    function deleteIndexAuteurForAuteurId($id_objet) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_auteur : deleteIndexAuteurForAuteurId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_index_auteurs WHERE id_auteur = $id_objet";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_auteur : deleteIndexAuteurForAuteurId()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ _fetchData()

    /**
     * This method is used to fetch result set fields into the object fields
     * @access  private
     * @param   int $row the row to fetch
     */
    function _fetchData($row) {
        $this->setHash($row['hash']);
        $this->setPoints($row['points']);
        $this->setAuteurId($row['id_auteur']);
        $this->setEmplacement($row['emplacement']);
    }

    // }}}

    // {{{ howManyIndexAuteurForAuteurId($id_objet)

    /**
     * This method is used to count how many index of authors exist for an author's ID
     * @access  public
     * @param   int $id_objet ID of authors to see
     */

    function howManyIndexAuteurForAuteurId($id_objet) {
    	if ((!isset($id_objet)) || ($id_objet < 0)) return 0;
        $howManyIndexAuteurForAuteurId = 0;
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_auteur : howManyIndexAuteurForAuteurId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        
		$query = "SELECT COUNT(*) as compteur FROM ".$GLOBALS['table_prefix']."_index_auteurs WHERE id_auteur = $id_objet";
		 
		$result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_auteur : howManyIndexAuteurForAuteurId()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        if ($row = $result->fetchRow()) {
            $howManyIndexAuteurForAuteurId = intval($row["compteur"]);
        }

        $result->free();
        return $howManyIndexAuteurForAuteurId;
    }

    // }}}
}
?>
