<?Php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Julien Guillot <jguillot@clever-age.com>		              |
// +----------------------------------------------------------------------+
//
// Base class for Index Breve business persistence abstraction.
// $Id$


require_once "PEAR.php";
require_once "DB.php";
require_once dirname(__FILE__)."/metier.php";
require_once dirname(__FILE__)."/../../inc_filtres.php3";

define("INDEX_BREVES_ALL_FIELDS", " hash, points, id_breve, emplacement");

/**
 * BD_index_breves is a base class for breve business persistence abstraction implementations, and must be
 * inherited by all such.
 * @package	BD
 * @author  Antoine Angnieux <aangenieux@clever-age.com>
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @access	public
 */
class BD_index_breves extends BD_metier {
    // {{{ properties


    /**
     * $_hash
     * @var     int
     * @access  private
     */
    var $_hash;
    
    /**
     * $_points
     * @var     int
     * @access  private
     */
    var $_points;
    
    /**
     * $_breveId
     * @var     int
     * @access  private
     */
    var $_breveId;

    /**
     * $_emplacement
     * @var     string
     * @access  private
     */
    var $_emplacement;


    // }}}


    // {{{ getEmplacement()

    /**
     * Returns the emplacement' value
     * @return  int
     * @access  public
     */

    function getEmplacement() {
        return $this->_emplacement;
    }
    
    // }}}

    // {{{ setEmplacement()

    /**
     * Sets the points' value
     * @param  int
     * @access  public
     */

    function setEmplacement($emplacement) {
        $this->_emplacement = $emplacement;
    }

    // }}}



    // {{{ factory()
    function &factory($dbParameters = null, $dbOptions = null) {

        if(file_exists(dirname(__FILE__)."/".$dbParameters->_dbEngine."/index_breves_".$dbParameters->_dbEngine.".php") == false) {
            include_once(dirname(__FILE__)."/common/index_breves_common.php");
            $classname = "BD_index_breves_common";
        }
        else {
            include_once(dirname(__FILE__)."/".$dbParameters->_dbEngine."/index_breves_".$dbParameters->_dbEngine.".php");
            $classname = "BD_index_breves_".$dbParameters->_dbEngine;
        }
        if (!class_exists($classname)) {
            return PEAR::raiseError("Cannot instanciate class $classname", null,
                                    null, null, null, null, false);
        }

        $obj =& new $classname;
        $result = $obj->setDbParameters($dbParameters);
        if ($dbOptions != null) {
            $obj->setDbOptions($dbOptions);
        }
        if (PEAR::isError($result)) {
            return $result;
        } else {
            return $obj;
        }
    }

    // }}}

    // {{{ constructor

    /**
     * DB_index_breves constructor.
     *
     * @access public
     */

    function BD_index_breves() {
    }

    // }}}

    // {{{ getHash()

    /**
     * Returns the hash's value
     * @return  int
     * @access  public
     */

    function getHash() {
        return $this->_hash;
    }

    // }}}

    // {{{ setHash()

    /**
     * Sets the hash's value
     * @param  int
     * @access  public
     */

    function setHash($hash) {
        $this->_hash = corriger_caracteres($hash);
    }

	// }}}

    // {{{ getPoints()

    /**
     * Returns the points' value
     * @return  int
     * @access  public
     */

    function getPoints() {
        return $this->_points;
    }
	
	// }}}

    // {{{ setPoints()

    /**
     * Sets the points' value
     * @param  int
     * @access  public
     */

    function setPoints($points) {
        $this->_points = $points;
    }

    // }}}
    
    // {{{ getBreveId()

    /**
     * Returns the breve ID
     * @return  int
     * @access  public
     */

    function getBreveId() {
        return $this->_breveId;
    }

    // }}}

    // {{{ setBreveId()

    /**
     * Sets the breve ID
     * @param  Date
     * @access  public
     */

    function setBreveId($breveId) {
        $this->_breveId = $breveId;
    }

    // }}}

    // {{{ setId()

    /**
     * Sets the breve ID
     * @param  Date
     * @access  public
     */

    function setId($breveId) {
        $this->setBreveId($breveId);
    }

    // }}}


    // {{{ create()

    /**
     * This method is used to create a new index of breve in the database
     * @access public
     */

    function create() {
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_breves : create()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "INSERT INTO ".$GLOBALS['table_prefix']."_index_breves (".INDEX_BREVES_ALL_FIELDS.") VALUES "
                ."('".$db->quoteString($this->_hash)."', "
                .$this->_points.", "
                .$this->_breveId.", '"
                .$db->quotestring($this->_emplacement).
                "')";
         

        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_breves : create()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ load()

    /**
     * This method is used to load an index of breve from the database
     * @access  public
     * @param   int $breveId ID of breve to load
     */

    function load($breveId) {
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_breves : load()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT".INDEX_BREVES_ALL_FIELDS."FROM ".$GLOBALS['table_prefix']."_index_breves WHERE id_breve = $breveId";

         
        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_breves : load()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
            if ($row = $result->fetchRow()) {
                $this->_fetchData($row);
            } else {
                return PEAR::raiseError("[".get_class($this)." DB_index_breves : load($breveId)] Aucun index de breves ne correspond  cet ID!", null,
                                    null, null, null, null, false);
            }
            $result->free();
        }
    }

    // }}}

    // {{{ delete()

    /**
     * This method is used to delete the index of breve
     * @access  public
     */

    function delete() {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_breves : delete()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_index_breves";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_breves : delete()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ deleteIndexBreveForBreveId($id_objet)

    /**
     * This method is used to delete an index of breve from the database
     * @access  public
     * @param   int $id_objet ID of breve to delete
     */

    function deleteIndexBreveForBreveId($id_objet) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_breves : deleteIndexBreveForBreveId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_index_breves WHERE id_breve = $id_objet";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_breves : deleteIndexBreveForBreveId()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ _fetchData()

    /**
     * This method is used to fetch result set fields into the object fields
     * @access  private
     * @param   int $row the row to fetch
     */

    function _fetchData($row) {
        $this->setHash($row['hash']);
        $this->setPoints($row['points']);
        $this->setBreveId($row['id_breve']);
        $this->setEmplacement($row['emplacement']);
    }

    // }}}

    // {{{ howManyIndexBreveForBreveId($id_objet)

    /**
     * This method is used to count how many index of breve exist for a breve's ID
     * @access  public
     * @param   int $id_objet ID of syndication to see
     */

    function howManyIndexBreveForBreveId($id_objet) {
    	if ((!isset($id_objet)) || ($id_objet < 0)) return 0;
        $howManyIndexBreveForBreveId = 0;
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_breves : howManyIndexBreveForBreveId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        
		$query = "SELECT COUNT(*) as compteur FROM ".$GLOBALS['table_prefix']."_index_breves WHERE id_breve = $id_objet";
		 
		$result = $db->query($query);
        if (DB::isError($result)) {
              return PEAR::raiseError("[".get_class($this)." DB_index_breves : howManyIndexBreveForBreveId()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        if ($row = $result->fetchRow()) {
            $howManyIndexBreveForBreveId = intval($row["compteur"]);
        }

        $result->free();
        return $howManyIndexBreveForBreveId;
    }

    // }}}
}
?>
