<?Php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Julien Guillot <jguillot@clever-age.com>		              |
// +----------------------------------------------------------------------+
//
// Base class for Index Dico business persistence abstraction.
// $Id$


require_once "PEAR.php";
require_once "DB.php";
require_once dirname(__FILE__)."/metier.php";
require_once dirname(__FILE__)."/../../inc_filtres.php3";

define("INDEX_DICO_ALL_FIELDS", " hash, dico ");

/**
 * BD_index_dico is a base class for dico business persistence abstraction implementations, and must be
 * inherited by all such.
 * @package	BD
 * @author  Antoine Angnieux <aangenieux@clever-age.com>
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @access	public
 */
class BD_index_dico extends BD_metier {
    // {{{ properties

    /**
     * $_hash
     * @var     int
     * @access  private
     */
    var $_hash;
    
    /**
     * $_dico
     * @var     String
     * @access  private
     */
    var $_dico;

    // }}}

    // {{{ factory()
    function &factory($dbParameters = null, $dbOptions = null) {

        if(file_exists(dirname(__FILE__)."/".$dbParameters->_dbEngine."/index_dico_".$dbParameters->_dbEngine.".php") == false) {
            include_once(dirname(__FILE__)."/common/index_dico_common.php");
            $classname = "BD_index_dico_common";
        }
        else {
            include_once(dirname(__FILE__)."/".$dbParameters->_dbEngine."/index_dico_".$dbParameters->_dbEngine.".php");
            $classname = "BD_index_dico_".$dbParameters->_dbEngine;
        }
        if (!class_exists($classname)) {
            return PEAR::raiseError("Cannot instanciate class $classname", null,
                                    null, null, null, null, false);
        }
        $obj =& new $classname;
        $result = $obj->setDbParameters($dbParameters);
        if ($dbOptions != null) {
            $obj->setDbOptions($dbOptions);
        }
        if (PEAR::isError($result)) {
            return $result;
        } else {
            return $obj;
        }
    }

    // }}}

    // {{{ constructor

    /**
     * DB_index_dico constructor.
     *
     * @access public
     */

    function BD_index_dico() {
    }

    // }}}

    // {{{ getHash()

    /**
     * Returns the hash's value
     * @return  int
     * @access  public
     */

    function getHash() {
        return $this->_hash;
    }

    // }}}

    // {{{ setHash($hash)

    /**
     * Sets the hash's value
     * @param  int
     * @access  public
     */

    function setHash($hash) {
        $this->_hash = corriger_caracteres($hash);
    }

	// }}}

    // {{{ getDico()

    /**
     * Returns the character string required
     * @return  String
     * @access  public
     */

    function getDico() {
        return $this->_dico;
    }

    // }}}

    // {{{ setDico($dico)

    /**
     * Sets the character string required
     * @param  String
     * @access  public
     */

    function setDico($dico) {
        $this->_dico = $dico;
    }

    // }}}


    // {{{ create()

    /**
     * This method is used to create a new character string required in the database
     * @access public
     */

    function create() {
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_dico : create()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "INSERT INTO ".$GLOBALS['table_prefix']."_index_dico (".INDEX_DICO_ALL_FIELDS.") VALUES "
                ."('".$db->quoteString($this->_hash)."', "
                ."'".$db->quoteString($this->_dico)."')";

         
        //echo $query;
        $result = $db->query($query);
        if (DB::isError($result)) {
            return $result;
        }
    }

    // }}}

    // {{{ load()

    /**
     * This method is used to load a character string required from the database
     * @access  public
     * @param   String $dico the character string required to load
     */

    function load($dico) {
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_dico : load()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT".INDEX_DICO_ALL_FIELDS."FROM ".$GLOBALS['table_prefix']."_index_dico WHERE dico = $dico";

         
        $result = $db->query($query);

        if (DB::isError($result)) {
            return $result;
        } else {
            if ($row = $result->fetchRow()) {
                $this->_fetchData($row);
            } else {
                return PEAR::raiseError("[".get_class($this)." DB_index_dico : load($dico)] Aucun index de dico ne correspond  cet ID!", null,
                                    null, null, null, null, false);
            }
            $result->free();
        }
    }

    // }}}

    // {{{ delete()

    /**
     * This method is used to delete the dictionary
     * @access  public
     */

    function delete() {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_dico : delete()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_index_dico";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return $result;
        }
    }

    // }}}

    // {{{ _fetchData()

    /**
     * This method is used to fetch result set fields into the object fields
     * @access  private
     * @param   int $row the row to fetch
     */

    function _fetchData($row) {
        $this->setHash($row['hash']);
    	$this->setDico($row['dico']);
    }

    // }}}

    // {{{ addDico()

	/**
     * This method is used to add a character string required from the database ignoring the Key value of the table
     * @access  public
     */

    function addDico($mots = array()) {
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_dico : addDico()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        while(list(,$monMot) = each($mots)) {
            $query = "SELECT dico FROM ".$GLOBALS['table_prefix']."_index_dico WHERE dico='".$monMot['dico']."'";
             

            //echo "<br><br>$query<br><br>";

            $result = $db->query($query);
            if (DB::isError($result)) {
                return PEAR::raiseError("[".get_class($this)." DB_index_dico : addDico()] ".$result->getMessage()."", null,
                    null, null, null, null, false);
            }

            if($result->numRows() == 0) {
                $query = "INSERT INTO ".$GLOBALS['table_prefix']."_index_dico (".INDEX_DICO_ALL_FIELDS.") VALUES "
                    ."('".$db->quoteString($monMot['hash'])."', "
                    ."'".$db->quoteString($monMot['dico'])."')";;

                 

                //echo "<br><br>$query<br><br>";

                $result = $db->query($query);
                if (DB::isError($result)) {
                    return $result;
                }
            }
        }
    }
    // }}}

    // {{{ composeResearchInIndex($dico)

    /**
     * This method is used to compose a research in the dictionary
     * @access  public
     * @param   String $dico the character string required to load
     */

    function composeResearchInIndex($dico) {
        $hashIds = array();

        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_dico : composeResearchInIndex()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT hash AS hx FROM ".$GLOBALS['table_prefix']."_index_dico WHERE ".join(" OR ", $dico);
         
        $result = $db->query($query);

        if (DB::isError($result)) {
            return $result;
        }

        while ($row = $result->fetchRow()) {
            //echo $row['hx'];
            //$hashIds[] = "0x".dechex($row['hx'],20);
            $hashIds[] = "'".$row['hx']."'";

        }

        $result->free();

        return $hashIds;
    }

    // }}}
    
    
    // {{{ getDicoFromHash 
    
    /**
     * 
     * @access  public
     * @param   String $hash 
     */
    
    function getDicoFromHash ($hash) {
         $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_dico : getDicoFromHash()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        
        $query = "SELECT dico FROM ".$GLOBALS['table_prefix']."_index_dico WHERE hash = '".$hash."'";
        $result = $db->query($query);
        $row = $result->fetchRow();
        return $row['dico'];
        
    }
    
    
    // }}}
}
?>