<?Php
//
// +----------------------------------------------------------------------+
// |                                         |
// +----------------------------------------------------------------------+
// | Author: Olivier Mansour	              |
// +----------------------------------------------------------------------+
//
// Base class for Index Docs business persistence abstraction.
// $Id: index_documents.php,v 1.1 2005/07/07 17:10:01 oliviermansour Exp $

/*
require_once "PEAR.php";
require_once "DB.php";
*/
require_once dirname(__FILE__)."/metier.php";
//  require_once dirname(__FILE__)."/../../inc_filtres.php3";


define("INDEX_DOCUMENTS_ALL_FIELDS", " hash, points, id_document, emplacement ");

/**
 * BD_index_docs is a base class for article business persistence abstraction implementations, and must be
 * inherited by all such.
 * @author 	Olivier Mansour
 * @access	public
 */
class BD_index_documents extends BD_metier {
    // {{{ properties

    /**
     * $_hash
     * @var     int
     * @access  private
     */
    var $_hash;
    
    /**
     * $_points
     * @var     int
     * @access  private
     */
    var $_points;
    
    /**
     * $_documentId
     * @var     int
     * @access  private
     */
    var $_documentId;


    /**
     * $_emplacement
     * @var     string
     * @access  private
     */
    var $_emplacement;

    // }}}

    // {{{ factory()

    /**
     * 
     * @param   BD_parameters DB connection parameters
     * @access public
     */

    function &factory($dbParameters = null, $dbOptions = null) {

        if(file_exists(dirname(__FILE__)."/".$dbParameters->_dbEngine."/index_documents_".$dbParameters->_dbEngine.".php") == false) {
            include_once(dirname(__FILE__)."/common/index_documents_common.php");
            $classname = "BD_index_documents_common";
        }
        else {
            include_once(dirname(__FILE__)."/".$dbParameters->_dbEngine."/index_documents_".$dbParameters->_dbEngine.".php");
            $classname = "BD_index_documents_".$dbParameters->_dbEngine;
        }
        if (!class_exists($classname)) {
            return PEAR::raiseError("Cannot instanciate class $classname", null,
                                    null, null, null, null, false);
        }

        $obj =& new $classname;
        $result = $obj->setDbParameters($dbParameters);
        if ($dbOptions != null) {
            $obj->setDbOptions($dbOptions);
        }
        if (PEAR::isError($result)) {
            return $result;
        } else {
            return $obj;
        }
    }

    // }}}

    // {{{ constructor

    /**
     * DB_index_articles constructor.
     *
     * @access public
     */

    function BD_index_documents() {
    }

    // }}}

    // {{{ getHash()

    /**
     * Returns the hash's value
     * @return  int
     * @access  public
     */

    function getHash() {
        return $this->_hash;
    }

    // }}}

    // {{{ setHash()

    /**
     * Sets the hash's value
     * @param  int
     * @access  public
     */

    function setHash($hash) {
        $this->_hash = $this->corriger_caracteres($hash);
    }

	// }}}

    // {{{ getPoints()

    /**
     * Returns the points' value
     * @return  int
     * @access  public
     */

    function getPoints() {
        return $this->_points;
    }
	
	// }}}

    // {{{ setPoints()

    /**
     * Sets the points' value
     * @param  int
     * @access  public
     */

    function setPoints($points) {
        $this->_points = $points;
    }

    // }}}


// {{{ getEmplacement()

    /**
     * Returns the emplacement' value
     * @return  int
     * @access  public
     */

    function getEmplacement() {
        return $this->_emplacement;
    }
    
    // }}}

    // {{{ setEmplacement()

    /**
     * Sets the points' value
     * @param  int
     * @access  public
     */

    function setEmplacement($emplacement) {
        $this->_emplacement = $emplacement;
    }

    // }}}



    
    // {{{ getDocumentId()

    /**
     * Returns the doc ID
     * @return  int
     * @access  public
     */

    function getDocumentId() {
        return $this->_documentId;
    }

    // }}}

    // {{{ setDocumentId()

    /**
     * Sets the doc ID
     * @param  int
     * @access  public
     */

    function setDocumentId($articleId) {
        $this->_documentId = $articleId;
    }

    // }}}
    
    // {{{ setId()

    /**
     * Sets the article ID
     * @param  int
     * @access  public
     */

    function setId($articleId) {
        $this->setDocumentId($articleId);
    }

    // }}}


    // {{{ create()

    /**
     * This method is used to create a new index of articles in the database
     * @access public
     */

    function create() {
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_document : create()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "INSERT INTO ".$GLOBALS['table_prefix']."_index_documents (".INDEX_DOCUMENTS_ALL_FIELDS.") VALUES "
                ."('".$db->quoteString($this->_hash)."', "
                .$this->_points.", "
                .$this->_documentId.", '"
                .$db->quotestring($this->_emplacement).
                "')";

        //echo "<br>".$query."<br>";
         

        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_document : create()] $query ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ load()

    /**
     * This method is used to load an index of articles from the database
     * @access  public
     * @param   int $articleId ID of article to load
     */

    function load($documentId) {
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_document : load()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT".INDEX_DOCUMENTS_ALL_FIELDS."FROM ".$GLOBALS['table_prefix']."_index_documents WHERE document_id = $documentId";

         
        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_document : load()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
            if ($row = $result->fetchRow()) {
                $this->_fetchData($row);
            } else {
                return PEAR::raiseError("[".get_class($this)." DB_index_documents : load($articleId)] Aucun index de document ne correspond  cet ID!", null,
                                    null, null, null, null, false);
            }
            $result->free();
        }
    }

    // }}}

    // {{{ delete()

    /**
     * This method is used to delete the index of doc
     * @access  public
     */

    function delete() {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_document : delete()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_index_documents";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_document : delete()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ deleteIndexArticleForArticleId($id_objet)

    /**
     * This method is used to delete an index of document from the database
     * @access  public
     * @param   int $id_objet ID of document to delete
     */

    function deleteIndexDocumentForDocumentId($id_objet) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_article : deleteIndexDocumentForDocumentId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_index_documents WHERE id_document = $id_objet";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_article : deleteIndexDocumentForDocumentId()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ _fetchData()

    /**
     * This method is used to fetch result set fields into the object fields
     * @access  private
     * @param   int $row the row to fetch
     */

    function _fetchData($row) {
        $this->setHash($row['hash']);
        $this->setPoints($row['points']);
        $this->setDocumentId($row['id_article']);
        $this->setEmplacement($row['emplacement']);
    }

    // }}}

    // {{{ howManyIndexArticle()

    /**
     * This method is used to count how many index of Document exist
     * @access  public
     */

    function howManyIndexDocument() {
        $howManyIndexDocument = 0;
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_Document : howManyIndexDocument()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        
		$query = "SELECT COUNT(*) AS cnt FROM ".$GLOBALS['table_prefix']."_index_documents";
         
		$result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_article : howManyIndexDocument()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        if ($row = $result->fetchRow()) {
            $howManyIndexDocument = intval($row["cnt"]);
        }
        $result->free();
        return $howManyIndexDocument;
    }

    // }}}

    // {{{ howManyIndexArticleForArticleId($id_objet)

    /**
     * This method is used to count how many index of articles exist for an article's ID
     * @access  public
     * @param   int $id_objet ID of artciles to see
     */

    function howManyIndexDocumentForDocumentId($id_objet) {
    	if ((!isset($id_objet)) || ($id_objet < 0)) return 0;
        $howManyIndexDocumentForDocumentId = 0;
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_Document : howManyIndexDocumentForDocumentId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        
		$query = "SELECT COUNT(*) as compteur FROM ".$GLOBALS['table_prefix']."_index_documents WHERE id_document = $id_objet";
		
		 
		$result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_Document : howManyIndexDocumentForDocumentId()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        if ($row = $result->fetchRow()) {
            $howManyIndexDocumentForDocumentId = intval($row["compteur"]);
        }

        $result->free();
        return $howManyIndexDocumentForDocumentId;
    }

    // }}}
}
?>
