<?Php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Julien Guillot <jguillot@clever-age.com>		              |
// +----------------------------------------------------------------------+
//
// Base class for Index Mot business persistence abstraction.
// $Id$



require_once "PEAR.php";
require_once "DB.php";
require_once dirname(__FILE__)."/metier.php";
require_once dirname(__FILE__)."/../../inc_filtres.php3";

define("INDEX_MOTS_ALL_FIELDS", " hash, points, id_mot, emplacement ");

/**
 * BD_index_mots is a base class for mot business persistence abstraction implementations, and must be
 * inherited by all such.
 * @package	BD
 * @author  Antoine Angnieux <aangenieux@clever-age.com>
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @access	public
 */
class BD_index_mots extends BD_metier {
    // {{{ properties

    /**
     * $_emplacement
     * @var     string
     * @access  private
     */
    var $_emplacement;


    /**
     * $_hash
     * @var     int
     * @access  private
     */
    var $_hash;

    /**
     * $_points
     * @var     int
     * @access  private
     */
    var $_points;
    
    /**
     * $_motId
     * @var     int
     * @access  private
     */
    var $_motId;

    // }}}

    // {{{ getEmplacement()

    /**
     * Returns the emplacement' value
     * @return  int
     * @access  public
     */

    function getEmplacement() {
        return $this->_emplacement;
    }
    
    // }}}

    // {{{ setEmplacement()

    /**
     * Sets the points' value
     * @param  int
     * @access  public
     */

    function setEmplacement($emplacement) {
        $this->_emplacement = $emplacement;
    }

    // }}}



    // {{{ factory()
    function &factory($dbParameters = null, $dbOptions = null) {

        if(file_exists(dirname(__FILE__)."/".$dbParameters->_dbEngine."/index_mots_".$dbParameters->_dbEngine.".php") == false) {
            include_once(dirname(__FILE__)."/common/index_mots_common.php");
            $classname = "BD_index_mots_common";
        }
        else {
            include_once(dirname(__FILE__)."/".$dbParameters->_dbEngine."/index_mots_".$dbParameters->_dbEngine.".php");
            $classname = "BD_index_mots_".$dbParameters->_dbEngine;
        }

        if (!class_exists($classname)) {
            return PEAR::raiseError("Cannot instanciate class $classname", null,
                                    null, null, null, null, false);
        }

        $obj =& new $classname;
        $result = $obj->setDbParameters($dbParameters);
        if ($dbOptions != null) {
            $obj->setDbOptions($dbOptions);
        }
        if (PEAR::isError($result)) {
            return $result;
        } else {
            return $obj;
        }
    }

    // }}}

    // {{{ constructor

    /**
     * DB_index_mots constructor.
     *
     * @access public
     */

    function BD_index_mots() {
    }

    // }}}

    // {{{ getHash()

    /**
     * Returns the hash's value
     * @return  int
     * @access  public
     */

    function getHash() {
        return $this->_hash;
    }

    // }}}

    // {{{ setHash()

    /**
     * Sets the hash's value
     * @param  int
     * @access  public
     */

    function setHash($hash) {
        $this->_hash = corriger_caracteres($hash);
    }

	// }}}

    // {{{ getPoints()

    /**
     * Returns the points' value
     * @return  int
     * @access  public
     */

    function getPoints() {
        return $this->_points;
    }
	
	// }}}

    // {{{ setPoints()

    /**
     * Sets the points' value
     * @param  int
     * @access  public
     */

    function setPoints($points) {
        $this->_points = $points;
    }

    // }}}
    
    // {{{ getMotId()

    /**
     * Returns the word ID
     * @return  int
     * @access  public
     */

    function getMotId() {
        return $this->_motId;
    }

    // }}}

    // {{{ setMotId()

    /**
     * Sets the word ID
     * @param  int
     * @access  public
     */

    function setMotId($motId) {
        $this->_motId = $motId;
    }

    // }}}

    // {{{ setId()

    /**
     * Sets the word ID
     * @param  int
     * @access  public
     */

    function setId($motId) {
        $this->setMotId($motId);
    }

    // }}}


    // {{{ create()

   	/**
     * This method is used to create a new index of words in the database
     * @access public
     */

    function create() {
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_mots : create()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "INSERT INTO ".$GLOBALS['table_prefix']."_index_mots (".INDEX_MOTS_ALL_FIELDS.") VALUES "
                ."('".$db->quoteString($this->_hash)."', "
                .$this->_points.", "
                .$this->_motId.", '"
                .$db->quotestring($this->_emplacement).
                "')";

         

        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_mots : create()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ load()

    /**
     * This method is used to load an index of words from the database
     * @access  public
     * @param   int $motId ID of word to load
     */

    function load($motId) {
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_mots : load()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT".INDEX_MOTS_ALL_FIELDS."FROM ".$GLOBALS['table_prefix']."_index_mots WHERE id_mot = $motId";

         
        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_mots : load()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
            if ($row = $result->fetchRow()) {
                $this->_fetchData($row);
            } else {
                return PEAR::raiseError("[".get_class($this)." DB_index_mots : load($motId)] Aucun index de mots ne correspond  cet ID!", null,
                                    null, null, null, null, false);
            }
            $result->free();
        }
    }

    // }}}

    // {{{ delete()

    /**
     * This method is used to delete the index of words
     * @access  public
     */

    function delete() {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_mots : delete()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_index_mots";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_mots : delete()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ deleteIndexMotForMotId($id_objet)

    /**
     * This method is used to delete an index of words from the database
     * @access  public
     * @param   int $id_objet ID of word to delete
     */

    function deleteIndexMotForMotId($id_objet) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_mots : deleteIndexMotForMotId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_index_mots WHERE id_mot = $id_objet";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_mots : deleteIndexMotForMotId()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ _fetchData()

    /**
     * This method is used to fetch result set fields into the object fields
     * @access  private
     * @param   int $row the row to fetch
     */

    function _fetchData($row) {
        $this->setHash($row['hash']);
        $this->setPoints($row['points']);
        $this->setMotId($row['id_mot']);
        $this->setEmplacement($row['emplacement']);
    }

    // }}}

   // {{{ howManyIndexMotForMotId($id_objet)

    /**
     * This method is used to count how many index of words exist for a word's ID
     * @access  public
     * @param   int $id_objet ID of word to see
     */

    function howManyIndexMotForMotId($id_objet) {
    	if ((!isset($id_objet)) || ($id_objet < 0)) return 0;
        $howManyIndexMotForMotId = 0;
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_mots : howManyIndexMotForMotId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        
		$query = "SELECT COUNT(*) as compteur FROM ".$GLOBALS['table_prefix']."_index_mots WHERE id_mot = $id_objet";
		 
		$result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_mots : howManyIndexMotForMotId()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        if ($row = $result->fetchRow()) {
            $howManyIndexMotForMotId = intval($row["compteur"]);
        }

        $result->free();
        return $howManyIndexMotForMotId;
    }

    // }}}
}
?>
