<?Php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Julien Guillot <jguillot@clever-age.com>		              |
// +----------------------------------------------------------------------+
//
// Base class for Index Rubrique business persistence abstraction.
// $Id$


require_once "PEAR.php";
require_once "DB.php";
require_once dirname(__FILE__)."/metier.php";
require_once dirname(__FILE__)."/../../inc_filtres.php3";

define("INDEX_RUBRIQUES_ALL_FIELDS", " hash, points, id_rubrique, emplacement ");

/**
 * BD_index_rubriques is a base class for rubrique business persistence abstraction implementations, and must be
 * inherited by all such.
 * @package	BD
 * @author  Antoine Angnieux <aangenieux@clever-age.com>
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @access	public
 */
class BD_index_rubriques extends BD_metier {
    // {{{ properties

    /**
     * $_hash
     * @var     int
     * @access  private
     */
    var $_hash;
    
    /**
     * $_points
     * @var     int
     * @access  private
     */
    var $_points;
    
    /**
     * $_rubriqueId
     * @var     int
     * @access  private
     */
    var $_rubriqueId;

    /**
     * $_emplacement
     * @var     string
     * @access  private
     */
    var $_emplacement;


    // }}}


     // {{{ getEmplacement()

    /**
     * Returns the emplacement' value
     * @return  int
     * @access  public
     */

    function getEmplacement() {
        return $this->_emplacement;
    }
    
    // }}}

    // {{{ setEmplacement()

    /**
     * Sets the points' value
     * @param  int
     * @access  public
     */

    function setEmplacement($emplacement) {
        $this->_emplacement = $emplacement;
    }

    // }}}


    // {{{ factory()
    function &factory($dbParameters = null, $dbOptions = null) {

        if(file_exists(dirname(__FILE__)."/".$dbParameters->_dbEngine."/index_rubriques_".$dbParameters->_dbEngine.".php") == false) {
            include_once(dirname(__FILE__)."/common/index_rubriques_common.php");
            $classname = "BD_index_rubriques_common";
        }
        else {
            include_once(dirname(__FILE__)."/".$dbParameters->_dbEngine."/index_rubriques_".$dbParameters->_dbEngine.".php");
            $classname = "BD_index_rubriques_".$dbParameters->_dbEngine;
        }

        if (!class_exists($classname)) {
            return PEAR::raiseError("Cannot instanciate class $classname", null,
                                    null, null, null, null, false);
        }

        $obj =& new $classname;
        $result = $obj->setDbParameters($dbParameters);
        if ($dbOptions != null) {
            $obj->setDbOptions($dbOptions);
        }
        if (PEAR::isError($result)) {
            return $result;
        } else {
            return $obj;
        }
    }

    // }}}

    // {{{ constructor

    /**
     * DB_index_rubriques constructor.
     *
     * @access public
     */

    function BD_index_rubriques() {
    }

    // }}}

    // {{{ getHash()

    /**
     * Returns the hash's value
     * @return  int
     * @access  public
     */

    function getHash() {
        return $this->_hash;
    }

    // }}}

    // {{{ setHash()

    function setHash($hash) {
        $this->_hash = corriger_caracteres($hash);
    }

	// }}}

    // {{{ getPoints()

    /**
     * Returns the points' value
     * @return  int
     * @access  public
     */

    function getPoints() {
        return $this->_points;
    }
	
	// }}}

    // {{{ setPoints()

    /**
     * Sets the points' value
     * @param  int
     * @access  public
     */

    function setPoints($points) {
        $this->_points = $points;
    }

    // }}}
    
    // {{{ getRubriqueId()

    /**
     * Returns the heading ID
     * @return  int
     * @access  public
     */

    function getRubriqueId() {
        return $this->_rubriqueId;
    }

    // }}}

    // {{{ setRubriqueId()

    /**
     * Sets the rubrique ID
     * @param  int
     * @access  public
     */

    function setRubriqueId($rubriqueId) {
        $this->_rubriqueId = $rubriqueId;
    }

    // }}}

    // {{{ setId()

    /**
     * Sets the rubrique ID
     * @param  int
     * @access  public
     */

    function setId($rubriqueId) {
        $this->setRubriqueId($rubriqueId);
    }

    // }}}


    // {{{ create()

    /**
     * This method is used to create a new index of headings in the database
     * @access public
     */

    function create() {
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_rubriques : create()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "INSERT INTO ".$GLOBALS['table_prefix']."_index_rubriques (".INDEX_RUBRIQUES_ALL_FIELDS.") VALUES "
               ."('".$db->quoteString($this->_hash)."', "
                .$this->_points.", "
                .$this->_rubriqueId.", '"
                .$db->quotestring($this->_emplacement).
                "')";
         

        //echo "<br>".$query."<br>";

        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_rubriques : create()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ load()

    /**
     * This method is used to load an index of headings from the database
     * @access  public
     * @param   int $rubriqueId ID of heading to load
     */

    function load($rubriqueId) {
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_rubriques : load()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT".INDEX_RUBRIQUES_ALL_FIELDS."FROM ".$GLOBALS['table_prefix']."_index_rubriques WHERE id_rubrique = $rubriqueId";

         
        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_rubriques : load()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
            if ($row = $result->fetchRow()) {
                $this->_fetchData($row);
            } else {
                return PEAR::raiseError("[".get_class($this)." DB_index_rubriques : load($rubriqueId)] Aucun index de rubriques ne correspond  cet ID!", null,
                                    null, null, null, null, false);
            }
            $result->free();
        }
    }

    // }}}

    // {{{ delete()

    /**
     * This method is used to delete the index of headings
     * @access  public
     */

    function delete() {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_rubriques : delete()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_index_rubriques";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_rubriques : delete()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ deleteIndexRubriqueForRubriqueId($id_objet)

    /**
     * This method is used to delete an index of headings from the database
     * @access  public
     * @param   int $id_objet ID of heading to delete
     */

    function deleteIndexRubriqueForRubriqueId($id_objet) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_rubriques : deleteIndexRubriqueForRubriqueId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_index_rubriques WHERE id_rubrique = $id_objet";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_rubriques : deleteIndexRubriqueForRubriqueId()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ _fetchData()

    /**
     * This method is used to fetch result set fields into the object fields
     * @access  private
     * @param   int $row the row to fetch
     */

    function _fetchData($row) {
        $this->setHash($row['hash']);
        $this->setPoints($row['points']);
        $this->setRubriqueId($row['id_rubrique']);
        $this->setEmplacement($row['emplacement']);
    }

    // }}}

    // {{{ howManyIndexRubriqueForRubriqueId($id_objet)

    /**
     * This method is used to count how many index of headings exist for a heading's ID
     * @access  public
     * @param   int $id_objet ID of heading to see
     */

    function howManyIndexrubriqueForRubriqueId($id_objet) {
    	if ((!isset($id_objet)) || ($id_objet < 0)) return 0;
        $howManyIndexRubriqueForRubriqueId = 0;
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_rubriques : howManyIndexrubriqueForRubriqueId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        
		$query = "SELECT COUNT(*) as compteur FROM ".$GLOBALS['table_prefix']."_index_rubriques WHERE id_rubrique = $id_objet";
		 
		$result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_rubriques : howManyIndexrubriqueForRubriqueId()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        if ($row = $result->fetchRow()) {
            $howManyIndexRubriqueForRubriqueId = intval($row["compteur"]);
        }

        $result->free();
        return $howManyIndexRubriqueForRubriqueId;
    }

    // }}}
}
?>
