<?Php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Julien Guillot <jguillot@clever-age.com>		              |
// +----------------------------------------------------------------------+
//
// Base class for Index Syndic business persistence abstraction.
// $Id$


require_once "PEAR.php";
require_once "DB.php";
require_once dirname(__FILE__)."/metier.php";
require_once dirname(__FILE__)."/../../inc_filtres.php3";

define("INDEX_SYNDIC_ALL_FIELDS", " hash, points, id_syndic, emplacement ");

/**
 * BD_index_syndic is a base class for syndic business persistence abstraction implementations, and must be
 * inherited by all such.
 * @package	BD
 * @author  Antoine Angnieux <aangenieux@clever-age.com>
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @access	public
 */
class BD_index_syndic extends BD_metier {
    // {{{ properties

    /**
     * $_hash
     * @var     int
     * @access  private
     */
    var $_hash;
    
    /**
     * $_points
     * @var     int
     * @access  private
     */
    var $_points;
    
    /**
     * $_syndicId
     * @var     int
     * @access  private
     */
    var $_syndicId;
    
    
     /**
     * $_emplacement
     * @var     string
     * @access  private
     */
    var $_emplacement;

    // }}}


    // {{{ getEmplacement()

    /**
     * Returns the emplacement' value
     * @return  int
     * @access  public
     */

    function getEmplacement() {
        return $this->_emplacement;
    }
    
    // }}}

    // {{{ setEmplacement()

    /**
     * Sets the points' value
     * @param  int
     * @access  public
     */

    function setEmplacement($emplacement) {
        $this->_emplacement = $emplacement;
    }

    // }}}

    // {{{ factory()

    /**
     * This method is a factory static method. It should be used to get any
     * specific implementation instace of Syndic business data type.
     * @param   BD_parameters DB connection parameters
     * @access public
     */

    function &factory($dbParameters = null, $dbOptions = null) {

        if(file_exists(dirname(__FILE__)."/".$dbParameters->_dbEngine."/index_syndic_".$dbParameters->_dbEngine.".php") == false) {
            include_once(dirname(__FILE__)."/common/index_syndic_common.php");
            $classname = "BD_index_syndic_common";
        }
        else {
            include_once(dirname(__FILE__)."/".$dbParameters->_dbEngine."/index_syndic_".$dbParameters->_dbEngine.".php");
            $classname = "BD_index_syndic_".$dbParameters->_dbEngine;
        }

        if (!class_exists($classname)) {
            return PEAR::raiseError("Cannot instanciate class $classname", null,
                                    null, null, null, null, false);
        }

        $obj =& new $classname;
        $result = $obj->setDbParameters($dbParameters);
        if ($dbOptions != null) {
            $obj->setDbOptions($dbOptions);
        }
        if (PEAR::isError($result)) {
            return $result;
        } else {
            return $obj;
        }
    }

    // }}}

    // {{{ constructor

    /**
     * DB_index_syndic constructor.
     *
     * @access public
     */

    function BD_index_syndic() {
    }

    // }}}

    // {{{ getHash()

    /**
     * Returns the hash's value
     * @return  int
     * @access  public
     */

    function getHash() {
        return $this->_hash;
    }

    // }}}

    // {{{ setHash()

    /**
     * Sets the hash's value
     * @param  int
     * @access  public
     */

    function setHash($hash) {
        $this->_hash = corriger_caracteres($hash);
    }

	// }}}

    // {{{ getPoints()

    /**
     * Returns the points' value
     * @return  int
     * @access  public
     */

    function getPoints() {
        return $this->_points;
    }
	
	// }}}

    // {{{ setPoints()

    /**
     * Sets the points' value
     * @param  int
     * @access  public
     */

    function setPoints($points) {
        $this->_points = $points;
    }

    // }}}
    
    // {{{ getSyndicId()

    /**
     * Returns the syndic ID
     * @return  int
     * @access  public
     */
    function getSyndicId() {
        return $this->_syndicId;
    }

    // }}}

    // {{{ setSyndicId()

    /**
     * Sets the syndic ID
     * @param  int
     * @access  public
     */

    function setSyndicId($syndicId) {
        $this->_syndicId = $syndicId;
    }

    // }}}

    // {{{ setId()

    /**
     * Sets the syndic ID
     * @param  int
     * @access  public
     */

    function setId($syndicId) {
        $this->setSyndicId($syndicId);
    }

    // }}}


    // {{{ create()

    /**
     * This method is used to create a new index of syndication in the database
     * @access public
     */

    function create() {
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_syndic : create()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "INSERT INTO ".$GLOBALS['table_prefix']."_index_syndic (".INDEX_SYNDIC_ALL_FIELDS.") VALUES "
               ."('".$db->quoteString($this->_hash)."', "
                .$this->_points.", "
                .$this->_syndicId.", '"
                .$db->quotestring($this->_emplacement).
                "')";

         
        //echo "<br><br> ------> ".$query."<br>";
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_syndic : create()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ load()

    /**
     * This method is used to load an index of syndication from the database
     * @access  public
     * @param   int $syndicId ID of syndication to load
     */

    function load($syndicId) {
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_syndic : load()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT".INDEX_SYNDIC_ALL_FIELDS."FROM ".$GLOBALS['table_prefix']."_index_syndic WHERE syndicId = $syndicId";

         
        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_syndic : load()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
            if ($row = $result->fetchRow()) {
                $this->_fetchData($row);
            } else {
                return PEAR::raiseError("[".get_class($this)." DB_index_syndic : load($syndicId)] Aucun index de syndic ne correspond  cet ID!", null,
                                    null, null, null, null, false);
            }
            $result->free();
        }
    }

    // }}}

    // {{{ delete()

    /**
     * This method is used to delete the index of syndication
     * @access  public
     */

    function delete() {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_syndic : delete()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_index_syndic";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_syndic : delete()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

   	// {{{ deleteIndexSyndicForSyndicId($id_objet)

    /**
     * This method is used to delete an index of syndication from the database
     * @access  public
     * @param   int $id_objet ID of syndication to delete
     */

    function deleteIndexSyndicForSyndicId($id_objet) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_syndic : deleteIndexSyndicForSyndicId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_index_syndic WHERE id_syndic = $id_objet";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_syndic : deleteIndexSyndicForSyndicId()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ _fetchData()

    /**
     * This method is used to fetch result set fields into the object fields
     * @access  private
     * @param   int $row the row to fetch
     */

    function _fetchData($row) {
        $this->setHash($row['hash']);
        $this->setPoints($row['points']);
        $this->setSyndicId($row['id_syndic']);
        $this->setEmplacement($row['emplacement']);
    }

    // }}}

    // {{{ howManyIndexSyndicForSyndicId($id_objet)

    /**
     * This method is used to count how many index of syndication exist for a syndication's ID
     * @access  public
     * @param   int $id_objet ID of syndication to see
     */

    function howManyIndexSyndicForSyndicId($id_objet) {
    	if ((!isset($id_objet)) || ($id_objet < 0)) return 0;
        $howManyIndexSyndicForSyndicId = 0;
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_syndic : howManyIndexSyndicForSyndicId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        
		$query = "SELECT COUNT(*) as compteur FROM ".$GLOBALS['table_prefix']."_index_syndic WHERE id_syndic = $id_objet";
		 
		$result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_index_syndic : howManyIndexSyndicForSyndicId()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        if ($row = $result->fetchRow()) {
            $howManyIndexSyndicForSyndicId = intval($row["compteur"]);
        }

        $result->free();
        return $howManyIndexSyndicForSyndicId;
    }

    // }}}
}
?>
