<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Matthieu Belge <mbelge@clever-age.com>                |
// +----------------------------------------------------------------------+
//
// Base class for Author business persistence abstraction .
//

if (defined("_BD_AUTEURLDAP3")) return;
define("_BD_AUTEURLDAP3", "1");

require_once dirname(__FILE__)."/../auteur.php";

/**
 * BD_auteur_ldap3 is an implementation for LDAPv3 of BD_auteur business class.
 * @package	BD_ldap3
 * @author 	Matthieu Belge <mbelge@clever-age.com>
 * @access	public
 */

class BD_auteur_ldap3 extends BD_auteur {
    // {{{ properties

    /**
    * Auteur DN.
    * @var     String
    * @access  private
    */
    var $_auteurDN;

    /**
    * Auteur ID.
    * @var     int
    * @access  private
    */
    var $_auteurId;

    /**
    * Name.
    * @var     String
    * @access  private
    */
    var $_nom;

    /**
    * Description of the user.
    * @var     String
    * @access  private
    */
    var $_bio;

    /**
    * Email.
    * @var     String
    * @access  private
    */
    var $_email;

    /**
    * Site name.
    * @var     String
    * @access  private
    */
    var $_nomSite;

    /**
    * Site url.
    * @var     String
    * @access  private
    */
    var $_urlSite;

    /**
    * login.
    * @var     String
    * @access  private
    */
    var $_login;

    /**
    * password.
    * @var     String
    * @access  private
    */
    var $_pass;

    /**
    * Statute.
    * @var     String
    * @access  private
    */
    var $_statut;

    /**
    * last update.
    * @var     Date
    * @access  private
    */
    var $_maj;

    /**
    * signature.
    * @var     String
    * @access  private
    */
    var $_pgp;

    /**
    * htpass.
    * @var     String
    * @access  private
    */
    var $_htpass;

    /**
    * online.
    * @var     Date
    * @access  private
    */
    var $_enLigne;

    /**
    * internal message
    * @var     String
    * @access  private
    */
    var $_imessage;

    /**
    * message
    * @var     String
    * @access  private
    */
    var $_messagerie;

    /**
    * useful variable.
    * @var     String
    * @access  private
    */
    var $_aleaActuel;

    /**
    * useful variable.
    * @var     String
    * @access  private
    */
    var $_aleaFutur;

    /**
    * preferences.
    * @var     String
    * @access  private
    */
    var $_prefs;

    /**
    * useful variable.
    * @var     String
    * @access  private
    */
    var $_cookieOubli;

    /**
    * source.
    * @var     String
    * @access  private
    */
    var $_source;
    // }}}

    // {{{ factory()
    function &factory($dbParameters = null) {

        include_once(dirname(__FILE__)."/".$dbParameters->_dbEngine."/auteur_".$dbParameters->_dbEngine.".php");
        $classname = "BD_auteur_".$dbParameters->_dbEngine;

        if (!class_exists($classname)) {
            return PEAR::raiseError("Cannot instanciate class $classname", null,
                                    null, null, null, null, false);
        }

        $obj =& new $classname;
        $result = $obj->setDbParameters($dbParameters);
        if (PEAR::isError($result)) {
            return $result;
        } else {
            return $obj;
        }
    }

    // }}}

    // {{{ constructor

    /**
     * DB_auteur constructor.
     *
     * @access public
     */

    function BD_auteur() {
    }

    // }}}

    // {{{ getAuteurDN()

    /**
     * Returns the Author's DN
     * @return  String
     * @access  public
     */

    function getAuteurDN() {
        return $this->_auteurDN;
    }

    // }}}

    // {{{ setAuteurDN()

    /**
     * Sets the Author's DN
     * @param   String
     * @access  public
     */

    function setAuteurDN($auteurDN) {
        $this->_auteurDN = $auteurDN;
    }

    // }}}

    // {{{ getAuteurId()

    /**
     * Returns the Author's ID
     * @return  int
     * @access  public
     */

    function getAuteurId() {
        return $this->_auteurId;
    }

    // }}}

    // {{{ setAuteurId()

    /**
     * Sets the Author's ID
     * @param   int
     * @access  public
     */

    function setAuteurId($auteurId) {
        $this->_auteurId = $auteurId;
    }

    // }}}

    // {{{ getNom()

    /**
     * Returns the Author's Name
     * @return  String
     * @access  public
     */

    function getNom() {
        return $this->_nom;
    }

    // }}}

    // {{{ setNom()

    /**
     * Sets the Author's Name
     * @param  String
     * @access  public
     */

    function setNom($nom) {
        $this->_nom = $nom;
    }

    // }}}

    // {{{ getBio()

    /**
     * Returns the Author's Biography
     * @return  String
     * @access  public
     */

    function getBio() {
        return $this->_bio;
    }

    // }}}

    // {{{ setBio()

    /**
     * Sets the Author's Biography
     * @param  String
     * @access  public
     */
    function setBio($bio) {
        $this->_bio = $bio;
    }

    // }}}

    // {{{ getEmail()

    /**
     * Returns the Author Email
     * @return  String
     * @access  public
     */

    function getEmail() {
        return $this->_email;
    }

    // }}}

    // {{{ setEmail()

    /**
     * Sets the Author Email
     * @param  String
     * @access  public
     */

    function setEmail($email) {
        $this->_email = $email;
    }

    // }}}

    // {{{ getNomSite()

    /**
     * Returns the Author's Site Name
     * @return  String
     * @access  public
     */

    function getNomSite() {
        return $this->_nomSite;
    }

    // }}}

    // {{{ setNomSite()

    /**
     * Sets the Author's Site Name
     * @param  String
     * @access  public
     */

    function setNomSite($nomSite) {
        $this->_nomSite = $nomSite;
    }

    // }}}

    // {{{ getUrlSite()

    /**
     * Returns the Author's Site URL
     * @return  String
     * @access  public
     */

    function getUrlSite() {
        return $this->_urlSite;
    }

    // }}}

    // {{{ setUrlSite()

    /**
     * Sets the Author's Site URL
     * @param  String
     * @access  public
     */

    function setUrlSite($urlSite) {
        $this->_urlSite = $urlSite;
    }

    // }}}

    // {{{ getLogin()

    /**
     * Returns the Author's Login
     * @return  String
     * @access  public
     */

    function getLogin() {
        return $this->_login;
    }

    // }}}

    // {{{ setLogin()

    /**
     * Sets the Author's Login
     * @param  String
     * @access  public
     */

    function setLogin($login) {
        $this->_login = $login;
    }

    // }}}

    // {{{ getPass()

    /**
     * Returns the Author's Password
     * @return  String
     * @access  public
     */

    function getPass() {
        return $this->_pass;
    }

    // }}}

    // {{{ setPass()

    /**
     * Sets the Author's Password
     * @param  String
     * @access  public
     */

    function setPass($pass) {
        $this->_pass = $pass;
    }

    // }}}

    // {{{ getStatut()

    /**
     * Returns the Author's Statute
     * @return  String
     * @access  public
     */

    function getStatut() {
        return $this->_statut;
    }

    // }}}

    // {{{ setStatut()

    /**
     * Sets the Author's Statute
     * @param  String
     * @access  public
     */

    function setStatut($statut) {
        $this->_statut = $statut;
    }

    // }}}

    // {{{ getMaj()

    /**
     * Returns the last update
     * @return  Date
     * @access  public
     */

    function getMaj() {
        return $this->_maj;
    }

    // }}}

    // {{{ setMaj()

    /**
     * Sets the last update
     * @param  Date
     * @access  public
     */

    function setMaj($maj) {
        $this->_maj = $maj;
    }

    // }}}

    // {{{ getPgp()

    /**
     * Returns the Author's Pgp
     * @return  String
     * @access  public
     */

    function getPgp() {
        return $this->_pgp;
    }

    // }}}

    // {{{ setPgp()

    /**
     * Sets the Author's Pgp
     * @param  String
     * @access  public
     */

    function setPgp($pgp) {
        $this->_pgp = $pgp;
    }

    // }}}

    // {{{ getHtpass()

    /**
     * Returns the Author's HtPassword
     * @return  String
     * @access  public
     */

    function getHtpass() {
        return $this->_htpass;
    }

    // }}}

    // {{{ setHtpass()

    /**
     * Sets the Author's HtPassword
     * @param  String
     * @access  public
     */

    function setHtpass($htpass) {
        $this->_htpass = $htpass;
    }

    // }}}

    // {{{ getEnLigne()

    /**
     * Returns the author is on line
     * @return  Date
     * @access  public
     */

    function getEnLigne() {
        return $this->_enLigne;
    }

    // }}}

    // {{{ setEnLigne()

    /**
     * Sets the author is on line
     * @param  Date
     * @access  public
     */
    function setEnLigne($enLigne) {
        $this->_enLigne = $enLigne;
    }

    // }}}

    // {{{ getImessage()

    /**
     * Returns if the Author uses Imessage
     * @return  String
     * @access  public
     */

    function getImessage() {
        return $this->_imessage;
    }

    // }}}

    // {{{ setImessage()

    /**
     * Sets if the Author uses Imessage
     * @param  String
     * @access  public
     */

    function setImessage($imessage) {
        $this->_imessage = $imessage;
    }

    // }}}

    // {{{ getMessagerie()

    /**
     * Returns the Author uses Message
     * @return  String
     * @access  public
     */

    function getMessagerie() {
        return $this->_messagerie;
    }

    // }}}

    // {{{ setMessagerie()

    /**
     * Sets the Author uses Message
     * @param  String
     * @access  public
     */

    function setMessagerie($messagerie) {
        $this->_messagerie = $messagerie;
    }

    // }}}

    // {{{ getAleaActuel()

    /**
     * Returns the Current alea
     * @return  String
     * @access  public
     */

    function getAleaActuel() {
        return $this->_aleaActuel;
    }

    // }}}

    // {{{ setAleaActuel()

    /**
     * Sets the Current alea
     * @param  String
     * @access  public
     */

    function setAleaActuel($aleaActuel) {
        $this->_aleaActuel = $aleaActuel;
    }

    // }}}

    // {{{ getAleaFutur()

    /**
     * Returns the Future alea
     * @return  String
     * @access  public
     */

    function getAleaFutur() {
        return $this->_aleaFutur;
    }

    // }}}

    // {{{ setAleaFutur()

    /**
     * Sets the Future alea
     * @param  String
     * @access  public
     */

    function setAleaFutur($aleaFutur) {
        $this->_aleaFutur = $aleaFutur;
    }

    // }}}

    // {{{ getPrefs()

    /**
     * Returns the Author's preferences
     * @return  String
     * @access  public
     */

    function getPrefs() {
        return $this->_prefs;
    }

    // }}}

    // {{{ setPrefs()

    /**
     * Sets the Author's preferences
     * @param  String
     * @access  public
     */

    function setPrefs($prefs) {
        $this->_prefs = $prefs;
    }

    // }}}

    // {{{ getCookieOubli()

    /**
     * Returns the cookie forgotten
     * @return  String
     * @access  public
     */

    function getCookieOubli() {
        return $this->_cookieOubli;
    }

    // }}}

    // {{{ setCookieOubli()

    /**
     * Sets the cookie forgotten
     * @param  String
     * @access  public
     */

    function setCookieOubli($cookieOubli) {
        $this->_cookieOubli = $cookieOubli;
    }

    // }}}

    // {{{ getSource()

    /**
     * Returns the Source
     * @return  String
     * @access  public
     */

    function getSource() {
        return $this->_source;
    }

    // }}}

    // {{{ setSource()

    /**
     * Sets the Source
     * @param  String
     * @access  public
     */

    function setSource($source) {
        $this->_source = $source;
    }

    // }}}

    // {{{ _getldapLogin () 

    /** 
    * le format ldap du login 
    * @param String
    * @return String
    * @access private
    * @author Olivier Mansour
    *
    */
    
    function _getldapLogin ($login) {
        // Ajout Olivier Mansour
        // pour ldap, les logins commencent par uid=
        $ldap_login = $login;
        if (substr($ldap_login,0,4) !=$GLOBALS['ldap_login_attribute']) {
            $ldap_login = $GLOBALS['ldap_login_attribute'].'='.$ldap_login;
        }
        return $ldap_login;
        // fin ajout Olivier Mansour
    } 
    
    // }}}
    
    // {{{ verifyPassword()

    /**
     * This method is used to verify the password of the author in the database
     * @access public
     */

    function verifyPassword($login, $passwd) {
        // ajout Olivier Mansour
        $ldap_login = $this->_getldapLogin ($login);
        // fin ajout Olivier Mansour
        
    	//Set new parameters to bind with the user
    	$myLdapDBParameters = $this->_dbParameters;
    	$myLdapDBParameters->setDbUser($ldap_login.','.$myLdapDBParameters->getDbName());
    	$myLdapDBParameters->setDbPass($passwd);

    	$db = &$this->_getDB($myLdapDBParameters);
		
		if (DB::isError($db)) {
            return false;
    	}
        
		$auteur = $db->getAll($ldap_login);
        
		if (DB::isError($auteur)) {
            return PEAR::raiseError("[".get_class($this)." BD_auteur : verifyPassword()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        
		if(!DB::isError($db)) {
			$this->setAuteurDN($auteur[0]['dn']);
			$this->setLogin($login);
			return true;
		} else {
			return false;
		}
	}

    // }}}

    // {{{ getAuteurInfos()

    /**
     * This method is used to get informations about the author in the database
     * @access public
     */

    function getAuteurInfos($login) {
        // ajout Olivier Mansour 
         $ldap_login = $this->_getldapLogin ($login);
        // fin ajout Olivier Mansour
        
		$db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." BD_auteur : getAuteurInfos()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

		$auteur = $db->getAll($ldap_login);
        if (DB::isError($auteur)) {
            return PEAR::raiseError("[".get_class($this)." BD_auteur : getAuteurInfos()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
		$this->setNom($auteur[0]['cn']);
		$this->setEmail($auteur[0]['mail']);
		$this->setLogin($auteur[0][$GLOBALS['ldap_login_attribute']]);
		$this->setBio($auteur[0]['description']);
	}

    // }}}

    // {{{ create()

    /**
     * This method is used to create a new author in the database
     * @access public
     */

    function create() {
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : create()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        $string_prefix = $GLOBALS['table_prefix']."_auteurs";
        $auteurId = $db->nextId($string_prefix, true);
        if (DB::isError($auteurId)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : create()] ".$auteurId->getMessage()."", null,
                null, null, null, null, false);
        }


        $this->_auteurId = $auteurId;

        $query = "INSERT INTO ".$GLOBALS['table_prefix']."_auteurs (".AUTEUR_ALL_FIELDS.") VALUES "
                ."('".$this->_auteurId."', "
                ."'".$this->_nom."', "
                ."'".$this->_bio."', "
                ."'".$this->_email."', "
                ."'".$this->_nomSite."', "
                ."'".$this->_urlSite."', "
                ."'".$this->_login."', "
                ."'".$this->_pass."', "
                ."'".$this->_statut."', "
                ."'".$this->_maj."', "
                ."'".$this->_pgp."', "
                ."'".$this->_htpass."', "
                ."'".$this->_enLigne."', "
                ."'".$this->_imessage."', "
                ."'".$this->_messagerie."', "
                ."'".$this->_aleaActuel."', "
                ."'".$this->_aleaFutur."', "
                ."'".$this->_prefs."', "
                ."'".$this->_cookieOubli."', "
                ."'".$this->_source."')";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : create()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ delete()

    /**
     * This method is used to delete an author from the database
     * @access  public
     * @param   int $idAuteur id of author to delete
     */

    function delete($auteurId) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : delete()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_auteurs WHERE id_auteur = $auteurId";

         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : delete()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ update()

    /**
     * This method is used to update this author in the database
     * @access public
     */

    function update() {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : update()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $maDate = new Date();
	    $this->setMaj($maDate->getDate(DATE_FORMAT_ISO));

        $query = "UPDATE ".$GLOBALS['table_prefix']."_auteurs "
                ."SET nom = '".$this->_nom."', "
                ."bio = '".$this->_bio."', email = '".$this->_email."', "
                ."nom_site = '".$this->_nomSite."', url_site = '".$this->_urlSite."', "
                ."login = '".$this->_login."', pass = '".$this->_pass."', "
                ."statut = '".$this->_statut."', maj = '".$this->_maj."', "
                ."pgp = '".$this->_pgp."', htpass = '".$this->_htpass."', "
                ."en_ligne = '".$this->_enLigne."', imessage = '".$this->_imessage."', "
                ."messagerie = '".$this->_messagerie."', alea_actuel = '".$this->_aleaActuel."', "
                ."alea_futur = '".$this->_aleaFutur."', prefs = '".$this->_prefs."', "
                ."cookie_oubli = '".$this->_cookieOubli."', source = '".$this->_source."' "
                ."WHERE id_auteur = ".$this->_auteurId;

         

        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : update()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ load()

    /**
     * This method is used to load an author from the database
     * @access  public
     * @param   int $idAuteur id of author to load
     */

    function load($auteurId) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : load()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT".AUTEUR_ALL_FIELDS."FROM ".$GLOBALS['table_prefix']."_auteurs WHERE id_auteur = $auteurId";
         
        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : load()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
            if ($row = $result->fetchRow()) {

                $maDate = new Date($row['maj']);
                $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

                $this->_fetchData($row);
				return 1;
            } else {
                return PEAR::raiseError("[".get_class($this)." DB_auteur : load(".$auteurId.")] Aucun auteur ne correspond pas  cet ID!", null,
                                    null, null, null, null, false);
            }
            $result->free();
        }
    }

    // }}}

    // {{{ _fetchData()

    /**
     * This method is used to fetch result set fields into the object fields
     *
     * @param   $row    resultset row
     * @access  private
     */
    function _fetchData($row) {
        $this->setAuteurId($row['id_auteur']);
        $this->setNom($row['nom']);
        $this->setBio($row['bio']);
        $this->setEmail($row['email']);
        $this->setNomSite($row['nom_site']);
        $this->setUrlSite($row['url_site']);
        $this->setLogin($row['login']);
        $this->setPass($row['pass']);
        $this->setStatut($row['statut']);
        $this->setMaj($row['maj']);
        $this->setPgp($row['pgp']);
        $this->setHtpass($row['htpass']);
        $this->setEnLigne($row['en_ligne']);
        $this->setImessage($row['imessage']);
        $this->setMessagerie($row['messagerie']);
        $this->setAleaActuel($row['alea_actuel']);
        $this->setAleaFutur($row['alea_futur']);
        $this->setPrefs($row['prefs']);
        $this->setCookieOubli($row['cookie_oubli']);
        $this->setSource($row['source']);
    }

    // }}}

    // {{{ deleteMajDate($majDate)

    /**
     * This method is used to delete all authors former to mydate
     * @access  public
     */

    function deleteMajDate($mydate) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : deleteMajDate()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $dateTmp = new Date($mydate);
        $mydate = $dateTmp->getDate(DATE_FORMAT_ISO);

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_auteurs WHERE maj < '$mydate'";
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : deleteMajDate()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ deleteAllAuteurIdsExceptAuteurIds($auteurs)

    function deleteAllAuteurIdsExceptAuteurIds($auteurs)  {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : deleteAllAuteurIdsExceptAuteurIds()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_auteurs_articles WHERE id_auteur NOT IN ($auteurs)";

        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : deleteAllAuteurIdsExceptAuteurIds()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ getAllAuteurId()

    function getAllAuteurId() {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllAuteurId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT id_auteur FROM ".$GLOBALS['table_prefix']."_auteurs";
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllAuteurId()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $result->fetchRow()) {    $auteurs[] = $row['id_auteur'];}
        $result->free();
        return $auteurs;
    }


    // }}}

    // {{{ getHtpassWithLoginExceptStatuts($statut1, $statut2)

    /**
     * Returns an array of htpass.
     *
     *
     * @return an array of htpass
     * @param $statut1
     * @param $statut2
     * @access public
     */

    function getHtpassWithLoginExceptStatuts($statut1, $statut2) {
        $logins = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getHtpassWithLoginExceptStatuts()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT login, htpass FROM ".$GLOBALS['table_prefix']."_auteurs WHERE statut != '$statut1' AND statut!='$statut2'";

        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getHtpassWithLoginExceptStatuts()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $result->fetchRow()) {    $logins[$row['login']] = $row['htpass'];}
        $result->free();
        return $loginss;
    }

    // }}}

    // {{{ getHtpassWithLoginForStatut($statut)

    /**
     * Returns an array of htpass.
     *
     *
     * @return an array of htpass
     * @param $statut1
     * @param $statut2
     * @access public
     */

    function getHtpassWithLoginForStatut($statut) {
        $logins = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getHtpassWithLoginForStatut()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT login, htpass FROM ".$GLOBALS['table_prefix']."_auteurs WHERE statut = '$statut'";

        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getHtpassWithLoginForStatut()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $result->fetchRow()) {    $logins[$row['login']] = $row['htpass'];}
        $result->free();
        return $loginss;
    }

    // }}}

    // {{{ getAllForLoginAndSource($login, $source)

    /**
     * Returns an array of Autors.
     *
     *
     * @return an array of Autors
     * @param $login
     * @param $source
     * @access public
     */

    function &getAllForLoginAndSource($login, $source) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllForLoginAndSource()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT ".AUTEUR_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_auteurs WHERE login='$login' AND source='$source'";

        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllForLoginAndSource()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultAuteur = &BD_auteur::factory($this->getDbParameters());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultAuteur->_fetchData($row);
            $result[] = &$resultAuteur;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ getAllForLogin($login)

    /**
     * Returns an array of Autors.
     *
     *
     * @return an array of Autors
     * @param $login
     * @access public
     */

    function &getAllForLogin($login) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllForLogin()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT ".AUTEUR_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_auteurs WHERE login='$login'";

        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllForLogin()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultAuteur = &BD_auteur::factory($this->getDbParameters());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultAuteur->_fetchData($row);
            $result[] = &$resultAuteur;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ getAllForLoginExceptStatuts($login, $statut1, $statut2)

    /**
     * Returns an array of Autors.
     *
     *
     * @return an array of Autors
     * @param $login
     * @param $statut1
     * @param $statut2
     * @access public
     */

    function &getAllForLoginExceptStatuts($login, $statut1, $statut2) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllForLoginExceptStatuts()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT ".AUTEUR_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_auteurs WHERE login='$login' AND statut!='$statut1' AND statut!='$statut2'";

        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllForLoginExceptStatuts()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultAuteur = &BD_auteur::factory($this->getDbParameters());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultAuteur->_fetchData($row);
            $result[] = &$resultAuteur;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ getAllForLoginandPassAndSourceExceptStatut($login, $pass, $source, $statut)

    /**
     * Returns an array of Autors.
     *
     *
     * @return an array of Autors
     * @param $login
     * @param $pass
     * @param $source
     * @param $statut
     * @access public
     */

    function &getAllForLoginAndPassAndSourceExceptStatut($login, $pass, $source, $statut) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllForLoginAndPassAndSourceExceptStatut()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT ".AUTEUR_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_auteurs WHERE login='".addslashes($login)."' AND pass='".addslashes($pass)."' AND statut<>'$statut' AND source='$source'";

        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllForLoginAndPassAndSourceExceptStatut()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultAuteur = &BD_auteur::factory($this->getDbParameters());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultAuteur->_fetchData($row);
            $result[] = &$resultAuteur;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ getAllExceptMessagerieAndAuteurIdAndPassAndLogin($messagerie, $auteurId, $pass , $login)

    /**
     * Returns an array of Autors.
     *
     *
     * @return an array of Autors
     * @param $messagerie
     * @param $auteurId
     * @param $pass
     * @param $login
     * @access public
     */

    function &getAllExceptMessagerieAndAuteurIdAndPassAndLogin($messagerie, $auteurId, $pass , $login) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllExceptMessagerieAndAuteurIdAndPassAndLogin()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT ".AUTEUR_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_auteurs WHERE messagerie<>'$messagerie' AND id_auteur<>'$auteurId' AND pass<>'$pass' AND login<>'$login'";

        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllExceptMessagerieAndAuteurIdAndPassAndLogin()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultAuteur = &BD_auteur::factory($this->getDbParameters());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultAuteur->_fetchData($row);
            $result[] = &$resultAuteur;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ getAllForEmail($email)

    /**
     * Returns an array of Autors.
     *
     *
     * @return an array of Autors
     * @param $email
     * @access public
     */

    function &getAllForEmail($email) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllForEmail()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT ".AUTEUR_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_auteurs WHERE email='$email'";

        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllForEmail()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultAuteur = &BD_auteur::factory($this->getDbParameters());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultAuteur->_fetchData($row);
            $result[] = &$resultAuteur;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ getAllForStatut($statut)

    /**
     * Returns an array of Autors.
     *
     *
     * @return an array of Autors
     * @param $statut
     * @access public
     */

    function &getAllForStatut($statut) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllForStatut()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT ".AUTEUR_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_auteurs WHERE statut='$statut'";

        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllForStatut()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultAuteur = &BD_auteur::factory($this->getDbParameters());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultAuteur->_fetchData($row);
            $result[] = &$resultAuteur;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ getAllForStatutAndMaj($statut, $myDate)

    /**
     * Returns an array of Autors.
     *
     *
     * @return an array of Autors
     * @param $statut
     * @param $myDate
     * @access public
     */

    function &getAllForStatutAndMaj($statut, $myDate) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllForStatutAndMaj()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $dateTmp = new Date($myDate);
        $myDate = $dateTmp->getDate(DATE_FORMAT_ISO);

        $query = "SELECT ".AUTEUR_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_auteurs WHERE statut='$statut' AND maj < '$mydate'";
        //$query = "SELECT ".AUTEUR_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_auteurs WHERE statut='$statut' AND maj < $mydate";

        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllForStatutAndMaj()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultAuteur = &BD_auteur::factory($this->getDbParameters());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultAuteur->_fetchData($row);
            $result[] = &$resultAuteur;
        }
        $queryResult->free();
        return $result;
    }

    // }}}


    // {{{ getAllForLoginAndNotStatut($login, $statut)

    /**
     * Returns an array of Autors.
     *
     *
     * @return an array of Autors
     * @param $login
     * @param $statut
     * @access public
     */

    function &getAllForLoginAndNotStatut($login, $statut) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllForLoginAndNotStatut()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT ".AUTEUR_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_auteurs WHERE login='$login' AND statut!='$statut'";

        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllForLoginAndNotStatut()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultAuteur = &BD_auteur::factory($this->getDbParameters());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultAuteur->_fetchData($row);
            $result[] = &$resultAuteur;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ getAllForCookieOubliAndNotStatutAndNotPass($p, '5poubelle', "")

    /**
     * Returns an array of Autors.
     *
     *
     * @return an array of Autors
     * @param $login
     * @param $statut
     * @access public
     */

    function &getAllForCookieOubliAndNotStatutAndNotPass($cookieOubli, $statut, $pass)  {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllForCookieOubliAndNotStatutAndNotPass()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT ".AUTEUR_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_auteurs WHERE cookie_oubli='$cookieOublie' AND statut!='$statut' AND pass!='$pass'";

        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllForCookieOubliAndNotStatutAndNotPass()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultAuteur = &BD_auteur::factory($this->getDbParameters());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultAuteur->_fetchData($row);
            $result[] = &$resultAuteur;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ getAllForRubriqueIds($rubriques)

    /**
     * Returns an array of Breve.
     *
     *
     * @return Array of Breve
     * @param $rubriques
     * @access public
     */

    function &getAllForArticleIds($articles) {
        $auteurs = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllForArticleIds()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT DISTINCT ".$GLOBALS['table_prefix']."_auteurs.id_auteur, maj FROM ".$GLOBALS['table_prefix']."_auteurs, ".$GLOBALS['table_prefix']."_auteurs_articles AS lien WHERE id_article IN ($articles) AND ".$GLOBALS['table_prefix']."_auteurs.id_auteur=lien.id_auteur";

        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllForArticleIds()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

    while ($row = $queryResult->fetchRow()) {
        $resultAuteur = &BD_auteur::factory($this->getDbParameters());

        $maDate = new Date($row['maj']);
        $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

        $resultAuteur->_fetchData($row);
        $auteurs[] = &$resultAuteur;
    }
    $queryResult->free();
    return $auteurs;
    }

    // }}}

    // {{{ getAllForArticleId($articleId)

    /**
     * Returns an array of Autors.
     *
     *
     * @return an array of Autors
     * @param $articleId
     * @access public
     */

    function &getAllForArticleId($articleId) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllForArticleId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT auteurs.id_auteur, nom, bio, email, nom_site, url_site, login, pass, statut, maj, pgp, htpass, en_ligne ,imessage,messagerie,alea_actuel,alea_futur,prefs,cookie_oubli,source  FROM ".$GLOBALS['table_prefix']."_auteurs AS auteurs, ".$GLOBALS['table_prefix']."_auteurs_articles AS lien WHERE lien.id_article=$articleId AND auteurs.id_auteur=lien.id_auteur";
//echo $query;
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllForArticleId()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultAuteur = &BD_auteur::factory($this->getDbParameters());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultAuteur->_fetchData($row);
            $result[] = &$resultAuteur;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ getAllForMessageId($messageId)

    /**
     * Returns an array of Autors.
     *
     *
     * @return an array of Autors
     * @param $messageId
     * @access public
     */

    function &getAllForMessageId($messageId) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllForMessageId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT auteurs.* FROM ".$GLOBALS['table_prefix']."_auteurs AS auteurs, ".$GLOBALS['table_prefix']."_auteurs_messages AS lien WHERE lien.id_message=$messageId AND lien.id_auteur=auteurs.id_auteur";

        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllForMessageId()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultAuteur = &BD_auteur::factory($this->getDbParameters());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultAuteur->_fetchData($row);
            $result[] = &$resultAuteur;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ getAllForMessageIdExceptAuteurId($messageId, $auteurId)

    /**
     * Returns an array of Autors.
     *
     *
     * @return an array of Autors
     * @param $messageId
     * @param $auteurId
     * @access public
     */

    function &getAllForMessageIdExceptAuteurId($messageId, $auteurId) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllForMessageIdExceptAuteurId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT auteurs.nom FROM ".$GLOBALS['table_prefix']."_auteurs AS auteurs, ".$GLOBALS['table_prefix']."_auteurs_messages AS lien WHERE lien.id_message=$messageId AND lien.id_auteur!=$auteurId AND lien.id_auteur=auteurs.id_auteur";

        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllForMessageIdExceptAuteurId()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultAuteur = &BD_auteur::factory($this->getDbParameters());
            $resultAuteur->_fetchData($row);
            $result[] = &$resultAuteur;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ getAllForAuteurIds($les_auteurs, $critere)

    /**
     * Returns an array of Autors.
     *
     *
     * @return an array of Autors
     * @param $les_auteurs
     * @param $critere
     * @access public
     */

    function &getAllForAuteurIds($les_auteurs, $critere) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllForAuteurIds()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT ".AUTEUR_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_auteurs WHERE id_auteur IN ($les_auteurs) ORDER BY $critere";


        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllForAuteurIds()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultAuteur = &BD_auteur::factory($this->getDbParameters());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultAuteur->_fetchData($row);
            $result[] = &$resultAuteur;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ getAllParticipants($ze_auteurs, $les_auteurs)

    /**
     * Returns an array of Autors.
     *
     *
     * @return an array of Autors
     * @param $les_auteurs
     * @param $critere
     * @access public
     */

    function &getAllParticipants($ze_auteurs, $les_auteurs) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllParticipants()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        /*
        $query = "SELECT ".AUTEUR_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_auteurs WHERE ";
		if ($les_auteurs) $query .= "id_auteur NOT IN ($ze_auteurs) AND ";
		$query .= " messagerie<>'non' AND statut IN ('minirezo', '1comite') ORDER BY statut, nom";
        */
        $profilMetier = &recuperer_instance_profil();
        $allProfils = $profilMetier->getAllProfils();
        while (list (,$monProfil) = each($allProfils)) {
            $poids[] = $monProfil->getPoids();

        }

        $query = "SELECT ".AUTEUR_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_auteurs WHERE ";
		if ($les_auteurs) $query .= "id_auteur NOT IN ($ze_auteurs) AND ";
		$query .= " messagerie<>'non' AND profil IN (" . join(",", $poids) . ") ORDER BY profil, nom";

        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllParticipants()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultAuteur = &BD_auteur::factory($this->getDbParameters());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultAuteur->_fetchData($row);
            $result[] = &$resultAuteur;
        }
        $queryResult->free();
        return $result;
    }

    // }}}


    // {{{ getAllExceptAuteurIdsAndStatuts($lesAuteurs)

    /**
     * Returns an array of Autors.
     *
     *
     * @return an array of Autors
     * @param $lesAuteurs
     * @access public
     */

    function &getAllExceptAuteurIdsAndStatuts($lesAuteurs) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllExceptAuteurIdsAndStatuts()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT ".AUTEUR_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_auteurs WHERE ";
	    if ($lesAuteurs) $query .= "id_auteur NOT IN ($lesAuteurs) AND ";
	    $query .= "statut<>'5poubelle' AND statut<>'nouveau' ORDER BY statut, nom";

        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllExceptAuteurIdsAndStatuts()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultAuteur = &BD_auteur::factory($this->getDbParameters());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultAuteur->_fetchData($row);
            $result[] = &$resultAuteur;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ getAllAuteurs()

    /**
     * Returns an array of Autors.
     *
     *
     * @return an array of Autors
     * @access public
     */

    function &getAllAuteurs() {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllAuteurs()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT ".AUTEUR_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_auteurs";

        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllAuteurs()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultAuteur = &BD_auteur::factory($this->getDbParameters());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultAuteur->_fetchData($row);
            $result[] = &$resultAuteur;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ updateHtPassAndPassAndAleaActuelAndCookieOubliForCookieOubli($htpass, $pass, $aleaActuel, $newCookieOubli , $cookieOubli)

    /**
     * Update HTpass Pass AleaActuel and cookieOublie fro CookieOublie.
     *
     *
     * @return an array of Autors
     * @param $htpass
     * @param $mdpass
     * @param $aleaActuel
     * @param $newCookieOubli
     * @param $cookieOubli
     * @access public
     */

    function updateHtPassAndPassAndAleaActuelAndCookieOubliForCookieOubli($htpass, $pass, $aleaActuel, $newCookieOubli , $cookieOubli) {

        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : updateHtPassAndPassAndAleaActuelAndCookieOubliForCookieOubli()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "UPDATE ".$GLOBALS['table_prefix']."_auteurs SET htpass='$htpass', pass='$pass', alea_actuel='$aleaActuel', cookie_oubli='$newCookieOubli' WHERE cookie_oubli='$cookieOubli'";

         

        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : updateHtPassAndPassAndAleaActuelAndCookieOubliForCookieOubli()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ updateCookieOubliForEmail($cookie, $email)

    /**
     * Update CookieOublie for email.
     *
     *
     * @return an array of Autors
     * @param $Cookie
     * @param $email
     * @access public
     */

    function updateCookieOubliForEmail($cookie, $email) {

        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : updateCookieOubliForEmail()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "UPDATE ".$GLOBALS['table_prefix']."_auteurs SET cookie_oubli = '$cookie' WHERE email ='$email'";

         

        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : updateCookieOubliForEmail()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ updateStatutForLogin($statut, $login)

    /**
     * Update Statut for login.
     *
     *
     * @update Statut
     * @param $statut
     * @param $login
     * @access public
     */

    function updateStatutForLogin($statut, $login) {

        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : updateStatutForLogin()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "UPDATE ".$GLOBALS['table_prefix']."_auteurs SET statut='$statut' WHERE login='$login'";

         

        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : updateStatutForLogin()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ updateProfilForLogin($profil, $login)

    /**
     * Update profil for login.
     *
     *
     * @update profil
     * @param $profil
     * @param $login
     * @access public
     */

    function updateProfilForLogin($profil, $login) {

        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : updateProfilForLogin()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "UPDATE ".$GLOBALS['table_prefix']."_auteurs SET profil='$profil' WHERE login='$login'";

         

        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : updateProfilForLogin()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ updatePassAndAleaFuturForLogin($pass, $aleaFutur, $login)

    /**
     * Update Pass and Alea for login.
     *
     *
     * @update Pass and Alea Futeur
     * @param $pass
     * @param $aleaFutur
     * @param $login
     * @access public
     */

    function updatePassAndAleaFuturForLogin($pass, $aleaFutur, $login) {

        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : updatePassAndAleaFuturForLogin()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "UPDATE ".$GLOBALS['table_prefix']."_auteurs SET alea_actuel = alea_futur, ".
				"pass = '$pass', alea_futur = '$aleaFutur' ".
				"WHERE login='$login'";



         

        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : updatePassAndAleaFuturForLogin()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ getAllInfosForDisplay($visiteurs, $connect_statut, &$tri, &$auteurs, &$nombre_auteurs)

    /**
     * get All infos for display list of writters.
     *
     *
     * @return tri, auteurs and nombre_auteurs
     * @param $visiteur
     * @param $connect_statut
     * @param $tri
     * @param $auteurs
     * @param $nombre_auteurs

     * @access public
     */

    function getAllInfosForDisplay($visiteurs, $connect_statut, &$tri, &$auteurs, &$nombre_auteurs)   {

        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllInfosForDisplay()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        //
        // Construire la requete
        //

        // limiter les statuts affiches
        /********Modification Authorization elebescond@clever-age.com***************************/
        $authorization = &recuperer_instance_authorization('afficherAuteursVisiteurs', $GLOBALS['connect_id_auteur'], array('visiteurs' => $visiteurs));
		if($authorization->isAuthorizedAction()) {
            $sql_statut_auteurs = " AND auteurs.statut like 'forum' OR auteurs.profil IN (0)";
            //$sql_statut_auteurs = " AND auteurs.profil IN ('forum', 0)";
    	    $sql_statut_articles = '';
    	    $tri = 'nom';
        } else {
        	$authorization = &recuperer_instance_authorization('afficherAuteurs', $GLOBALS['connect_id_auteur']);
        	if($authorization->isAuthorizedAction()) {
        		$sql_statut_auteurs = " AND auteurs.profil IN (8, 4, 2, 1)";
    	    	$sql_statut_articles = " AND articles.statut IN ('prop', 'publie')";
        	}    	    
        	else {
        		$sql_statut_auteurs = " AND auteurs.profil IN (8, 4, 2, 1, 0)";
    	    	$sql_statut_articles = "";
        	}
		}
        /*
        if (($visiteurs == "oui") AND ($connect_statut == 'minirezo')) {
    	    $sql_statut_auteurs = " AND auteurs.statut IN ('6forum', '5poubelle')";
    	    $sql_statut_articles = '';
    	    $tri = 'nom';
        } else if ($connect_statut != 'minirezo') {
        	$sql_statut_auteurs = " AND auteurs.statut IN ('minirezo', '1comite')";
    	    $sql_statut_articles = " AND articles.statut IN ('prop', 'publie')";
        } else {
        	$sql_statut_auteurs = " AND auteurs.statut IN ('minirezo', '1comite', '5poubelle')";
    	    $sql_statut_articles = "";
        }
        */
        /*****************FIN modif authorization***********************************************/

        // tri
        switch ($tri) {
        case 'nombre':
    	    $sql_order = ' ORDER BY compteur DESC, unom';
    	    $type_requete = 'nombre';
    	    break;

        case 'statut':
    	    $sql_order = ' ORDER BY auteurs.statut, unom';
    	    $type_requete = 'auteur';
	        break;

        case 'nom':
        default:
    	    $sql_order = ' ORDER BY unom';
	        $type_requete = 'auteur';
        }


        // si on doit afficher les auteurs par statut ou par nom,
        // la requete principale est simple, et une autre requete
        // vient calculer les nombres d'articles publies ;
        // si en revanche on doit classer par nombre, la bonne requete
        // est la concatenation de $query_nombres et de $query_auteurs


        $auteurs = Array();

        if ($type_requete == 'auteur') {

            $query = "SELECT *, UPPER(nom) AS unom FROM ".$GLOBALS['table_prefix']."_auteurs AS auteurs WHERE 1 $sql_statut_auteurs	$sql_order";

            $queryResult = $db->query($query);

            if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllInfosForDisplay()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
            }
            while ($row = $queryResult->fetchRow()) {
        		$auteurs[$row['id_auteur']] = $row;
	    	    $nombre_auteurs ++;

		        $nom_auteur = $row['nom'];
		        $premiere_lettre = addslashes(strtoupper(substr($nom_auteur,0,1)));
		        if ($premiere_lettre != $lettre_prec) {
        			$lettre[$premiere_lettre] = $nombre_auteurs;
		        }
		        $lettre_prec = $premiere_lettre;
	        }
        $queryResult->free();


        $query = "SELECT auteurs.id_auteur, UPPER(auteurs.nom) AS unom, COUNT(articles.id_article) AS compteur
		    FROM ".$GLOBALS['table_prefix']."_auteurs AS auteurs, ".$GLOBALS['table_prefix']."_auteurs_articles AS lien, ".$GLOBALS['table_prefix']."_articles AS articles
		    WHERE auteurs.id_auteur=lien.id_auteur AND lien.id_article=articles.id_article
		    $sql_statut_auteurs $sql_statut_articles
		    GROUP BY auteurs.id_auteur
		    $sql_order";

        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllInfosForDisplay()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $queryResult->fetchRow())
		    $auteurs[$row['id_auteur']]['compteur'] = $row['compteur'];

        $queryResult->free();

    	// si on n'est pas minirezo, supprimer les auteurs sans article publie
    	// sauf les admins, toujours visibles.
    	/********Modification Authorization elebescond@clever-age.com***************************/
    	$authorization = &recuperer_instance_authorization('afficherNombreArticle', $GLOBALS['connect_id_auteur']);
		if(!$authorization->isAuthorizedAction()) {
    	/*
    	if ($connect_statut != 'minirezo') {
        */
        /*****************FIN modif authorization***********************************************/
            /*
		    reset($auteurs);
		    $profilMetier = &recuperer_instance_profil();
            $monProfil = $profilMetier->getProfilForIntitule('item_webmestre');
            if(PEAR::isError($monProfil)) {
                die($monProfil->getMessage());
            }

		    while (list(,$auteur) = each ($auteurs)) {
		        if (! $auteur['compteur'] AND ($auteur['profil'] < $monProfil->getPoids())) {
                //if (! $auteur['compteur'] AND ($auteur['profil'] != 'minirezo')) {
				    unset($auteurs[$auteur['id_auteur']]);
				    $nombre_auteurs --;
			    }
		    }
		    */
	    }

        } else { // tri par nombre
	        /*
	        $query = "SELECT auteurs.*, UPPER(nom) AS unom, COUNT(articles.id_article) AS compteur
    		    FROM ".$GLOBALS['table_prefix']."_auteurs auteurs, ".$GLOBALS['table_prefix']."_auteurs_articles lien, ".$GLOBALS['table_prefix']."_articles articles
		        WHERE auteurs.id_auteur=lien.id_auteur AND lien.id_article=articles.id_article
		        $sql_statut_auteurs $sql_statut_articles
		        GROUP BY auteurs.id_auteur
		        $sql_order";
		    */

		    $profilMetier = &recuperer_instance_profil();
		    $allProfils = $profilmetier->getAllProfils();
		    if(PEAR::isError($allProfils)) {
		        die($allProfils->getMessage());
		    }

		    while(list(, $monProfil) = each($allProfils)) {
                $poids[] = $monProfil->getPoids();
            }

		    $query = "SELECT auteurs.id_auteur, auteurs.nom, auteurs.url_site, auteurs.email, auteurs.statut, auteurs.profil,  COUNT(articles.id_article) AS compteur FROM ".$GLOBALS['table_prefix']."_auteurs auteurs, ".$GLOBALS['table_prefix']."_auteurs_articles lien, ".$GLOBALS['table_prefix']."_articles articles WHERE auteurs.id_auteur=lien.id_auteur AND lien.id_article=articles.id_article AND auteurs.statut IN (" . join(",", $poids) . ") GROUP BY auteurs.id_auteur, auteurs.nom, auteurs.url_site, auteurs.email, auteurs.statut ORDER BY compteur DESC, auteurs.nom ASC";
		    //$query = "SELECT auteurs.id_auteur, auteurs.nom, auteurs.url_site, auteurs.email, auteurs.statut, auteurs.profil,  COUNT(articles.id_article) AS compteur FROM ".$GLOBALS['table_prefix']."_auteurs auteurs, ".$GLOBALS['table_prefix']."_auteurs_articles lien, ".$GLOBALS['table_prefix']."_articles articles WHERE auteurs.id_auteur=lien.id_auteur AND lien.id_article=articles.id_article AND auteurs.statut IN ('minirezo', 'comite', '5poubelle') GROUP BY auteurs.id_auteur, auteurs.nom, auteurs.url_site, auteurs.email, auteurs.statut ORDER BY compteur DESC, auteurs.nom ASC";
		    //echo "<br>$query<br>";
            $queryResult = $db->query($query);

            if (DB::isError($queryResult)) {
                return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllInfosForDisplay()] ".$queryResult->getMessage()."", null,
                  null, null, null, null, false);
            }
            unset($vus);
            while ($row = $queryResult->fetchRow()) {
    	    	$auteurs[$row['id_auteur']] = $row;
		        $vus .= ','.$row['id_auteur'];
		        $nombre_auteurs ++;
    	    }
            
            $queryResult->free();
    	    	    
	        // si on est admin, ajouter tous les auteurs sans articles
	        // sinon ajouter seulement les admins sans articles
    	    /********Modification Authorization elebescond@clever-age.com***************************/
			$authorization = &recuperer_instance_authorization('afficherNombreArticle', $GLOBALS['connect_id_auteur']);
			if($authorization->isAuthorizedAction())
    	    /*
        	    if ($connect_statut == 'minirezo')
            */
            /*****************FIN modif authorization***********************************************/
	            $sql_statut_auteurs_ajout = $sql_statut_auteurs;
	        else {
        	    $profilMetier = &recuperer_instance_profil();
        	    $monProfil8 = $profilMetier->getProfilForIntitule('item_administrateur');
        	    $monProfil4 = $profilMetier->getProfilForIntitule('item_webmestre');
        		$sql_statut_auteurs_ajout = " AND auteurs.profil IN (".$monProfil->getPoids().",".$monProfil4->getPoids().")";
        		//$sql_statut_auteurs_ajout = " AND auteurs.statut = 'minirezo'";
            }
        
    	    $query = "SELECT auteurs.*, UPPER(nom), 0 as compteur
    		    FROM ".$GLOBALS['table_prefix']."_auteurs auteurs
		        WHERE id_auteur NOT IN (0$vus)
		        $sql_statut_auteurs_ajout
		        $sql_order";
            //echo $query;
            $queryResult = $db->query($query);

            if (DB::isError($queryResult)) {
                return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllInfosForDisplay()] ".$queryResult->getMessage()."", null,
                    null, null, null, null, false);
            }
            
            while ($row = $queryResult->fetchRow()) {
        		$auteurs[$row['id_auteur']] = $row;
		        $nombre_auteurs ++;
	        }
    	    
	        $queryResult->free();
        }
        
        
        unset ($rub_restreinte);
        /********Modification Authorization elebescond@clever-age.com***************************/
    	$authorization = &recuperer_instance_authorization('afficherAdminRestreint', $GLOBALS['connect_id_auteur']);
		if($authorization->isAuthorizedAction()) { // recuperer les admins restreints
    	/*
        if ($connect_statut == 'minirezo') { // recuperer les admins restreints
        */
        /*****************FIN modif authorization***********************************************/
            //-----------Zone de modification Clever Age elebescond----
            $rubriqueMetier = &recuperer_instance_rubrique();
            $rub_restreinte = $rubriqueMetier->getAllAuteurRubrique();
            if(PEAR::isError($rub_restreinte)) {
                die($rub_restreinte->getMessage());
            }
            /*
            $restreint = ".$GLOBALS['table_prefix']."_query("SELECT * FROM ".$GLOBALS['table_prefix']."_auteurs_rubriques");
            while ($row = ".$GLOBALS['table_prefix']."_fetch_array($restreint))
        	    $rub_restreinte[$row['id_auteur']] .= ','.$row['id_rubrique'];
            */
            //--------Fin de zone de modification----------------------	    	    
        }

    }

    // }}}


    /**
     * Returns an array of Autors.
     *
     *
     * @return an array of Autors
     * @param $email
     * @access public
     */

    function &getAllForLoginAndNotAuteurIdAndNotStatut($login, $id_auteur, $statut) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllForLoginAndNotAuteurIdAndNotStatut()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT ".AUTEUR_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_auteurs WHERE login='".addslashes($login)."' AND id_auteur!=$id_auteur AND statut!='$statut'";

        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllForLoginAndNotAuteurIdAndNotStatut()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultAuteur = &BD_auteur::factory($this->getDbParameters());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultAuteur->_fetchData($row);
            $result[] = &$resultAuteur;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ createIgnore()

    function createIgnore() {
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : createIgnore()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        
        $string_prefix = $GLOBALS['table_prefix']."_auteurs";
        $auteurId = $db->nextId($string_prefix, true);

        if (DB::isError($auteurId)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : createIgnore()] ".$auteurId->getMessage()."", null,
                null, null, null, null, false);
        }

        $this->_auteurId = $auteurId;


        $query = "SELECT id_auteur FROM ".$GLOBALS['table_prefix']."_auteurs WHERE id_auteur='".$this->_auteurId."'";
         
        $result = $db->getOne($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : createIgnore()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

        if($result->numRows() == 0) {
            $query = "INSERT INTO ".$GLOBALS['table_prefix']."_auteurs (".AUTEUR_ALL_FIELDS.") VALUES "
                ."('".$this->_auteurId."', "
                ."'".$this->_nom."', "
                ."'".$this->_bio."', "
                ."'".$this->_email."', "
                ."'".$this->_nomSite."', "
                ."'".$this->_urlSite."', "
                ."'".$this->_login."', "
                ."'".$this->_pass."', "
                ."'".$this->_statut."', "
                ."'".$this->_maj."', "
                ."'".$this->_pgp."', "
                ."'".$this->_htpass."', "
                ."'".$this->_enLigne."', "
                ."'".$this->_imessage."', "
                ."'".$this->_messagerie."', "
                ."'".$this->_aleaActuel."', "
                ."'".$this->_aleaFutur."', "
                ."'".$this->_prefs."', "
                ."'".$this->_cookieOubli."', "
                ."'".$this->_source."')";

        	echo "<br><br>".$query."<br><br>";
             

            $result = $db->query($query);
            if (DB::isError($result)) {
                return PEAR::raiseError("[".get_class($this)." DB_auteur : createIgnore()] ".$result->getMessage()."", null,
                    null, null, null, null, false);
            }
        }
    }

    // }}}

    // {{{ getAllConnections($auteurId)

    /**
     * This method returns all Connections
     * @param auteurId
     * @return  int
     * @access  public
     */
    function &getAllConnections($auteurId) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllConnections()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $maDate = new Date();
        $maDate->subtractSeconds(intval(5*60));

        $query = "SELECT ".AUTEUR_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_auteurs WHERE id_auteur!=$auteurId AND imessage!='non' AND messagerie!='non' AND en_ligne>'" . $maDate->getDate(DATE_FORMAT_ISO) . "'";

        //$query = "SELECT id_auteur, nom FROM ".$GLOBALS['table_prefix']."_auteurs WHERE id_auteur!=$auteurId AND imessage!='non' AND messagerie!='non' AND en_ligne>DATE_SUB(NOW(),INTERVAL 5 MINUTE)";

        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllConnections()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultAuteur = &BD_auteur::factory($this->getDbParameters());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultAuteur->_fetchData($row);
            $result[] = &$resultAuteur;
        }
        $queryResult->free();
        return $result;
    }

    // }}}
}
?>