<?php

// $Id$

require_once (dirname(__FILE__)."/metier.php");
require_once (dirname(__FILE__)."/../../inc_meta.php3");

/**
 * BD_mapping is a base class for mapping and article relation managements.
 * @package	BD
 * @author	Guillaume Grason <guillaume.grason@diplomatie.gouv.fr>
 * @access	public
 */
 
 // $Id$

class BD_mapping  extends BD_metier {

    // {{{ properties


    /**
     * Parameters instance used for PEAR::DB factory and
     * Metier subclasses factories.
     *
     * @access private
     */
    var $_dbParameters;

    /**
     * DB options array used for PEAR::DB options.
     *
     * @access private
     */
    var $_dbOptions = false;

    /**
     * Article ID.
     * @var     int
     * @access  private
     */
    var $_articleId;

    /**
     * Mapping ID.
     * @var     String
     * @access  private
     */
    var $_mappingId;

    // {{{ factory()

    /**
     * This method is a factory static method. It should be used to get any
     * specific implementation instace of Article business data type.
     * @param   BD_parameters DB connection parameters
     * @access public
     */
    function &factory($dbParameters, $dbOptions = null) {

        if(file_exists(dirname(__FILE__)."/".$dbParameters->_dbEngine."/mapping_".$dbParameters->_dbEngine.".php") == false) {
            include_once(dirname(__FILE__)."/common/mapping_common.php");
            $classname = "BD_mapping_common";
        }
        else {
            include_once(dirname(__FILE__)."/".$dbParameters->_dbEngine."/mapping_".$dbParameters->_dbEngine.".php");
            $classname = "BD_mapping_".$dbParameters->_dbEngine;
        }

        if (!class_exists($classname)) {
            return PEAR::raiseError("Cannot instanciate class $classname", null,
                null, null, null, null, false);
        }

        $obj =& new $classname;
        $result = $obj->setDbParameters($dbParameters);
        if ($dbOptions != null) {
            $obj->setDbOptions($dbOptions);
        }
        if (PEAR::isError($result)) {
            return $result;
        } else {
            return $obj;
        }
    }

    // }}}

    // {{{ constructor

    /**
     * DB_article constructor.
     *
     * @access public
     */

    function BD_mapping() {
    }

    // }}}


	// {{{ getArticleId()

    function getArticleId() {
        return $this->_articleId;
    }

    // }}}

    // {{{ setArticleId()

    function setArticleId($articleId) {
        $this->_articleId = $articleId;
    }

    // }}}

    // {{{ getMappingId()

    function getMappingId() {
        return $this->_mappingId;
    }

    // }}}

    // {{{ setMappingId()

    function setMappingId($mappingId) {
         $this->_mappingId = $mappingId;
    }

    // }}}

    // {{{ _fetchData()

    /**
     * This method is used to fetch result set fields into the object fields
     * @access  private
     * @param   int $idArticle id of article to load
     */

    function _fetchData($row) {
        $this->setArticleId($row['id_article']);
        $this->setMappingId($row['id_map']);
        
    }

    // }}}

    // {{{ createEntry()

    /**
     * This method is used to create an entry in the database
     * @access public
     */

    function createEntry($articleId, $mappingId) {
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_mapping : createEntry()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        
        $string_prefix = $GLOBALS['table_prefix']."_articles_mapping";
        $Id = $db->nextId($string_prefix, true);
        
		$query = "INSERT INTO ".$GLOBALS['table_prefix']."_articles_mapping (id, id_map, id_article) VALUES ($Id, '$mappingId', '$articleId')";
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_mapping : createEntry()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ deleteEntryByArticleIdAndMappingId()

    /**
     * This method is used to delete an entry from the database
     * @access public
     */

    function deleteEntryByArticleIdAndMappingId($articleId, $mappingId) {
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_mapping : deleteEntryByArticleIdAndMappingId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
		$query = "DELETE FROM ".$GLOBALS['table_prefix']."_articles_mapping WHERE id_map = '$mappingId' AND id_article = '$articleId'";
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_mapping : deleteEntryByArticleIdAndMappingId()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ deleteEntryByArticleId()

    /**
     * This method is used to delete multiples entries from the database
     * @access public
     */

    function deleteEntryByArticleId($articleId) {
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_mapping : deleteEntryByArticleId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
		$query = "DELETE FROM ".$GLOBALS['table_prefix']."_articles_mapping id_article = '$articleId'";
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_mapping : deleteEntryByArticleId()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ getMappings()

    /**
     * This method is used to list entries from the database corresponding to an article ID
     * @access public
     */

    function getMappings($articleId) {
		$mappings = array();
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_mapping : getMappings()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

		$query = "SELECT id_map, id_article FROM ".$GLOBALS['table_prefix']."_articles_mapping WHERE id_article=".$articleId;
        $queryResult = $db->query($query);

		if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_mapping : getMappings()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $queryResult->fetchRow()) {
			$this->_fetchData($row);
			$mappings[] = $this->getMappingId();
        }
        $queryResult->free();
        return $mappings;
    }

    // }}}

    // {{{ loadArticle()

    /**
     * This method is used to find the parent of a mapping from the database
     * @access public
     */

    function loadArticle($mappingId) {
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_mapping : loadArticle()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

		$query = "SELECT id_map, id_article FROM ".$GLOBALS['table_prefix']."_articles_mapping WHERE id_map=".$mappingId;
        $queryResult = $db->query($query);

		if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_mapping : loadArticle()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

        $row = $queryResult->fetchRow();
		$this->_fetchData($row);
		return $this->getArticleId();
    }

    // }}}

}

?>