<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Erwan LE BESCOND <elebescond@clever-age.com>                 |
// +----------------------------------------------------------------------+
//
// Base class for Message business persistence abstraction.
//

// $Id$

require_once ("PEAR.php");
require_once ("DB.php");

require_once (dirname(__FILE__)."/metier.php");

define("MESSAGE_ALL_FIELDS", " id_message, titre, texte, type, date_heure, rv, statut, id_auteur, maj, date_fin ");

/**
 * BD_message is a base class for message business persistence abstraction implementations, and must be
 * inherited by all such.
 * @package	BD
 * @author  Antoine Ang�nieux <aangenieux@clever-age.com>
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @access	public
 *
 */
class BD_message extends BD_metier {

    // {{{ properties

    /**
     * Message ID.
     * @var     int
     * @access  private
     */
    var $_messageId;

    /**
     * Title.
     * @var     String
     * @access  private
     */
    var $_titre;

    /**
     * Text.
     * @var     String
     * @access  private
     */
    var $_texte;

    /**
     * Type.
     * @var     String
     * @access  private
     */
    var $_type;

    /**
     * Date_heure.
     * @var     Date
     * @access  private
     */
    var $_dateHeure;

    /**
     * rv.
     * @var     String
     * @access  private
     */
    var $_rv;

    /**
     * State.
     * @var     String
     * @access  private
     */
    var $_statut;

    /**
     * Autor Id.
     * @var     int
     * @access  private
     */
    var $_auteurId;

    /**
     * Update Date.
     * @var     Date
     * @access  private
     */
    var $_majDate;

    /**
     * End Date.
     * @var     Date
     * @access  private
     */
    var $_finDate;

    // }}}

    // {{{ factory()
    function &factory($dbParameters = null, $dbOptions = null) {

        if(file_exists(dirname(__FILE__)."/".$dbParameters->_dbEngine."/message_".$dbParameters->_dbEngine.".php") == false) {
            include_once(dirname(__FILE__)."/common/message_common.php");
            $classname = "BD_message_common";
        }
        else {
            include_once(dirname(__FILE__)."/".$dbParameters->_dbEngine."/message_".$dbParameters->_dbEngine.".php");
            $classname = "BD_message_".$dbParameters->_dbEngine;
        }

        if (!class_exists($classname)) {
            return PEAR::raiseError("Cannot instanciate class $classname", null,
                                    null, null, null, null, false);
        }

        $obj =& new $classname;
        $result = $obj->setDbParameters($dbParameters);
        if ($dbOptions != null) {
            $obj->setDbOptions($dbOptions);
        }
        if (PEAR::isError($result)) {
            return $result;
        } else {
            return $obj;
        }
    }

    // }}}

    // {{{ constructor

    /**
     * DB_message constructor.
     *
     * @access public
     */

    function BD_message() {
    }

    // }}}

    // {{{ getMessageId()

    /**
     * Returns the Message ID
     * @return  int
     * @access  public
     */

    function getMessageId() {
        return $this->_messageId;
    }

    // }}}

    // {{{ setMessageId()

    /**
     * Sets the Message ID
     * @param   int
     * @access  public
     */

    function setMessageId($messageId) {
        $this->_messageId = $messageId;
    }

    // }}}

    // {{{ getTitre()

    /**
     * Returns the Title
     * @return  String
     * @access  public
     */

    function getTitre() {
        return $this->_titre;
    }
    
    // {{{ setTitre()

    /**
     * Sets the Title
     * @param   String
     * @access  public
     */

    function setTitre($titre) {
        $this->_titre = corriger_caracteres($titre);
    }

    // }}}

    // {{{ getTexte()

    /**
     * Returns the Texte
     * @return  String
     * @access  public
     */

    function getTexte() {
        return $this->_texte;
    }
    
    // {{{ setTexte()

    /**
     * Sets the Texte
     * @param   String
     * @access  public
     */

    function setTexte($texte) {
        $this->_texte = corriger_caracteres($texte);
    }

    // }}}    
    
    // {{{ getType()

    /**
     * Returns the Type
     * @return  String
     * @access  public
     */

    function getType() {
        return $this->_type;
    }
    
    // }}}
    
    // {{{ setType()

    /**
     * Sets the Type
     * @param   String
     * @access  public
     */

    function setType($type) {
        $this->_type = corriger_caracteres($type);
    }

    // }}}
    
    // {{{ getDateHeure()

    /**
     * Returns Time
     * @return  Date
     * @access  public
     */

    function getDateHeure() {
        return $this->_dateHeure;
    }

    // }}}

    // {{{ setDateHeure()

    /**
     * Sets the time
     * @param  Date
     * @access public
     */

    function setDateHeure($dateHeure) {
        $this->_dateHeure = $dateHeure;
    }

    // }}}    

    // {{{ getRv()

    /**
     * Returns rv
     * @return  String
     * @access  public
     */

    function getRv() {
        return $this->_rv;
    }

    // }}}

    // {{{ setRv()

    /**
     * Sets rv
     * @param   String
     * @access  public
     */

    function setRv($rv) {
        $this->_rv = corriger_caracteres($rv);
    }

    // }}}

    // {{{ getStatut()

    /**
     * Returns the State
     * @return  String
     * @access  public
     */

    function getStatut() {
        return $this->_statut;
    }

    // }}}

    // {{{ setStatut()

    /**
     * Sets the State
     * @param   String
     * @access  public
     */

    function setStatut($statut) {
        $this->_statut = corriger_caracteres($statut);
    }

    // }}}    
    
    // {{{ getAuteurId()

    /**
     * Returns the Autor ID
     * @return  int
     * @access  public
     */

    function getAuteurId() {
        return $this->_auteurId;
    }

    // }}}

    // {{{ setAuteurId()

    /**
     * Sets the Auteur ID
     * @param   int
     * @access  public
     */

    function setAuteurId($auteurId) {
        $this->_auteurId = $auteurId;
    }

    // }}}

    // {{{ getMajDate()

    /**
     * Returns the message update date
     * @return  Date
     * @access  public
     */

    function getMajDate() {
        return $this->_majDate;
    }

    // }}}

    // {{{ setMajDate()

    /**
     * Sets the message update date
     * @param   Date
     * @access  public
     */

    function setMajDate($majDate) {
        $this->_majDate = $majDate;
    }

    // }}}

    // {{{ getFinDate()

    /**
     * Returns the message end date
     * @return  Date
     * @access  public
     */

    function getFinDate() {
        return $this->_finDate;
    }

    // }}}

    // {{{ setFinDate()

    /**
     * Sets the message end date
     * @param   Date
     * @access  public
     */

    function setFinDate($finDate) {
        $this->_finDate = $finDate;
    }

    // }}}

    // {{{ create()

    function create() {
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : create()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        $string_prefix = $GLOBALS['table_prefix']."_messages";
        $messageId = $db->nextId($string_prefix, true);
        if (DB::isError($messageId)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : create()] ".$messageId->getMessage()."", null,
                null, null, null, null, false);
        }

        $this->_messageId = $messageId;
        
        //if ($this->_dateHeure == "NOW()") $dateValue = "NOW()"; else $dateValue = "'".$db->quoteString($this->_dateHeure)."'";
        
        $maDate = new Date();
	    $this->setDateHeure($maDate->getDate(DATE_FORMAT_ISO));

        $query = "INSERT INTO ".$GLOBALS['table_prefix']."_messages (".MESSAGE_ALL_FIELDS.") VALUES "
                ."(".$this->_messageId.", "
                ."'".$db->quoteString($this->_titre)."', "
                ."'".$db->quoteString($this->_texte)."', "
                ."'".$db->quoteString($this->_type)."', "
                ."'".$db->quoteString($this->_dateHeure)."', "
                ."'".$db->quoteString($this->_rv)."', "
                ."'".$db->quoteString($this->_statut)."', "
                ."".$this->_auteurId.", "
                ."'".$db->quoteString($this->_majDate)."', "
                ."'".$db->quoteString($this->_finDate)."' )";

         

        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : create()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ update()

    function update() {
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : update()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        //if ($this->_dateHeure == "NOW()") $dateValue = "NOW()"; else $dateValue = "'".$db->quoteString($this->_dateHeure)."'";

        $maDate = new Date();
	    $this->setMajDate($maDate->getDate(DATE_FORMAT_ISO));

        $query = "UPDATE ".$GLOBALS['table_prefix']."_messages "
                ."SET titre = '".$db->quoteString($this->_titre)."', "
                ."texte = '".$db->quoteString($this->_texte)."', type = '".$db->quoteString($this->_type)."', "
                ."date_heure = '".$db->quoteString($this->_dateHeure)."', rv = '".$db->quoteString($this->_rv)."', "
                ."statut = '".$db->quoteString($this->_statut)."', id_auteur = ".$this->_auteurId.", "
                ."maj = '".$db->quoteString($this->_majDate)."', date_fin = '".$db->quoteString($this->_finDate)."' "
                ."WHERE id_message = ".$this->_messageId;
         

        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : update()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

    }

    // }}}

    // {{{ load()

    function load($idMessage) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : load()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT ".MESSAGE_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_messages WHERE id_message = $idMessage";

         
        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : load()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
            if ($row = $result->fetchRow()) {

                $maDate = new Date($row['maj']);
                $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

                $this->_fetchData($row);
            } else {
                return PEAR::raiseError("[".get_class($this)." DB_message : load($idMessage)] Aucun message ne correspond pas � cet ID!", null,
                                    null, null, null, null, false);
            }
            $result->free();
        }
    }

    // }}}

    // {{{ delete()

    function delete($idMessage) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : delete()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_messages WHERE id_message = $idMessage";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : delete()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ _fetchData()

    function _fetchData($row) {
        $this->setMessageId($row['id_message']);
        $this->setTitre($row['titre']);
        $this->setTexte($row['texte']);
        $this->setType($row['type']);
        $this->setDateHeure($row['date_heure']);
        $this->setRv($row['rv']);
        $this->setStatut($row['statut']);
        $this->setAuteurId($row['id_auteur']);
        $this->setMajDate($row['maj']);
        $this->setFinDate($row['date_fin']);
    }

    // }}}

    // {{{ deleteAllExceptMessageIds($messages)

    function deleteAllExceptMessageIds($messages)  {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : deleteAllExceptMessageIds()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        
        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_messages WHERE id_message NOT IN ($messages)";    
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : deleteAllExceptMessageIds()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ deleteForStatutAndMajDate($statut, $myDate)

    function deleteForStatutAndMajDate($statut, $myDate) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : deleteForStatutAndMajDate()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        $maDate = new Date($myDate);
        
        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_messages WHERE (statut = '$statut') AND (date_heure < '" . $maDate->getDate(DATE_FORMAT_ISO) . "')";
         
        //echo "<br><br>$query<br><br>";

        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : deleteForStatutAndMajDate()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ deleteForMessageIdAndAuteurId($supp_dest)

    function deleteForMessageIdAndAuteurId($supp_dest) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : deleteForMessageIdAndAuteurId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        
        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_auteurs_messages WHERE id_message=" . $this->_messageId . " AND id_auteur=$supp_dest";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : deleteForMessageIdAndAuteurId()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ deleteForAuteurIdAndMessageId($nouv_auteur, $id_message)

    function deleteForAuteurIdAndMessageId($nouv_auteur, $id_message) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : deleteForAuteurIdAndMessageId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        
        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_auteurs_messages WHERE id_auteur=$nouv_auteur AND id_message=$id_message";
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : deleteForAuteurIdAndMessageId()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ deleteAuteurs()

    /**
     * This method is used to delete all authors attached to this message
     * @access  public
     */
    function deleteAuteurs() {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : deleteAuteurs()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_auteurs_messages WHERE id_message = ".$this->_messageId;
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : deleteAuteurs()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ deleteForMessageIds($messages)

    function deleteForMessageIds($id_objet)  {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : deleteForMessageIds()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        
        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_auteurs_messages WHERE id_message=$id_objet";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : deleteForMessageIds()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ deleteAllAuteurIdsExceptAuteurIds($auteurs)

    function deleteAllAuteurIdsExceptAuteurIds($auteurs)  {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : deleteAllAuteurIdsExceptAuteurIds()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        
        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_auteurs_messages WHERE id_auteur NOT IN ($auteurs)";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : deleteAllAuteurIdsExceptAuteurIds()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}
    
    // {{{ getAllMessageIdsForType($type)

    function getAllMessageIdsForType($type) {
        $messageIds = array();

        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : getAllMessageIdsForType()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        
        $query = "SELECT id_message FROM ".$GLOBALS['table_prefix']."_messages WHERE type LIKE '$type'";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : getAllMessageIdsForType()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $result->fetchRow()) {    $messageIds[] = $row['id_message'];}
        $result->free();
        return $messageIds;
    }

    // }}}

    // {{{ getAllMessageIdsForSameMessage()

    function getAllMessageIdsForSameMessage() {
        $messageIds = array();

        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : getAllMessageIdsForSameMessage()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        
        $query = "SELECT m.id_message FROM ".$GLOBALS['table_prefix']."_messages m, ".$GLOBALS['table_prefix']."_auteurs_messages lien ".
		"WHERE m.id_message = lien.id_message GROUP BY m.id_message";
        
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : getAllMessageIdsForSameMessage()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }        
        while ($row = $result->fetchRow()) {    $messageIds[] = $row['id_message'];}
        $result->free();
        return $messageIds;
    }

    // }}}

    // {{{ setVu($vu)

    function setVu($vu) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : setVu()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "UPDATE ".$GLOBALS['table_prefix']."_auteurs_messages SET vu = '$vu' WHERE id_message=".$this->_messageId."";

         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : setVu()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ setAllVu($vu)

    function setAllVu($vu) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : setAllVu()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "UPDATE ".$GLOBALS['table_prefix']."_auteurs_messages SET vu = '$vu'";

         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : setAllVu()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ setVuForStatut($vu, $statut)

    function setVuForStatut($vu, $statut) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : setVuForStatut()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "UPDATE ".$GLOBALS['table_prefix']."_auteurs_messages SET vu=$vu WHERE statut=$statut";

         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : setVuForStatut()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ addAuteur($connect_id_auteur, $id_message, 'oui')

    function addAuteur($connect_id_auteur, $id_message, $vu) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : addAuteur()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "INSERT INTO ".$GLOBALS['table_prefix']."_auteurs_messages (id_auteur,id_message,vu) VALUES ($connect_id_auteur,$id_message,'$vu')";

         

        //echo '<br />' . $query . '<br />';

        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : addAuteur()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ updateVuForMessageId($vu, $id_message)

    function updateVuForMessageId($vu, $id_message) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : updateVuForMessageId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "UPDATE ".$GLOBALS['table_prefix']."_auteurs_messages SET vu='$vu' WHERE id_message=$id_message";

         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : updateVuForMessageId()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        return $queryResult;
    }

    // }}}

    // {{{ updateDateHeureForMessageIdAndRv($id_message, $rv)

    function updateDateHeureForMessageIdAndRv($id_message, $rv) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : updateDateHeureForMessageIdAndRv()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $maDate = new Date();

        $query = "UPDATE ".$GLOBALS['table_prefix']."_messages SET date_heure='" . $maDate->getDate(DATE_FORMAT_ISO) . "' WHERE id_message=$id_message AND rv<>'$rv'";

         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : updateDateHeureForMessageIdAndRv()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        return $queryResult;
    }

    // }}}

    // {{{ updateStatutForMessageId($statut, $id_message)

    function updateStatutForMessageId($statut, $id_message) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : updateStatutForMessageId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $maDate = new Date();

        $query = "UPDATE ".$GLOBALS['table_prefix']."_messages SET date_heure='" . $maDate->getDate(DATE_FORMAT_ISO) . "' WHERE id_message=$id_message AND rv<>$statut";

         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : updateStatutForMessageId()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        return $queryResult;
    }

    // }}}

    // {{{ updateVuForMessageIdAndAuteurId($vu, $id_message, $connect_id_auteur)

    function updateVuForMessageIdAndAuteurId($vu, $id_message, $connect_id_auteur) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : updateVuForMessageIdAndAuteurId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "UPDATE ".$GLOBALS['table_prefix']."_auteurs_messages SET vu='$vu' WHERE id_message=$id_message AND id_auteur=$connect_id_auteur";

         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : updateVuForMessageIdAndAuteurId()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        return $queryResult;
    }

    // }}}

    // {{{ getAllForTypeAndStatut($type, $statut, $critere)

    /**
     * Returns an array of Message.
     *
     *
     * @return Array of Message
     * @param $type
     * @param $statut
     * @param $critere
     * @access public
     */

    function &getAllForTypeAndStatut($type, $statut, $critere) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : getAllForTypeAndStatut()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT ".MESSAGE_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_messages WHERE type = $type AND statut = $statut ORDER BY $critere DESC";

         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : getAllForTypeAndStatut()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $queryResult->fetchRow()) {
            $resultMessage = &BD_message::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultMessage->_fetchData($row);
            $result[] = &$resultMessage;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ getAllForAuteurIdAndVuAndStatutAndType($connect_id_auteur, $vu, $statut, $type)

    /**
     * Returns an array of Message.
     *
     *
     * @return Array of Message
     * @param $connect_id_auteur
     * @param $vu
     * @param $statut
     * @param $type
     * @access public
     */

    function &getAllForAuteurIdAndVuAndStatutAndType($connect_id_auteur, $vu, $statut, $type) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : getAllForAuteurIdAndVuAndStatutAndType()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT messages.* FROM ".$GLOBALS['table_prefix']."_messages messages, ".$GLOBALS['table_prefix']."_auteurs_messages lien WHERE lien.id_auteur=$connect_id_auteur AND vu='$vu' AND statut='$statut' AND type='$type' AND lien.id_message=messages.id_message";

        //echo '<br><br>'.$query.'<br><br>';
         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : getAllForAuteurIdAndVuAndStatutAndType()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $queryResult->fetchRow()) {
            $resultMessage = &BD_message::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultMessage->_fetchData($row);
            $result[] = &$resultMessage;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ getAuteurIdAndMessageIdForStatut($statut)

    /**
     * Returns an array of Message.
     *
     *
     * @return Array of Message
     * @param $type
     * @param $statut
     * @param $critere
     * @access public
     */

    function &getAuteurIdAndMessageIdForStatut($statut) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : getAuteurIdAndMessageIdForStatut()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT ".MESSAGE_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_auteurs_messages WHERE statut=$statut";
         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : getAuteurIdAndMessageIdForStatut()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $queryResult->fetchRow()) {
            $resultMessage = &BD_message::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultMessage->_fetchData($row);
            $result[] = &$resultMessage;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ getAuteurIdsForMessageId($messageId)

    /**
     * Returns an array of Author.
     *
     *
     * @return Array of Author
     * @param $messageId
     * @access public
     */

    function &getAuteurIdsForMessageId($messageId) {
        $auteurs = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : getAuteurIdsForMessageId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT id_auteur FROM ".$GLOBALS['table_prefix']."_auteurs_messages WHERE id_message=$messageId";
         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : getAuteurIdsForMessageId()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $queryResult->fetchRow()) $auteurs[] = $row['id_auteur'];
        $queryResult->free();
        return $auteurs;
    }

    // }}}

    // {{{ howManyMessageForAuteurIdAndMessageId($connect_id_auteur, $id_message)

    /**
     * This method returns the number of article written by a given author
     * @return  int
     * @access  public
     */
    function howManyMessageForAuteurIdAndMessageId($connect_id_auteur, $id_message) {
        $howManyMessage = 0;
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : howManyMessageForAuteurIdAndMessageId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        
		$query = "SELECT COUNT(*) as compteur FROM ".$GLOBALS['table_prefix']."_auteurs_messages WHERE id_auteur=$connect_id_auteur AND id_message=$id_message";
		 
		$result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : howManyMessageForAuteurIdAndMessageId()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        if ($row = $result->fetchRow()) {
            $howManyMessage = intval($row["compteur"]);
        }

        $result->free();
        return $howManyMessage;
    }

    // }}}

    // {{{ getAllForAuteurIdAndStatutAndRv($connect_id_auteur, $statut, $rv)

    /**
     * Returns an array of Message.
     *
     *
     * @return Array of Message
     * @param $connect_id_auteur
     * @param $statut
     * @param $rv
     * @access public
     */

    function &getAllForAuteurIdAndStatutAndRv($connect_id_auteur, $statut, $rv) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : getAllForAuteurIdAndStatutAndRv()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $maDate = new Date();
        $maDate->subtractSeconds(intval(3600*24));

        $query = "SELECT messages.* FROM ".$GLOBALS['table_prefix']."_messages messages, ".$GLOBALS['table_prefix']."_auteurs_messages lien WHERE lien.id_auteur=$connect_id_auteur AND messages.statut='$statut' AND lien.id_message=messages.id_message AND messages.rv='$rv' AND messages.date_heure>'" . $maDate->getDate(DATE_FORMAT_ISO) . "'";
        //$query = "SELECT messages.* FROM ".$GLOBALS['table_prefix']."_messages messages, ".$GLOBALS['table_prefix']."_auteurs_messages lien WHERE lien.id_auteur=$connect_id_auteur AND messages.statut='$statut' AND lien.id_message=messages.id_message AND messages.rv='$rv' AND messages.date_heure>'" . $maDate->getDate() . "' GROUP BY messages.id_message";
        //$query = "SELECT ".MESSAGE_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_messages messages, ".$GLOBALS['table_prefix']."_auteurs_messages lien WHERE lien.id_auteur='$connect_id_auteur' AND messages.statut=$statut AND lien.id_message=messages.id_message AND messages.rv=$rv AND messages.date_heure>DATE_SUB(NOW(),INTERVAL 1 DAY) GROUP BY messages.id_message";
        //echo $query;
         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : getAllForAuteurIdAndStatutAndRv()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $queryResult->fetchRow()) {
            $resultMessage = &BD_message::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultMessage->_fetchData($row);
            $result[] = &$resultMessage;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ getPersonnalRDV($connect_id_auteur, $annee_today, $mois_today)

    /**
     * Returns an array of Message.
     *
     *
     * @return Array of Message
     * @param $connect_id_auteur
     * @param $annee_today
     * @param $mois_today
     * @access public
     */

    function &getPersonnalRDV($connect_id_auteur, $annee_today, $mois_today, $jour_today ='01')   {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : getPersonnalRDV()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        
        $query = "SELECT messages.* FROM ".$GLOBALS['table_prefix']."_messages messages, ".$GLOBALS['table_prefix']."_auteurs_messages lien WHERE ((lien.id_auteur='$connect_id_auteur' AND lien.id_message=messages.id_message) OR messages.type='affich') AND messages.rv='oui' AND messages.date_heure >='$annee_today-$mois_today-$jour_today 00:00:00' AND messages.date_heure <= '$annee_today-$mois_today-$jour_today 23:59:59' AND messages.statut='publie' ORDER BY messages.date_heure";
        //die($query);
         
        //echo "<br><br>$query<br><br>";

        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : getPersonnalRDV()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $queryResult->fetchRow()) {
            $resultMessage = &BD_message::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultMessage->_fetchData($row);
            $result[] = &$resultMessage;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ getPersonnalRDVForMonth($connect_id_auteur, $annee_today, $mois_today)

    /**
     * Returns an array of Message.
     *
     *
     * @return Array of Message
     * @param $connect_id_auteur
     * @param $annee_today
     * @param $mois_today
     * @access public
     */

    function &getPersonnalRDVForMonth($connect_id_auteur, $annee_today, $mois_today)   {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : getPersonnalRDVForMonth()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        // retrait S Petit
        //$query = "SELECT messages.* FROM ".$GLOBALS['table_prefix']."_messages messages, ".$GLOBALS['table_prefix']."_auteurs_messages lien WHERE ((lien.id_auteur='$connect_id_auteur' AND lien.id_message=messages.id_message) OR messages.type='affich') AND messages.rv='oui' AND messages.date_heure >='$annee_today-$mois_today-$jour_today 00:00:00' AND messages.date_heure <= '$annee_today-$mois_today-$jour_today 23:59:59' AND messages.statut='publie' GROUP BY messages.id_message ORDER BY messages.date_heure";
        
        
        // modifications  S Petit
        $maDate = new Date("$annee_today-$mois_today-01 00:00:00");
        $maDate->addSeconds(intval(3600*24*31));
        $maDate->setDay(01);
        $query = "SELECT messages.* FROM ".$GLOBALS['table_prefix']."_messages messages, ".$GLOBALS['table_prefix']."_auteurs_messages lien WHERE ((lien.id_auteur='$connect_id_auteur' AND lien.id_message=messages.id_message) OR messages.type='affich') AND messages.rv='oui' AND messages.date_heure >='$annee_today-$mois_today-01 00:00:00' AND messages.date_heure <= '" . $maDate->getDate(DATE_FORMAT_ISO) . "' AND messages.statut='publie' ORDER BY messages.date_heure";
        /*
        $maDate = new Date();
        $maDate->addSeconds(3600*24*30);
        //$query = "SELECT messages.* FROM ".$GLOBALS['table_prefix']."_messages messages, ".$GLOBALS['table_prefix']."_auteurs_messages lien WHERE ((lien.id_auteur='$connect_id_auteur' AND lien.id_message=messages.id_message) OR messages.type='affich') AND messages.rv='oui' AND messages.date_heure >='$annee_today-$mois_today-01' AND messages.date_heure <= '" . $maDate->getDate() . "' AND messages.statut='publie' GROUP BY messages.id_message ORDER BY messages.date_heure";
        $query = "SELECT messages.* FROM ".$GLOBALS['table_prefix']."_messages messages, ".$GLOBALS['table_prefix']."_auteurs_messages lien WHERE ((lien.id_auteur='$connect_id_auteur' AND lien.id_message=messages.id_message) OR messages.type='affich') AND messages.rv='oui' AND messages.date_heure >='$annee_today-$mois_today-01' AND messages.date_heure <= '" . $maDate->getDate() . "' AND messages.statut='publie' ORDER BY messages.date_heure";
        */
        // fin modifications
         
        //echo "<br><br>$query<br><br>";

        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : getPersonnalRDVForMonth()]".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $queryResult->fetchRow()) {
            $resultMessage = &BD_message::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultMessage->_fetchData($row);
            $result[] = &$resultMessage;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ getRDV($connect_id_auteur, $vu, $annee_today, $mois_today, $statut)

    /**
     * Returns an array of Message.
     *
     *
     * @return Array of Message
     * @param $connect_id_auteur
     * @param $vu
     * @param $annee_today
     * @param $mois_today
     * @param $statut
     * @access public
     */

    function &getRDV($connect_id_auteur, $vu, $annee_today, $mois_today, $statut) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : getRDV()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $maDate = new Date("$annee_today-$mois_today-01 00:00:00");
        $maDate->addSeconds(intval(3600*24*31));
        $maDate->setDay(01);

        $query = "SELECT messages.* FROM ".$GLOBALS['table_prefix']."_messages messages, ".$GLOBALS['table_prefix']."_auteurs_messages lien WHERE (lien.id_auteur=$connect_id_auteur AND lien.id_message=messages.id_message) AND messages.rv='$vu' AND messages.date_heure >='$annee_today-$mois_today-01 00:00:00' AND messages.date_heure <= '" . $maDate->getDate(DATE_FORMAT_ISO) . "' AND messages.statut='$statut' ORDER BY messages.date_heure";
        /*
        $query = "SELECT ".MESSAGE_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_messages messages, ".$GLOBALS['table_prefix']."_auteurs_messages lien
        WHERE (lien.id_auteur='$connect_id_auteur' AND lien.id_message=messages.id_message)
         AND messages.rv='$vu' AND
         messages.date_heure >='$annee_today-$mois_today-1' AND
         messages.date_heure <= DATE_ADD('$annee_today-$mois_today-1', INTERVAL 1 MONTH)
         AND messages.statut='$statut' GROUP BY messages.id_message ORDER BY messages.date_heure";
        */
         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : getRDV()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $queryResult->fetchRow()) {
            $resultMessage = &BD_message::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultMessage->_fetchData($row);
            $result[] = &$resultMessage;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ getAgenda($connect_id_auteur, $vu, $annee_today, $mois_today, $statut)

    /**
     * Returns an array of RDV.
     *
     *
     * @return Array of RDV
     * @param $connect_id_auteur
     * @param $vu
     * @param $annee_today
     * @param $mois_today
     * @param $statut
     * @access public
     */

    function &getAgenda($connect_id_auteur, $annee, $mois) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : getAgenda()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $maDate = new Date("$annee-$mois-01 00:00:00");
        $maDate->addSeconds(intval(3600*24*31));
        $maDate->setDay(01);

        $query = "SELECT messages.* FROM ".$GLOBALS['table_prefix']."_messages messages, ".$GLOBALS['table_prefix']."_auteurs_messages lien WHERE ((lien.id_auteur='$connect_id_auteur' AND lien.id_message=messages.id_message) OR messages.type='affich') AND messages.rv='oui' AND messages.date_heure >='$annee-$mois-01 00:00:00' AND messages.date_heure <= '" . $maDate->getDate(DATE_FORMAT_ISO) . "' AND messages.statut='publie' ORDER BY messages.date_heure";                  
         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : getAgenda()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $queryResult->fetchRow()) {
            $resultMessage = &BD_message::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultMessage->_fetchData($row);
            $result[] = &$resultMessage;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ displayTasks($type, $connect_id_auteur)

    /**
     * Returns an array of Tasks.
     *
     *
     * @return Array of Tasks
     * @param $type
     * @param $connect_id_auteur
     * @access public
     */

    function &displayTasks($type, $connect_id_auteur) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : displayTasks()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        switch ($type) {
        
            case 'annonces':
            
                $query = "SELECT * FROM ".$GLOBALS['table_prefix']."_messages WHERE type = 'affich' AND rv != 'oui' AND statut = 'publie' ORDER BY date_heure DESC";
                    
            break;
            
            case 'pb':
            
                $query = "SELECT * FROM ".$GLOBALS['table_prefix']."_messages messages WHERE id_auteur=$connect_id_auteur AND statut='publie' AND type='pb' AND rv!='oui'";
            
            break;
            
            case 'rv':
        
                $maDate1 = new Date();
                $maDate1->subtractSeconds(intval(3600*24));
                
                $maDate2 = new Date();
                $maDate2->addSeconds(intval(3600*24*31));
                
                $query = "SELECT messages.* FROM ".$GLOBALS['table_prefix']."_messages messages, ".$GLOBALS['table_prefix']."_auteurs_messages lien WHERE ((lien.id_auteur='$connect_id_auteur' AND lien.id_message=messages.id_message) OR messages.type='affich') AND messages.rv='oui' AND messages.date_heure > '" . $maDate1->getDate(DATE_FORMAT_ISO) . "' AND messages.date_heure < '" . $maDate2->getDate(DATE_FORMAT_ISO) . "' AND messages.statut='publie' ORDER BY messages.date_heure";
            
            break;
        
            default:
            break;
        }

        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : displayTasks()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $queryResult->fetchRow()) {
            $resultMessage = &BD_message::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultMessage->_fetchData($row);
            $result[] = &$resultMessage;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ getAllAuteursForMessageExceptAuteurId($connect_id_auteur)

    /**
     * Returns an array of auteurs.
     *
     *
     * @return Array of autors
     * @param $connect_id_auteur
     * @access public
     */

    function &getAllAuteursForMessageExceptAuteurId($connect_id_auteur) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : getAllAuteursForMessageExceptAuteurId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT auteurs.* FROM ".$GLOBALS['table_prefix']."_auteurs auteurs, ".$GLOBALS['table_prefix']."_auteurs_messages lien WHERE (lien.id_message='" . $this->getMessageId() . "' AND (auteurs.id_auteur!='$connect_id_auteur' AND lien.id_auteur=auteurs.id_auteur))";
         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : getAllAuteursForMessageExceptAuteurId()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $queryResult->fetchRow()) {
            $resultAuteur = &BD_auteur::factory($this->getDbParameters(), $this->getDbOptions());
            $resultAuteur->_fetchData($row);
            $result[] = &$resultAuteur;
        }
        $queryResult->free();
        return $result;
    }

    // }}}


    // {{{ auteurHasRDVThisMonth($connect_id_auteur, $annee, $mois)

    /**
     * Returns an array of auteurs.
     *
     *
     * @return Array of autors
     * @param $connect_id_auteur
     * @param $annee
     * @param $mois
     * @access public
     */

    function &auteurHasRDVThisMonth($connect_id_auteur, $annee, $mois) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : auteurHasRDVThisMonth()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $maDate = new Date('$annee-$mois-01 00:00:00');
        $maDate->addSeconds(3600*24*31);
        
        $query = "SELECT messages.id_message FROM ".$GLOBALS['table_prefix']."_messages AS messages, ".$GLOBALS['table_prefix']."_auteurs_messages AS lien ".
			"WHERE ((lien.id_auteur='$connect_id_auteur' AND lien.id_message=messages.id_message) OR messages.type='affich') ".
			"AND messages.rv='oui' AND messages.date_heure >='$annee-$mois-01' AND date_heure <  '" . $maDate->getDate(DATE_FORMAT_ISO) . "' ".
			"AND messages.statut='publie'";
         
        $queryResult = $db->limitQuery($query, 0, 1);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : auteurHasRDVThisMonth()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

        return ($queryResult->numRows() > 0);        
    }

    // }}}

    // {{{ auteurHasRDVThisDay($connect_id_auteur, $annee_today, $mois_today, $jour_today)

    /**
     * Returns an array of auteurs.
     *
     *
     * @return Array of autors
     * @param $connect_id_auteur
     * @param $annee_today
     * @param $mois_today
     * @param $jour_today     
     * @access public
     */

    function &auteurHasRDVThisDay($connect_id_auteur, $annee_today, $mois_today, $jour_today) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : auteurHasRDVThisDay()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $maDate = new Date('$annee_today-$mois_today-$jour_today 00:00:00');
        $maDate->addSeconds(3600*24*31);
        
        $query = "SELECT messages.id_message FROM ".$GLOBALS['table_prefix']."_messages AS messages, ".$GLOBALS['table_prefix']."_auteurs_messages AS lien ".
			"WHERE ((lien.id_auteur='$connect_id_auteur' AND lien.id_message=messages.id_message) OR messages.type='affich') ".
			"AND messages.rv='oui' AND messages.date_heure >='$annee_today-$mois_today-$jour_today' AND messages.date_heure < '" . $maDate->getDate(DATE_FORMAT_ISO) . "' ".
			"AND messages.statut='publie'";
			
         
        $queryResult = $db->limitQuery($query, 0, 1);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : auteurHasRDVThisDay()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

        return ($queryResult->numRows() > 0);        
    }

    // }}}

    // {{{ getImportantAuthors($connect_id_auteur)

    /**
     * Returns an array of auteurs.
     *
     *
     * @return Array of autors
     * @param $connect_id_auteur
     * @access public
     */

    function &getImportantAuthors($connect_id_auteur) {
        $rows = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : getImportantAuthors()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT auteurs.id_auteur, auteurs.nom, COUNT(*) AS total FROM ".$GLOBALS['table_prefix']."_auteurs AS auteurs,  ".$GLOBALS['table_prefix']."_auteurs_messages AS lien2, ".$GLOBALS['table_prefix']."_messages AS messages, ".$GLOBALS['table_prefix']."_auteurs_messages AS lien ".
	        "WHERE (lien.id_auteur = $connect_id_auteur AND lien.id_message = messages.id_message) ".
	        "AND (lien2.id_auteur = lien2.id_auteur AND lien2.id_message = messages.id_message AND lien2.id_auteur != $connect_id_auteur AND auteurs.id_auteur = lien2.id_auteur) GROUP BY auteurs.id_auteur, auteurs.nom ORDER BY total DESC";
         
        $queryResult = $db->limitQuery($query, 0, 20);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : getImportantAuthors()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $queryResult->fetchRow()) {
            $rows[] = $row;
        }
        $queryResult->free();
        return $rows;
    }

    // }}}
}
?>