<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Erwan LE BESCOND <elebescond@clever-age.com>                |
// +----------------------------------------------------------------------+
//
// Base class for Message List Data abstraction.
//

/**
 * BD_messageListData is a base class for message lists data database abstraction implementations, and must be
 * inherited by all such.
 */
if (defined("_BD_MESSAGELISTDATA")) return;
    define("_BD_MESSAGELISTDATA", "1");

require_once "PEAR.php";
require_once "DB.php";
require_once dirname(__FILE__)."/objectlistdata.php";


/**
 * This class implements data lists for message list business data type
 * @package	BD
 * @author  Antoine Angnieux <aangenieux@clever-age.com>
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @access	public
 */
class BD_messageListData extends BD_objectListData {

    /**
     * Create a new message list data object for the specified database parameters
     * passed
     *
     * @param BD_parameters $dbParameters database configuration object
     *
     * @return mixed a newly created MessageListData object, or a PEAR error code on
     * error
     *
     * access public
     */

    function &factory($dbParameters = null) {
        if(file_exists(dirname(__FILE__)."/".$dbParameters->_dbEngine."/messagelistdata_".$dbParameters->_dbEngine.".php") == false) {
            include_once(dirname(__FILE__)."/common/messagelistdata_common.php");
            $classname = "BD_messagelistdata_common";
        }
        else {
            include_once(dirname(__FILE__)."/".$dbParameters->_dbEngine."/messagelistdata_".$dbParameters->_dbEngine.".php");
            $classname = "BD_messageListData_".$dbParameters->_dbEngine;
        }

        if (!class_exists($classname)) {
            return PEAR::raiseError("Cannot instanciate class $classname", null,
                                    null, null, null, null, false);
        }

        $obj =& new $classname;
        $result = $obj->setDbParameters($dbParameters);
        if (PEAR::isError($result)) {
            return $result;
        } else {
            return $obj;
        }
    }

    // {{{ constructor

    /**
     * Constructor.
     *
     * @access public
     */

    function BD_messageListData() {
        $par = get_parent_class(get_parent_class($this));
        $this->$par();
    }

    // }}}

    // {{{ _fillQueries()

    /**
     * This methods fill the query associative arrays with SQL 92 compliant
     * queries. Each driver that requires specific SQL querying must implement
     * the _adaptQueriesToDriver() method.
     * @access  private
     * @see     _adaptQueriesToDriver()
     */
    function _fillQueries() {
        $this->_queries[MESSAGES_BY_RV_AND_DATE] =  "SELECT * FROM ".$GLOBALS['table_prefix']."_messages messages, ".$GLOBALS['table_prefix']."_auteurs_messages lien ".
	                                                "WHERE lien.id_auteur=? AND rv=? AND date_heure > <!spipDATE_SUBTRACT_ONE_DAYspip!> ".
	                                                "AND statut=? AND lien.id_message=messages.id_message";
        $this->_queriesCount[MESSAGES_BY_RV_AND_DATE] =  "SELECT COUNT(*) FROM ".$GLOBALS['table_prefix']."_messages messages, ".$GLOBALS['table_prefix']."_auteurs_messages lien ".
	                                                "WHERE lien.id_auteur=? AND rv=? AND date_heure > <!spipDATE_SUBTRACT_ONE_DAYspip!> ".
	                                                "AND statut=? AND lien.id_message=messages.id_message";
        /*
        $this->_queries[MESSAGES_BY_RV_AND_DATE] =  "SELECT * FROM ".$GLOBALS['table_prefix']."_messages messages, ".$GLOBALS['table_prefix']."_auteurs_messages lien ".
	                                                "WHERE lien.id_auteur=? AND rv=? AND date_heure > DATE_SUB(NOW(), INTERVAL 1 DAY) ".
	                                                "AND statut=? AND lien.id_message=messages.id_message";
        $this->_queriesCount[MESSAGES_BY_RV_AND_DATE] =  "SELECT COUNT(*) FROM ".$GLOBALS['table_prefix']."_messages messages, ".$GLOBALS['table_prefix']."_auteurs_messages lien ".
	                                                "WHERE lien.id_auteur=? AND rv=? AND date_heure > DATE_SUB(NOW(), INTERVAL 1 DAY) ".
	                                                "AND statut=? AND lien.id_message=messages.id_message";
        */
                
        $this->_queries[MESSAGES_BY_AUTEUR_STATUT_TYPE_DATE_RV] = "SELECT * FROM ".$GLOBALS['table_prefix']."_messages messages WHERE id_auteur=? AND statut=? AND type=? AND rv<>? AND ( rv<>? OR date_heure > <!spipDATE_SUBTRACT_ONE_DAYspip!>)";
        $this->_queriesCount[MESSAGES_BY_AUTEUR_STATUT_TYPE_DATE_RV] = "SELECT COUNT(*) FROM ".$GLOBALS['table_prefix']."_messages messages WHERE id_auteur=? AND statut=? AND type=? AND rv<>? AND ( rv<>? OR date_heure > <!spipDATE_SUBTRACT_ONE_DAYspip!>)";

        $this->_queries[MESSAGES_BY_AUTEUR_VU_STATUT] = "SELECT * FROM ".$GLOBALS['table_prefix']."_messages messages, ".$GLOBALS['table_prefix']."_auteurs_messages lien ".
	                                                    "WHERE lien.id_auteur=? AND vu=? ".
                                                        "AND statut=? AND lien.id_message=messages.id_message";
        $this->_queriesCount[MESSAGES_BY_AUTEUR_VU_STATUT] = "SELECT COUNT(*) FROM ".$GLOBALS['table_prefix']."_messages messages, ".$GLOBALS['table_prefix']."_auteurs_messages lien ".
	                                                    "WHERE lien.id_auteur=? AND vu=? ".
                                                        "AND statut=? AND lien.id_message=messages.id_message";
        
        $this->_queries[MESSAGES_BY_AUTEUR_STATUT_TYPE_JOINTURE] = "SELECT * FROM ".$GLOBALS['table_prefix']."_messages messages, ".$GLOBALS['table_prefix']."_auteurs_messages lien ".
	                                                        "WHERE lien.id_auteur=? AND statut=? AND type=? AND rv<>? AND lien.id_message=messages.id_message";
        $this->_queriesCount[MESSAGES_BY_AUTEUR_STATUT_TYPE_JOINTURE] = "SELECT COUNT(*) FROM ".$GLOBALS['table_prefix']."_messages messages, ".$GLOBALS['table_prefix']."_auteurs_messages lien ".
	                                                        "WHERE lien.id_auteur=? AND statut=? AND type=? AND rv<>? AND lien.id_message=messages.id_message";
        
        
        $this->_queries[MESSAGES_BY_AUTEUR_STATUT] = "SELECT * FROM ".$GLOBALS['table_prefix']."_messages messages WHERE id_auteur=? AND statut=?";
        $this->_queriesCount[MESSAGES_BY_AUTEUR_STATUT] = "SELECT COUNT(*) FROM ".$GLOBALS['table_prefix']."_messages messages WHERE id_auteur=? AND statut=?";
                
        $this->_queries[MESSAGES_BY_AUTEUR_STATUT_TYPE] = "SELECT * FROM ".$GLOBALS['table_prefix']."_messages messages WHERE id_auteur=? AND statut=? AND type=? AND rv<>?";
        $this->_queriesCount[MESSAGES_BY_AUTEUR_STATUT_TYPE] = "SELECT COUNT(*) FROM ".$GLOBALS['table_prefix']."_messages messages WHERE id_auteur=? AND statut=? AND type=? AND rv<>?";

        
        $this->_queries[MESSAGES_BY_STATUT_TYPE] = "SELECT * FROM ".$GLOBALS['table_prefix']."_messages messages WHERE statut=? AND type=? AND rv = ?";
        $this->_queriesCount[MESSAGES_BY_STATUT_TYPE] = "SELECT COUNT(*) FROM ".$GLOBALS['table_prefix']."_messages messages WHERE statut=? AND type=? AND rv = ?";
    }

    // }}}

    // {{{ getHTMLList($titre_table, $requete, $affrub=false)

    /**
     * returns the HTML List for the various breve data lists implementations
     * This method should <b>NEVER<b> be overloaded, otherwise EXTRA-EXTRA-CARE is required
     * while overloading this method.
     *
     * @return String reprensenting the generated HTML list navigation
     * @param $queryType int representing the desired query type (refer to inc_listdata_query_types_contants.php)
     * @param $params array containing the query parameters
     * @param $countQuery boolean : if set to true, the returned query is a count result query for the specified query type.
     * @access public
     */

    function displayHTMLList($titre_table, $queryType, $params = array(), $afficher_auteurs = true, $important = false, $boite_importante = true, $obligatoire = false) {
	    global $messages_vus;
	    global $connect_id_auteur;
	    global $couleur_claire;
	    global $spip_lang_rtl;

        $copyParams = $params;

        $tranches = $this->_getHTMLNavigation($queryType, $params, 3);
        
        $requete = $this->_getQuery($queryType, false, $copyParams);	    
	
	    //echo '<br />' . $requete . '<br />';
	
	    // Interdire l'affichage de message en double
	    /*
	    if ($messages_vus) {
    		$query_message .= ' AND messages.id_message NOT IN ('.join(',', $messages_vus).')';
	    }

        $query_message .= ' ORDER BY date_heure DESC';
        */
	    /*
	    $tranches = afficher_tranches_requete($query_message, 3);
        */
        
	    if ($tranches OR $obligatoire) {
    		if ($important) debut_cadre_relief();

    		echo "<P><TABLE WIDTH=100% CELLPADDING=0 CELLSPACING=0 BORDER=0><TR><TD WIDTH=100% BACKGROUND=''>";
		    echo "<TABLE WIDTH=100% CELLPADDING=3 CELLSPACING=0 BORDER=0>";
    
		    bandeau_titre_boite($titre_table, $afficher_auteurs, $boite_importante);
    
		    echo $tranches;
    
		    $db = &$this->_getDB();
            if (DB::isError($db)) {
                die("Impossible d'obternir une connexion  la base de donnes! ".$db->getMessage());
            }
            if ($this->_getQueryIsLimited()) {
                $limitStart = $this->_getLimitStart();
                $limitCount = $this->_getLimitCount();
                $result_message = $db->limitQuery($requete, $limitStart, $limitCount, $params);
            } else {
                $result_message = $db->query($requete, $params);
            }
		    /*
		    $result_message = ".$GLOBALS['table_prefix']."_query($query_message);
		    */
		    
		    $num_rows = $result_message->numRows();
    
		    while($row = $result_message->fetchRow()) {
    			$vals = '';
    
			    $id_message = $row['id_message'];
			    $date = $row["date_heure"];
			    $titre = $row["titre"];
			    $type = $row["type"];
			    $statut = $row["statut"];
			    $page = $row["page"];
			    $rv = $row["rv"];
			    $vu = $row["vu"];
			    $messages_vus[$id_message] = $id_message;
    
			    //
			    // Titre
			    //
    
			    $s = "<A HREF='message.php3?id_message=$id_message'>";
    
			    switch ($type) {
			    case 'pb' :
    				$puce = 'm_envoi_bleu$spip_lang_rtl.gif';
				    break;
			    case 'memo' :
    				$puce = 'm_envoi_jaune$spip_lang_rtl.gif';
				    break;
			    case 'affich' :
    				$puce = 'm_envoi_jaune$spip_lang_rtl.gif';
				    break;
			    case 'normal':
			    default:
    				$puce = 'm_envoi$spip_lang_rtl.gif';
				    break;
			    }
    				
			    $s .= "<img src='img_pack/$puce' width='14' height='7' border='0'>";
			    $s .= "&nbsp;&nbsp;".typo($titre)."</A>";
			    $vals[] = $s;
    
			    //
			    // Auteurs
    
			    if ($afficher_auteurs) {

    				$auteurMetier = &recuperer_instance_auteur();
    				$allForMessageIdExceptAuteurId = $auteurMetier->getAllForMessageIdExceptAuteurId($id_message, $connect_id_auteur);
    				if(PEAR::isError($allForMessageIdExceptAuteurId)) {
    				    die($allForMessageIdExceptAuteurId->getMessage());
    				}
    				/* Ajout CPSQY / Stphane PETIT */
					unset($auteurs);
					/* Fin ajout CPSQY / Stphane PETIT */
    				while(list(, $monAuteur) = each($allForMessageIdExceptAuteurId)) {
                        $auteurs[] = typo($monAuteur->getNom());
    				}
    				/*
    				$query_auteurs = "SELECT auteurs.nom FROM ".$GLOBALS['table_prefix']."_auteurs auteurs, ".$GLOBALS['table_prefix']."_auteurs_messages lien WHERE lien.id_message=$id_message AND lien.id_auteur!=$connect_id_auteur AND lien.id_auteur=auteurs.id_auteur";
				    $result_auteurs = ".$GLOBALS['table_prefix']."_query($query_auteurs);
				    $auteurs = '';
				    while ($row_auteurs = ".$GLOBALS['table_prefix']."_fetch_array($result_auteurs)) {
    					$auteurs[] = typo($row_auteurs['nom']);
				    }
                    */
				    if ($auteurs AND $type == 'normal') {
    					$s = "<FONT FACE='Arial,Helvetica,sans-serif' SIZE=1>";
					    $s .= join(', ', $auteurs);
					    $s .= "</FONT>";
				    }
				    else $s = "&nbsp;";
				    $vals[] = $s;
			    }
    			
			    //
			    // Date
			    //
    
			    $s = affdate($date);
			    $vals[] = $s;
    
			    $table[] = $vals;
		    }
    
		    if ($afficher_auteurs) {
    			$largeurs = array('', 130, 90);
			    $styles = array('arial2', 'arial1', 'arial1');
		    }
		    else {
    			$largeurs = array('', 90);
			    $styles = array('arial2', 'arial1');
		    }
		    afficher_liste($largeurs, $table, $styles);
    
		    echo "</TABLE></TD></TR></TABLE>";
		    $result_message->free();
		    if ($important) fin_cadre_relief();
	    }
    }
}
?>