<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Erwan LE BESCOND <elebescond@clever-age.com>                |
// +----------------------------------------------------------------------+
//
// Base class for Meta business persistence abstraction.
//

if (defined("_BD_META")) return;
define("_BD_META", "1");

define("META_ALL_FIELDS", " nom, valeur, maj ");

require_once dirname(__FILE__)."/metier.php";
//require_once dirname(__FILE__)."/../../inc_filtres.php3";
require_once dirname(__FILE__)."/../../inc_meta.php3";


/**
 * BD_meta is a base class for meta business persistence abstraction implementations, and must be
 * inherited by all such.
 * @package	BD
 * @author  Antoine Angnieux <aangenieux@clever-age.com>
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @access	public
 */
class BD_meta extends BD_metier {
    // {{{ properties

    /**
    * Name.
    * @var     String
    * @access  private
    */
    var $_nom;

    /**
    * Value.
    * @var     String
    * @access  private
    */
    var $_valeur;

    /**
    * Last Update.
    * @var    Date
    * @access  private
    */
    var $_maj;

    // }}}

    // {{{ factory()
    function &factory($dbParameters = null, $dbOptions = null) {

        if(file_exists(dirname(__FILE__)."/".$dbParameters->_dbEngine."/meta_".$dbParameters->_dbEngine.".php") == false) {
            include_once(dirname(__FILE__)."/common/meta_common.php");
            $classname = "BD_meta_common";
        }
        else {
            include_once(dirname(__FILE__)."/".$dbParameters->_dbEngine."/meta_".$dbParameters->_dbEngine.".php");
            $classname = "BD_meta_".$dbParameters->_dbEngine;
        }

        if (!class_exists($classname)) {
            return PEAR::raiseError("Cannot instanciate class $classname", null,
                                    null, null, null, null, false);
        }

        $obj =& new $classname;
        $result = $obj->setDbParameters($dbParameters);
        if ($dbOptions != null) {
            $obj->setDbOptions($dbOptions);
        }
        if (PEAR::isError($result)) {
            return $result;
        } else {
            return $obj;
        }
    }

    // }}}

    // {{{ constructor

    /**
     * DB_meta constructor.
     *
     * @access public
     */

    function BD_meta() {
    }

    // }}}

    // {{{ getNom()

    function getNom() {
        return $this->_nom;
    }

    // }}}

    // {{{ setNom()

    function setNom($nom) {
        //C'est le chien qui court apres sa queue: corriger_caracteres ne peut pas avoir besoin de meta!
        //$this->_nom = corriger_caracteres($nom);
        $this->_nom = $nom;
    }

    // }}}
    
    // {{{ getValeur()

    function getValeur() {
        return  $this->_valeur;
    }

    // }}}

    // {{{ setValeur()

    function setValeur($valeur) {
        //pareil ici...
        //$this->_valeur = corriger_caracteres($valeur);
        $this->_valeur = $valeur;
    }

    // }}}

    // {{{ getMaj()

    function getMaj() {
        return $this->_maj;
    }

    // }}}

    // {{{ setMaj()

    function setMaj($maj) {
        $this->_maj = $maj;
    }

    // }}}

    // {{{ create()

    function create() {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_meta : create()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "INSERT INTO ".$GLOBALS['table_prefix']."_meta (".META_ALL_FIELDS.") VALUES "
                ."('".$db->quoteString($this->_nom)."', "
                ."'".$db->quoteString($this->_valeur)."', "
                ."'".$db->quoteString($this->_maj)."')";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_meta : create()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ delete()

    function delete($nom) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_meta : delete()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_meta WHERE nom = $nom";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_meta : delete()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ update()

    function update() {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_meta : update()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $maDate = new Date();
        $this->setMaj($maDate->getDate(DATE_FORMAT_ISO));
        
        $query = "UPDATE ".$GLOBALS['table_prefix']."_meta "
                ."SET nom = '".$db->quoteString($this->_nom)."', "
                ."valeur = '".$db->quoteString($this->_valeur)."', maj = '".$db->quoteString($this->_maj)."' "
                ."WHERE nom = '".$db->quoteString($this->_nom)."'";

        
        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_meta : update()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ load()

    function load($nom) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_meta : load()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT".META_ALL_FIELDS."FROM ".$GLOBALS['table_prefix']."_meta WHERE nom = '$nom'";
        //echo $query;
         
        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_meta : load()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
            if ($row = $result->fetchRow()) {
                $maDate = new Date($row['maj']);
                $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

                $this->_fetchData($row);
            } else {
                return PEAR::raiseError("[".get_class($this)." DB_metavisite : load(".$meta.")] Aucun meta ne correspond pas  ce nom!", null,
                                    null, null, null, null, false);
            }
            $result->free();
        }
    }

    // }}}

    // {{{ _fetchData()

    function _fetchData($row) {
        $this->setNom($row['nom']);
        $this->setValeur($row['valeur']);
        $this->setMaj($row['maj']);
    }

    // }}}

    // {{{ getAllMeta()

    function &getAllMetas() {
        $metas = array();
        $db = &$this->_getDB();


        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_meta : getAllMetas()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT ".META_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_meta";
        
         
        //echo($query);
        $result = $db->query($query);

        //var_dump($result);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_meta : getAllMetas()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        
        while ($row = $result->fetchRow()) {
            $resultMeta = &BD_meta::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultMeta->_fetchData($row);
            $metas[] = &$resultMeta;
        }
        $result->free();
        return $metas;
    }

    // }}}

    // {{{ writeMeta($nom, $valeur)

    function writeMeta($nom, $valeur) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_meta : writeMeta()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        $query = "SELECT nom FROM ".$GLOBALS['table_prefix']."_meta WHERE nom='$nom'";
        //echo $query;
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_meta : writeMeta()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

        if($result->numRows() > 0) {        
		    $query = "UPDATE ".$GLOBALS['table_prefix']."_meta SET valeur='$valeur' WHERE nom='$nom'";
            //$query = "REPLACE ".$GLOBALS['table_prefix']."_meta (nom, valeur) VALUES ('$nom', '$valeur')";
		    //echo $query;
		     
		    $result = $db->query($query);

            if (DB::isError($result)) {
                return PEAR::raiseError("[".get_class($this)." DB_meta : writeMeta()] ".$result->getMessage()."", null,
                    null, null, null, null, false);
            }
        }
        else {
            $query = "INSERT INTO ".$GLOBALS['table_prefix']."_meta (nom, valeur) VALUES ('$nom', '$valeur')";
             
            //echo $query;
            $result = $db->query($query);

            if (DB::isError($result)) {
                return PEAR::raiseError("[".get_class($this)." DB_meta : writeMeta()] ".$result->getMessage()."", null,
                    null, null, null, null, false);
            }
        }
    }

    // }}}    

}
?>