<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Clever Age                                                   |
// +----------------------------------------------------------------------+
//
// Base class for any business persistence abstraction.
// $Id$

require_once ("PEAR.php");
require_once (dirname(__FILE__)."/DBManager.php");
require_once (dirname(__FILE__)."/../date.php");
require_once (dirname(__FILE__)."/parameters.php"); 

if (file_exists(dirname(__FILE__)."/../../mes_options.php3")) {
    require_once (dirname(__FILE__)."/../../mes_options.php3");
} else {
    $GLOBALS['table_prefix'] = 'spip';
}

if (!file_exists(dirname(__FILE__)."/inc_config_metier.php")) {
	require_once (dirname(__FILE__)."/inc_config_metier_install.php");
} else {
	require_once (dirname(__FILE__)."/inc_config_metier.php");
}

/**
 * BD_metier is a base class for all business persistence abstraction implementations, and must be
 * inherited by all such.
 * @package	BD
 * @author  Antoine Angenieux <aangenieux@clever-age.com>
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @access	public
 */

class BD_metier {
    // {{{ properties

    /**
     * Parameters instance used for PEAR::DB factory and
     * Metier subclasses factories.
     *
     * @access private
     */
    var $_dbParameters;

    /**
     * DB options array used for PEAR::DB options.
     *
     * @access private
     */
    var $_dbOptions = false;

    /**
     * DB_NestedSet tehcnical manipulation object
     * @var DB_NestedSet_DB
     * @access private
     */
    var $_nestedSet;

    var $nestedset_params = array(
        'id_mot' => 'id',
        'id_root'=> 'rootid',
        'l'      => 'l',
        'r'      => 'r',
        'streh'  => 'norder',
        'level_mot'  => 'level',
        /* Correction S.PETIT - omansour*/
         'titre'  => 'name',
         'descriptif' => 'descriptif',
         'texte' => 'texte',
         'extra' => 'extra',
         'id_groupe' => 'id_groupe',
         'type_mot' => 'type_mot'
         /* fin correction */
    );

    
    var $nestedset_node_table;

    var $nestedset_lock_table;
    
    var $nestedset_sequence_table;

    var $nestedset_secondary_sort = "titre";

    var $nestedset_debug = false;

    // }}}


    function BD_metier(){
        $this->nestedset_node_table= $GLOBALS['table_prefix']."_mots";
        $this->nestedset_lock_table= $GLOBALS['table_prefix']."_lock_mots";
    }
    // {{{ getDbParameters()

    /**
     * Getter method to retreive the instance Parameters object
     *
     * @return      DB parameters
     * @access      public
     */

    function getDbParameters() {
        return $this->_dbParameters;
    }

    // }}}

    // {{{ setDbParameters()

    /**
     * Setter method to set the instance Parameters object
     *
     * @param $dbParameters     new DB parameters
     */

    function setDbParameters($dbParameters) {
        if (strtolower(get_class($dbParameters)) == "bd_parameters") {
            $this->_dbParameters = $dbParameters;
        } else {
            return PEAR::raiseError("Erreur! le parametre de la methode setDbParameters doit etre un objet de la hierarchie DB_parameters !",
                              null, null, null, null, null, false);
        }
    }

    // }}}

    // {{{ getDbParameters()

    /**
     * Getter method to retreive the instance Options array
     *
     * @return      array
     * @access      public
     */

    function getDbOptions() {
        return $this->_dbOptions;
    }

    // }}}

    // {{{ setDbOptions()

    /**
     * Setter method to set the instance Parameters object
     *
     * @param array     array of PEAR::DB options
     */

    function setDbOptions($dbOptions) {
        $this->_dbOptions = $dbOptions;
    }

    // }}}

    // {{{ _traiteQuery()

    /**
     * This protected method is used to keep SPIP compatibility.
     * This is the method where table prefixes must be handled.
     *
     * @param $query        The SQL query that must be "SPIP"ed
     * @return              String representing the modified SQL query
     *
     */

    /* obsolete maintenant */

    function _traiteQuery($query) {
        if ($GLOBALS['mysql_rappel_connexion'] AND $db = $this->_dbParameters->_dbName) {
		    $db = '`'.$db.'`.';
		}
    	// changer les noms des tables ($table_prefix)
    	if (eregi('[[:space:]](VALUES|WHERE)[[:space:]].*$', $query, $regs)) {
    		$suite = $regs[0];
    		$query = substr($query, 0, -strlen($suite));
    	}
    	$query = ereg_replace('([[:space:],])'.$GLOBALS['table_prefix'].'_', '\1'.$db.$GLOBALS['table_prefix'].'_', $query) . $suite;

    	return $query;
    }

    // }}}

    // {{{ _getDB()

    /**
     * Protected method used to get an PEAR::DB instance
     * using the parameters stored in the _dbParameters field
     *
     * @return      Newly creating PEAR::DB object
     *              according to the instance parameters
     * @access private
     */
    function &_getDB($dbParameters = null) {
        require_once "PEAR.php";
        if($dbParameters == null) {
            $DBManager = &DBManager::getDBManager($this->_dbParameters->getDSN(), $this->_dbOptions);
            $db = $DBManager->getDB($this->_dbParameters->getDSN(), $this->_dbOptions);            
        } else {
            $DBManager = &DBManager::getDBManager($dbParameters->getDSN(), $this->_dbOptions);
            $db = $DBManager->getDB($dbParameters->getDSN(), $this->_dbOptions);
        }
        return $db;
    }

    // }}}


    // {{{ _getNestedSetInstance()

    /**
     * This method returns a configured ready-to-use DB_NestedSet/NestedSet instance
     *
     * @access private
     * @return NestedSet instance
     */

    function &_getNestedSetInstance() {
        $db = &$this->_getDB();

        $this->nestedset_node_table = $GLOBALS['table_prefix']."_mots";
        $this->nestedset_lock_table = $GLOBALS['table_prefix']."_lock_mots";
        $this->nestedset_sequence_table =  $GLOBALS['table_prefix']."_mots";

        require_once dirname(__FILE__)."/NestedSetHelper/NestedSet.php";
        $nestedSet = &new NestedSetHelper_NestedSet($db, $this->nestedset_params);

        $nestedSet->node_table = &$this->nestedset_node_table;
        $nestedSet->lock_table = &$this->nestedset_lock_table;
        $nestedSet->sequence_table = &$this->nestedset_sequence_table;
        $nestedSet->secondarySort = &$this->nestedset_secondary_sort;
        $nestedSet->debug = &$this->nestedset_debug;

        return $nestedSet;
    }

    // }}}

    // {{{ _pearIncluded()

    /**
     * Protected method used to check whether we are 
     * in the fast pear-less mode.
     *
     * @return      true if PEAR has been included, false otherwise
     * @access private
     */
    function _pearIncluded() {
        if (defined('PEAR_OS'))
            return true;
        else
            return false;
    }

    // }}}

    // {{{

    //C"est la copie de la methode de inc_filtres. A voir comment
    //merger les deux (attention a la difference par rapport a la gestion des metas)
    // Corrige les caracteres degoutants utilises par les Windozeries
    function corriger_caracteres($texte) {
            static $trans;
            if (!$trans) {
                // 145,146,180 = simple quote ; 147,148 = double quote ; 150,151 = tiret long
                $trans['iso-8859-1'] = array(
                        chr(146) => "'",
                        chr(180) => "'",
                        chr(147) => '&#8220;',
                        chr(148) => '&#8221;',
                        chr(150) => '-',
                        chr(151) => '-',
                        chr(133) => '...'
                );
                $trans['utf-8'] = array(
                        chr(194).chr(146) => "'",
                        chr(194).chr(180) => "'",
                        chr(194).chr(147) => '&#8220;',
                        chr(194).chr(148) => '&#8221;',
                        chr(194).chr(150) => '-',
                        chr(194).chr(151) => '-',
                        chr(194).chr(133) => '...'
                );
                }
				/* On utilise le cache des metas */
				global $meta;
				if (isset($meta))
				{
					$charset = $meta['charset'];
				}
                else
                {
					require_once (dirname(__FILE__)."/inc_meta_factory.php");
    	            $metaMetier = &recuperer_instance_meta();
        	        $loadOK = $metaMetier->load('charset');
            	    if (PEAR::isError($loadOK)) {
                	        die ($loadOK->getMessage());
	                }
    	            $charset = $metaMetier->getValeur();
                }
                if (!$trans[$charset]) return $texte;
                if ($GLOBALS['flag_strtr2']) return strtr($texte, $trans[$charset]);
                reset($trans[$charset]);
                while (list($from, $to) = each($trans[$charset])) 
                        $texte = str_replace($from, $to, $texte);
                return $texte;
        }
        
        
    // {{{
        
    function corriger_null($texte) {
        if ( is_null($texte) || $texte == 'NULL' ) { return ''; }
        else { return $texte; }
    }
    // }}}

    
    // {{{
    
    /** Mise  jour en cascade des objets lis  celui-ci lors de changement de statut. 
     */
    function updateRelatedObjects() {
        $rubriqueMetier = &recuperer_instance_rubrique();

        $parent_rubrique_updated = false; 

        // Changement de statut
        if  ( count($this->_statutsHisto) )  { // le statut a change

            // -- Mise  jour de la rubrique contenant cet objet
            $rubriqueMetier->load($this->getRubriqueId());
            $parent_rubrique_updated = $rubriqueMetier->checkStatutDateAndUpdate($rubriqueMetier->getRubriqueId());
        }
        
        // Changement de date
        if ( (count($this->_datesHisto)) and (!$parent_rubrique_updated) )  { // la date a changee ... ok on la verifie
            $rubriqueMetier->load($this->getRubriqueId());
            $dateCalcul = $rubriqueMetier->getDateFromRubrique($rubriqueMetier->getRubriqueId());
            $dateRubrique = new Date( $rubriqueMetier->getDate() );
            if (Date::compare($dateCalcul, $dateRubrique) != 0) { 
                $rubriqueMetier->setDate($dateCalcul->getDate());
                // $rubriqueMetier->update(); 
                $rubriqueMetier->update(); // va enclencher la recursivite
            }
        }
        
        $rubriqueIds = array ();
        // detection du changement de rubrique pour les objets diffrents des rubriques
        $rubriqueIds[] = array(); 
        if (isset ($this->_rubriqueIdsHisto)) { 
            $rubriqueIds = $this->getRubriqueIdsHisto(); 
            $rubriqueIds[] = $this->getRubriqueId();
        }
        
        $rubriqueIds = array_unique( $rubriqueIds );

        // changement de rubriques 
        if ( count($rubriqueIds) > 1 ) { // on a change de rubrique
            // echo 'on a change de rubrique'; 
            foreach ($rubriqueIds as $rubId) {
                $update =  false;
                $rubriqueMetier->load($rubId);
                $update = $rubriqueMetier->checkStatutDateAndUpdate($rubriqueMetier->getRubriqueId());
                
                if ($update) {
                    // $rubriqueMetier->update();
                } else { // update du parent mais .... pourquoi ? 
                    if ($rubriqueMetier->getParentId() > 0) { 
                        $rubriqueMetierParent = &recuperer_instance_rubrique();  
                        $rubriqueMetierParent->load($rubriqueMetier->getParentId()); // charge la rubrique parente
                        $rubriqueMetierParent->checkStatutDateAndUpdate($rubriqueMetier->getParentId());
                    }
                }
            }
        }
        
        unset ($rubriqueMetier);
    
    }
    
    // }}}

     // {{{

    /** Renvoie l'URL vers la page de l'objet 
     * @param      bool     $edit      Url vers la page de consultation ($edit == false) ou d'dition ($edit == true)
     * @return     string
     * @abstract   Cette mthode doit tre surcharge dans les classes descendantes de bd_metier.
     */
    function getUrl( $edit = false ) { 
        if ( get_class($this) == 'bd_metier' ) { 
            trigger_error( 'Cette mthode doit tre surcharge dans les classes descendantes de bd_metier.', E_WARNING ); 
        }
    }

    // }}}
     
     
    // {{{
    
    function accept( &$renderer ) {
        $renderer->visit( $this );
    }

    // }}}
    
    // {{{ getChildObject($objectname)
    /**  
     * @param string objectname
     * @return object 
     * @abstract revoie un object mtier selon le parametre pass - peut tre appel statiquement
     */

    function getChildObject($objectname) {
        
        // les articles
        if (strpos($objectname, 'article') !== false) {
       
            include_once (dirname(__FILE__). '/inc_article_factory.php');
            $obj = & recuperer_instance_article(); 
            return $obj;
        }
        // les breves
        if (strpos($objectname, 'breve') !== false) {
            include_once (dirname(__FILE__). '/inc_breve_factory.php');
            $obj = & recuperer_instance_breve(); 
            return $obj;
        }
        // les rubriques
        if (strpos($objectname, 'rubrique') !== false) {
            include_once (dirname(__FILE__). '/inc_rubrique_factory.php');
            $obj = & recuperer_instance_rubrique(); 
            return $obj;
        }
        // les auteurs
        if (strpos($objectname, 'auteur') !== false) {
            include_once (dirname(__FILE__). '/inc_auteur_factory.php');
            $obj = & recuperer_instance_auteur(); 
            return $obj;
        }
        // les mots
        if (strpos($objectname, 'mot') !== false) {
            include_once (dirname(__FILE__). '/inc_mot_factory.php');
            $obj = & recuperer_instance_mot(); 
            return $obj;
        }
        // les sites
        if ((strpos($objectname, 'site')  !== false) or (strpos($objectname, 'syndic')  !== false )) {
            include_once (dirname(__FILE__). '/inc_syndic_factory.php');
            $obj = & recuperer_instance_syndic(); 
            return $obj;
        }
        
        // cas par dfaut : 
        return PEAR::raiseError("impossible de crer un objet avec $objectname",
                              null, null, null, null, null, false);
    }
    
    
    
    // }}}
}

?>
