<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Erwan LE BESCOND <elebescond@clever-age.com>                 |
// | Author: Antoine ANGENIEUX<aangenieux@clever-age.com>                 |
// |         (contribution for handling trees of keywords)
// +----------------------------------------------------------------------+
//
// Base class for Mot business persistence abstraction.
//

require_once dirname(__FILE__)."/metier.php";

//Configuration data for DB_NestedSet use

define("MOT_ALL_FIELDS", " id_mot, type_mot, titre, descriptif, texte, id_groupe, maj, extra ");
define("MOT_ALL_FIELDS_EXCEPT_MAJ", " id_mot, type_mot, titre, descriptif, texte, id_groupe, extra ");

/**
 * BD_mot is a base class for mot business persistence abstraction implementations, and must be
 * inherited by all such.
 * @package	BD
 * @author  Antoine Angnieux <aangenieux@clever-age.com>
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @access	public
 */
class BD_mot extends BD_metier {

    // {{{ properties

    /**
     * Mot ID.
     * @var     int
     * @access  private
     */
    var $_motId;

    /**
     * type.
     * @var     String
     * @access  private
     */
    var $_type;

    /**
     * Title.

     * @var     String
     * @access  private
     */
    var $_titre;

    /**
     * Description.
     * @var     String
     * @access  private
     */
    var $_descriptif;

    /**
     * Text.
     * @var     String
     * @access  private
     */
    var $_texte;

    /**
     * Group ID.
     * @var     int
     * @access  private
     */
    var $_groupeId;

    /**
     * Update Date.
     * @var     Date
     * @access  private
     */
    var $_majDate;

    /**
     * extra fields.
     * @var     String
     * @access  private
     */
    var $_extra;

    // }}}

    // {{{ factory()
    function &factory($dbParameters = null, $dbOptions = null) {

        if(file_exists(dirname(__FILE__)."/".$dbParameters->_dbEngine."/mot_".$dbParameters->_dbEngine.".php") == false) {
            include_once(dirname(__FILE__)."/common/mot_common.php");
            $classname = "BD_mot_common";
        }
        else {
            include_once(dirname(__FILE__)."/".$dbParameters->_dbEngine."/mot_".$dbParameters->_dbEngine.".php");
            $classname = "BD_mot_".$dbParameters->_dbEngine;
        }

        if (!class_exists($classname)) {
            return PEAR::raiseError("Cannot instanciate class $classname", null,
                                    null, null, null, null, false);
        }

        $obj =& new $classname;

        $result = $obj->setDbParameters($dbParameters);
        if ($dbOptions != null) {
            $obj->setDbOptions($dbOptions);
        }
        if (PEAR::isError($result)) {
            return $result;
        } else {
            return $obj;
        }
    }

    // }}}

    // {{{ constructor

    /**
     * DB_mot constructor.
     *
     * @access public
     */

    function BD_mot() {
    }

    // }}}

    // {{{ getMotId()

    /**
     * Returns the Mot ID
     * @return  int
     * @access  public
     */

    function getMotId() {
        return $this->_motId;
    }

    // }}}

    // {{{ setMotId()

    /**
     * Sets the Mot ID
     * @param   int
     * @access  public
     */

    function setMotId($motId) {
        $this->_motId = $motId;
    }

    // }}}

    // {{{ getType()

    /**
     * Returns the Type
     * @return  String
     * @access  public
     */

    function getType() {
        return $this->_type;
    }

    // }}}

    // {{{ setType()

    /**
     * Sets the Type
     * @param   String
     * @access  public
     */

    function setType($type) {
        $this->_type = $this->corriger_caracteres($type);
    }

    // }}}

    // {{{ getTitre()

    /**
     * Returns the word title
     * @return  String
     * @access  public
     */

    function getTitre() {
        return $this->_titre;
    }

    // }}}

    // {{{ setTitre()

    /**
     * Sets the word title
     * @param   String
     * @access  public
     */

    function setTitre($titre) {
        $this->_titre = $this->corriger_caracteres($titre);
    }

    // }}}

    // {{{ getDescriptif()

    /**
     * Returns the word description
     * @return  String
     * @access  public
     */

    function getDescriptif() {
        return $this->_descriptif;
    }

    // }}}

    // {{{ setDescriptif()

    /**
     * Sets the word description
     * @param   String
     * @access  public
     */

    function setDescriptif($descriptif) {
        $this->_descriptif = $this->corriger_caracteres($descriptif);
    }

    // }}}

    // {{{ getTexte()

    /**
     * Returns the word text
     * @return  String
     * @access  public
     */

    function getTexte() {
        return $this->_texte;
    }

    // }}}

    // {{{ setTexte()

    /**
     * Sets the word text
     * @param   String
     * @access  public
     */

    function setTexte($texte) {
        $this->_texte = $this->corriger_caracteres($texte);
    }

    // }}}

    // {{{ getGroupeId()

    /**
     * Returns the Group ID
     * @return  int
     * @access  public
     */

    function getGroupeId() {
        return $this->_groupeId;
    }

    // }}}

    // {{{ setGroupeId()

    /**
     * Sets the Group ID
     * @param   int
     * @access  public
     */

    function setGroupeId($groupeId) {
        $this->_groupeId = $groupeId;
    }

    // }}}

    // {{{ getMajDate()

    /**
     * Returns the word update date
     * @return  Date
     * @access  public
     */

    function getMajDate() {
        return $this->_majDate;
    }

    // }}}

    // {{{ setMajDate()

    /**
     * Sets the word update date
     * @param   Date
     * @access  public
     */

    function setMajDate($majDate) {
        $this->_majDate = $majDate;
    }

    // }}}

    // {{{ getExtra()

    /**
     * Returns the word extra fields
     * @return  String
     * @access  public
     */

    function getExtra() {
        return $this->_extra;
    }

    // }}}

    // {{{ setExtra()

    /**
     * Sets the word extra fields
     * @param   String
     * @access  public
     */

    function setExtra($extra) {
        $this->_extra = $extra;
    }

    // }}}

    // {{{ _getNestedSet()

    /**
     * Returns the reference to the technical nested set object.
     * @return  DB_NestedSet
     * @access  private
     */

    function &_getNestedSet() {
        return $this->_nestedSet;
    }

    // }}}

    // {{{ _setNestedSet()

    /**
     * Sets the technical nested set used for tree manipulation.
     * @param   DB_NestedSet_DB PEAR::DB implementation for compatibility
     *                          with this abstraction layer
     * @access private
     */

    function _setNestedSet(&$nestedSet) {
        $this->_nestedSet = &$nestedSet;
    }

    // }}}

    // {{{ create()

    function create($motId = null, $specificTTL = null) {
        
        $nestedSet = &$this->_getNestedSetInstance();
        if ($specificTTL != null) {
        	$nestedSet->lockTTL = $specificTTL;
        }

        $values = array (
            'type_mot'      => $this->_type,
            'titre'     => $this->_titre,
            'descriptif'=> $this->_descriptif,
            'texte'     => $this->_texte,
            'id_groupe' => $this->_groupeId,
            'extra' => $this->_extra
        );
        

        if ($motId == null) {
            $this->_motId = $nestedSet->createRootNode($values);
        } else {
            $this->_motId = $nestedSet->createSubNode($motId, $values);
        }

        if (PEAR::isError($this->_motId)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : create()] ".$this->_motId->getMessage()."", null,
                null, null, null, null, false);
        }
        
        /*
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : create()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        $motId = $db->nextId('".$GLOBALS['table_prefix']."_mots', true);
        if (DB::isError($motId)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : create()] ".$motId->getMessage()."", null,
                null, null, null, null, false);
        }

        $this->_motId = $motId;

        if($this->_groupeId == null) $this->_groupeId = 0;

        $query = "INSERT INTO ".$GLOBALS['table_prefix']."_mots (".MOT_ALL_FIELDS_EXCEPT_MAJ.") VALUES "
                ."(".$this->_motId.", "
                ."'".$db->quoteString($this->_type)."', "
                ."'".$db->quoteString($this->_titre)."', "
                ."'".$db->quoteString($this->_descriptif)."', "
                ."'".$db->quoteString($this->_texte)."', "
                .$this->_groupeId.")";

         

        //echo "<br><br>$query<br><br>";

        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : create()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        */
    }

    // }}}

    // {{{ update()

    function update() {
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : update()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        $maDate = new Date();
	    $this->setMajDate($maDate->getDate(DATE_FORMAT_ISO));

        $query = "UPDATE ".$GLOBALS['table_prefix']."_mots "
                ."SET id_mot = ".$this->_motId.", "
                ."type_mot = '".$db->quoteString($this->_type)."', titre = '".$db->quoteString($this->_titre)."', "
                ."descriptif = '".$db->quoteString($this->_descriptif)."', texte = '".$db->quoteString($this->_texte)."', "
                ."id_groupe = ".$this->_groupeId.", maj = '".$db->quoteString($this->_majDate)."', "
                ."extra = '".$db->quoteString($this->_extra)."' "
                ."WHERE id_mot = ".$this->_motId;

         
         
        //echo '<br>' . $query . '<br>';

        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : update()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

    }

    // }}}

    // {{{ load()

    function load($idMot) {
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : load()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT ".MOT_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_mots WHERE id_mot = $idMot";

         

        //echo '<br>' . $query . '<br>';

        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : load()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
            if ($row = $result->fetchRow()) {

                $maDate = new Date($row['maj']);
                $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

                $this->_fetchData($row);
            } else {
                return PEAR::raiseError("[".get_class($this)." DB_mot : load($idMot)] Aucun mot ne correspond pas  cet ID!", null,
                                    null, null, null, null, false);
            }
            $result->free();
        }
    }

    // }}}

    // {{{ delete()

    function delete($idMot) {
        /*
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : delete()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_mots WHERE id_mot = $idMot";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : delete()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        */
        $db = &$this->_getNestedSetInstance();
        $db->deleteNode($idMot);
    }

    // }}}

    // {{{ _fetchData()

    function _fetchData($row) {
        $this->setMotId($row['id_mot']);
        $this->setType($row['type_mot']);
        $this->setTitre($row['titre']);
        $this->setDescriptif($row['descriptif']);
        $this->setTexte($row['texte']);
        $this->setGroupeId($row['id_groupe']);
        $this->setMajDate($row['maj']);
        $this->setExtra($row['extra']);
    }

    // }}}

    // {{{ deleteMajDate($myDate)

    /**
     * This method is used to delete all words former to mydate
     * @access  public
     */

    function deleteMajDate($myDate) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : deleteMajDate()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $dateTmp = new Date($mydate);
        $mydate = $dateTmp->getDate(DATE_FORMAT_ISO);

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_mots WHERE maj < '$myDate'";

         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : deleteMajDate()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ getAllMotIds()

    function getAllMotIds() {
        $motIds = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : getAllMotIds()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT id_mot FROM ".$GLOBALS['table_prefix']."_mots";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : getAllMotIds()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $result->fetchRow()) {    $motIds[] = $row['id_mot'];}
        $result->free();
        return $motIds;
    }

    // }}}

    // {{{ getAllTypes()

    function getAllTypes() {
        $types = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : getAllTypes()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT DISTINCT type_mot FROM ".$GLOBALS['table_prefix']."_mots";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : getAllTypes()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $result->fetchRow()) {    $types[] = $row['type_mot'];}
        $result->free();
        return $types;
    }

    // }}}

    // {{{ updateNullType($newType)

    function updateNullType($newType) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : updateNullType()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "UPDATE ".$GLOBALS['table_prefix']."_mots SET type_mot='Mots sans groupe...' WHERE type_mot=''";
         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : updateNullType()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ updateGroupeIdForType($id_groupe, $type)

    function updateGroupeIdForType($id_groupe, $type) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : updateGroupeIdForType()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "UPDATE ".$GLOBALS['table_prefix']."_mots SET id_groupe = $id_groupe WHERE type_mot=\"$type\"";
         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : updateGroupeIdForType()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ updateTypeForGroupeId($type, $id_groupe)

    function updateTypeForGroupeId($change_type, $id_groupe) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : updateTypeForGroupeId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "UPDATE ".$GLOBALS['table_prefix']."_mots SET type_mot='" . $db->quoteString($change_type) . "' WHERE id_groupe=$id_groupe";

         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : updateTypeForGroupeId()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ addMot($table, $id_table, $id_mot, $id_table_value)

    function addMot($table, $id_table, $id_mot, $id_table_value) {
        
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : addMot()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "INSERT INTO ".$GLOBALS['table_prefix']."_mots_".$table." (id_mot, ".$id_table.") VALUES ($id_mot, $id_table_value)";
         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : addMot()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ deleteForTitle($titre)

    function deleteForTitle($titre) {

        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : deleteForTitle()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_mots WHERE titre=$titre";
         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : deleteForTitle()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ deleteMotTable($table, $id_table, $id_message, $supp_mot = -1)

    function deleteMotTable($table, $id_table, $id_message, $supp_mot = -1) {

        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : deleteMotTable()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }


        if ($supp_mot == -1)
            $mots_supp = "";
        else
		    $mots_supp = " AND id_mot=$supp_mot";

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_mots_$table WHERE $id_table=$id_message $mots_supp";
         
		//echo '<br>' . $query . '<br>';

        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : deleteMotTable()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ deleteMotTableForTableIdNotIn($table, $id_table, $values)

    function deleteMotTableForTableIdNotIn($table, $id_table, $values) {

        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : deleteMotTableForTableIdNotIn()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_mots_$table WHERE $id_table NOT IN ($values)";
         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : deleteMotTableForTableIdNotIn()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ deleteForTitleAndMaj($titre, $mydate)

    function deleteForTitleAndMaj($titre, $mydate) {

        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : deleteForTitleAndMaj()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $dateTmp = new Date($mydate);
        $mydate = $dateTmp->getDate(DATE_FORMAT_ISO);

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_mots WHERE titre LIKE ".$db->quote($titre)." AND maj < '$mydate'";
         
        //echo $query.'<br>';
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : deleteForTitleAndMaj()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ getAllFromMotsAndAnotherTable($table, $id_table, $id_objet)

    /**
     * Returns an array of Mots.
     *
     *
     * @return Array of Mot
     * @param $table
     * @param $id_table
     * @param $id_objet
     * @access public
     */

    function &getAllFromMotsAndAnotherTable($table, $id_table, $id_objet, $orderBy = false) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : getAllFromMotsAndAnotherTable()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT mots.* FROM ".$GLOBALS['table_prefix']."_mots mots, ".$GLOBALS['table_prefix']."_mots_$table lien WHERE lien.$id_table=$id_objet AND mots.id_mot=lien.id_mot";
         
		//echo '<br>--> ' . $query . '<br>';

        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : getAllFromMotsAndAnotherTable()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultMot = &BD_mot::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultMot->_fetchData($row);

            $result[] = &$resultMot;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ getAllFromMotsAndAnotherTableAndGroupId($table, $id_table, $id_objet, $id_groupe)

    /**
     * Returns an array of Mots.
     *
     *
     * @return Array of Mot
     * @param $table
     * @param $id_table
     * @param $id_objet
     * @access public
     */

    function &getAllFromMotsAndAnotherTableForGroupId($table, $id_table, $id_objet, $id_groupe) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : getAllFromMotsAndAnotherTableForGroupId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT mots.* FROM ".$GLOBALS['table_prefix']."_mots mots, ".$GLOBALS['table_prefix']."_mots_$table lien, ".$GLOBALS['table_prefix']."_groupes_mots groupe WHERE groupe.id_groupe=$id_groupe AND groupe.id_groupe = mots.id_groupe AND lien.$id_table=$id_objet AND mots.id_mot=lien.id_mot";
         
		//echo '<br>--> ' . $query . '<br>';

        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : getAllFromMotsAndAnotherTableForGroupId()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultMot = &BD_mot::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultMot->_fetchData($row);

            $result[] = &$resultMot;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ getAllFromMotsAndAnotherTableAndGroupId($table, $id_table, $id_objet, $id_groupe)

    /**
     * Returns an array of Mots.
     *
     *
     * @return Array of Mot
     * @param $table
     * @param $id_table
     * @param $id_objet
     * @access public
     */

    function &hasMotsAndAnotherTableForGroupId($table, $id_table, $id_objet, $id_groupe) {
        $result = false;
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : getAllFromMotsAndAnotherTableForGroupId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT count(mots.id_mot) AS num FROM ".$GLOBALS['table_prefix']."_mots mots, ".$GLOBALS['table_prefix']."_mots_$table lien, ".$GLOBALS['table_prefix']."_groupes_mots groupe WHERE groupe.id_groupe=$id_groupe AND groupe.id_groupe = mots.id_groupe AND lien.$id_table=$id_objet AND mots.id_mot=lien.id_mot";
         
		//echo '<br>--> ' . $query . '<br>';

        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : getAllFromMotsAndAnotherTableForGroupId()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $result = $row["num"];
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ getAllFromAnotherTable($table, $id_table, $id_mot)

    /**
     * Returns an array of Mots_table.
     *
     *
     * @return Array of MotTable
     * @param $table
     * @param $id_table
     * @param $id_mot
     * @access public
     */

    function &getAllFromAnotherTable($table, $id_table, $id_mot) {
        $tableIds = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : getAllFromAnotherTable()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "Select $id_table FROM ".$GLOBALS['table_prefix']."_mots_$table WHERE id_mot=".$id_mot."";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : getAllFromAnotherTable()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $result->fetchRow()) {    $tableIds[] = $row['id_mot'];}
        $result->free();
        return $tableIds;
    }

    // }}}

    // {{{ getAllForForumId($id_message)

    /**
     * Returns an array of Mots.
     *
     *
     * @return Array of Mot
     * @param $id_message
     * @access public
     */

    function &getAllForForumId($id_message) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : getAllForForumId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT mots.id_mot, type_mot, titre, descriptif, texte, id_groupe, maj FROM ".$GLOBALS['table_prefix']."_mots_forum lien, ".$GLOBALS['table_prefix']."_mots mots WHERE id_forum=$id_message AND mots.id_mot = lien.id_mot";
         
        //echo "<br>$query<br>";


        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : getAllForForumId()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultMot = &BD_mot::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultMot->_fetchData($row);

            $result[] = &$resultMot;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ getAllMotIdsForRubrique()

    /**
     * Returns an array of Mots.
     *
     *
     * @return Array of Mot
     * @param $id_message
     * @access public
     */

    function &getAllMotIdsForRubrique() {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : getAllMotIdsForRubrique()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT COUNT(*) AS cnt, mots.id_mot FROM ".$GLOBALS['table_prefix']."_mots_rubriques lien, ".$GLOBALS['table_prefix']."_rubriques rubrique, ".$GLOBALS['table_prefix']."_mots mots WHERE lien.id_mot=mots.id_mot AND rubrique.id_rubrique=lien.id_rubrique GROUP BY mots.id_mot";
         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : getAllMotIdsForRubrique()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $result[] = $row;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ getAllForGroupIdAndMotId($id_groupe, $les_mots = null)

    function &getAllForGroupIdAndMotId($id_groupe, $les_mots = null) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : getAllForGroupIdAndMotId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT ".MOT_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_mots WHERE id_groupe = $id_groupe ";
		if ($les_mots != null) $query .= "AND id_mot NOT IN ($les_mots) ";
		$query .= "ORDER BY type_mot, titre";
         
        //echo "<br>-->$query<br>";

        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : getAllForGroupIdAndMotId()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultMot = &BD_mot::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultMot->_fetchData($row);

            $result[] = &$resultMot;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ getAllMotsForGroupeId($selectGroupe)

    /**
     * Returns an array of Mots.
     *
     *
     * @return Array of Mot
     * @param $seidObjet
     * @access public
     */

    function &getAllMotsForGroupeId($selectGroupe, $critere = false) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : getAllMotsForGroupeId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT ".MOT_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_mots WHERE id_groupe=$selectGroupe";

        if($critere!=false) $query .= " ORDER BY $critere";
         
        //echo "<br>$query<br>";
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : getAllMotsForGroupeId()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultMot = &BD_mot::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultMot->_fetchData($row);

            $result[] = &$resultMot;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ getAllMotsForMotId($les_mots,"titre")

    /**
     * Returns an array of Mots.
     *
     *
     * @return Array of Mot
     * @param $les_mots
     * @param $critere
     * @access public
     */

    function &getAllMotsForMotId($les_mots,$critere) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : getAllMotsForMotId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT ".MOT_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_mots WHERE id_mot IN ($les_mots) ORDER BY $critere";
         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : getAllMotsForMotId()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultMot = &BD_mot::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultMot->_fetchData($row);

            $result[] = &$resultMot;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ exist($table, $id_table, $nouv_mot, $id_objet)

    /**
     * Returns an boolean.
     *
     *
     * @return boolean
     * @param $table
     * @param $id_table
     * @param $nouv_mot
     * @param $id_objet
     * @access public
     */

    function exist($table, $id_table, $nouv_mot, $id_objet) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : exist()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT * FROM ".$GLOBALS['table_prefix']."_mots_$table WHERE id_mot=$nouv_mot AND $id_table=$id_objet";
         
        //echo "<br>$query<br>";

        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : exist()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        if($result->numRows() == 0) {
            $result->free();
            return false;
        }
        else {
            $result->free();
            return true;
        }

        return $tableIds;
    }

    // }}}

    // {{{ getAllMotIdsForArticleStatut($aff_articles, $statut)

    /**
     * Returns an array of Mots.
     *
     *
     * @return Array of Mot
     * @param $id_message
     * @access public
     */

    function &getAllMotIdsForArticleStatut($aff_articles, $statut) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : getAllMotIdsForArticleStatut()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT COUNT(*) as cnt, mots.id_mot FROM ".$GLOBALS['table_prefix']."_mots_articles lien, ".$GLOBALS['table_prefix']."_articles article, ".$GLOBALS['table_prefix']."_mots mots"
			. " WHERE lien.id_mot=mots.id_mot AND article.id_article=lien.id_article"
			. " AND article.statut LIKE '%$aff_articles%' AND article.statut!='$statut' GROUP BY mots.id_mot";
        /*
        $query = "SELECT COUNT(*) as cnt, mots.id_mot FROM ".$GLOBALS['table_prefix']."_mots_articles lien, ".$GLOBALS['table_prefix']."_articles article, ".$GLOBALS['table_prefix']."_mots mots"
			. " WHERE lien.id_mot=mots.id_mot AND article.id_article=lien.id_article"
			. " AND FIND_IN_SET(article.statut,'$aff_articles')>0 AND article.statut!='$statut' GROUP BY mots.id_mot";
        */
         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : getAllMotIdsForArticleStatut()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $result[] = $row;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ getAllMotIdsForBreveStatut($aff_articles, $statut)

    /**
     * Returns an array of Mots.
     *
     *
     * @return Array of Mot
     * @param $id_message
     * @access public
     */

    function &getAllMotIdsForBreveStatut($aff_articles, $statut) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : getAllMotIdsForBreveStatut()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT COUNT(*) AS cnt, mots.id_mot FROM ".$GLOBALS['table_prefix']."_mots_breves lien, ".$GLOBALS['table_prefix']."_breves breve, ".$GLOBALS['table_prefix']."_mots mots"
			. " WHERE lien.id_mot=mots.id_mot AND breve.id_breve=lien.id_breve"
			. " AND breve.statut LIKE '%$aff_articles%' AND breve.statut!='$statut' GROUP BY mots.id_mot";
        /*
        $query = "SELECT COUNT(*) AS cnt, mots.id_mot FROM ".$GLOBALS['table_prefix']."_mots_breves lien, ".$GLOBALS['table_prefix']."_breves breve, ".$GLOBALS['table_prefix']."_mots mots"
			. " WHERE lien.id_mot=mots.id_mot AND breve.id_breve=lien.id_breve"
			. " AND FIND_IN_SET(breve.statut,'$aff_articles')>0 AND breve.statut!='$statut' GROUP BY mots.id_mot";
        */
         
        //echo $query;
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : getAllMotIdsForBreveStatut()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $result[] = $row;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ getAllMotIdsForSyndicStatut($aff_articles, $statut)

    /**
     * Returns an array of Mots.
     *
     *
     * @return Array of Mot
     * @param $id_message
     * @access public
     */

    function &getAllMotIdsForSyndicStatut($aff_articles, $statut) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : getAllMotIdsForSyndicStatut()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT COUNT(*) AS cnt, mots.id_mot FROM ".$GLOBALS['table_prefix']."_mots_syndic lien, ".$GLOBALS['table_prefix']."_syndic syndic, ".$GLOBALS['table_prefix']."_mots mots"
			. " WHERE lien.id_mot=mots.id_mot AND syndic.id_syndic=lien.id_syndic"
			. " AND syndic.statut LIKE '$%aff_articles%' AND syndic.statut!='$statut' GROUP BY mots.id_mot";

        /*
        $query = "SELECT COUNT(*) AS cnt, mots.id_mot FROM ".$GLOBALS['table_prefix']."_mots_syndic lien, ".$GLOBALS['table_prefix']."_syndic syndic, ".$GLOBALS['table_prefix']."_mots mots"
			. " WHERE lien.id_mot=mots.id_mot AND syndic.id_syndic=lien.id_syndic"
			. " AND FIND_IN_SET(syndic.statut,'$aff_articles')>0 AND syndic.statut!='$statut' GROUP BY mots.id_mot";
        */
         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : getAllMotIdsForSyndicStatut()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $result[] = $row;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ getAllMotIdsForArticles($aff_articles)

    /**
     * Returns an array of Mots.
     *
     *
     * @return Array of Mot
     * @param $id_message
     * @access public
     */

    function &getAllMotIdsForArticles($aff_articles) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : getAllMotIdsForArticles()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT COUNT(*) as cnt, lien.id_mot FROM ".$GLOBALS['table_prefix']."_mots_articles lien, ".$GLOBALS['table_prefix']."_articles article WHERE article.id_article=lien.id_article AND article.statut IN ($aff_articles) GROUP BY lien.id_mot";
         
        //echo '<br />' . $query .  '<br />';


        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : getAllMotIdsForArticles()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $result[] = $row;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ getAllMotIdsForBreves($aff_articles)

    /**
     * Returns an array of Mots.
     *
     *
     * @return Array of Mot
     * @param $id_message
     * @access public
     */

    function &getAllMotIdsForBreves($aff_articles) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : getAllMotIdsForBreves()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }


        $query = "SELECT COUNT(*) AS cnt, lien.id_mot FROM ".$GLOBALS['table_prefix']."_mots_breves lien, ".$GLOBALS['table_prefix']."_breves breve WHERE breve.id_breve=lien.id_breve AND breve.statut IN ($aff_articles) GROUP BY lien.id_mot";
         
        //echo $query;
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : getAllMotIdsForBreves()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $result[] = $row;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ getAllMotIdsForSyndics($aff_articles)

    /**
     * Returns an array of Mots.
     *
     *
     * @return Array of Mot
     * @param $id_message
     * @access public
     */

    function &getAllMotIdsForSyndics($aff_articles) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : getAllMotIdsForSyndics()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT COUNT(*) AS cnt, mots.id_mot FROM ".$GLOBALS['table_prefix']."_mots_syndic lien, ".$GLOBALS['table_prefix']."_syndic syndic, ".$GLOBALS['table_prefix']."_mots mots"
			. " WHERE lien.id_mot=mots.id_mot AND syndic.id_syndic=lien.id_syndic"
			. " AND syndic.statut LIKE '$%aff_articles%' AND syndic.statut!='$statut' GROUP BY mots.id_mot";

        /*
        $query = "SELECT COUNT(*) AS cnt, mots.id_mot FROM ".$GLOBALS['table_prefix']."_mots_syndic lien, ".$GLOBALS['table_prefix']."_syndic syndic, ".$GLOBALS['table_prefix']."_mots mots"
			. " WHERE lien.id_mot=mots.id_mot AND syndic.id_syndic=lien.id_syndic"
			. " AND FIND_IN_SET(syndic.statut,'$aff_articles')>0 AND syndic.statut!='$statut' GROUP BY mots.id_mot";
        */
         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : getAllMotIdsForSyndics()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $result[] = $row;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ howManyMotIdsForMotIdandArticleStatut($id_mot, $aff_articles, $statut)

    /**
     * Returns an array of Mots.
     *
     *
     * @return Array of Mot
     * @param $id_message
     * @access public
     */

    function howManyMotIdsForMotIdandArticleStatut($id_mot, $aff_articles, $statut) {
        $howManyMotIds = 0;
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : howManyMotIdsForMotIdandArticleStatut()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT COUNT(*) as cpt FROM ".$GLOBALS['table_prefix']."_mots_articles lien, ".$GLOBALS['table_prefix']."_articles article WHERE lien.id_mot=$id_mot AND article.id_article=lien.id_article AND article.statut LIKE '%$aff_articles%' AND article.statut!='$statut'";
        //$query = "SELECT COUNT(*) as cpt FROM ".$GLOBALS['table_prefix']."_mots_articles lien, ".$GLOBALS['table_prefix']."_articles article WHERE lien.id_mot=$id_mot AND article.id_article=lien.id_article AND FIND_IN_SET(article.statut,'$aff_articles')>0 AND article.statut!='$statut'";
         
        //echo $query;
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : howManyMotIdsForMotIdandArticleStatut()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        if($row = $queryResult->fetchRow()) $howManyMotIds = $row['cpt'];

        $queryResult->free();
        return $howManyMotIds;
    }

    // }}}

    // {{{ isLeaf()

    /**
     * This method returns true if the current keywork is a leaf in the keywords tree
     * false otherwise
     *
     * @return  boolean
     * @access  public
     */

    function isLeaf() {
        $db = &$this->_getNestedSetInstance();
        $sons = $db->getSubBranch($this->_motId);
        return (count($sons) == 0);
    }

    // }}}

    // {{{ getDescendents()

    /**
     *
     *
     *
     **/

    function getBranch($ids) {
        if (is_array($ids)) {
            $db = $this->_getNestedSetInstance();
            while (list(, $id) = each($ids)) {
                $nodes = $db->getSubBranch($id);
                while (list($nodeId, ) = each($nodes)) {
                    $result[] = $nodeId;
                }
                $nodes = $db->getParents($id);
                while (list($nodeId, ) = each($nodes)) {
                    $result[] = $nodeId;
                }
            }
        }
        return $result;
    }

    // }}}

    function getSubBranchIds($id) {
        $db = $this->_getNestedSetInstance();

        $nodes = $db->getSubBranch($id, true);
        $result[] = $id;
        if($nodes) {
            while(list(, $myNode) = each($nodes)) {
                $result[] = $myNode['id'];
            }
        }
        return $result;
    }


    function getParentId($id) {
        $db = $this->_getNestedSetInstance();

        $db->_debugMessage('getParents($id)');
        if (!($child = $db->_getNodeObject($id))) {
            return false;
        }

        $sql = sprintf('SELECT %s FROM %s WHERE %s=%s AND %s=%s AND %s<%s AND %s>%s ORDER BY %s ASC',
                            $db->_getSelectFields($aliasFields),
                            $db->node_table,
                            $db->flparams['rootid'],
                            $child->rootid,
                            $db->flparams['level'],
                            $child->level-1,
                            $db->flparams['l'],
                            $child->l,
                            $db->flparams['r'],
                            $child->r,
                            $db->flparams['level']
               );
               //echo '>>>>>' . $sql . '<br>';
        return $db->_processResultSet($sql, true, false);
    }

    function getEnfantIds($id) {
        $db = $this->_getNestedSetInstance();

        $db->_debugMessage('getParents($id)');
        if (!($child = $db->_getNodeObject($id))) {
            return false;
        }

        $sql = sprintf('SELECT %s FROM %s WHERE %s=%s AND %s=%s AND %s>%s AND %s<%s ORDER BY %s ASC',
                            $db->_getSelectFields($aliasFields),
                            $db->node_table,
                            $db->flparams['rootid'],
                            $child->rootid,
                            $db->flparams['level'],
                            $child->level+1,
                            $db->flparams['l'],
                            $child->l,
                            $db->flparams['r'],
                            $child->r,
                            $db->flparams['level']
               );
               //var_dump ($db->flparams);
               //echo '>>>>>R' . $sql . '<br>';
        return $db->_processResultSet($sql, true, false);
    }

    // {{{ getGranularityImpactedMot()

    /**
     *
     *
     *
     */

    function getGranularityImpactedMot($motToCheck, $motsSelected) {
        $db = $this->_getNestedSetInstance();
        $impacted = array();

        while (list(, $currentMot) = each($motsSelected)) {
            // Si le nouveau mot cl et un mot slectionn de l'arborescence sont dans la mme branche
            // alors il y a changement de granularit pour le mot slectionn ! (simple, non?)
            $motToCheckNode = $db->pickNode($motToCheck);
            $currentMotNode = $db->pickNode($currentMot);
            if ($db->isParent($motToCheckNode, $currentMotNode) || $db->isParent($currentMotNode, $motToCheckNode)) {
                $impacted[] = $currentMot;
            }
        }
        reset($motsSelected);
        return $impacted;
    }

    //

    // {{{ getCheminMot()

    /**
     * This method returns the path from the root node to the current node
     * as an array of Mot.
     * @return  String   path to this Mot
     * @access  public
     */

    function getCheminMot() {
        $db = &$this->_getNestedSetInstance();
        $nodes = &$db->getParents($this->getMotId());
        $result = '';
        while (list(, $currentNode) = each($nodes)) {
            $result .= $currentNode->name . '&nbsp; > &nbsp;';
        }

        return $result;

    }

    // }}}

    function getHierarchie($id_mot) {
        $result = array();
        $db = &$this->_getNestedSetInstance();
        $nodes = &$db->getParents($id_mot);

        //$result[] = $id_mot;
        $result = array();
        if (is_array($nodes)) {
            while (list(, $currentNode) = each($nodes)) {
                $result[] .= $currentNode->id;
            }
        }
        return $result;
    }

	/**
     * Returns Count the number of words for a type of content
     *
     *
     * @return int The number of words
     * @param String $type
     * @access public
     */

    function howManyMotForType($type) {

		$count = 0;
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : howManyMotForType()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = 'SELECT COUNT(*) as cpt FROM '.$GLOBALS['table_prefix'].'_mots mots,  '.$GLOBALS['table_prefix'].'_groupes_mots groupes WHERE ' . $type  . '=\'oui\' AND mots.id_groupe=groupes.id_groupe';
        $count = $db->getOne($query);

        if (DB::isError($count)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : howManyMotForType()] ".$count->getMessage()."", null,
                null, null, null, null, false);
        }
        
        return $count;

    }

}
?>
