<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Antoine Angenieux <aangenieux@clever-age.com>                |
// +----------------------------------------------------------------------+
//
// Base class for Article business persistence abstraction.
//

if (defined("_BD_ARTICLEMYSQL")) return;
define("_BD_ARTICLEMYSQL", "1");

require_once dirname(__FILE__)."/../article.php";

/**
 * BD_article_mysql is an implementation for MySQL of BD_article business class.
 * @package	BD_mysql
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @access	public
 */
class BD_article_mysql extends BD_article {

    function getRubriqueIdsByStatus($statut, $postDated) {
        $rubriqueIds = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : getRubriqueIdsByStatus()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT DISTINCT id_rubrique FROM ".$GLOBALS['table_prefix']."_articles WHERE statut = '$statut'";
        if ($postDated == "non") {
            $query .= " AND date_heure <= NOW()";
        }
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : getRubriqueIdsByStatus()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $result->fetchRow()) {
            $rubriqueIds[] = $row['id_rubrique'];
        }
        $result->free();
        return $rubriqueIds;
    }

    function getMaxDateByRubriqueAndStatus($rubriqueId, $statut, $postDated) {
        $dateResult = '';
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : getMaxDateByRubriqueAndStatus()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT MAX(date_heure) AS date_h FROM ".$GLOBALS['table_prefix']."_articles ".
				 "WHERE id_rubrique=$rubriqueId AND statut = '$status'";

        if ($postDated == "non") {
            $query .= " AND date_heure <= NOW()";
        }
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : getMaxDateByRubriqueAndStatus()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $result->fetchRow()) {
            $dateResult = $row['date_h'];
        }
        $result->free();
        return $dateResult;
    }

/*
    function isPostDated() {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : isPostDated()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        $query = "SELECT id_article FROM ".$GLOBALS['table_prefix']."_articles WHERE id_article=".$this->_articleId." AND date_heure<=NOW()";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : isPostDated()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        $isPostDated = !($result->numRows());
        $result->free();
        return $isPostDated;
    }
*/

    function hasLastModified($auteurId) {
        $hasLastModified = true;
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : hasLastModified()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT auteur_modif, UNIX_TIMESTAMP(date_modif) AS modification, UNIX_TIMESTAMP(NOW()) AS maintenant FROM ".$GLOBALS['table_prefix']."_articles WHERE id_article='".$db->quoteString($this->_articleId)."'";

         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : hasLastModified()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

        if ($row = $result->fetchRow()) {
            $auteur_modif = $row["auteur_modif"];
            $this->_auteurModif = $auteur_modif;



    		$modification = $row["modifications"];
    		$maintenant = $row["maintenant"];

    		$result->free();
        	$date_diff = floor(($maintenant - $modification)/60);
        	$this->_whenWasModified = $date_diff;

    		if ($date_diff >= 0 AND $date_diff < 60 AND $auteur_modif > 0 AND $auteur_modif != $auteurId) {
    			$hasLastModified = false;
    			$query_auteur = "SELECT nom FROM ".$GLOBALS['table_prefix']."_auteurs WHERE id_auteur='$auteur_modif'";
    			 
    			$result_auteur = $db->query($query_auteur);
                if (DB::isError($result_auteur)) {
                    return PEAR::raiseError("[".get_class($this)." DB_article : hasLastModified()] ".$result_auteur->getMessage()."", null,
                        null, null, null, null, false);
                }
    			if ($row_auteur = $result_auteur->fetchRow()) {
    				$this->_computedLastModified = true;
    				$this->_lastModifiedUserName = $row_auteur["nom"];
    			}
    		}
        }
        return $hasLastModified;
    }

    // {{{ getToday()

    /**
     * Returns an array of Article representing
     * the current day published articles.
     *
     *
     * @return Array of Article
     * @param $month
     * @param $year
     * @access public
     */

    function &getToday($month, $year) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : getToday()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT id_article, titre, date_heure FROM ".$GLOBALS['table_prefix']."_articles WHERE statut='publie' AND date_heure >='$year-$month-0' AND date_heure < DATE_ADD('$year-$month-1', INTERVAL 1 MONTH) ORDER BY date_heure";
        
         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : getToday()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $queryResult->fetchRow()) {
            $resultArticle = &BD_article::factory($this->getDbParameters(), $this->getDbOptions());
            $resultArticle->setArticleId($row['id_article']);
            $resultArticle->setTitre($row['titre']);
            $resultArticle->setDate($row['date_heure']);
            $result[] = &$resultArticle;

        }

        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ getOpened()

    /**
     * Returns an array of Article representing
     * the currently opened articles for a given author
     *
     * This method is abstract and will be implemented
     * in a future version, when the data model has been
     * updated.
     *
     * @return Array of Article
     * @param int $authorId
     * @access public
     */

    function &getOpened($authorId) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : getOpened()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT id_article, titre FROM ".$GLOBALS['table_prefix']."_articles WHERE auteur_modif = '$authorId' AND id_rubrique > 0 AND date_modif > DATE_SUB(NOW(), INTERVAL 1 HOUR) ORDER BY date_modif DESC";
         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : getOpened()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $queryResult->fetchRow()) {
            $resultArticle = &BD_article::factory($this->getDbParameters(), $this->getDbOptions());
            $resultArticle->setArticleId($row['id_article']);
            $resultArticle->setTitre($row['titre']);
            $result[] = &$resultArticle;

        }

        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ howManyArticleForMot($conf_mot, $aff_articles, 'refuse')

    function HowManyArticleForMot($conf_mot, $aff_articles, $statut)    {
        $howManyArticle = 0;
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : HowManyArticleForMot()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

		$query = "SELECT COUNT(*) as cnt FROM ".$GLOBALS['table_prefix']."_mots_articles lien, ".$GLOBALS['table_prefix']."_articles article	WHERE lien.id_mot=$conf_mot AND article.id_article=lien.id_article AND FIND_IN_SET(article.statut,'$aff_articles')>0 AND article.statut!='$statut'";
		 
		$result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : HowManyArticleForMot()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        if ($row = $result->fetchRow()) {
            $howManyArticle = intval($row["cnt"]);
        }
        $result->free();
        return $howManyArticle;
    }
    // }}}

    // {{{ computePopularity())

    /**
     * Updates all articles to compute new popularity value
     *
     * @return mixed DB::Error if an error occured, nothin otherwise
     * @access public
     */

    //D�ol�pour le code, mais c'est toujours parail : on essaye de garder
    //au maximum le code original...

    function computePopularity() {
    	$db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : computePopularity()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

     	$date = lire_meta('date_stats_popularite');
    	include_once(dirname(__FILE__)."/../../../inc_meta.php3");

    	ecrire_meta("date_stats_popularite", time());
        ecrire_metas(); // il faut le marquer de suite pour eviter les acces concurrents

    	$duree = time() - $date;
    	// duree de demi-vie d'une visite dans le calcul de la popularite (en jours)
    	$demivie = 1;
    	// periode de reference en jours
    	$periode = 1;
    	// $a est le coefficient d'amortissement depuis la derniere mesure
    	$a = pow(2, - $duree / ($demivie * 24 * 3600));
    	// $b est la constante multiplicative permettant d'avoir
    	// une visite par jour (periode de reference) = un point de popularite
    	// (en regime stationnaire)
    	// or, magie des maths, ca vaut log(2) * duree journee/demi-vie
    	// si la demi-vie n'est pas trop proche de la seconde ;)
    	$b = log(2) * $periode / $demivie;

    	// oublier un peu le passe
    	$query = "UPDATE ".$GLOBALS['table_prefix']."_articles SET popularite = popularite * $a";
 
        spip_log("Execute: $query");

        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : computePopularity()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

    	// ajouter les points visites
    	$count_article = array();

        //----------Modification Clever Age elebescond----------
        $visiteMetier = &recuperer_instance_visite();
	    $allVisites = $visiteMetier->getAllVisiteForTypeSinceXsec($duree, 'article');
        if (DB::isError($allVisites)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : computePopularity()] ".$allVisites->getMessage()."", null,
                null, null, null, null, false);
        }
	    $updatePopQuery = "UPDATE ".$GLOBALS['table_prefix']."_articles "
    			         ."SET popularite = GREATEST(1,popularite) + $b * ! "
    			         ."WHERE id_article IN (0!)";

        while (list(, $maVisite) = each($allVisites)) {
    		$count_article[$maVisite['count']] .= ','.$maVisite['id_objet'];	// l'objet a count visites
    	}
	    /*
        $query = "SELECT COUNT(*) as count,id_objet FROM ".$GLOBALS['table_prefix']."_visites_temp WHERE maj > DATE_SUB(NOW(), INTERVAL $duree SECOND) AND type='article' GROUP BY id_objet";
    	$result = $db->query($query);
    	if (DB::isError($result)) {
    	    return $result;
    	}

    	$updatePopQuery = "UPDATE ".$GLOBALS['table_prefix']."_articles "
    			         ."SET popularite = GREATEST(1,popularite) + $b * ! "
    			         ."WHERE id_article IN (0!)";

    	while ($row = $result->fetchRow()) {
    		$count_article[$row['count']] .= ','.$row['id_objet'];	// l'objet a count visites
    	}
	    */
        //---------Fin modification Clever Age-------


    	reset ($count_article);
    	while (list($count,$articles) = each($count_article)) {
    		$params = array();
    		$params[] = $count;
    		$params[] = $articles;
    		$query = $this->_traiteQuery($updatePopQuery);
    		$db->query($query, $params);
    	}

    	// ajouter les points referers
    	$count_article = array();

        //----------Modification Clever Age elebescond----------
        $refererMetier = &recuperer_instance_referer();
	    $allReferers = $refererMetier->getAllRefererForTypeSinceXsec($duree, 'article');
        if (DB::isError($allReferers)) {
            die($allReferers->getMessage());
        }
	    while (list(, $monReferer) = each($allReferers)) {
    		$count_article[$monReferer['count']] .= ','.$monReferer['id_objet'];	// l'objet a count visites
    	}
	    /*
    	$query = "SELECT COUNT(*) as count,id_objet FROM ".$GLOBALS['table_prefix']."_referers_temp WHERE maj > DATE_SUB(NOW(), INTERVAL $duree SECOND) AND type='article' GROUP BY id_objet";
    	$result = $db->query($query);
    	if (DB::isError($result)) {
    	    return $result;
    	}

    	while ($row = $result->fetchRow()) {
    		$count_article[$row['count']] .= ','.$row['id_objet'];	// l'objet a count visites
    	}
	    */
        //---------Fin modification Clever Age-------


    	reset ($count_article);
    	while (list($count,$articles) = each($count_article)) {
    		$params = array();
    		$params[] = $count;
    		$params[] = $articles;
    		$query = $this->_traiteQuery($updatePopQuery);
    		$db->query($updatePopQuery, $params);
    	}

    	// et enregistrer les metas...

    	$query = "SELECT MAX(popularite) AS maxpop, SUM(popularite) AS sumpop FROM ".$GLOBALS['table_prefix']."_articles";

    	$result = $db->query($query);
    	if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : computePopularity()] ".$result->getMessage()."", null,
                null, null, null, null, false);
    	}
    	if ($row = $result->fetchRow()) {
    	    $maxpop = $row['maxpop'];
    	    $totalpop = $row['sumpop'];
    	    ecrire_meta("popularite_max", $maxpop);
        	ecrire_meta("popularite_total", $totalpop);
        	ecrire_metas();
    	}
    	$result->free();
    }

    // }}}
    
    // {{{ calculatePublishedRubrique()

    /**
     * This method return la liste des langues utilisees par les articles.
     * @return	Array
     */

    function &calculatePublishedRubrique($trad_lang) {
        $rubriqueIds = array();
        $db = &$this->_getDB();
        
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article_mysql : calculatePublishedRubrique()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT DISTINCT a.id_rubrique ".
			"FROM ".$GLOBALS['table_prefix']."_articles AS a LEFT JOIN ".$GLOBALS['table_prefix']."_articles AS t ".
			"ON (a.id_article = t.id_trad AND t.lang = '$trad_lang') ".
			"WHERE a.statut='publie' AND a.lang!='$trad_lang' AND (a.id_trad=0 OR a.id_trad=a.id_article) ".
			"AND (t.id_article IS NULL OR t.statut!='publie' OR t.date_modif < a.date_modif)";
		

		 
		
		//echo '<br />' . $query . '<br />';
		
		$queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_article_mysql : calculatePublishedRubrique()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $queryResult->fetchRow()) {
            $rubriqueIds[] = $row['id_rubrique'];
        }
        $queryResult->free();
        return $rubriqueIds;
    }

    // }}}
    
    // {{{ calculateNoTraductionForRubrique()

    /**
     * This method return la liste des langues utilisees par les articles.
     * @return	Array
     */

    function calculateNoTraductionForRubrique($trad_lang, $id_parent) {
        $rows = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article_mysql : calculateNoTraductionForRubrique()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT a.id_article, a.titre, a.date_heure, a.descriptif, a.lang, t.id_article AS trad_id_article, t.statut AS trad_statut, (t.date_modif >= a.date_modif) AS trad_a_jour ".
			"FROM ".$GLOBALS['table_prefix']."_articles AS a LEFT JOIN ".$GLOBALS['table_prefix']."_articles AS t ".
			"ON (a.id_article = t.id_trad AND t.lang = '$trad_lang') ".
			"WHERE a.id_rubrique=$id_parent AND a.statut='publie' AND a.lang!='$trad_lang' AND (a.id_trad=0 OR a.id_trad=a.id_article) ".
			"AND (t.id_article IS NULL OR t.statut!='publie' OR t.date_modif < a.date_modif) ".
			"ORDER BY t.statut='publie' DESC, trad_a_jour DESC, a.titre";
		

		 
		
		//echo '<br />' . $query . '<br />';
		
		$queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_article_mysql : calculateNoTraductionForRubrique()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $queryResult->fetchRow()) {
            $rows[] = $row;
        }
        
        $queryResult->free();
        return $rows;
    }

    // }}}


    // {{{ getTradStatistics()

    /**
     * This method return la liste des langues utilisees par les articles.
     * @return	Array
     */

    function getTradStatistics($trad_lang) {
        $row = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article_mysql : calculateNoTraductionForRubrique()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT COUNT(*) AS total, SUM(t.statut='publie') AS traduits, SUM(t.statut='publie' AND t.date_modif < a.date_modif) AS conflits ".
		"FROM ".$GLOBALS['table_prefix']."_articles AS a LEFT JOIN ".$GLOBALS['table_prefix']."_articles AS t ".
		"ON (a.id_article = t.id_trad AND t.lang = '$trad_lang') ".
		"WHERE a.statut='publie' AND a.lang!='$trad_lang' AND (a.id_trad=0 OR a.id_trad=a.id_article)";
		
         
		$queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_article_mysql : calculateNoTraductionForRubrique()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

        if($row = $queryResult->fetchRow()) {
            return $row;
        }
        
        $queryResult->free();
        return false;
    }

    // }}}
        
}
?>