<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Antoine Angnieux <aangenieux@clever-age.com>                |
// +----------------------------------------------------------------------+
//
// Base class for Article business persistence abstraction.
//

if (defined("_BD_AUTEURMYSQL")) return;
define("_BD_AUTEURMYSQL", "1");

require_once dirname(__FILE__)."/../auteur.php";
define("AUTEUR_ALL_FIELDS", " id_auteur, nom, bio, email, nom_site, url_site, login, pass, statut, maj, pgp, htpass, "
							."en_ligne ,imessage,messagerie,alea_actuel,alea_futur,prefs,cookie_oubli,source ");


/**
 * BD_article_mysql is an implementation for MySQL of BD_article business class.
 * @package	BD_mysql
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @access	public
 */
class BD_auteur_mysql extends BD_auteur {

    // {{{ createIgnore()

    function createIgnore() {
        $db = &$this->_getDB();
        $string_prefix = $GLOBALS['table_prefix']."_auteurs";
        $auteurId = $db->nextId($string_prefix, true);

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : createIgnore()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $this->_auteurId = $auteurId;

        $query = "INSERT IGNORE INTO ".$GLOBALS['table_prefix']."_auteurs (".AUTEUR_ALL_FIELDS.") VALUES "
                ."('".$db->quoteString($this->_auteurId)."', "
                ."'".$db->quoteString($this->_nom)."', "
                ."'".$db->quoteString($this->_bio)."', "
                ."'".$db->quoteString($this->_email)."', "
                ."'".$db->quoteString($this->_nomSite)."', "
                ."'".$db->quoteString($this->_urlSite)."', "
                ."'".$db->quoteString($this->_login)."', "
                ."'".$db->quoteString($this->_pass)."', "
                ."'".$db->quoteString($this->_statut)."', "
                ."'".$db->quoteString($this->_maj)."', "
                ."'".$db->quoteString($this->_pgp)."', "
                ."'".$db->quoteString($this->_htpass)."', "
                ."'".$db->quoteString($this->_enLigne)."', "
                ."'".$db->quoteString($this->_imessage)."', "
                ."'".$db->quoteString($this->_messagerie)."', "
                ."'".$db->quoteString($this->_aleaActuel)."', "
                ."'".$db->quoteString($this->_aleaFutur)."', "
                ."'".$db->quoteString($this->_prefs)."', "
                ."'".$db->quoteString($this->_cookieOubli)."', "
                ."'".$db->quoteString($this->_source)."')";

        //echo "<br><br>".$query."<br><br>";

         

        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : createIgnore()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}


}
?>