<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Erwan LE BESCOND <elebescond@clever-age.com>                |
// +----------------------------------------------------------------------+
//
// Base class for Breve business persistence abstraction.
//

if (defined("_BD_BREVEMYSQL")) return;
define("_BD_BREVEMYSQL", "1");

require_once dirname(__FILE__)."/../breve.php";

/**
 * BD_breve_mysql is an implementation for MySQL of BD_breve business class.
 * @package	BD_mysql
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @access	public
 */
class BD_breve_mysql extends BD_breve {

    // {{{ getToday()

    /**
     * Returns an array of Breve representing
     * the current day published breves.
     *
     *
     * @return Array of Breve
     * @param $month
     * @param $year
     * @access public
     */

    function &getToday($month, $year) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_breve : getToday()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT id_breve, titre, date_heure FROM ".$GLOBALS['table_prefix']."_breves WHERE statut='publie' AND date_heure >='$year-$month-0' AND date_heure < DATE_ADD('$year-$month-1', INTERVAL 1 MONTH) ORDER BY date_heure";
         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_breve : getToday()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $queryResult->fetchRow()) {
            $resultBreve = &BD_breve::factory($this->getDbParameters(), $this->getDbOptions());
            $resultBreve->setBreveId($row['id_breve']);
            $resultBreve->setTitre($row['titre']);
            $resultBreve->setDateHeure($row['date_heure']);
            $result[] = &$resultBreve;
        }

        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ howManyBreveForMot($conf_mot,$aff_articles,$statut)

    function HowManyBreveForMot($conf_mot,$aff_articles,$statut)    {
        $howManyBreve = 0;
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_breve : HowManyBreveForMot()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        
		$query = "SELECT COUNT(*) as cnt FROM ".$GLOBALS['table_prefix']."_mots_breves lien, ".$GLOBALS['table_prefix']."_breves breve "
		        . "WHERE lien.id_mot=$conf_mot AND breve.id_breve=lien.id_breve "
			    . "AND FIND_IN_SET(breve.statut,'$aff_articles')>0 AND breve.statut!='refuse'";

		 
		$result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_breve : HowManyBreveForMot()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        if ($row = $result->fetchRow()) {
            $howManyBreve = intval($row["cnt"]);
        }
        $result->free();
        return $howManyBreve;
    }

    // }}}

}
?>