<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Erwan LE BESCOND <elebescond@clever-age.com>                 |
// +----------------------------------------------------------------------+
//
// Base class for Message business persistence abstraction.
//

if (defined("_BD_MESSAGEMYSQL")) return;
define("_BD_MESSAGEMYSQL", "1");

require_once dirname(__FILE__)."/../message.php";

/**
 * BD_message_mysql is an implementation for MySQL of BD_message business class.
 * @package	BD_mysql
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @access	public
 */
class BD_message_mysql extends BD_message {

    // {{{ getRDV($connect_id_auteur, $vu, $annee_today, $mois_today, $statut)

    /**
     * Returns an array of Message.
     *
     *
     * @return Array of Message
     * @param $connect_id_auteur
     * @param $vu
     * @param $annee_today
     * @param $mois_today
     * @param $statut
     * @access public
     */

    function &getRDV($connect_id_auteur, $vu, $annee_today, $mois_today, $statut) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : getRDV()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }



        $query = "SELECT messages.* FROM ".$GLOBALS['table_prefix']."_messages messages, ".$GLOBALS['table_prefix']."_auteurs_messages lien
        WHERE (lien.id_auteur='$connect_id_auteur' AND lien.id_message=messages.id_message)
         AND messages.rv='$vu' AND
         messages.date_heure >='$annee_today-$mois_today-1' AND
         messages.date_heure <= DATE_ADD('$annee_today-$mois_today-1', INTERVAL 1 MONTH)
         AND messages.statut='$statut' GROUP BY messages.id_message ORDER BY messages.date_heure";
         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : getRDV()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $queryResult->fetchRow()) {
            $resultMessage = &BD_message::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultMessage->_fetchData($row);
            $result[] = &$resultMessage;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ getAnnonces($type, $rv, $annee_today, $mois_today, $statut)

    /**
     * Returns an array of Message.
     *
     *
     * @return Array of Message
     * @param $connect_id_auteur
     * @param $vu
     * @param $annee_today
     * @param $mois_today
     * @param $statut
     * @access public
     */

    function &getAnnonces($type, $rv, $annee_today, $mois_today, $statut)   {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : getAnnonces()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT ".MESSAGE_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_messages messages WHERE messages.type='$type' AND messages.rv='$rv' AND messages.date_heure >='$annee_today-$mois_today-1' AND messages.date_heure <= DATE_ADD('$annee_today-$mois_today-1', INTERVAL 1 MONTH) AND messages.statut='$statut' GROUP BY messages.id_message ORDER BY messages.date_heure";

        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : getAnnonces()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $queryResult->fetchRow()) {
            $resultMessage = &BD_message::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultMessage->_fetchData($row);
            $result[] = &$resultMessage;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ getAllForAuteurIdAndStatutAndRv($connect_id_auteur, $statut, $rv)

    /**
     * Returns an array of Message.
     *
     *
     * @return Array of Message
     * @param $connect_id_auteur
     * @param $statut
     * @param $rv
     * @access public
     */

    function &getAllForAuteurIdAndStatutAndRv($connect_id_auteur, $statut, $rv) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : getAllForAuteurIdAndStatutAndRv()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT messages.* FROM ".$GLOBALS['table_prefix']."_messages messages, ".$GLOBALS['table_prefix']."_auteurs_messages lien WHERE lien.id_auteur='$connect_id_auteur' AND messages.statut='$statut' AND lien.id_message=messages.id_message AND messages.rv='$rv' AND messages.date_heure>DATE_SUB(NOW(),INTERVAL 1 DAY) GROUP BY messages.id_message";
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : getAllForAuteurIdAndStatutAndRv()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $queryResult->fetchRow()) {
            $resultMessage = &BD_message::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultMessage->_fetchData($row);
            $result[] = &$resultMessage;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

}
?>