<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Erwan LE BESCOND <elebescond@clever-age.com>                 |
// +----------------------------------------------------------------------+
//
// Base class for Mot business persistence abstraction.
//

if (defined("_BD_MOTMYSQL")) return;
define("_BD_MOTMYSQL", "1");

require_once dirname(__FILE__)."/../mot.php";

/**
 * BD_mot_mysql is an implementation for MySQL of BD_mot business class.
 * @package	BD_mysql
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @access	public
 */
class BD_mot_mysql extends BD_mot {

    // {{{ getAllMotIdsForArticleStatut($aff_articles, $statut)

    /**
     * Returns an array of Mots.
     *
     *
     * @return Array of Mot
     * @param $id_message
     * @access public
     */

    function &getAllMotIdsForArticleStatut($aff_articles, $statut) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : getAllMotIdsForArticleStatut()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT COUNT(*) as cnt, mots.id_mot FROM ".$GLOBALS['table_prefix']."_mots_articles lien, ".$GLOBALS['table_prefix']."_articles article, ".$GLOBALS['table_prefix']."_mots mots"
			. " WHERE lien.id_mot=mots.id_mot AND article.id_article=lien.id_article"
			. " AND FIND_IN_SET(article.statut,'$aff_articles')>0 AND article.statut!='$statut' GROUP BY mots.id_mot";
            
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : getAllMotIdsForArticleStatut()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $result[] = $row;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ getAllMotIdsForBreveStatut($aff_articles, $statut)

    /**
     * Returns an array of Mots.
     *
     *
     * @return Array of Mot
     * @param $id_message
     * @access public
     */

    function &getAllMotIdsForBreveStatut($aff_articles, $statut) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : getAllMotIdsForBreveStatut()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT COUNT(*) AS cnt, mots.id_mot FROM ".$GLOBALS['table_prefix']."_mots_breves lien, ".$GLOBALS['table_prefix']."_breves breve, ".$GLOBALS['table_prefix']."_mots mots"
			. " WHERE lien.id_mot=mots.id_mot AND breve.id_breve=lien.id_breve"
			. " AND FIND_IN_SET(breve.statut,'$aff_articles')>0 AND breve.statut!='$statut' GROUP BY mots.id_mot";
         
        //echo '<br>'.$query.'<br>';

        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : getAllMotIdsForBreveStatut()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $result[] = $row;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ getAllMotIdsForSyndicStatut($aff_articles, $statut)

    /**
     * Returns an array of Mots.
     *
     *
     * @return Array of Mot
     * @param $id_message
     * @access public
     */

    function &getAllMotIdsForSyndicStatut($aff_articles, $statut) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : getAllMotIdsForSyndicStatut()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT COUNT(*) AS cnt, mots.id_mot FROM ".$GLOBALS['table_prefix']."_mots_syndic lien, ".$GLOBALS['table_prefix']."_syndic syndic, ".$GLOBALS['table_prefix']."_mots mots"
			. " WHERE lien.id_mot=mots.id_mot AND syndic.id_syndic=lien.id_syndic"
			. " AND FIND_IN_SET(syndic.statut,'$aff_articles')>0 AND syndic.statut!='$statut' GROUP BY mots.id_mot";

         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : getAllMotIdsForSyndicStatut()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $result[] = $row;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ howManyMotIdsForMotIdandArticleStatut($id_mot, $aff_articles, $statut)

    /**
     * Returns an array of Mots.
     *
     *
     * @return Array of Mot
     * @param $id_message
     * @access public
     */

    function howManyMotIdsForMotIdandArticleStatut($id_mot, $aff_articles, $statut) {
        $howManyMotIds = 0;
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : howManyMotIdsForMotIdandArticleStatut()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT COUNT(*) as cpt FROM ".$GLOBALS['table_prefix']."_mots_articles lien, ".$GLOBALS['table_prefix']."_articles article WHERE lien.id_mot=$id_mot AND article.id_article=lien.id_article AND FIND_IN_SET(article.statut,'$aff_articles')>0 AND article.statut!='$statut'";
         
        //echo $query;
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_mot : howManyMotIdsForMotIdandArticleStatut()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        if($row = $queryResult->fetchRow()) $howManyMotIds = $row['cpt'];

        $queryResult->free();
        return $howManyMotIds;
    }

    // }}}

}
?>