<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Erwan LE BESCOND <elebescond@clever-age.com>                 |
// +----------------------------------------------------------------------+
//
// Base class for Rubrique business persistence abstraction.
//


if (defined("_BD_RUBRIQUEMYSQL")) return;
define("_BD_RUBRIQUEMYSQL", "1");

require_once dirname(__FILE__)."/../rubrique.php";

/**
 * BD_rubrique_mysql is an implementation for MySQL of BD_rubrique business class.
 * @package	BD_mysql
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @access	public
 */
class BD_rubrique_mysql extends BD_rubrique {

    // {{{ getParentAndGrandParentForRubriqueId($id_rubrique)

    /**
     * Returns an array with Parent and Grand Parent
     *
     * @return Array of Rubrique_id
     * @param $auteurId
     * @access public
     */

    function &getParentAndGrandParentForRubriqueId($id_rubrique) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : getParentAndGrandParentForRubriqueId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT a.id_parent AS ida, b.id_parent AS idb ".
			"FROM ".$GLOBALS['table_prefix']."_rubriques a LEFT JOIN ".$GLOBALS['table_prefix']."_rubriques b ON (b.id_rubrique = a.id_parent) ".
			"WHERE a.id_rubrique = $id_rubrique";
         
        //echo $query;

        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : getParentAndGrandParentForRubriqueId()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $result = $row;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

}
?>