<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Erwan LE BESCOND <elebescond@clever-age.com>                 |
// +----------------------------------------------------------------------+
//
// Base class for Mot business persistence abstraction.
//

if (defined("_SERVICEMYSQL")) return;
define("_SERVICEMYSQL", "1");

require_once dirname(__FILE__)."/../service.php";

/**
 * service_mysql is an implementation for MySQL of service class.
 * @package	BD_mysql
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @access	public
 */
class Service_mysql extends Service {
    // {{{ getLock($nom, $timeout = 0)

    /**
     * unlock AGORA.
     *
     *
     * @return  mixed   boolean or PEAR::Error object
     * @param $nom
     * @param $timeout
     * @access public
     */

    function getLock($nom, $timeout = 0) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." service : getLock()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
		
		global $spip_mysql_db, $table_prefix;
		if ($table_prefix) $nom = "$table_prefix:$nom";
		if ($spip_mysql_db) $nom = "$spip_mysql_db:$nom";
		
		$nom = addslashes($nom);
		
		$query = "SELECT GET_LOCK('$nom', $timeout) AS result";
		 
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : getLock()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
		
		if ($row = $queryResult->fetchRow()) {
			//spip_log("Service_mysql: '$query' renvoie ".$row['result']);
            return $row['result'];
        }

    }

    // }}}

    // {{{ releaseLock($nom)

    /**
     * unlock AGORA.
     *
     *
     * @return  mixed   void or PEAR::Error object
     * @param $nom
     * @access public
     */

    function releaseLock($nom) {

        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." service : releaseLock()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
		
		global $spip_mysql_db, $table_prefix;
		if ($table_prefix) $nom = "$table_prefix:$nom";
		if ($spip_mysql_db) $nom = "$spip_mysql_db:$nom";
		
		$nom = addslashes($nom);
		$query = "SELECT RELEASE_LOCK('$nom')";
         
        //echo $query;
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_message : releaseLock()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}
    
}
?>