<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Erwan LE BESCOND <elebescond@clever-age.com>                |
// +----------------------------------------------------------------------+
//
// Base class for Signature business persistence abstraction.
//

if (defined("_BD_SIGNATUREMYSQL")) return;
define("_BD_SIGNATUREMYSQL", "1");

require_once dirname(__FILE__)."/../signature.php";

/**
 * BD_signature_mysql is an implementation for MySQL of BD_signature business class.
 * @package	BD_mysql
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @access	public
 */
class BD_signature_mysql extends BD_signature {

    // {{{ howManySignatureForStatutsAndDateTime($statut1, $statut2, $id_article)

    /**
     * This method returns the number of signature
     * @return  int
     * @access  public
     */
    function howManySignatureForStatutsAndDateTime($statut1, $statut2, $id_article = null) {
        $howManySignatures = 0;
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_signature : howManySignatureForStatutsAndDateTime()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        
		$query = "SELECT COUNT(*) AS cnt FROM ".$GLOBALS['table_prefix']."_signatures WHERE (statut='$statut1' OR statut='$statut1') AND date_time>DATE_SUB(NOW(),INTERVAL 180 DAY)";

        if($id_article != null) $query .= " AND id_article=$id_article";

        $result = $db->getOne($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_signature : howManySignatureForStatutsAndDateTime()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
            $howManySignatures = $result;
        }

        return $howManySignatures;
    }

    // }}}

    // {{{ deleteForStatutsAndDateTime($statut1, $statut2)

     /**
     * This method is used to delete $statut1 and $statut2 signatures
     * @access  public
     */
    function deleteForStatutsAndDateTime($statut1, $statut2) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_signature : deleteForStatutsAndDateTime()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_signatures WHERE NOT (statut='$statut1' OR statut='$statut2') AND date_time<DATE_SUB(NOW(),INTERVAL 10 DAY)";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_signature : deleteForStatutsAndDateTime()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}
}
?>