<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Julien Guillot <jguillotd@clever-age.com>                |
// +----------------------------------------------------------------------+
//
// Base class for mot business persistence abstraction.
//

if (defined("_BD_INDEX_MOTS_MYSQL")) return;
define("_BD_INDEX_MOTS_MYSQL", "1");

require_once dirname(__FILE__)."/../index_mots.php";

/**
 * BD_index_mots_mysql is an implementation for MySQL of BD_index_mots business class.
 * @package	BD_mysql
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @access	public
 */
class BD_subscriber_link_mysql extends BD_subscriber_link {

     // {{{ liste_user()
  //fonction de listage des utilisateurs appartenant  la newsletter ayant l'id spcifi en entre
  //La mthode retourne un tableau contenant la liste des identifiants sub_id concern par la newsletter
  
  function liste($id){

       $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_subscriber_link : liste_user_inscrit()] ".$db->getMessage()."", null,
                null, null, null, null, false);
            }
             //cm_ls.lst_id lst_id, cm_ls.sub_id sub_id_ls, cm_ls.lsr_mode lsr_mode, cm_ls.lsr_id lsr_id ";
        $query = " SELECT cm_ls.sub_id sub_id, cm_s.sub_email email,  cm_s.sub_first_name sub_first_name, cm_s.sub_middle_name sub_middle_name, cm_s.sub_last_name sub_last_name, cm_s.sub_title sub_title, cm_s.sub_profile sub_profile, cm_ls.lsr_mode mode, cm_ls.lst_id lst_id, 'NOTPENDING' statut
                       FROM ".$GLOBALS['table_prefix']."_cm_lists_subscribers cm_ls INNER JOIN ".$GLOBALS['table_prefix']."_cm_subscribers cm_s ON cm_ls.sub_id = cm_s.sub_id
                       WHERE cm_ls.lst_id = $id ORDER by email";
   	  	$query_pending = " SELECT cm_p.sub_id sub_id, cm_s.sub_email email, cm_s.sub_first_name sub_first_name, cm_s.sub_middle_name sub_middle_name, cm_s.sub_last_name sub_last_name, cm_s.sub_title sub_title, cm_s.sub_profile sub_profile, cm_p.pnd_mode mode, cm_p.lst_id lst_id, 'PENDING' statut
                       FROM ".$GLOBALS['table_prefix']."_cm_pending cm_p INNER JOIN ".$GLOBALS['table_prefix']."_cm_subscribers cm_s ON cm_p.sub_id = cm_s.sub_id
                       WHERE cm_p.lst_id = $id ORDER by email";
		

        $result = $db->query($query);
    	$result_pending = $db->query($query_pending); 
		
        if (DB::isError($result)||DB::isError($result_pending)) {
            return PEAR::raiseError("[".get_class($this)." DB_subscriber_link : liste_user_inscrit()] ".$result->getMessage()."", null,
                null, null, null, null, false);
                } 
            else {
                while ($row = $result->fetchRow()){
                   $tab_inscrit_classe[$row['email']]=$row;
                }
                while ($row_pending = $result_pending->fetchRow()){
                   $tab_inscrit_pending[$row['email']]=$row;
                }

                $tab_retour2 = array(0=>$tab_inscrit_classe, 1=>$tab_inscrit_pending);        
                return($tab_retour2);
          }

     }
     
     // }}}
     
       // {{{ liste_user_inscrit()
     

     function liste_user_inscrit($id){

		$db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_subscriber_link : liste_user_inscrit()] ".$db->getMessage()."", null,
                null, null, null, null, false);
            }
            
        $query = "SELECT cm_ls.sub_id sub_id, cm_s.sub_email email, cm_ls.lsr_mode mode, cm_ls.lst_id lst_id, 'NOTPENDING' statut
                       FROM ".$GLOBALS['table_prefix']."_cm_lists_subscribers cm_ls INNER JOIN ".$GLOBALS['table_prefix']."_cm_subscribers cm_s ON cm_ls.sub_id = cm_s.sub_id
                       WHERE cm_ls.lst_id = $id ORDER by email";

        $result = $db->query($query);
         
            if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_subscriber_link : liste_user_inscrit()] ".$result->getMessage()."", null,
                null, null, null, null, false);
                } 
            else {

                while ($row = $result->fetchRow()){
                	
                   $tab_inscrit_classe[$row['email']]=$row;
				   $initial = substr($row['email'],0,1);
                   $tab_initial_2[$initial]=$initial;
                }
                $tab_retour2 = array(0=>$tab_inscrit_classe, 1=>$tab_initial_2);        
                return($tab_retour2);
          }

     }
     
       // }}}     
       
       function liste_user_non_inscrit($id){
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_subscriber_link : liste_user_non_inscrit()] ".$db->getMessage()."1", null,
                null, null, null, null, false);
            }
            
        $query = "SELECT cm_ls.sub_id sub_id, cm_ls.sub_email email, cm_s.pnd_mode mode, cm_s.lst_id lst_id, 'PENDING' statut
                        FROM ".$GLOBALS['table_prefix']."_cm_subscribers cm_ls INNER JOIN ".$GLOBALS['table_prefix']."_cm_pending cm_s ON cm_ls.sub_id = cm_s.sub_id
                        WHERE cm_s.lst_id = $id ORDER by email ";
        
        $result = $db->query($query);

	    if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_subscriber_link : liste_user_non_inscrit()] ".$result->getMessage()."2", null,
                null, null, null, null, false);
                } 
            else {
                while ($row = $result->fetchRow()){
                    $tab_non_inscrit_classe[$row['email']]=$row;
                    $initial = substr($row['email'],0,1);
                    $tab_initial[$initial]=$initial;
                }
                
                $tab_retour = array(0=>$tab_non_inscrit_classe, 1=>$tab_initial);                
                return($tab_retour);
            }

     }
     
       // }}}     
       
	function searh_mail_inscrit($id, $email){
		$db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_subscriber_link : searh_mail_inscrit()] ".$db->getMessage()."", null,
                null, null, null, null, false);
            }
            
        $query = "SELECT cm_ls.sub_id sub_id, cm_s.sub_email email, cm_ls.lsr_mode mode, cm_ls.lst_id lst_id, 'NOTPENDING' statut
                       FROM ".$GLOBALS['table_prefix']."_cm_lists_subscribers cm_ls INNER JOIN ".$GLOBALS['table_prefix']."_cm_subscribers cm_s ON cm_ls.sub_id = cm_s.sub_id
                       WHERE cm_ls.lst_id = $id AND sub_email like '%".$email."%' ORDER by email  ";
		//echo $query;
        $result = $db->query($query);
         
            if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_subscriber_link : searh_mail_inscrit()] ".$result->getMessage()."", null,
                null, null, null, null, false);
                } 
            else {

                while ($row = $result->fetchRow()){
                	
                   $tab_inscrit_classe[$row['email']]=$row;
				   $initial = substr($row['email'],0,1);
                   $tab_initial_2[$initial]=$initial;
                }
                $tab_retour2 = array(0=>$tab_inscrit_classe, 1=>$tab_initial_2);        
                return($tab_retour2);
          }
	
    	   
	}

	function searh_mail_non_inscrit($id, $email){
		$db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_subscriber_link : searh_mail_non_inscrit()] ".$db->getMessage()."", null,
                null, null, null, null, false);
            }
            
        $query = "SELECT cm_p.sub_id sub_id, cm_s.sub_email email, cm_s.sub_first_name sub_first_name, cm_s.sub_middle_name sub_middle_name, cm_s.sub_last_name sub_last_name, cm_s.sub_title sub_title, cm_s.sub_profile sub_profile, cm_p.pnd_mode mode, cm_p.lst_id lst_id, 'PENDING' statut
                       FROM ".$GLOBALS['table_prefix']."_cm_pending cm_p INNER JOIN ".$GLOBALS['table_prefix']."_cm_subscribers cm_s ON cm_p.sub_id = cm_s.sub_id
                       WHERE cm_p.lst_id = $id AND sub_email like '%".$email."%' ORDER by email ";
		//echo $query;
        $result = $db->query($query);
         
            if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_subscriber_link : searh_mail_non_inscrit()] ".$result->getMessage()."", null,
                null, null, null, null, false);
                } 
            else {

                while ($row = $result->fetchRow()){
                	
                   $tab_inscrit_classe[$row['email']]=$row;
				   $initial = substr($row['email'],0,1);
                   $tab_initial_2[$initial]=$initial;
                }
                $tab_retour2 = array(0=>$tab_inscrit_classe, 1=>$tab_initial_2);        
                return($tab_retour2);
          }
	
    	   
	}


}
?>