<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Erwan LE BESCOND <elebescond@clever-age.com>                 |
// +----------------------------------------------------------------------+
//
// Base class for Syndic business persistence abstraction.
//

if (defined("_BD_SYNDICMYSQL")) return;
define("_BD_SYNDICMYSQL", "1");

require_once dirname(__FILE__)."/../syndic.php";

/**
 * BD_syndic_mysql is an implementation for MySQL of BD_syndic business class.
 * @package	BD_mysql
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @access	public
 */
class BD_syndic_mysql extends BD_syndic {


    // {{{ getSyndicIdsForStatutAndDateIndex($statut)

    /**
     * Returns an array of Syndic IDS.
     *
     * @return Array of SyndicsIds
     * @param $month
     * @param $year
     * @access public
     */

    function &getSyndicIdsForStatutAndDateIndex($statut) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_syndic : getSyndicIdsForStatutAndDateIndex()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT id_syndic FROM ".$GLOBALS['table_prefix']."_syndic WHERE statut='$statut' AND date_index < DATE_SUB(NOW(), INTERVAL 7 DAY) ORDER BY date_index";
         
        $queryResult = $db->limitQuery($query, 0, 1);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_syndic : getSyndicIdsForStatutAndDateIndex()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $queryResult->fetchRow()) {
            $result[] = $row['id_syndic'];
        }

        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ getAllForSyndicationAndStatutAndIntervalHour($syndication, $statut, $hour)

    /**
     * Returns an array of Syndication.
     *
     *
     * @return Array of Syndication
     * @param $syndication
     * @param $statut
     * @param $hour
     * @access public
     */

    function &getAllForSyndicationAndStatutAndIntervalHour($syndication, $statut, $hour) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_syndic : getAllForSyndicationAndStatutAndIntervalHour()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT * FROM ".$GLOBALS['table_prefix']."_syndic WHERE syndication='$syndication' AND statut='$statut' AND date_syndic < DATE_SUB(NOW(), INTERVAL $hour HOUR) ORDER BY date_syndic";
         
        //echo "<br>$query<br>";


        $queryResult = $db->limitQuery($query, 0, 1);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_syndic : getAllForSyndicationAndStatutAndIntervalHour()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultSyndic = &BD_syndic::factory($this->getDbParameters(), $this->getDbOptions());
            $resultSyndic->setSyndicId($row['id_syndic']);
            $resultSyndic->setRubriqueId($row['id_rubrique']);
            $resultSyndic->setSecteurId($row['id_secteur']);
            $resultSyndic->setNomSite($row['nom_site']);
            $resultSyndic->setUrlSite($row['url_site']);
            $resultSyndic->setUrlSyndic($row['url_syndic']);
            $resultSyndic->setDescriptif($row['descriptif']);
            $resultSyndic->setMajDate($row['maj']);
            $resultSyndic->setSyndication($row['syndication']);
            $resultSyndic->setStatut($row['statut']);
            $resultSyndic->setDate($row['date_heure']);
            $resultSyndic->setDateSyndic($row['date_syndic']);
            $resultSyndic->setDateIndex($row['date_index']);
            $resultSyndic->setModeration($row['moderation']);
            $result[] = &$resultSyndic;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ getAllSyndicForSyndicIdAndsyndication($id_syndic)

    /**
     * Returns an array of Syndication.
     *
     *
     * @return Array of Syndication
     * @param $id_syndic
     * @access public
     */

    function &getAllSyndicForSyndicIdAndsyndication($id_syndic) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_syndic : getAllSyndicForSyndicIdAndsyndication()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT * FROM ".$GLOBALS['table_prefix']."_syndic WHERE id_syndic='$id_syndic' AND syndication IN ('oui', 'sus', 'off')";
         
        //echo "<br>$query<br>";

        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_syndic : getAllSyndicForSyndicIdAndsyndication()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultSyndic = &BD_syndic::factory($this->getDbParameters(), $this->getDbOptions());
            $resultSyndic->setSyndicId($row['id_syndic']);
            $resultSyndic->setRubriqueId($row['id_rubrique']);
            $resultSyndic->setSecteurId($row['id_secteur']);
            $resultSyndic->setNomSite($row['nom_site']);
            $resultSyndic->setUrlSite($row['url_site']);
            $resultSyndic->setUrlSyndic($row['url_syndic']);
            $resultSyndic->setDescriptif($row['descriptif']);
            $resultSyndic->setMajDate($row['maj']);
            $resultSyndic->setSyndication($row['syndication']);
            $resultSyndic->setStatut($row['statut']);
            $resultSyndic->setDate($row['date_heure']);
            $resultSyndic->setDateSyndic($row['date_syndic']);
            $resultSyndic->setDateIndex($row['date_index']);
            $resultSyndic->setModeration($row['moderation']);
            $result[] = &$resultSyndic;
        }
        $queryResult->free();
        return $result;
    }

    // }}}
}
?>