<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Antoine Angnieux <aangenieux@clever-age.com>                |
// +----------------------------------------------------------------------+
//
// Base class for Article business persistence abstraction.
//
if (defined("_BD_NEWSLETTER")) return;
    define("_BD_NEWSLETTER", "1");

require_once "PEAR.php";
require_once "DB.php";
require_once dirname(__FILE__)."/metier.php";
require_once dirname(__FILE__)."/../../inc_filtres.php3";
require_once dirname(__FILE__)."/../../inc_meta.php3";

define("NEWSLETTER_ALL_FIELDS", ' lst_id, lst_name, lst_comment, lst_moderation, lst_moderator_email, '
                                .'lst_subscribe_subject, lst_subscribe_text, lst_subject, '
                                .'lst_unsubscribe_subject, lst_unsubscribe_text, lst_subject_tag, '
                                .'lst_html_skeleton, lst_text_skeleton, lst_nb_articles ');

/**
 * BD_newsletter is a base class for newsletter business persistence abstraction implementations, and must be
 * inherited by all such.
 * @package	BD
 * @author  Antoine Angnieux <aangenieux@clever-age.com>
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @access	public
 */
class BD_newsletter extends BD_metier {

    // {{{ properties

	var $_id;
    var $_name;
	var $_comment;
	var $_moderation;
	var $_moderatorEmail;
    var $_subscribeSubject;
    var $_subscribeText;
    var $_subject;
    var $_unsubscribeSubject;
    var $_unsubscribeText;
    var $_subjectTag;
    var $_htmlSkeleton;
    var $_textSkeleton;
    var $_nbArticles;

    // }}}

    // {{{ factory()
    function &factory($dbParameters = null, $dbOptions = null) {
        if(file_exists(dirname(__FILE__)."/".$dbParameters->_dbEngine."/newsletter_".$dbParameters->_dbEngine.".php") == false) {
            include_once(dirname(__FILE__)."/common/newsletter_common.php");
            $classname = "BD_newsletter_common";
        }
        else {
            include_once(dirname(__FILE__)."/".$dbParameters->_dbEngine."/newsletter_".$dbParameters->_dbEngine.".php");
            $classname = "BD_newsletter_".$dbParameters->_dbEngine;
        }

        if (!class_exists($classname)) {
            return PEAR::raiseError("Cannot instanciate class $classname", null,
                                    null, null, null, null, false);
        }

        $obj =& new $classname;

        $result = $obj->setDbParameters($dbParameters);
        if ($dbOptions != null) {
            $obj->setDbOptions($dbOptions);
        }
        if (PEAR::isError($result)) {
            return $result;
        } else {
            return $obj;
        }
    }

    // }}}

    // {{{ constructor

    /**
     * DB_newsletter constructor.
     *
     * @access public
     */

    function BD_newsletter() {
    }

    // }}}

    // {{{ getId()

    function getId() {
        return $this->_id;
    }

    // }}}

    // {{{ setId()

    function setId($id) {
        $this->_id = $id;
    }

    // }}}

    // {{{ getName()

    function getName() {
        return stripslashes($this->_name);
    }

    // }}}

    // {{{ setName()

    function setName($name) {
         $this->_name = addslashes(corriger_caracteres($name));
    }

    // }}}

    // {{{ getComment()

    function getComment() {
        return stripslashes($this->_comment);
    }

    // }}}

    // {{{ setComment()

    function setComment($comment) {
        $this->_comment = addslashes(corriger_caracteres($comment));
    }

    // }}}

    // {{{ getModeration()

    function getModeration() {
        return $this->_moderation;
    }

    // }}}

    // {{{ setModeration()

    function setModeration($moderation) {
        $this->_moderation = $moderation;
    }

    // }}}

	// {{{ getModeratorEmail()

	function getModeratorEmail() {
	    return stripslashes($this->_moderatorEmail);
	}

	// }}}

	//{{{ setModeratorEmail()

	function setModeratorEmail($moderatorEmail) {
	    $this->_moderatorEmail = addslashes(corriger_caracteres($moderatorEmail));
	}

	// }}}

	// {{{ getSubscribeSubject()

	function getSubscribeSubject() {
	    return stripslashes($this->_subscribeSubject);
	}

	// }}}

	// {{{ setSubscribeSubject()

	function setSubscribeSubject($subscribeSubject) {
	    $this->_subscribeSubject = addslashes(corriger_caracteres($subscribeSubject));
	}

	// }}}

    // {{{ getSubscribeText()

	function getSubscribeText() {
	    return stripslashes($this->_subscribeText);
	}

	// }}}

	// {{{ setSubscribeText()

	function setSubscribeText($subscribeTexte) {
	    $this->_subscribeText = addslashes(corriger_caracteres($subscribeTexte));
	}

	// }}}

    // {{{ getSubject()

	function getSubject() {
	    return stripslashes($this->_subject);
	}

	// }}}

	// {{{ setSubject()

	function setSubject($subject) {
	    $this->_subject= addslashes(corriger_caracteres($subject));
	}

	// }}}

    // {{{ getUnsubscribeSubject()

	function getUnsubscribeSubject() {
	    return stripslashes($this->_unsubscribeSubject);
	}

	// }}}

	// {{{ setUnsubscribeSubject()

	function setUnsubscribeSubject($unsubscribeSubject) {
	    $this->_unsubscribeSubject = addslashes(corriger_caracteres($unsubscribeSubject));
	}

	// }}}

    // {{{ getUnsubscribeText()

	function getUnsubscribeText() {
	    return stripslashes($this->_unsubscribeText);
	}

	// }}}

	// {{{ setUnsubscribeText()

	function setUnsubscribeText($unsubscribeTexte) {
	    $this->_unsubscribeText = addslashes(corriger_caracteres($unsubscribeTexte));
	}

	// }}}

    // {{{ getSubjectTag()

	function getSubjectTag() {
	    return $this->_subjectTag;
	}

	// }}}

	// {{{ setSubjectTag()

	function setSubjectTag($subjectTag) {
	    $this->_subjectTag = $subjectTag;
	}

	// }}}

    // {{{ getHtmlSkeleton()

	function getHtmlSkeleton() {
	    return $this->_htmlSkeleton;
	}

	// }}}

	// {{{ setHtmlSkeleton()

	function setHtmlSkeleton($htmlSkeleton) {
	    $this->_htmlSkeleton = $htmlSkeleton;
	}

	// }}}

    // {{{ getTextSkeleton()

	function getTexteSkeleton() {
	    return $this->_textSkeleton;
	}

	// }}}

	// {{{ setTextSkeleton()

	function setTextSkeleton($textSkeleton) {
	    $this->_textSkeleton = $textSkeleton;
	}

	// }}}

    // {{{ getNbArticles()

    function getNbArticles() {
        return $this->_nbArticles;
    }

    // }}}

    // {{{ setNbArticles()

    function setNbArticles($nbArticles) {
        $this->_nbArticles = $nbArticles;
    }

    // }}}

    // {{{ create()

    function create() {

        $db = &$this->_getDB();
        $string_prefix = $GLOBALS['table_prefix']."_cm_lists";
        $newsletterId = $db->nextId($string_prefix, true);
        if (DB::isError($newsletterId)) {
            return $newsletterId;
        }

        $this->_id = $newsletterId;

        if($this->_nbArticles==NULL)$this->_nbArticles=0;

        $query = 'INSERT INTO '.$GLOBALS['table_prefix'].'_cm_lists ('.NEWSLETTER_ALL_FIELDS.') VALUES '
                ."('".$this->_id."', "
                ."'".$this->_name."', "
            	."'".$this->_comment."', "
            	."'".$this->_moderation."', "
            	."'".$this->_moderatorEmail."', "
                ."'".$this->_subscribeSubject."', "
                ."'".$this->_subscribeText."', "
                ."'".$this->_subject."', "
                ."'".$this->_unsubscribeSubject."', "
                ."'".$this->_unsubscribeText."', "
                ."'".$this->_subjectTag."', "
                ."'".$this->_htmlSkeleton."', "
                ."'".$this->_textSkeleton."', "
                ."'".$this->_nbArticles."') ";
        //die($query);
        

        $result = $db->query($query);

        if (DB::isError($result)) {
           return PEAR::raiseError("[".get_class($this)." DB_newsletter : create()] ".$result->getMessage(), null,
                                    null, null, null, null, false);
        }
    }

    // }}}

    // {{{ update()

    function update() {
        $db = &$this->_getDB();
        $query = "UPDATE ".$GLOBALS['table_prefix']."_cm_lists SET "
				."lst_name = '".$this->_name."'"
				.", lst_comment= '".$this->_comment."'"
            	.", lst_moderation= '".$this->_moderation."'"
            	.", lst_moderator_email= '".$this->_moderatorEmail."'"
                .", lst_subscribe_subject= '".$this->_subscribeSubject."'"
                .", lst_subscribe_text= '".$this->_subscribeText."'"
                .", lst_subject= '".$this->_subject."'"
                .", lst_unsubscribe_subject= '".$this->_unsubscribeSubject."'"
                .", lst_unsubscribe_text= '".$this->_unsubscribeText."'"
                .", lst_subject_tag= '".$this->_subjectTag."'"
                .", lst_html_skeleton= '".$this->_htmlSkeleton."'"
                .", lst_text_skeleton= '".$this->_textSkeleton."'"
                .", lst_nb_articles= '".$this->_nbArticles."'"
				." WHERE lst_id = ".$this->_id;

         

		//echo '<br>' . $query . '<br>';

        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_newsletter : update()] ".$result->getMessage(), null,
                                    null, null, null, null, false);
        }

    }

    // }}}

    // {{{ load()

    function load($idNewsletter) {
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return $db;
        }

        $query = "SELECT".NEWSLETTER_ALL_FIELDS."FROM ".$GLOBALS['table_prefix']."_cm_lists WHERE lst_id = $idNewsletter";
		//echo '<br>' . $query .  '<br>';
         
        $result = $db->query($query);

        if (DB::isError($result)) {
            return $result;
        } else {
            if ($row = $result->fetchRow()) {
                $this->_fetchData($row);
            } else {
                return PEAR::raiseError("[".get_class($this)." DB_newsletter : load($idNewsletter)] Aucune lettre d'information ne correspond  cet ID!", null,
                                    null, null, null, null, false);
            }
            $result->free();
        }
    }

    // }}}

    // {{{ delete()

    function delete($id) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return $db;
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_cm_lists WHERE lst_id = $id";

// ATTENTION, SI CETTE FONCTIONNALITE EST IMPLEMTENTEE, PENSEZ A SUPPRIMER TOUTES LES REFERENCES
// A CETTE LISTE!!

         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return $result;
        }

    }

    // }}}

    // {{{ getListsForModeration($moderation)

    function getListsForModeration($moderation) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." BD_newsletter : getListsForModeration()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        $query = "SELECT ".NEWSLETTER_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_cm_lists WHERE lst_moderation != '$moderation' ORDER BY lst_name";

        $queryResult = $db->query($query);

        $newsletters = array();

        if (DB::isError($result)) {
			return PEAR::raiseError("[".get_class($this)." BD_newsletter : getListsForModeration()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
			while ($row = $queryResult->fetchRow()) {
        		$resultNewsletter = &BD_newsletter::factory($this->getDbParameters(), $this->getDbOptions());
        		$resultNewsletter->_fetchData($row);
        		$newsletters[] = &$resultNewsletter;
	    	}
	    	$queryResult->free();
        }
    	return $newsletters;
    }

    // }}}

    // {{{ _fetchData()

    function _fetchData($row) {
        $this->setId($row['lst_id']);
        $this->setName($row['lst_name']);
        $this->setComment($row['lst_comment']);
        $this->setModeration($row['lst_moderation']);
        $this->setModeratorEmail($row['lst_moderator_email']);
        $this->setSubscribeSubject($row['lst_subscribe_subject']);
        $this->setSubscribeText($row['lst_subscribe_text']);
        $this->setSubject($row['lst_subject']);
        $this->setUnsubscribeSubject($row['lst_unsubscribe_subject']);
        $this->setUnsubscribeText($row['lst_unsubscribe_text']);
        $this->setSubjectTag($row['lst_subject_tag']);
        $this->setHtmlSkeleton($row['lst_html_skeleton']);
        $this->setTextSkeleton($row['lst_text_skeleton']);
        $this->setNbArticles($row['lst_nb_articles']);
    }

    // }}}

}
?>