<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Franois Xavier LACROIX <fxlacroix@clever-age.com>                |
// +----------------------------------------------------------------------+
//
// Base class for ".$GLOBALS['table_prefix']."_cm_list_subscribers
//

if (defined("_BD_NEWSLETTER_CM_COMMON_LIST")) return;
    define("_BD_NEWSLETTER_CM_COMMON_LIST", "1");

require_once "PEAR.php";
require_once "DB.php";
require_once dirname(__FILE__)."/metier.php";
require_once dirname(__FILE__)."/inc_newsletter_cm_list_factory.php";

define("SUBSCRIBERS_LINK", "lst_id, sub_id, lsr_mode, lsr_id");
define("NEWSLETTERS_ALL_LIST", "lst_id, lst_name, lst_comment, lst_moderation, lst_moderator_email, lst_subscribe_subject, lst_subscribe_text, lst_subject, lst_unsubscribe_subject, lst_unsubscribe_text, lst_subject_tag, lst_html_skeleton, lst_text_skeleton, lst_nb_articles");
define("SUBSCRIBERS_ALL_FIELDS", "sub_id, sub_email, sub_first_name, sub_middle_name, sub_last_name, sub_title ,sub_profile");        

/**
 * Gestion des listes de newsletter par id (cf. subscriber_cm)
 * @author  Franois Xavier LACROIX <fxlacroix@clever-age.com>
 * @access  public
 */
 
 class BD_newsletter_cm_list extends BD_metier {
 
  /**
     * Newsletter ID.
     * @var     int
     * @access  private
     */
    var $_lst_id;

    /**
     * nom de la liste newsletter.
     * @var    int
     * @access  private
     */
    var $_lst_name ;

    /**
     * Commentaire associ
     * @var     String
     * @access  private
     */
    var $_lst_comment ;

    /**
     * lst_moderation
     * @var     String(open)
     * @access  private
     */
    var $_lst_moderation;

    /**
     * liste des mails modrateurs
     * @var     string
     * @access  private
     */
    var $_lst_moderator_email;

    /**
     * lst_subscribe_subject
     * @var     String
     * @access  private
     */
    var $_lst_subscribe_subject;

    /**
     * lst_subscribe_text
     * @var     string
     * @access  private
     */
    var $_lst_subscribe_text;

    /**
     * lst_subject disponible
     * @var     string
     * @access  private
     */
    var $_lst_subject;

    /**
     * lst_unsubscribe_subject 
     * @var     string
     * @access  private
     */
    var $_lst_unsubscribe_subject;
    
    /**
     * lst_unsubscribe_text pour se dsincrire
     * @var     string
     * @access  private
     */
    var $_lst_unsubscribe_text ;    

    /**
     * lst_subject_tag
     * @var     int
     * @access  private
     */
    var $_lst_subject_tag ;  
    
    /**
     * lst_html_skeleton
     * @var     string
     * @access  private
     */
    var $_lst_html_skeleton ;     
 
    /**
     * lst_html_skeleton
     * @var     string
     * @access  private
     */
    var $_lst_text_skeleton ;    
    
     /**
     * lst_html_skeleton
     * @var     int
     * @access  private
     */
    var $_lst_nb_articles ;    
 

 function newsletterCmList() {
    }

    // }}}

    // {{{ newsletterCmList()

    function getLstId() {
        return $this->_lst_id;
    }

    // }}}

    // {{{ getLstId()

    function setLstId($id) {
        $this->_lst_id = $id;
    }

    // }}}

    // {{{ setLstId()


    function getLstName() {
        return $this->_lst_name;
    }

    // }}}

    // {{{ getLstName()

    function setLstName($name) {
        $this->_lst_name = $name;
    }

    // }}}

    // {{{ setLstName()

  function getLstComment() {
        return $this->_lst_comment;
    }

    // }}}

    // {{{ getLstComment()

    function setLstComment($name) {
        $this->_lst_comment = $name;
    }

    // }}}

    // {{{ setLstComment()

  function getLstModeration() {
        return $this->_lst_moderation;
    }

    // }}}

    // {{{ getLstModeration()

    function setLstModeration($name) {
        $this->_lst_moderation = $name;
    }

    // }}}

    // {{{ setLstModeration()

  function get_lst_moderator_email() {
        return $this->_lst_moderator_email;
    }

    // }}}

    // {{{ get_lst_moderator_email()

    function setLstModeratorEmail($mail) {
        $this->_lst_moderator_email = $mail;
    }

    // }}}

    // {{{ setLstModeratorEmail()

  function getLstSubscribeSubject() {
        return $this->_lst_subscribe_subject;
    }

    // }}}

    // {{{ getLstSubscribeSubject()

    function setLstSubscribeSubject($mail) {
        $this->_lst_subscribe_subject = $mail;
    }

    // }}}

    // {{{ setLstSubscribeSubject()

  function getLstSubscribeText() {
        return $this->_lst_subscribe_text;
    }

    // }}}

    // {{{ getLstSubscribeText()

    function setLstSubscribeText($tex) {
        $this->_lst_subscribe_text = $tex;
    }

    // }}}

    // {{{ setLstSubscribeText()


  function getLstSubject() {
        return $this->_lst_subject;
        
    }

    // }}}

    // {{{ getLstSubject()

    function setLstSubject($sub) {
        $this->_lst_subject = $sub;
    }

    // }}}

    // {{{ setLstSubject()

  function getLstUnsubscribeSubject() {
        return $this->_lst_unsubscribe_subject;
    }

    // }}}

    // {{{ getLstUnsubscribeSubject()

    function setLsUnsubscribeSubject($sub) {
        $this->_lst_unsubscribe_subject = $sub;
    }

    // }}}

    // {{{ setLsUnsubscribeSubject()

  function getLstUnsubscribeText() {
        return $this->_lst_unsubscribe_text;
    }

    // }}}

    // {{{ getLstUnsubscribeText()

    function setLstUnsubscribeText($tex) {
        $this->_lst_unsubscribe_text = $tex;
    }

    // }}}

    // {{{ setLstUnsubscribeText()

    function getLstSubjectTag() {
        return $this->_lst_subject_tag;
    }

    // }}}

    // {{{ getLstSubjectTag()

    function setLstSubjectTag($tag) {
        $this->_lst_subject_tag = $tag;
    }

    // }}}

    // {{{ setLstSubjectTag()

   function getLstHtmlSkeleton() {
        return $this->_lst_html_skeleton;
    }

    // }}}

    // {{{ getLstHtmlSkeleton()

    function setLstHtmlSkeleton($skeleton) {
        $this->_lst_html_skeleton = $skeleton;
    }

    // }}}

    // {{{ setLstHtmlSkeleton()

    function getLstTextSkeleton() {
        return $this->_lst_text_skeleton;
    }

    // }}}

    // {{{ getLstTextSkeleton()

    function setLstTextSkeleton($skeleton) {
        $this->_lst_text_skeleton = $skeleton;
    }

    // }}}

    // {{{ setLstTextSkeleton()

    function getLstNbArticles() {
        return $this->_lst_nb_articles;
    }

    // }}}

    // {{{ getLstNbArticles()

    function setLstNbArticles($article) {
        $this->_lst_nb_articles = $article;
    }

    // }}}

    // {{{ setLstNbArticles()


//
//La fonction create cre un nouvel enregistrement dans la table ".$GLOBALS['table_prefix']."_cm_list
//
 function create() {
       
       //print_r($this);
        $db = &$this->_getDB();
    if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_newsletter_cm_list : create()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        if($this->_lst_id == null) $this->_lst_id = 0;
        if($this->_lst_name == null) $this->_lst_name = "";
        if($this->_lst_comment == null) $this->_lst_comment = "";
        if($this->_lst_moderation == null) $this->_lst_moderation = "";
        if($this->_lst_moderator_email  == null) $this->_lst_moderator_email = "";
        if($this->_lst_subscribe_subject == null) $this->_lst_subscribe_subject = "";
        if($this->_lst_subscribe_text == null) $this->_lst_subscribe_text = "";
        if($this->_lst_unsubscribe_subject  == null) $this->_lst_unsubscribe_subject = "";
        if($this->_lst_unsubscribe_text == null) $this->_lst_unsubscribe_text = "";
        if($this->_lst_subject_tag   == null) $this->_lst_subject_tag  = 0;
        if($this->_lst_html_skeleton == null) $this->_lst_html_skeleton = "";
        if($this->_lst_text_skeleton   == null) $this->_lst_text_skeleton  = "";
        if($this->_lst_nb_articles == null) $this->_lst_nb_articles = 0;

         $query = "INSERT INTO ".$GLOBALS['table_prefix']."_cm_lists (".NEWSLETTERS_ALL_LIST.") VALUES "
                ."('".$this->_lst_id."', "
                ."'".$this->_lst_name."', "
                ."'".$this->_lst_comment."', "
                ."'".$this->_lst_moderation."', "
                ."'".$this->_lst_moderator_email."', "
                ."'".$this->_lst_subscribe_subject."', "
                ."'".$this->_lst_subscribe_text."', "
                ."'".$this->_lst_subject."', "
                ."'".$this->_lst_unsubscribe_subject."', "
                ."'".$this->_lst_unsubscribe_text."', "
                ."'".$this->_lst_subject_tag."', "
                ."'".$this->_lst_html_skeleton."', "
                ."'".$this->_lst_text_skeleton."', "                 
                ."'".$this->_lst_nb_articles."')";

         
        //echo $query;
        //echo"<br />$query<br><br />";
        $result = $db->query($query);
         if (DB::isError($result)) {
            echo (mysql_error());
            return PEAR::raiseError("[".get_class($this)." DB_newsletter_cm_list : delete()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

    }
    
        // }}}

    // {{{ create()
    
    
    //La fonction load() affecte un enregistrement de la table ".$GLOBALS['table_prefix']."_cm_list
    
    function load($lst_id) {
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_nwsletter_cm_list : load()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        
        $query = "SELECT ".NEWSLETTERS_ALL_LIST." FROM ".$GLOBALS['table_prefix']."_cm_lists WHERE lst_id = $lst_id";
        
        //echo $query;
        
        
         
        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_newsletter_cm_list : load()] ".$result->getMessage()."", null,
                null, null, null, null, false);
            }
        else{

            if ($row = $result->fetchRow()) {
                
                $this->_lst_id = $row['lst_id'];
                $this->_lst_name = $row['lst_name'];
                $this->_lst_comment = $row['lst_comment'];
                $this->_lst_moderation = $row['lst_moderation'];
                $this->_lst_moderator_email = $row['lst_moderator_email'];
                $this->_lst_subscribe_subject = $row['lst_subscribe_subject'];
                $this->_lst_subscribe_text = $row['lst_subscribe_text'];
                $this->_lst_subject= $row['lst_subject'];
                $this->_lst_unsubscribe_subject = $row['lst_unsubscribe_subject'];
                $this->_lst_unsubscribe_text = $row['lst_unsubscribe_text'];
                $this->_lst_subject_tag = $row['lst_subject_tag'];
                $this->_lst_html_skeleton = $row['lst_html_skeleton'];
                $this->_lst_text_skeleton = $row['lst_text_skeleton'];
                $this->_lst_nb_articles = $row['lst_nb_articles'];
                } 
            else{
                return PEAR::raiseError("[".get_class($this)." DB_nwsletter_cm_list : load($idArticle)] Aucunes listes ne correspond pas  cet ID!", null,
                                    null, null, null, null, false);
            }
            $result->free();
        }
    }
    
           // }}}

    // {{{ load()
    
    
    //La fonction delete() supprimer un enregistrement de la table ".$GLOBALS['table_prefix']."_cm_list
    //Par dfaut, la fonction supprimer l'identifiant de l'objet appelant
    //Si une valeur est en entre (lst_id), alors c'est cet identifiant qui sera supprim
    //Chaque objet a donc la fonctionnalit de pouvoir supprimer n'importe quel objet de la base!!
    
    function delete($lst_id='') {
        
        if($lst_id=='')$lst_id=$this->getLstId();

        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_newsletter_cm_list : delete()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
     $query = "DELETE FROM ".$GLOBALS['table_prefix']."_cm_lists WHERE lst_id = $lst_id";
     
     
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_newsletter_cm_list : delete()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

    }

    
           // }}}

    // {{{ delete()


       //Fonction factory pour l'instanciation de l'objet

     function &factory($dbParameters, $dbOptions = null) {

        if(file_exists(dirname(__FILE__)."/".$dbParameters->_dbEngine."/newsletter_cm_list_".$dbParameters->_dbEngine.".php") == false) {
            include_once(dirname(__FILE__)."/common/newsletter_cm_list_common.php");
            $classname = "BD_newsletter_cm_list";
        }
        else {
            include_once(dirname(__FILE__)."/".$dbParameters->_dbEngine."/newsletter_cm_list_".$dbParameters->_dbEngine.".php");
            $classname = "BD_newsletter_cm_list_".$dbParameters->_dbEngine;
        }

        if (!class_exists($classname)) {
            return PEAR::raiseError("Cannot instanciate class $classname", null,
                null, null, null, null, false);
        }

        $obj =& new $classname;
        $result = $obj->setDbParameters($dbParameters);
        if ($dbOptions != null) {
            $obj->setDbOptions($dbOptions);
        }
        if (PEAR::isError($result)) {
            return $result;
        } else {
            return $obj;
        }
    }  
 }
            // }}}

    // {{{ factory()
 