<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Antoine Angnieux <aangenieux@clever-age.com>                |
// +----------------------------------------------------------------------+
//
// Base class for Article business persistence abstraction.


// $Id$
//

require_once (dirname(__FILE__)."/metier.php");
require_once (dirname(__FILE__).'/inc_subscriber_factory.php');
require_once (dirname(__FILE__).'/inc_cm_user_groups_factory.php');
require_once (dirname(__FILE__)."/../../inc_filtres.php3");
require_once (dirname(__FILE__)."/../../inc_meta.php3");

define ('NEWSLETTER_INSTANCE_ALL_FIELDS', 'pst_id, lst_id, pst_date_create, pst_date_update, pst_date_sent, pst_subject, destinataires_specifiques, user_group_inactif ');

/**
 * BD_article is a base class for article business persistence abstraction implementations, and must be
 * inherited by all such.
 * @package	BD
 * @author  Antoine Angnieux <aangenieux@clever-age.com>
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @access	public
 */
class BD_newsletterInstance extends BD_metier {
	// {{{ properties

	var $_id;
	var $_newsletterId;
	var $_creationDate;
	var $_modificationDate;
	var $_sentDate;
	var $_subject;
	var $_destinatairesSpecifiques;
	var $_userGroupInactif;

	// }}}

	// {{{ factory()

	function & factory($dbParameters = null, $dbOptions = null) {
		if (file_exists(dirname(__FILE__)."/".$dbParameters -> _dbEngine."/newsletter_instance_".$dbParameters -> _dbEngine.".php") == false) {
			include_once (dirname(__FILE__)."/common/newsletter_instance_common.php");
			$classname = "BD_newsletterInstance_common";
		} else {
			include_once (dirname(__FILE__)."/".$dbParameters -> _dbEngine."/newsletter_instance_".$dbParameters -> _dbEngine.".php");
			$classname = "BD_newsletterInstance_".$dbParameters -> _dbEngine;
		}

		if (!class_exists($classname)) {
			return PEAR :: raiseError("Cannot instanciate class $classname", null, null, null, null, null, false);
		}

		$obj = & new $classname;

		$result = $obj -> setDbParameters($dbParameters);
		if ($dbOptions != null) {
			$obj -> setDbOptions($dbOptions);
		}
		if (PEAR :: isError($result)) {
			return $result;
		} else {
			return $obj;
		}
	}

	// }}}

	// {{{ constructor

	/**
	 * DB_newsletter constructor.
	 *
	 * @access public
	 */

	function BD_newsletter() {
	}

	// }}}

	// {{{ getId()

	function getId() {
		return $this -> _id;
	}

	// }}}

	// {{{ setId()

	function setId($id) {
		$this -> _id = $id;
	}

	// }}}

	// {{{ getNewsletterId()

	function getNewsletterId() {
		return $this -> _newsletterId;
	}

	// }}}

	// {{{ setNewsletterId()

	function setNewsletterId($newsletterId) {
		$this -> _newsletterId = $newsletterId;
	}

	// }}}

	// {{{ getCreationDate()

	function getCreationDate() {
		return $this -> _creationDate;
	}

	// }}}

	// {{{ setCreationDate();

	function setCreationDate($creationDate) {
		$this -> _creationDate = $creationDate;
	}

	// }}}

	// {{{ getModificationDate()

	function getModificationDate() {
		return $this -> _modificationDate;
	}

	// }}}

	// {{{ setModificationDate();

	function setModificationDate($modificationDate) {
		$this -> _modificationDate = $modificationDate;
	}

	// }}}

	// {{{ getSentDate()

	function getSentDate() {
		return $this -> _sentDate;
	}

	// }}}

	// {{{ setSentDate();

	function setSentDate($sentDate) {
		$this -> _sentDate = $sentDate;
	}

	// }}}

	// {{{ getSubject()

	function getSubject() {
		return $this -> _subject;
	}

	// }}}

	// {{{ setSubject()

	function setSubject($subject) {
		$this -> _subject = corriger_caracteres($subject);
	}

	// }}}

	// {{{ getDestinatairesSpecifiques()

	function getDestinatairesSpecifiques() {
		return $this -> _destinatairesSpecifiques;
	}

	// }}}

	// {{{ setDestinatairesSpecifiques()

	function setDestinatairesSpecifiques($destinatairesSpecifiques) {
		$this -> _destinatairesSpecifiques = corriger_caracteres($destinatairesSpecifiques);
	}

	// }}}

	// {{{ getUserGroupInactif()

	function getUserGroupInactif() {
		return $this -> _userGroupInactif;
	}

	// }}}

	// {{{ setUserGroupInactif()

	function setUserGroupInactif($userGroupInactif) {
		$this -> _userGroupInactif = corriger_caracteres($userGroupInactif);
	}

	// }}}

	// {{{ create()

	function create() {
		$db = & $this -> _getDB();
        $string_prefix = $GLOBALS['table_prefix']."_cm_posts";
		$postId = $db -> nextId($string_prefix, true);
		if (DB :: isError($db)) {
			return PEAR :: raiseError("[".get_class($this)." DB_newsletter_instance : create()] ".$db -> getMessage()."", null, null, null, null, null, false);
		}
		$this -> _id = $postId;
		$maDate = new Date();
		$this -> setCreationDate($maDate -> getDate(DATE_FORMAT_ISO));
		$this -> setModificationDate($maDate -> getDate(DATE_FORMAT_ISO));

		if (!isset($this -> _destinatairesSpecifiques)) {
			$this -> setDestinatairesSpecifiques('');
		}

		$query = 'INSERT INTO '.$GLOBALS['table_prefix'].'_cm_posts ('.NEWSLETTER_INSTANCE_ALL_FIELDS.') VALUES '."('".$this -> _id."', "."'".$this -> _newsletterId."', "."'".$this -> _creationDate."', "."'".$this -> _modificationDate."', "."'".$this -> _sentDate."', "."'".$db -> quoteString($this -> _subject)."', "."'".$db -> quoteString($this -> _destinatairesSpecifiques)."', "."'".$db -> quoteString($this -> _userGroupInactif)."') ";
		//echo '<br>' . $query . '<br>';
		 

		$result = $db -> query($query);
		if (DB :: isError($result)) {
			return PEAR :: raiseError("[".get_class($this)." DB_newsletter_instance : create()] ".$result -> getMessage()."", null, null, null, null, null, false);
		}
	}

	// }}}

	// {{{ update()

	function update() {
		$db = & $this -> _getDB();
		$maDate = new Date();
		$this -> setModificationDate($maDate -> getDate(DATE_FORMAT_ISO));

		if (!isset($this -> _destinatairesSpecifiques)) {
			$this -> setDestinatairesSpecifiques('');
		}

		$query = "UPDATE ".$GLOBALS['table_prefix']."_cm_posts SET "."pst_id = '".$this -> _id."'".", lst_id = '".$this -> _newsletterId."'".", pst_date_update = '".$this -> _modificationDate."'".", pst_date_sent = '".$this -> _sentDate."'".", pst_subject = '".$db -> quoteString($this -> _subject)."'".", destinataires_specifiques = '".$db -> quoteString($this -> _destinatairesSpecifiques)."'".", user_group_inactif = '".$db -> quoteString($this -> _userGroupInactif)."'"." WHERE pst_id = ".$this -> _id;

		 

		$result = $db -> query($query);
		if (DB :: isError($result)) {
			die('error during update query on '.$GLOBALS['table_prefix'].'_cm_posts'.$result -> getMessage());
		}

	}

	// }}}

	// {{{ load()

	function load($id) {
		$db = & $this -> _getDB();
		if (DB :: isError($db)) {
			return $db;
		}

		$query = "SELECT ".NEWSLETTER_INSTANCE_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_cm_posts WHERE pst_id = $id";
		//echo '<br>' . $query . '<br>';
		 
		$result = $db -> query($query);

		if (DB :: isError($result)) {
			return $result;
		} else {
			if ($row = $result -> fetchRow()) {
				$this -> _fetchData($row);
			} else {
				return PEAR::raiseError("[".get_class($this)." DB_newsletter_instance : load($id)] Aucun post ne correspond  cet ID!", null,
                                    null, null, null, null, false);
			}
			$result -> free();
		}
	}

	// }}}

	// {{{ delete()

	function delete($id) {
		$db = & $this -> _getDB();

		if (DB :: isError($db)) {
			return $db;
		}

		$query = "DELETE FROM ".$GLOBALS['table_prefix']."_cm_posts WHERE pst_id = $id";

		// ATTENTION, SI CETTE FONCTIONNALITE EST IMPLEMTENTEE, PENSEZ A SUPPRIMER TOUTES LES REFERENCES
		// A CETTE LISTE!!

		 
		$result = $db -> query($query);
		if (DB :: isError($result)) {
			return $result;
		}

	}

	// }}}

	// {{{ contains()
	function contains($article_id, $position) {
		$db = & $this -> _getDB();

		if (DB :: isError($db)) {
			return $db;
		}

		$query = 'SELECT article_id, pst_id, art_order FROM '.$GLOBALS['table_prefix'].'_cm_posts_articles '.'WHERE article_id = '.$article_id.' AND pst_id = '.$this -> _id.' AND art_order = '.$position;

		 
		$result = $db -> getOne($query);
		if (DB :: isError($result)) {
			return $result;
		}
		if ($result) {
			return true;
		} else {
			return false;
		}
	}
	// }}}

	// {{{ linkArticle()

	function linkArticle($article_id, $position) {
		$db = & $this -> _getDB();

		if (DB :: isError($db)) {
			return $db;
		}

		$query = 'DELETE FROM '.$GLOBALS['table_prefix'].'_cm_posts_articles '.'WHERE article_id = '.$article_id.' AND pst_id = '.$this -> _id;

		 
		$result = $db -> query($query);
		if (DB :: isError($result)) {
			return $result;
		}
		$query = 'INSERT INTO '.$GLOBALS['table_prefix'].'_cm_posts_articles (article_id, pst_id, art_order) '."VALUES ('$article_id', '".$this -> _id."', '$position')";
		 
		$result = $db -> query($query);
		if (PEAR :: isError($result)) {
			die($result -> getMessage());
		}
	}

	// }}}

	// {{{ getLinkedArticles()

	function getLinkedArticles() {
		$db = & $this -> _getDB();
		if (DB :: isError($db)) {
			return $db;
		}
		$query = 'SELECT article_id, art_order FROM '.$GLOBALS['table_prefix'].'_cm_posts_articles '.'WHERE pst_id = '.$this -> _id.' ORDER BY art_order ASC';

		 
		$queryResult = $db -> query($query);
		$linkedArticles = array();
		if (DB :: isError($result)) {
			die('Error executing select on '.$GLOBALS['table_prefix'].'_cm_posts_articles. '.$result -> getMessage());
		} else {
			while ($row = $queryResult -> fetchRow()) {
				$articleMetier = & recuperer_instance_article();
				$loadOK = $articleMetier -> load($row['article_id']);
				if (PEAR :: isError($loadOK)) {
					die($loadOK -> getMessage());
				}
				$linkedArticles[] = & $articleMetier;
			}
			$queryResult -> free();
		}
		return $linkedArticles;
	}

	// }}}

	// {{{ getLinkedArticleIds()

	function getLinkedArticleIds() {
		$db = & $this -> _getDB();
		if (DB :: isError($db)) {
			return $db;
		}
		$query = 'SELECT article_id, art_order FROM '.$GLOBALS['table_prefix'].'_cm_posts_articles '.'WHERE pst_id = '.$this -> _id.' ORDER BY art_order ASC';

		 
		$queryResult = $db -> query($query);
		$linkedArticleIds = array();
		if (DB :: isError($result)) {
			die('Error executing select on '.$GLOBALS['table_prefix'].'_cm_posts_articles. '.$result -> getMessage());
		} else {
			while ($row = $queryResult -> fetchRow()) {
				$linkedArticleIds[] = $row['article_id'];
			}
			$queryResult -> free();
		}
		return $linkedArticleIds;
	}

	// }}}

	// {{{ activerGroupe($idGroupe)

	function activerGroupe($idGroupe) {
		$db = & $this -> _getDB();
		if (DB :: isError($db)) {
			return $db;
		}

		$userGroupInactif = explode(";", $this -> getUserGroupInactif());

		$key = array_search($idGroupe, $userGroupInactif);
		if ($key >= 0) {
			unset($userGroupInactif[$key]);
		}
		$this -> setUserGroupInactif(implode(";", $userGroupInactif));
		$updateOK = $this -> update();
		if (PEAR :: isError($updateOK)) {
			return PEAR :: raiseError("[".get_class($this)." BD_newsletterInstance : activerGroupe()] ".$updateOK -> getMessage()."", null, null, null, null, null, false);
		}
	}

	// }}}

	// {{{ desactiverGroupe($idGroupe)

	function desactiverGroupe($idGroupe) {
		$db = & $this -> _getDB();
		if (DB :: isError($db)) {
			return PEAR :: raiseError("[".get_class($this)." BD_newsletterInstance : desactiverGroupe()] ".$db -> getMessage()."", null, null, null, null, null, false);
		}

		$userGroupInactif = explode(";", $this -> getUserGroupInactif());

		$key = array_search($idGroupe, $userGroupInactif);
		if ($key == false) {
			$userGroupInactif[] = $idGroupe;
		}
		$this -> setUserGroupInactif(implode(";", $userGroupInactif));
		$updateOK = $this -> update();
		if (PEAR :: isError($updateOK)) {
			return PEAR :: raiseError("[".get_class($this)." BD_newsletterInstance : desactiverGroupe()] ".$updateOK -> getMessage()."", null, null, null, null, null, false);
		}
	}

	// }}}

	// {{{ initializePosts()

	function initializePosts() {
		$emails = array();
		$db = & $this -> _getDB();
		if (DB :: isError($db)) {
			return PEAR :: raiseError("[".get_class($this)." BD_newsletterInstance : initializePosts()] ".$db -> getMessage()."", null, null, null, null, null, false);
		}

		//Recuperation des inscrits du FRONT
		$subscriberMetier = & recuperer_instance_subscriber();
		$emails = $emails = array_merge($emails, $subscriberMetier -> getSubscribersForLstId($this -> getNewsletterId()));
		if (PEAR :: isError($emails)) {
			die($emails -> getMessage());
		}

		//Recuperation des groupes generaux definis pour cette newsletter
		$cmUserGroupMetier = & recuperer_instance_cm_user_groups();
		$groups = $cmUserGroupMetier -> getAllUserGroups($this -> getNewsletterId());
		if (PEAR :: isError($groups)) {
			die($groups -> getMessage());
		}

		while (list (, $myGroup) = each($groups)) {
			if (!in_array($myGroup->getGroupeId(), explode(",", $this->getUserGroupInactif()))) {
				$emails = array_merge($emails, $myGroup -> getSubscribersForGroupId());
			}
		}

		//Recuperation des groupes specifiques a ce post
		$cmUserGroupMetier = & recuperer_instance_cm_user_groups();
		$groups = $cmUserGroupMetier -> getAllUserGroupsForPostId($this -> getId());
		if (PEAR :: isError($groups)) {
			die($groups -> getMessage());
		}

		while (list (, $myGroup) = each($groups)) {
			$emails = array_merge($emails, $myGroup -> getSubscribersForGroupId());
		}

		$maDate = new Date();
		while (list (, $monEmail) = each($emails)) {
			$query = 'INSERT INTO '.$GLOBALS['table_prefix'].'_cm_posts_queued VALUES ('.$this -> getId().', '.$monEmail['id_auteur'].', '.$monEmail['id_sub'].', \''.$monEmail['email'].'\',  ' . $monEmail['mode'] . ', \''.$maDate -> getDate().'\')';
			//echo '<br>' . $query . '<br>'; 
			 
			$queryResult = $db -> query($query);

			if (DB :: isError($queryResult)) {
				return PEAR :: raiseError("[".get_class($this)." BD_newsletterInstance : initializePosts()] ".$queryResult -> getMessage()."", null, null, null, null, null, false);
			}
		}
		$this->setSentDate($maDate->getDate(DATE_FORMAT_ISO));
		$updateOK = $this->update(); 
		if(PEAR::isError($updateOK)) {
			die($updateOK->getMessage());
		}
	}

	// }}}

    // {{{ isAlreadyQueued()

    function isAlreadyQueued() {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." BD_newsletterInstance : isAlreadyQueued()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        $query = "SELECT COUNT(*) FROM ".$GLOBALS['table_prefix']."_cm_posts_queued WHERE pst_id = ".$this->getId();

         

        $nb = $db->getOne($query);

        if (DB::isError($nb)) {
			die("[".get_class($this)." BD_newsletterInstance : isAlreadyQueued()] ".$nb->getMessage());
        }

        if ($nb >= 1) return true;
        else return false;
    }

    // }}}
    
    // {{{ cancelPosts()

    function cancelPosts() {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." BD_newsletterInstance : cancelPosts()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_cm_posts_queued WHERE pst_id = ".$this->getId();

         

        $result = $db->query($query);

        if (DB::isError($result)) {
			die("[".get_class($this)." BD_newsletterInstance : cancelPosts()] ".$result->getMessage());
        }

    }

    // }}}    
    
	// {{{ getAllPosts($number)

    function &getAllPosts($number = 25) {
        $posts = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." BD_newsletterInstance : getAllPosts()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

		$query = 'SELECT pst_id, id_auteur, id_sub, email, sub_mode AS mode FROM '.$GLOBALS['table_prefix'].'_cm_posts_queued ORDER BY psq_date';
		
		 
		//echo '<br>' . $query . '<br>';
		
		$result = $db->limitQuery($query, 0, $number);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." BD_newsletterInstance : getAllPosts()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $result->fetchRow()) {
            $posts[] = $row;
        }
        $result->free();
        return $posts;
    }

    // }}}
  
  	// {{{ isAlreadySend($myPost)

    function isAlreadySend($myPost) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." BD_newsletterInstance : isAlreadySend()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        // Modifcation elebescond omansour
        if ($myPost['id_auteur'] != 0) { // c un auteur 
            $query = 'SELECT COUNT(*) FROM '.$GLOBALS['table_prefix'].'_cm_posts_done WHERE pst_id = ' . $myPost['pst_id'] . ' AND id_auteur = ' . $myPost['id_auteur'];
        } else { // c un cm_subscriber
            $query = 'SELECT COUNT(*) FROM '.$GLOBALS['table_prefix'].'_cm_posts_done WHERE pst_id = ' . $myPost['pst_id'] . ' AND id_sub = ' . $myPost['id_sub'];
        }
		//$query = 'SELECT COUNT(*) FROM '.$GLOBALS['table_prefix'].'_cm_posts_done WHERE (pst_id = ' . $myPost['pst_id'] . ' AND id_sub = ' . $myPost['id_sub'] . ') OR (pst_id = ' . $myPost['pst_id'] . ' AND id_auteur = ' . $myPost['id_auteur'] . ')';
        // fin modifs
		//echo $query;
		$nb = $db->getOne($query);
        //print_r ($nb);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." BD_newsletterInstance : isAlreadySend()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

        if ($nb >= 1) return true;
        else return false;
    }

    // }}}  
    
      	// {{{ deletePostQueued($myPost)

    function deletePostQueued($myPost) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." BD_newsletterInstance : deletePostQueued()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
		$query = 'DELETE FROM '.$GLOBALS['table_prefix'].'_cm_posts_queued WHERE pst_id = ' . $myPost['pst_id'] . ' AND id_auteur = ' . $myPost['id_auteur'] . ' AND id_sub = '.$myPost['id_sub']; 
		
		$nb = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." BD_newsletterInstance : deletePostQueued()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

		return true;
    }

    // }}} 
    
	// {{{ setPostDone($myPost)

    function setPostDone($myPost) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." BD_newsletterInstance : setPostDone()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        $query = 'INSERT INTO '.$GLOBALS['table_prefix'].'_cm_posts_done VALUES ('.$this -> getId().', '.$myPost['id_auteur'].', '.$myPost['id_sub'].', \''.$myPost['email'].'\')';

         

        $result = $db->query($query);

        if (DB::isError($result)) {
			die("[".get_class($this)." BD_newsletterInstance : setPostDone()] ".$result->getMessage());
        }

    }

    // }}}  
    
	// {{{ _fetchData()

	function _fetchData($row) {
		$this -> setId($row['pst_id']);
		$this -> setNewsletterId($row['lst_id']);
		$this -> setCreationDate($row['pst_date_create']);
		$this -> setModificationDate($row['pst_date_update']);
		$this -> setSentDate($row['pst_date_sent']);
		$this -> setSubject($row['pst_subject']);
		$this -> setDestinatairesSpecifiques($row['destinataires_specifiques']);
		$this -> setUserGroupInactif($row['user_group_inactif']);
	}

	// }}}

		// {{{ percentage_left()
		//Fonction de calcul du nombre de post envoy par rapport au nombre total
    function percentage_left($id_post, $id_newsletter) {
    	$db = &$this->_getDB();
			
			if (DB::isError($db)) {
      	 return PEAR::raiseError("[".get_class($this)." BD_newsletterInstance : percentage_left()] ".$db->getMessage()."", null,
                null, null, null, null, false);
      	}
      $queryTotal = "";
 		  /*
          $queryTotal .= " SELECT  sub_id  AS nbSubTotal ";
			$queryTotal .= " 			 FROM ".$GLOBALS['table_prefix']."_lists_subscribers ";
			$queryTotal .= " 			 WHERE lst_id = $id_newsletter ";
            */
			
			$queryQueued .= " SELECT  id_sub  AS nbSubQueued ";
			$queryQueued .= " 			 FROM ".$GLOBALS['table_prefix']."_cm_posts_queued ";
			$queryQueued .= " 			 WHERE pst_id = $id_post";			

			$queryDone .= " SELECT  id_sub  AS nbSubDone ";
			$queryDone .= " 			 FROM ".$GLOBALS['table_prefix']."_cm_posts_done ";
			$queryDone .= " 			 WHERE pst_id = $id_post";		


            // $resultTotal = $db->query($queryTotal);
			$resultQueued = $db->query($queryQueued);
			$resultDone =  $db->query($queryDone);
            
            
      if ((DB::isError($resultTotal))&&(DB::isError($resultQueued))&&(DB::isError($resultDone))) {
				 die("[".get_class($this)." BD_newsletterInstance : percentage_left()] ".$result->getMessage());
      	 }				
    	else{
			//traitement
				 // $nbTotal = $resultTotal->numRows();
				 $nbQueued = $resultQueued->numRows();
                 if (DB::isError($nbQueued)) {
                    $nbQueued = 0;   
                 }
				 $nbDone = $resultDone->numRows();
                 if (DB::isError($nbDone)) {
                    $nbDone = 0;   
                 }
                 $nbTotal = $nbQueued + $nbDone;  
                 $nbCurrent = $nbDone; 
        /*
				 if($resultDone['nbSubDone']==0){
	 				  $nbTotal = $rowTotal['nbSubTotal'];
						$nbCurrent = 0;	 
				 }elseif($resultDone['nbSubDone']>0){
				 		$nbTotal = $rowTotal['nbSubTotal'];
				 		$nbCurrent = $rowTotal['nbSubTotal'] - $rowQueued['nbSubQueued'];				 		
				 }
         */ 
         return(array($nbCurrent,$nbTotal));

        }
		}
    // }}}
		

		//delete_pst(){
		//Fonction de suppression des modles de lettres pst
		function delete_pst($pst_id){
			$db = &$this->_getDB();
			
			if (DB::isError($db)) {
      	 return PEAR::raiseError("[".get_class($this)." BD_newsletterInstance : delete_pst()] ".$db->getMessage()."", null,
                null, null, null, null, false);
      	}else{
				 	$queryDeleteDone = "";
     		  $queryDeleteDone .= " DELETE FROM ".$GLOBALS['table_prefix']."_cm_posts_done  ";
    			$queryDeleteDone .= " 			 WHERE pst_id = $pst_id ";
					$db->query($queryDeleteDone);
					
					if ((DB::isError($resultTotal))&&(DB::isError($resultQueued))&&(DB::isError($resultDone))) {
				 		 die("[".get_class($this)." BD_newsletterInstance : percentage_left()] ".$result->getMessage());
      	 		 }				
    			else{
							$queryDeleteModele = "";
     		  		$queryDeleteModele .= " DELETE FROM ".$GLOBALS['table_prefix']."_cm_posts  ";
    					$queryDeleteModele .= " 			 WHERE pst_id = $pst_id ";
							$db->query($queryDeleteModele);
							if ((DB::isError($resultTotal))&&(DB::isError($resultQueued))&&(DB::isError($resultDone))) {
				 		 		 die("[".get_class($this)." BD_newsletterInstance : percentage_left()] ".$result->getMessage());
      	 		 	}	
					 }
				}
		}
		
		//consult_pst_done(){
		//Fonction de consultation des inscrits ayant reu la lettre d'information
		function consult_pst_done($pst_id,$lst_id){
      $db = &$this->_getDB();
			
			if (DB::isError($db)) {
      	 return PEAR::raiseError("[".get_class($this)." BD_newsletterInstance : consult_pst_done()] ".$db->getMessage()."", null,
                null, null, null, null, false);
      	}else{
              $queryConsultDone  = "SELECT *"
                      . " FROM ".$GLOBALS['table_prefix']."_cm_posts_done, ".$GLOBALS['table_prefix']."_cm_subscribers "
                        //.$GLOBALS['table_prefix']."_cm_lists_subscribers'
                      . " WHERE ".$GLOBALS['table_prefix']."_cm_posts_done.pst_id =".$pst_id
                      . " AND ".$GLOBALS['table_prefix']."_cm_subscribers.sub_id = ".$GLOBALS['table_prefix']."_cm_posts_done.id_sub"
                      //. " AND ".$GLOBALS['table_prefix']."_cm_lists_subscribers.sub_id = "
                      //. " ".$GLOBALS['table_prefix']."_cm_posts_done.id_sub"
                      //. " AND ".$GLOBALS['table_prefix']."_cm_lists_subscribers.lst_id=".$lst_id
                      . " ORDER BY ".$GLOBALS['table_prefix']."_cm_subscribers.sub_email ASC";
              //echo $queryConsultDone;							
              $resultConsultDone = $db->query($queryConsultDone);
							
						
					if ((DB::isError($resultTotal))&&(DB::isError($resultQueued))&&(DB::isError($resultDone))) {
				 		 die("[".get_class($this)." BD_newsletterInstance : consult_pst_done()] ".$result->getMessage());
      	 		 }				
    			else{
							while ($row = $resultConsultDone->fetchRow()) {
									$posts[] = $row;
              }
					 }
				}
				return($posts);
		}
		
		// {{{ verificationAffichagePanneau()
		//Fcontion de vrification que des subscruber sont en attente de recevoir leur newsletter
		function countSubscribersQueued() {
    	$db = &$this->_getDB();
			
			if (DB::isError($db)) {
      	 return PEAR::raiseError("[".get_class($this)." BD_newsletterInstance : countSubscribersQueued()] ".$db->getMessage()."", null,
                null, null, null, null, false);
      	}
			
			$queryQueued .= " SELECT count( id_sub ) AS nbSubQueued ";
			$queryQueued .= " 			 FROM ".$GLOBALS['table_prefix']."_cm_posts_queued ";	

			$resultQueued = $db->query($queryQueued);
			
      if (DB::isError($resultQueued)) {
				 die("[".get_class($this)." BD_newsletterInstance : countSubscribersQueued()] ".$resultQueued->getMessage());
      	 }				
    	else{
			//traitement
				 $rowQueued = $resultQueued->fetchRow();
				 return $rowQueued['nbSubQueued'];
		}
	}	
 	// }}}
}
?>
