<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Matthieu Belge <mbelge@clever-age.com>                       |
// | Author: Antoine Angnieux <aangenieux@clever-age.com>                |
// +----------------------------------------------------------------------+
//
// Base class for Newsletter List Data abstraction.
//

/**
 * BD_newsletterListData is a base class for newsletter lists data database abstraction implementations, and must be
 * inherited by all such.
 * @package	BD
 * @author  Antoine Angnieux <aangenieux@clever-age.com>
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @access	public
 */

if (defined("_BD_NEWSLETTERLISTDATA")) return;
    define("_BD_NEWSLETTERLISTDATA", "1");

require_once "PEAR.php";
require_once "DB.php";
require_once dirname(__FILE__)."/objectlistdata.php";
require_once dirname(__FILE__)."/inc_listdata_querytypes_constants.php";

class BD_newsletterListData extends BD_objectListData {

    /**
     * Create a new newsletter list data object for the specified database parameters
     * passed
     *
     * @param BD_parameters $dbParameters database configuration object
     * @return mixed a newly created NewsletterListData object, or a PEAR error code on
     *               error
     * @access public
     */
    function &factory($dbParameters = null, $dbOptions = null) {
        if(file_exists(dirname(__FILE__)."/".$dbParameters->_dbEngine."/newsletterlistdata_".$dbParameters->_dbEngine.".php") == false) {
            include_once(dirname(__FILE__)."/common/newsletterlistdata_common.php");
            $classname = "BD_newsletterlistdata_common";
        }
        else {
            include_once(dirname(__FILE__)."/".$dbParameters->_dbEngine."/newsletterlistdata_".$dbParameters->_dbEngine.".php");
            $classname = "BD_newsletterlistdata_".$dbParameters->_dbEngine;
        }

        if (!class_exists($classname)) {
            return PEAR::raiseError("Cannot instanciate class $classname", null,
                                    null, null, null, null, false);
        }

        $obj =& new $classname;

        $result = $obj->setDbParameters($dbParameters);
        if ($dbOptions != null) {
            $obj->setDbOptions($dbOptions);
        }
        if (PEAR::isError($result)) {
            return $result;
        } else {
            return $obj;
        }
    }

    // {{{ constructor

    /**
     * Abstract Constructor.
     *
     * @access public
     */


    function BD_newsletterListData() {
        $par = get_parent_class(get_parent_class($this));

        $this->$par();
    }

    // }}}


    // {{{ getHTMLList($titre_table, $queryType, $params, $afficher_visites = false, $afficher_auteurs = true, $toujours_afficher = false, $afficher_cadre = true)

    /**
     * returns the HTML List for the various article data lists implementations
     * This method should <b>NEVER<b> be overloaded, otherwise EXTRA-EXTRA-CARE is required
     * while overloading this method.
     *
     * @return String reprensenting the generated HTML list navigation
     * @param $queryType int representing the desired query type (refer to inc_listdata_query_types_contants.php)
     * @param $params array containing the query parameters
     * @param $countQuery boolean : if set to true, the returned query is a count result query for the specified query type.
     * @access public
     */

    function displayHTMLList($titre_table, $queryType, $params = array(), $urlDest = 'newsletter_admin.php3') {
		global $connect_id_auteur, $connect_statut;
		$requete = $this->_getQuery($queryType, false, $params);
		$db = &$this->_getDB();
		if (DB::isError($db)) {
			die("Impossible d'obternir une connexion  la base de donnes! ".$db->getMessage());
		}
		$result = $db->query($requete, $params);
		if (DB::isError($result)) {
			die("la requete a choue! ".$result->getMessage());
		}
		debut_cadre_relief("newsletter-24.gif");
		echo "<table width=100% cellpadding=0 cellspacing=0 border=0><tr><td width=100% background=''>";
		echo "<table width=100% cellpadding=3 cellspacing=0 border=0>";
		bandeau_titre_boite_articles($titre_table, true);
		while ($row = $result->fetchRow()) {
			echo '<tr bgcolor="#FFFFFF"><td class="arial2" colspan="1"><a href="'.$urlDest.'?id_newsletter='.$row['lst_id'].'" title="'.$row['lst_comment'].'"><img src="img_pack/puce-verte.gif" alt="" width="13" height="14" border="0"></a>&nbsp;&nbsp;<a href="'.$urlDest.'?id_newsletter='.$row['lst_id'].'" title="'.$row['lst_comment'].'">'.$row['lst_name'].'</a></td>'
			    .'<td class="arial2" nowrap>'.$row['lst_nb_articles'].' articles au choix</td></tr>';
		}
		$result->free();
		echo "</table></td></tr></table>";
		fin_cadre_relief();
		return $tous_id;
    }
    // }}}

    // {{{ _fillQueries()

    /**
     * This methods fill the query associative arrays with SQL 92 compliant
     * queries. Each driver that requires specific SQL querying must implement
     * the _adaptQueriesToDriver() method.
     * @access  private
     * @see     _adaptQueriesToDriver()
     */
    function _fillQueries() {
		$this->_queries[NEWSLETTER_ALL] = "SELECT lst_id, lst_name, lst_comment, lst_nb_articles "
										  ."FROM ".$GLOBALS['table_prefix']."_cm_lists "
										  ."ORDER BY lst_name";
	}

    // }}}

 		// {{{ getTabModelePlusQueued()

    /**
     * This function will return an array organized, depending on your newsletter
		 * It will help to manage multiples letters and be able to consult the percentage of launch letter
     */
    function getTabModelePlusQueued() {
			$db = &$this->_getDB();
  		if (DB::isError($db)) {
  			 return PEAR::raiseError("[".get_class($this)." DB_newsletterlistData : getTabModelePlusQueued()] ".$db->getMessage()."", null,
                null, null, null, null, false);
  		}

			$sqlQuery  = " SELECT * ";
			$sqlQuery .= " 				FROM spip_cm_posts, spip_cm_lists  ";
 			$sqlQuery .= " INNER JOIN spip_cm_posts_queued ";
 			$sqlQuery .= " 			 ON spip_cm_posts.pst_id = spip_cm_posts_queued.pst_id ";
			$sqlQuery .= " WHERE spip_cm_posts.lst_id = spip_cm_lists.lst_id";
			$sqlQuery .= " ORDER BY spip_cm_posts_queued.psq_date DESC";


      $result = $db->query($sqlQuery);
			$tabReturn = array();			
            
      if (DB::isError($result)) {
           return PEAR::raiseError("[".get_class($this)." DB_newsletterlistData : getTabModelePlusQueued()] ".$result->getMessage()."", null,
                  null, null, null, null, false);
      }else {
    			 while ($row = $result->fetchRow()) {
					 	$tabReturn[$row['lst_name']][$row['pst_id']] = $row;
        	}      		 
			 }	
      return($tabReturn);
		}
    // }}}
}
?>