<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Antoine Angnieux <aangenieux@clever-age.com>                |
// +----------------------------------------------------------------------+
//
// Base class for data list diplay
//


// $Id$

require_once ("PEAR.php");
require_once ("DB.php");
require_once (dirname(__FILE__)."/metier.php");
require_once (dirname(__FILE__)."/../../inc_version.php3");
require_once (dirname(__FILE__)."/../../inc_meta.php3");

/**
 * BD_objectListData is a base class for objects lists data database abstraction implementations, and must be
 * inherited by all such.
 * @package	BD
 * @author  Antoine Angnieux <aangenieux@clever-age.com>
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @access	public
 */

class BD_objectListData extends BD_metier {

    // {{{ properties

    /**
     * flag wether or not datas have been collected
     * used to check if navigation controls can be
     * generated
     *
     * @var     boolean
     * @access  private
     */

    var $_computed;

    /**
     * Represents the current SQL query
     *
     * @var     String
     * @access  private
     */

    var $_currentQuery;

    /**
     * flag wether or not the query to execute
     * must be limited using DB::limitQuery()
     *
     * @var     boolean
     * @access  private
     */

     var $_queryIsLimited;

    /**
     * indicates the beginning offset of the query limit
     *
     * @var     int
     * @access  private
     */

    var $_limitStart;

    /**
     * represents the number to which the result set must be limited
     *
     * @var     int
     * @access  private
     */

    var $_limitCount;

    /**
     * Array containing the list data queries
     *
     * @var     array
     * @access  private
     */
    var $_queries = array();

    /**
     * Array containing the list data count queries
     *
     * @var     array
     * @access  private
     */
     var $_queriesCount = array();

    // }}}

    // {{{ constructor

    /**
     * Basic constructor for all object list data implementations.
     * This parent constructor MUST be called when instanciating
     * any subclass.
     * @access public
     * @return void
     */

    function BD_objectListData() {
        $this->_fillQueries();
        $this->_adaptQueriesToDriver();
    }

    // }}}

    // {{{ _getComputed()

    /**
     * Get the computed flag state
     *
     * @return boolean flag value
     * @access private
     */

    function _getComputed() {
        return $this->_computed;
    }

    // }}}

    // {{{ _setComputed($_computed)

    /**
     * set the computed flag state
     *
     * @param $_computed boolean flag value
     * @access private
     */

    function _setComputed($_computed) {
        $this->_computed = $_computed;
    }

    // }}}

    // {{{ _getCurrentQuery()

    /**
     * Get the current SQL query for used for data list fetching
     * DEBUG USE!!
     *
     * @return String
     * @access public
     */

    function _getCurrentQuery() {
        return $this->_currentQuery;
    }

    // }}}

    // {{{ _setCurrentQuery($_currentQuery)

    /**
     * set the current query
     * DEBUG USE!!
     *
     * @param $_currentQuery String
     * @access public
     */

    function _setCurrentQuery($_currentQuery) {
        $this->_currentQuery = $_currentQuery;
    }

    // }}}

    // {{{ _getQueryIsLimited()

    /**
     * Get the queryIsLimited flag state
     *
     * @return boolean flag value
     * @access private
     */

    function _getQueryIsLimited() {
        return $this->_queryIsLimited;
    }

    // }}}

   // {{{ _setQueryIsLimited($_queryIsLimited)

    /**
     * set the queryIsLimited flag state
     *
     * @param $_queryIsLimited boolean flag value
     * @access private
     */

    function _setQueryIsLimited($_queryIsLimited) {
        $this->_queryIsLimited = $_queryIsLimited;
    }

    // }}}

    // {{{ _getLimitStart()

    /**
     * Get the limitStart value
     *
     * @return int limitStart value
     * @access private
     */

    function _getLimitStart() {
        return $this->_limitStart;
    }

    // }}}

    // {{{ _setLimitStart($_limitStart)

    /**
     * set the limitStart value
     *
     * @param $_limitStart int value
     * @access private
     */

    function _setLimitStart($_limitStart) {
        $this->_limitStart = $_limitStart;
    }

    // }}}

    /**
     * Get the limitCount value
     *
     * @return int limitCount value
     * @access private
     */

    function _getLimitCount() {
        return $this->_limitCount;
    }

    // }}}

    // {{{ _setLimitCount($_limitCount)

    /**
     * set the limitCount value
     *
     * @param $_limitCount int value
     * @access private
     */

    function _setLimitCount($_limitCount) {
        $this->_limitCount = $_limitCount;
    }

    // }}}

    // {{{ _getQuery($queryType, $countQuery = false, params = null)

    /**
     * returns the SQL query identified by the $queryType value.
     *
     * @return String representing the SQL request compliant with the driver implementation
     * @param $queryType int representing the desired query type (refer to inc_listdata_query_types_contants.php)
     * @param $countQuery boolean : if set to true, the returned query is a count result query for the specified query type.
     * @access private
     */

    function _getQuery($queryType, $countQuery = false, &$params) {
		if ($countQuery) {
            $queries = &$this->_getCountQueries();
        } else {
            $queries = &$this->_getQueries();
        }

        if (isset($queries[$queryType])) {
            $returnValue = $queries[$queryType];

            //Recuperation de la date courante au format ISO
            $maDate = new Date();
            $returnValue = ereg_replace("<!spipNOW_DATE_FORMAT_ISOspip!>", "'".$maDate->getDate(DATE_FORMAT_ISO)."'", $returnValue);

            //Recuperation de la date de la veille
            $maDate = new Date();
            $maDate->subtractSeconds(intval(24*3600));
            $returnValue = ereg_replace("<!spipDATE_SUBTRACT_ONE_DAYspip!>", "'".$maDate->getDate(DATE_FORMAT_ISO)."'", $returnValue);

            //Prparation de la requete de recherche
            //pour les articles
            if(ereg("<!spipARTICLE_CONSTRUCTION_RECHERCHEspip!>", $returnValue)) {
                if($params['id_article']) {
                    $returnValue = ereg_replace("<!spipARTICLE_CONSTRUCTION_RECHERCHEspip!>", " (id_article = " . $params['id_article'] . ") OR <!spipSUITE_RECHERCHEspip!>", $returnValue);
                }
                if( $params['titre'] ) {
                    $returnValue = ereg_replace( "<!spipSUITE_RECHERCHEspip!>", 
                                                 " (titre LIKE '%" . join("%' AND titre LIKE '%", $params['titre'])."%') ",
                                                 $returnValue );
                    $returnValue = ereg_replace( "<!spipARTICLE_CONSTRUCTION_RECHERCHEspip!>",
                                                 " (titre LIKE '%" . join("%' AND titre LIKE '%", $params['titre'])."%') ",
                                                 $returnValue );
                }
            }

            //pour les breves
            if(ereg("<!spipBREVE_CONSTRUCTION_RECHERCHEspip!>", $returnValue)) {
                if($params['id_breve']) {
                    $returnValue = ereg_replace("<!spipBREVE_CONSTRUCTION_RECHERCHEspip!>", " (id_breve = " . $params['id_breve'] . ") OR <!spipSUITE_RECHERCHEspip!>", $returnValue);
                }
                $returnValue = ereg_replace("<!spipSUITE_RECHERCHEspip!>", " (titre LIKE '%".join("%' AND titre LIKE '%", $params['titre'])."%') ", $returnValue);
                $returnValue = ereg_replace("<!spipBREVE_CONSTRUCTION_RECHERCHEspip!>", " (titre LIKE '%".join("%' AND titre LIKE '%", $params['titre'])."%') ", $returnValue);
            }

            //pour les rubriques
            if(ereg("<!spipRUBRIQUE_CONSTRUCTION_RECHERCHEspip!>", $returnValue)) {
                if($params['id_rubrique']) {
                    $returnValue = ereg_replace("<!spipRUBRIQUE_CONSTRUCTION_RECHERCHEspip!>", " (id_rubrique = " . $params['id_rubrique'] . ") OR <!spipSUITE_RECHERCHEspip!>", $returnValue);
                }
                if ( $params['titre'] ) {
                    $returnValue = ereg_replace( "<!spipSUITE_RECHERCHEspip!>", 
                                                 " (titre LIKE '%" . join("%' AND titre LIKE '%", $params['titre'])."%') ", 
                                                 $returnValue );
                    $returnValue = ereg_replace( "<!spipRUBRIQUE_CONSTRUCTION_RECHERCHEspip!>",
                                                 " (titre LIKE '%".join("%' AND titre LIKE '%", $params['titre'])."%') ", 
                                                 $returnValue );
                }
            }

            //pour les sites
            if(ereg("<!spipSYNDIC_CONSTRUCTION_RECHERCHEspip!>", $returnValue)) {
                if($params['id_syndic']) {
                    $returnValue = ereg_replace("<!spipSYNDIC_CONSTRUCTION_RECHERCHEspip!>", " (id_syndic = " . $params['id_syndic'] . ") OR <!spipSUITE_RECHERCHEspip!>", $returnValue);
                }
                $returnValue = ereg_replace("<!spipSUITE_RECHERCHEspip!>", " (nom_site LIKE '%".join("%' AND nom_site LIKE '%", $params['nom_site'])."%') ", $returnValue);
                $returnValue = ereg_replace("<!spipSYNDIC_CONSTRUCTION_RECHERCHEspip!>", " (nom_site LIKE '%".join("%' AND nom_site LIKE '%", $params['nom_site'])."%') ", $returnValue);
            }

            /*
            echo '<br><br>avant -->  '.$returnValue.'<br><br>';
            var_dump($params);
            */
			
			
     		$newParams = array();
     		
			
            $myArray = split("[\!]", $returnValue);
            $ind = 0;
            $returnValue = "";
            while(list(, $tok) = each($myArray)) {
                unset($myArrayTmp);
                $j = $ind;
                $myArrayTmp = split("[\?]", $tok);
                if(sizeOf($myArrayTmp) > 1) {
                    for($i=$ind;$i<($ind+sizeOf($myArrayTmp)-1);$i++) {
                        $newParams[] = $params[$j];
                        $j++;
                    }
                    $ind = $j;
                }
                $returnValue .= $tok.$params[$ind];
                $ind++;
            }
            $params = $newParams;

        } else {
            $returnValue = PEAR::raiseError("[".get_class($this)." _getQuery():] queryType $queryType undefined within this implementation !",
                              PEAR_LOG_CRIT, null, null, null, null, false);
        }

        //$returnValue = $this->_traiteQuery($returnValue);
        
        return $returnValue;
    }

    // }}}

    /// {{{ _getCountQueries()

    /**
     * This method returns the _queriesCount array
     * This method is "protected"
     * @return  array   Count list elements queries
     * @access private
     */
    function _getCountQueries() {
        return $this->_queriesCount;
    }

    // }}}

    // {{{ _getQueries()

    /**
     * This method returns the _queries array
     * @return  array   list elements queries
     */
    function _getQueries() {
        return $this->_queries;
    }

    // }}}

    // {{{ _getHTMLNavigation($queryType, $params, $colspan)

    /**
     * returns the HTML navigation for the vaious object data lists implementations
     * This method should <b>NOT<b> be overloaded, otherwise extra-care is required
     * while overloading this method.
     *
     * @return String reprensenting the generated HTML list navigation
     * @param $queryType int representing the desired query type (refer to inc_listdata_query_types_contants.php)
     * @param $params array containing parameters for a given query type
     * @param $countQuery boolean : if set to true, the returned query is a count result query for the specified query type.
     * @access private
     */

    function _getHTMLNavigation($queryType, $params, $colspan) {
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return;
        }

        $query_count = $this->_getQuery($queryType, true, $params);
        
        $this->_setCurrentQuery($query_count);


        $num_rows = $db->getOne($query_count, $params);
        //echo $num_rows;

        if (DB::isError($num_rows)) {
            // die($num_rows->getMessage());
            PEAR::raiseError($num_rows->getMessage(), PEAR_LOG_CRIT);
        }
        if (DB::isError($num_rows) || $num_rows == 0) return; 

    	$nb_aff = 10;
    	// Ne pas couper pour trop peu
    	if ($num_rows <= 1.5 * $nb_aff) $nb_aff = $num_rows;

    	/* A verifier, ne sert pas  priori...
    	if (ereg('LIMIT .*,([0-9]+)', $query, $regs)) {
    		if ($num_rows > $regs[1]) $num_rows = $regs[1];
    	}
    	*/

    	$texte = "\n";
    	if ($num_rows > $nb_aff) {
    		$tmp_var = trim($this->_getQuery($queryType, false, $params)).join($params, ',');
    		$deb_aff = intval(getTmpVar($tmp_var));

    		$texte .= "<tr><td background=\"\" class=\"arial2\" colspan=\"".($colspan - 1)."\">";

    		for ($i = 0; $i < $num_rows; $i += $nb_aff){
    			$deb = $i + 1;
    			$fin = $i + $nb_aff;
    			if ($fin > $num_rows) $fin = $num_rows;
    			if ($deb > 1) $texte .= " | ";
    			if ($deb_aff + 1 >= $deb AND $deb_aff + 1 <= $fin) {
    				$texte .= "<B>$deb</B>";
    			}
    			else {
    				$link = new Link;
    				$link->addTmpVar($tmp_var, strval($deb - 1));
    				$texte .= "<A HREF=\"".$link->getUrl()."\">$deb</A>";
    			}
    		}
    		$texte .= "</td>\n";
    		$texte .= "<td background=\"\" class=\"arial2\" colspan=\"1\" align=\"right\" valign=\"top\">";
    		if ($deb_aff == -1) {
    			$texte .= "<B>"._T('info_tout_afficher')."</B>";
    		} else {
    			$link = new Link;
    			$link->addTmpVar($tmp_var, -1);
    			$texte .= "<A HREF=\"".$link->getUrl()."\">"._T('lien_tout_afficher')."</A>";
    		}

    		$texte .= "</td>\n";
    		$texte .= "</tr>\n";

    		if ($deb_aff != -1) {
    			$this->_setQueryIsLimited(true);
    			$this->_setLimitStart($deb_aff);
    			$this->_setLimitCount($nb_aff);
    			/*
    			$query = eregi_replace('LIMIT[[:space:]].*$', '', $query);
    			$query .= " LIMIT $deb_aff, $nb_aff";
    			*/
    		}
    	}
    	return $texte;
    }

    // }}}

    // {{{ _fillQueries()

    /**
     * This methods fill the query associative arrays with SQL 92 compliant
     * queries. This method is abstract as it is dependent upon the data
     * types to list (articles, breves, authors, etc.)
     * @access  private
     * @see     _adaptQueriesToDriver()
     */
    function _fillQueries() {
        return PEAR::raiseError("[".get_class($this)." _fillQueryies() :] This method is abstract and must be called only on an implementation !",
                              null, null, null, null, null, false);
    }

    // }}}

    // {{{ _adaptQueriesToDriver()

    /**
     * This method must be redefines in derived class if the driver requires
     * the use of database specific querying (non SQL 92 compliant queries)
     * this method is "protected"
     * @access private
     */
    function _adaptQueriesToDriver() {

    }

    // }}}


}
?>