<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Olivier Mansour                |
// +----------------------------------------------------------------------+
//
// Base class for Article business persistence abstraction.
// $Id: article_oci8.php,v 1.2 2005/12/30 16:51:49 oliviermansour Exp $

require_once dirname(__FILE__)."/../article.php";

class BD_article_oci8 extends BD_article {
 
 
    // {{{ calculateNoTraductionForRubrique()

    /**
     * This method return la liste des langues utilisees par les articles.
     * @return  Array
     */

    function calculateNoTraductionForRubrique($trad_lang, $id_parent) {
        $rows = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article_oci8 : calculateNoTraductionForRubrique()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT a.id_article, a.titre, a.date_heure, a.descriptif, a.lang, t.id_article AS trad_id_article, t.statut " .
            "AS trad_statut, (t.date_modif >= a.date_modif) AS trad_a_jour ".
            "FROM ".$GLOBALS['table_prefix']."_articles a LEFT JOIN ".$GLOBALS['table_prefix']."_articles t ".
            "ON (a.id_article = t.id_trad AND t.lang = '$trad_lang') ".
            "WHERE a.id_rubrique=$id_parent AND a.statut='publie' AND a.lang!='$trad_lang' AND (a.id_trad=0 OR a.id_trad=a.id_article) ".
            "AND (t.id_article IS NULL OR t.statut!='publie' OR t.date_modif < a.date_modif) ".
            "ORDER BY t.statut='publie' DESC, trad_a_jour DESC, a.titre";
        
// TODO : ce SQL n'est pas bon !'
         
        
        echo '<br />' . $query . '<br />';
        
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_article_oci8 : calculateNoTraductionForRubrique()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $queryResult->fetchRow()) {
            $rows[] = $row;
        }
        
        $queryResult->free();
        return $rows;
    }

    // }}}
    
    
    
    
    // {{{ calculatePublishedRubrique()

    /**
     * This method return la liste des langues utiliss par les articles.
     * @return  Array
     */

    function &calculatePublishedRubrique($trad_lang) {
        $rubriqueIds = array();
        $db = &$this->_getDB();
        
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article_oci8 : calculatePublishedRubrique()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT DISTINCT a.id_rubrique ".
            "FROM ".$GLOBALS['table_prefix']."_articles a LEFT JOIN ".$GLOBALS['table_prefix']."_articles t ".
            "ON (a.id_article = t.id_trad AND t.lang = '$trad_lang') ".
            "WHERE a.statut='publie' AND a.lang!='$trad_lang' AND (a.id_trad=0 OR a.id_trad=a.id_article) ".
            "AND (t.id_article IS NULL OR t.statut!='publie' OR t.date_modif < a.date_modif)";
        

         
        
        //echo '<br />' . $query . '<br />';
        
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_article_oci8 : calculatePublishedRubrique()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $queryResult->fetchRow()) {
            $rubriqueIds[] = $row['id_rubrique'];
        }
        $queryResult->free();
        return $rubriqueIds;
    }

    // }}}
    
    
 
 
    // {{{ getArticlesForStatutAndAuteur($statut, $auteurId)

    /**
     * This method return la liste des articles prpars par un auteur donn
     * @param statuts String
     * @param critere 
     * @return  Array
     */

    function getArticlesForStatutAndAuteur($statut, $auteurId) {
        
        $articles = array();
        
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article_oci8 : getArticlesForStatutAndAuteur()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        
        $query = "SELECT articles.id_article FROM ".$GLOBALS['table_prefix']."_articles articles, ".$GLOBALS['table_prefix']."_auteurs_articles lien WHERE articles.statut = '$statut' AND articles.id_article = lien.id_article AND lien.id_auteur = $auteurId ORDER BY articles.date_heure DESC";


        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : getArticlesForStatutAndAuteur()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
            while ($row = $result->fetchRow()) {
                $resultArticle = &BD_article::factory($this->getDbParameters(), $this->getDbOptions());
    
                $maDate = new Date($row['maj']);
                $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);
    
                //$resultArticle->_fetchData($row);
                $resultArticle->load($row['id_article']);
                $articles[] = &$resultArticle;
            }
            $result->free();
        }
        
        return $articles;
        
    }

    // }}}
    
    
    
    
    
    // {{{ update()

    /**
     * This method is used to update this article in the database
     * @access public
     */

    function update() {
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : update()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        /*
        if ($this->_date == "NOW()") $dateValue = "NOW()"; else $dateValue = "'".$db->quoteString($this->_date)."'";
        if ($this->_modificationDate == "NOW()") $dateModifValue = "NOW()"; else $dateModifValue = "'".$db->quoteString($this->_date)."'";
        */

        $maDate = new Date();
        $this->setMajDate($maDate->getDate(DATE_FORMAT_ISO));
        
        
        // calcul du secteur ...  chaque fois 
        $rubriqueMetier = &recuperer_instance_rubrique();
        $rubriqueMetier->load($this->_rubriqueId);
        $this->_secteurId = $rubriqueMetier->findSectorId();
        
        
        // vrification de la date d'expiration 
        if (!is_null($this->_expirationDate) and ($this->_expirationDate != '0000-00-00 00:00:00')) {
            include_once (dirname(__FILE__).'/../../date.php');
            // la date d'expiration doit tre suprieure a la date de publication en ligne     
            if (Date::compare(new Date($this->getExpirationDate()), new Date($this->getDate())) < 0) {
                $this->_expirationDate  = null; // cette date n'est pas valide 
            }
        }

        // avec Oracle le CLOB doit s'inserer 4000 par 4000 ou via un pointeur ! 
        if (strlen($this->_texte) < 3980) { // OK 
    
    
            $query = "UPDATE ".$GLOBALS['table_prefix']."_articles "
                    ."SET surtitre = '".$db->quoteString($this->_surtitre)."', "
                    ."titre = '".$db->quoteString($this->_titre)."', soustitre = '".$db->quoteString($this->_soustitre)."', "
                    ."id_rubrique = ".$this->_rubriqueId.", descriptif = '".$db->quoteString($this->_descriptif)."', "
                    ."chapo = '".$db->quoteString($this->_chapo)."', texte = '".$db->quoteString($this->_texte)."', "
                    ."ps = '".$db->quoteString($this->_ps)."', date_heure = '".$db->quoteString($this->_date)."', "
                    ."statut = '".$db->quoteString($this->_statut)."', id_secteur = ".$this->_secteurId.", "
                    ."maj = '".$db->quoteString($this->_majDate)."', export = '".$db->quoteString($this->_export)."', "
                    ."date_redac = '".$db->quoteString($this->_redactionDate)."', visites = ".$this->_visites.", "
                    ."referers = ".$this->_referers.", popularite = ".$this->_popularite.", "
                    ."accepter_forum = '".$db->quoteString($this->_accepterForum)."', auteur_modif = ".$this->_auteurModif.", "
                    ."date_modif = '".$db->quoteString($this->_modificationDate)."', extra = '".$db->quoteString($this->_extra)."', "
                    ."lang = '".$db->quoteString($this->_lang)."', langue_choisie= '" . $db->quoteString($this->_langChoisie) . "', "
                    ."id_trad = '".$this->_tradId."', nom_site= '" . $db->quoteString($this->_nomSite) . "', "
                    ."url_site = '".$db->quoteString($this->_urlSite)."',"
                    ."activer_historique = '".$this->_activerHistorique."',"
                    ."date_expiration = '".$this->_expirationDate."' "
                    ." WHERE id_article = ".$this->_articleId;
                    
            $result = $db->query($query);
            if (DB::isError($result)) {
                return PEAR::raiseError("[".get_class($this)." DB_article : update() $query => $query ] ".$result->getMessage()."", null,
                    null, null, null, null, false);
            }
    
        } else { 
            // 1st update with empty clob
            $query = "UPDATE ".$GLOBALS['table_prefix']."_articles "
                    ."SET surtitre = '".$db->quoteString($this->_surtitre)."', "
                    ."titre = '".$db->quoteString($this->_titre)."', soustitre = '".$db->quoteString($this->_soustitre)."', "
                    ."id_rubrique = ".$this->_rubriqueId.", descriptif = '".$db->quoteString($this->_descriptif)."', "
                    ."chapo = '".$db->quoteString($this->_chapo)."', texte = EMPTY_CLOB(), "
                    ."ps = '".$db->quoteString($this->_ps)."', date_heure = '".$db->quoteString($this->_date)."', "
                    ."statut = '".$db->quoteString($this->_statut)."', id_secteur = ".$this->_secteurId.", "
                    ."maj = '".$db->quoteString($this->_majDate)."', export = '".$db->quoteString($this->_export)."', "
                    ."date_redac = '".$db->quoteString($this->_redactionDate)."', visites = ".$this->_visites.", "
                    ."referers = ".$this->_referers.", popularite = ".$this->_popularite.", "
                    ."accepter_forum = '".$db->quoteString($this->_accepterForum)."', auteur_modif = ".$this->_auteurModif.", "
                    ."date_modif = '".$db->quoteString($this->_modificationDate)."', extra = '".$db->quoteString($this->_extra)."', "
                    ."lang = '".$db->quoteString($this->_lang)."', langue_choisie= '" . $db->quoteString($this->_langChoisie) . "', "
                    ."id_trad = '".$this->_tradId."', nom_site= '" . $db->quoteString($this->_nomSite) . "', "
                    ."url_site = '".$db->quoteString($this->_urlSite)."',"
                    ."activer_historique = '".$this->_activerHistorique."',"
                    ."date_expiration = '".$this->_expirationDate."' "
                    ." WHERE id_article = ".$this->_articleId;
                    
            $result = $db->query($query);
            if (DB::isError($result)) {
                return PEAR::raiseError("[".get_class($this)." DB_article : update() $query => $query ] ".$result->getMessage()."", null,
                    null, null, null, null, false);
            }
            
            // on fait a a l'ancienne pour le CLOB
            // 2nd update with just the texte CLOB
            $conn = ociLogon ($this->_dbParameters->getDbHost(), $this->_dbParameters->getDbUser(), $this->_dbParameters->getDbPass());
            
            $query = "UPDATE ".$GLOBALS['table_prefix']."_articles set texte = EMPTY_CLOB() WHERE id_article = ".$this->_articleId." " .
                    "returning texte into :THE_CLOB";
            $DBresult = ociparse($conn, $query);
            $Clob = OCINewDescriptor($conn, OCI_D_LOB);
            OCIBindByName($DBresult, ":THE_CLOB", &$Clob, -1, OCI_B_CLOB);
            OCIExecute($DBresult, OCI_DEFAULT);
            $Clob->save($this->_texte);
            ocicommit($conn);
            ociLogoff ($conn);

            //var_dump ($test);

        } 

        //die ( "<br><br>$query<br><br>");

        

        // vrification de la non expiration de l'article
        if ($this->isExpired()) {
            // je dois repasser sur la rubrique - j'ai dj un objet rubriqueMetier
            if ( $rubriqueMetier->checkForExpired() ) { // va modifier mon objet rubrique
                $update = $rubriqueMetier->update();
                if ( PEAR::isError($update) ) {         
                    PEAR::raiseError("Rubrique::update $id error".$update->getMessage(), PEAR_LOG_ERR); 
                } else {
                    // je dois recharger mon article si je compte utiliser mon objet apres
                    $this->setIsLoaded(false);
                    $this->load($this->getArticleId());
                }
            }
        }


        // Mise  jour des objets lis
        $this->updateRelatedObjects();
        
        // Mise  jour de l'embargo
        $this->updateEmbargo();

    /******* Ajout MAPPING guillaume.grason@diplomatie.gouv.fr *******/
    if ($this->getStatut()=='mappe') { // il faut mettre  jour la rubrique
            $rubriqueMetier->load($this->getRubriqueId());
            $statut = $rubriqueMetier->getStatutFromRubrique($this->getRubriqueId());
            if ($statut != $rubriqueMetier->getStatut()) {
                $rubriqueMetier->setStatut($statut);
                $rubriqueMetier->update();
            }
            unset ($rubriqueMetier);
        }
    /******* Fin Ajout MAPPING guillaume.grason@diplomatie.gouv.fr *******/
    }

    // }}}
    
    
    
     // {{{ load()

    /**
     * This method is used to load an article from the database
     * @access  public
     * @param   int $idArticle id of article to load
     */

    function load($idArticle) {
        if (($this->_isLoaded) and ($this->_articleId == $idArticle)) return; // l'article est charg 
    
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : load()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        define("ARTICLE_ALL_FIELDS_WH_TEXTE", " id_article, surtitre, titre, soustitre, id_rubrique, descriptif, chapo, "
        ."ps, date_heure, statut, id_secteur, maj, export, date_redac, visites, referers, popularite, "
        ."accepter_forum, auteur_modif, date_modif, extra, lang, langue_choisie, id_trad, nom_site, url_site, version_id, activer_historique, date_expiration ");

        $query = "SELECT".ARTICLE_ALL_FIELDS_WH_TEXTE."FROM ".$GLOBALS['table_prefix']."_articles WHERE id_article = $idArticle";
         

        //echo "<br>" . $query . "<br>";

        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : load() $query => $query ] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
            if ($row = $result->fetchRow()) {

                $maDate = new Date($row['maj']);
                $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

                $this->_fetchData($row);
            } else {
                return PEAR::raiseError("[".get_class($this)." DB_article : load($idArticle)] Aucun article ne correspond pas  cet ID!", null,
                                    null, null, null, null, false);
            }
            $result->free();
        }
        
        // okay, maintenant on rcupre le texte
        $DBlink = ociLogon ($this->_dbParameters->getDbHost(), $this->_dbParameters->getDbUser(), $this->_dbParameters->getDbPass());
        $query = "SELECT texte FROM ".$GLOBALS['table_prefix']."_articles WHERE id_article = $idArticle";
        $stmt=OCIParse($DBlink,$query);
        OCIExecute($stmt,OCI_DEFAULT);
        $result = array();
        $x=0;
        while(OCIFetch($stmt)){
                 $ncols=OCINumCols($stmt);
                 $result[$x] = array();
                 for($i=1,$j=0;$i<=$ncols;$i++,$j++){
                         $column_name=OCIColumnName($stmt,$i);
                         if(is_object($tmp=OCIResult($stmt,$i))&&OCIColumnType($stmt,$i)=='CLOB'){
                                 $column_value=$tmp->load();
                         }else{
                                 $column_value=$tmp;
                         }
                         $result[$x][$j] = $column_value;
                 }
                 $x++;
        }
        $this->_texte = $result[0][0];  // TODO must be optimized ? 
        
        // l'article est charg 
        $this->_isLoaded = true;
    }

    // }}}
    
    
 
    
}

?>
