<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Olivier Mansour                |
// +----------------------------------------------------------------------+
//
// Base class for Forum business persistence abstraction.
// $Id: forum_oci8.php,v 1.1 2005/11/24 13:12:58 oliviermansour Exp $

require_once dirname(__FILE__)."/../forum.php";

class BD_forum_oci8 extends BD_forum {

     // {{{ getAllEmptyMessagesForStatut($statut)

    /**
     * Returns an array of Forum.
     *
     * @return Array of Forum
     * @param $statut
     * @access public
     */

    function &getAllEmptyMessagesForStatut($statut) {
        $forums = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_forum : getAllEmptyMessagesForStatut()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT * FROM ".$GLOBALS['table_prefix']."_forum WHERE statut='$statut' AND LENGTH(texte) <= 0";

        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_forum : getAllEmptyMessagesForStatut()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $queryResult->fetchRow()) {
            $resultForum = &BD_forum::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultForum->_fetchData($row);
            $forums[] = &$resultForum;
        }
        $queryResult->free();
        return $forums;
    }

    // }}}    
    
}

?>
