<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Antoine Angnieux <aangenieux@clever-age.com>                |
// +----------------------------------------------------------------------+
//
// Class for defining data source connection parameters
//
if (defined("_BD_PARAMS")) return;
define("_BD_PARAMS", "1");

/**
 * This class defines parameters for accessing a given datasource
 * @package	BD
 * @author  Antoine Angnieux <aangenieux@clever-age.com>
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @access	public
 */

class BD_parameters {

    // {{{ properties

    /**
     * DB engine normalized name (see PEAR::DB for more information)
     * @var     String
     * @access  private
     */
    var $_dbEngine;

    /**
     * User name for database connection
     * @var     String
     * @access  private
     */
    var $_dbUser;

    /**
     * User password for database connection
     * @var     String
     * @access  private
     */
    var $_dbPass;

    /**
     * DB engine host name
     * @var     String
     * @access  private
     */
    var $_dbHost;

    /**
     * Database name
     * @var     String
     * @access  private
     */
    var $_dbName;

    // }}}

	// {{{ getDbEngine()

    /**
     * Getter method to retreive Engine var
     *
     * @return      Engine var
     * @access      public
     */

    function getDbEngine() {
        return $this->_dbEngine;
    }

    // }}}

    // {{{ setDbEngine()

    /**
     * Setter method to set Engine var
     *
     * @param $dbEngine     new DB Engine
     */

    function setDbEngine($dbEngine) {
        $this->_dbEngine = $dbEngine;
    }

    // }}}

	// {{{ getDbUser()

    /**
     * Getter method to retreive User var
     *
     * @return      User var
     * @access      public
     */

    function getDbUser() {
        return $this->_dbUser;
    }

    // }}}

    // {{{ setDbUser()

    /**
     * Setter method to set User var
     *
     * @param $dbUser     new DB User
     */

    function setDbUser($dbUser) {
        $this->_dbUser = $dbUser;
    }

    // }}}

	// {{{ getDbPass()

    /**
     * Getter method to retreive Pass var
     *
     * @return      Pass var
     * @access      public
     */

    function getDbPass() {
        return $this->_dbPass;
    }

    // }}}

    // {{{ setDbPass()

    /**
     * Setter method to set Pass var
     *
     * @param $dbPass     new DB Engine
     */

    function setDbPass($dbPass) {
        $this->_dbPass = $dbPass;
    }

    // }}}

	// {{{ getDbHost()

    /**
     * Getter method to retreive Host var
     *
     * @return      Host var
     * @access      public
     */

    function getDbHost() {
        return $this->_dbHost;
    }

    // }}}

    // {{{ setDbHost()

    /**
     * Setter method to set Host var
     *
     * @param $dbHost     new DB Host
     */

    function setDbHost($dbHost) {
        $this->_dbHost = $dbHost;
    }

    // }}}

	// {{{ getDbName()

    /**
     * Getter method to retreive Name var
     *
     * @return      Name var
     * @access      public
     */

    function getDbName() {
        return $this->_dbName;
    }

    // }}}

    // {{{ setDbName()

    /**
     * Setter method to set Name var
     *
     * @param $dbEngine     new DB Name
     */

    function setDbName($dbName) {
        $this->_dbName = $dbName;
    }

    // }}}
    
    // {{{ constructor

    /**
     * Constructor for BD_Paramaters class
     * @param   $dbEngine String representing the normalized DB engine name
     * @param   $dbUser String representing the db user
     * @param   $dbPass String representing the user password
     * @param   $dbHost String representing the DB host
     * @param   $dbName String representing the DB name
     * @access  public
     */
    function BD_parameters($dbEngine, $dbUser, $dbPass, $dbHost, $dbName) {
        $this->_dbEngine = $dbEngine;
        $this->_dbUser = $dbUser;
        $this->_dbPass = $dbPass;
        $this->_dbHost = $dbHost;
        $this->_dbName = $dbName;
    }

    // }}}

    // {{{ getDSN()

    /**
     * This method returns the PEAR::DB well formed DSN
     * @return  String representing the PEAR::DB DSB
     * @access public
     */
    function getDSN() {
        $datasource = $this->_dbEngine.'://'.
                      $this->_dbUser.':'.
                      $this->_dbPass.'@'.
                      $this->_dbHost.'/'.
                      $this->_dbName;
        return $datasource;
    }

    // }}}
}

?>