<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Erwan LE BESCOND <elebescond@clever-age.com>                 |
// +----------------------------------------------------------------------+
//
// Base class for Petition business persistence abstraction.
//

if (defined("_BD_PETITION")) return;
    define("_BD_PETITION", "1");

require_once "PEAR.php";
require_once "DB.php";
require_once dirname(__FILE__)."/metier.php";

define("PETITION_ALL_FIELDS", " id_article, email_unique, site_obli, site_unique, message, texte, maj ");

/**
 * BD_petition is a base class for petition business persistence abstraction implementations, and must be
 * inherited by all such.
 * @package	BD
 * @author  Antoine Angnieux <aangenieux@clever-age.com>
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @access	public
 */
class BD_petition extends BD_metier {

    // {{{ properties

    /**
     * Article ID.
     * @var     int
     * @access  private
     */
    var $_articleId;

    /**
     * email.
     * @var     String
     * @access  private
     */
    var $_emailUnique;

    /**
     * obligatory site .
     * @var     String
     * @access  private
     */
    var $_siteObli;

    /**
     * Unique Site.
     * @var     String
     * @access  private
     */
    var $_siteUnique;

    /**
     * message.
     * @var     String
     * @access  private
     */
    var $_message;

    /**
     * texte.
     * @var     String
     * @access  private
     */
    var $_texte;

    /**
     * Update Date.
     * @var     Date
     * @access  private
     */
    var $_majDate;


    // }}}

    // {{{ factory()

    /**
     * This method is a factory static method. It should be used to get any
     * specific implementation instace of Petition business data type.
     * @param   BD_parameters DB connection parameters
     * @access public
     */
    function &factory($dbParameters, $dbOptions = null) {

        if(file_exists(dirname(__FILE__)."/".$dbParameters->_dbEngine."/petition_".$dbParameters->_dbEngine.".php") == false) {
            include_once(dirname(__FILE__)."/common/petition_common.php");
            $classname = "BD_petition_common";
        }
        else {
            include_once(dirname(__FILE__)."/".$dbParameters->_dbEngine."/petition_".$dbParameters->_dbEngine.".php");
            $classname = "BD_petition_".$dbParameters->_dbEngine;
        }

        if (!class_exists($classname)) {
            return PEAR::raiseError("Cannot instanciate class $classname", null,
                                    null, null, null, null, false);
        }

        $obj =& new $classname;
        $result = $obj->setDbParameters($dbParameters);
        if ($dbOptions != null) {
            $obj->setDbOptions($dbOptions);
        }
        if (PEAR::isError($result)) {
            return $result;
        } else {
            return $obj;
        }
    }

    // }}}

    // {{{ constructor

    /**
     * DB_petition constructor.
     *
     * @access public
     */

    function BD_petition() {
    }

    // }}}

    // {{{ getArticleId()

    /**
     * Returns the Article ID
     * @return  int
     * @access  public
     */

    function getArticleId() {
        return $this->_articleId;
    }

    // }}}

    // {{{ setArticleId()

    /**
     * Sets the Article ID
     * @param   int
     * @access  public
     */

    function setArticleid($articleId) {
        $this->_articleId = $articleId;
    }

    // }}}

    // {{{ getEmailUnique()

    /**
     * Returns the unique Email
     * @return  String
     * @access  public
     */

    function getEmailUnique() {
        return $this->_emailUnique;
    }

    // }}}

    // {{{ setEmailUnique()

    /**
     * Sets the Unqiue Email
     * @param   String
     * @access  public
     */

    function setEmailUnique($emailUnique) {
        $this->_emailUnique = corriger_caracteres($emailUnique);
    }

    // }}}

    // {{{ getSiteObli()

    /**
     * Returns the Obligatory Site
     * @return  String
     * @access  public
     */

    function getSiteObli() {
        return $this->_siteObli;
    }

    // }}}

    // {{{ setSiteObli()

    /**
     * Sets the Obligatory Site
     * @param   String
     * @access  public
     */

    function setSiteObli($siteObli) {
        $this->_siteObli = corriger_caracteres($siteObli);
    }

    // }}}

    // {{{ getsiteUnique()

    /**
     * Returns the unique Site
     * @return  String
     * @access  public
     */

    function getSiteUnique() {
        return $this->_siteUnique;
    }

    // }}}

    // {{{ setSiteUnique()

    /**
     * Sets the unique Site
     * @param   String
     * @access  public
     */

    function setSiteUnique($siteUnique) {
        $this->_siteUnique = corriger_caracteres($siteUnique);
    }

    // }}}

    // {{{ getMessage()

    /**
     * Returns the Message
     * @return  String
     * @access  public
     */

    function getMessage() {
        return $this->_message;
    }

    // }}}

    // {{{ setMessage()

    /**
     * Sets the Message
     * @param   String
     * @access  public
     */

    function setMessage($message) {
        $this->_message = corriger_caracteres($message);
    }

    // }}}

    // {{{ getTexte()

    /**
     * Returns the Text
     * @return  String
     * @access  public
     */

    function getTexte() {
        return $this->_texte;
    }

    // }}}

    // {{{ setTexte()

    /**
     * Sets the Text
     * @param   String
     * @access  public
     */

    function setTexte($texte) {
        $this->_texte = corriger_caracteres($texte);
    }

    // }}}

    // {{{ getMajDate()

    /**
     * Returns the petition update date
     * @return  Date
     * @access  public
     */

    function getMajDate() {
        return $this->_majDate;
    }

    // }}}

    // {{{ setMajDate()

    /**
     * Sets the petition update date
     * @param   Date
     * @access  public
     */

    function setMajDate($majDate) {
        $this->_majDate = $majDate;
    }

    // }}}

    // {{{ create()

    function create() {
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_petition : create()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        $string_prefix = $GLOBALS['table_prefix']."_petitions";
        $signatureId = $db->nextId($string_prefix, true);
        if (DB::isError($petitionId)) {
            return PEAR::raiseError("[".get_class($this)." DB_petition : create()] ".$petitionId->getMessage()."", null,
                null, null, null, null, false);
        }

        $this->_petitionId = $petitionId;

        $query = "INSERT INTO ".$GLOBALS['table_prefix']."_petitions (".PETITION_ALL_FIELDS.") VALUES "
                ."".$this->_articleId.", "
                ."'".$db->quoteString($this->_emailUnique)."', "
                ."'".$db->quoteString($this->_siteObli)."', "
                ."'".$db->quoteString($this->_siteUnique)."', "
                ."'".$db->quoteString($this->_message)."', "
                ."'".$db->quoteString($this->_texte)."', "
                ."'".$db->quoteString($this->_majDate)."')";

         

        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_petition : create()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ update()

    function update() {
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_petition : update()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $maDate = new Date();
	    $this->setMajDate($this->getDate(DATE_FORMAT_ISO));

        $query = "UPDATE ".$GLOBALS['table_prefix']."_petitions "
                ."SET id_article = ".$this->_articleId.", "
                ."email_unique = '".$db->quoteString($this->_emailUnique)."', site_obli = '".$db->quoteString($this->_siteObli)."', "
                ."site_unique = '".$db->quoteString($this->_siteUnique)."', message = '".$db->quoteString($this->_message)."', "
                ."maj = '".$db->quoteString($this->_majDate)."' "
                ."WHERE id_signature = ".$this->_signatureId;

         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_petition : update()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

    }

    // }}}

    // {{{ load()

    function load($idArticle) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_petition : load()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT ".PETITION_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_petitions WHERE id_article = $idArticle";

         
        //echo $query."<br>";
        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_petition : load()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
            if ($row = $result->fetchRow()) {

                $maDate = new Date($row['maj']);
                $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

                $this->_fetchData($row);
            } else {
                return PEAR::raiseError("[".get_class($this)." DB_petition : load($idPetition)] Aucune petition ne correspond pas  cet ID!", 99,
                                    null, null, null, null, false);
            }
            $result->free();
        }
    }

    // }}}

    // {{{ replace($id_article, $email_unique, $site_obli, $site_unique, $message, $texte_petition)

    function replace($id_article, $email_unique, $site_obli, $site_unique, $message, $texte_petition) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_petition : replace()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        $query = "SELECT id_article FROM ".$GLOBALS['table_prefix']."_petitions WHERE id_article=$id_article";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_petition : writeMeta()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

        if($result->numRows() > 0) {
            $query = "UPDATE ".$GLOBALS['table_prefix']."_petitions SET email_unique='$email_unique', site_obli='$site_obli', site_unique='$site_unique', message='$message', texte='$texte_petition' WHERE id_article=$id_article";
			/*
            $query = "REPLACE ".$GLOBALS['table_prefix']."_petitions (id_article, email_unique, site_obli, site_unique, message, texte) ".
				"VALUES ($id_article, '$email_unique', '$site_obli', '$site_unique', '$message', '$texte_petition')";
            */
             
            $result = $db->query($query);
            if (DB::isError($result)) {
                return PEAR::raiseError("[".get_class($this)." DB_petition : replace()] ".$result->getMessage()."", null,
                    null, null, null, null, false);
            }
        }
        else {
            $query = "INSERT INTO ".$GLOBALS['table_prefix']."_petitions(id_article, email_unique, site_obli, site_unique, message, texte) VALUES ($id_article, '$email_unique', '$site_obli', '$site_unique', '$message', '$texte_petition')";

             
            $result = $db->query($query);
            if (DB::isError($result)) {
                return PEAR::raiseError("[".get_class($this)." DB_petition : replace()] ".$result->getMessage()."", null,
                    null, null, null, null, false);
            }
        }
    }

    // }}}

    // {{{ delete()

    function delete($idArticle) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_petition : delete()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_petitions WHERE id_article = $idArticle";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_petition : delete()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ _fetchData()

    function _fetchData($row) {
        $this->setArticleId($row['id_article']);
        $this->setEmailUnique($row['email_unique']);
        $this->setSiteObli($row['site_obli']);
        $this->setSiteUnique($row['site_unique']);
        $this->setMessage($row['message']);
        $this->setTexte($row['texte']);
        $this->setMajDate($row['maj']);
    }

    // }}}

    // {{{ deleteMajDate($myDate)

    /**
     * This method is used to delete all petitions former to mydate
     * @access  public
     */

    function deleteMajDate($myDate) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_petition : deleteMajDate()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $dateTmp = new Date($mydate);
        $mydate = $dateTmp->getDate(DATE_FORMAT_ISO);

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_petitions WHERE maj < '$mydate'";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_petition : deleteMajDate()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

        // {{{ getAllForArticleId($id_article)

    /**
     * This method returns an array of petition
     * @return  int
     * @access  public
     */
    function &getAllForArticleId($id_article) {
        $result= array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_petition : getAllForArticleId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

		$query = "SELECT ".PETITION_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_petitions WHERE id_article=$id_article";
         
        $queryResult = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_petition : getAllForArticleId()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $queryResult->fetchRow()) {
            $resultPetition = &BD_petition::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultPetition->_fetchData($row);

            $result[] = &$resultPetition;
        }
        $queryResult->free();

        return $result;
    }

    // }}}

}
?>