<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Erwan LE BESCOND <elebescond@clever-age.com>                |
// +----------------------------------------------------------------------+
//
// Base class for profil business persistence abstraction.
//

if (defined("_BD_PROFIL")) return;
define("_BD_PROFIL", "1");

require_once dirname(__FILE__)."/metier.php";

define("PROFIL_ALL_FIELDS", " poids, intitule ");

/**
 * BD_profil is a base class for profil business persistence abstraction implementations, and must be
 * inherited by all such.
 * @package	BD
 * @author  Antoine Angnieux <aangenieux@clever-age.com>
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @access	public
 */
class BD_profil extends BD_metier {
    // {{{ properties

    /**
    * Poids.
    * @var     Int
    * @access  private
    */
    var $_poids;

    /**
    * Intitule.
    * @var     String
    * @access  private
    */
    var $_intitule;



    // {{{ factory()
    function &factory($dbParameters = null, $dbOptions = null) {

        if(file_exists(dirname(__FILE__)."/".$dbParameters->_dbEngine."/profil_".$dbParameters->_dbEngine.".php") == false) {
            include_once(dirname(__FILE__)."/common/profil_common.php");
            $classname = "BD_profil_common";
        }
        else {
            include_once(dirname(__FILE__)."/".$dbParameters->_dbEngine."/profil_".$dbParameters->_dbEngine.".php");
            $classname = "BD_profil_".$dbParameters->_dbEngine;
        }

        if (!class_exists($classname)) {
            return PEAR::raiseError("Cannot instanciate class $classname", null,
                                    null, null, null, null, false);
        }

        $obj =& new $classname;
        $result = $obj->setDbParameters($dbParameters);
        if ($dbOptions != null) {
            $obj->setDbOptions($dbOptions);
        }
        if (PEAR::isError($result)) {
            return $result;
        } else {
            return $obj;
        }
    }

    // }}}

    // {{{ constructor

    /**
     * DB_profil constructor.
     *
     * @access public
     */

    function BD_profil() {
    }

    // }}}

    // {{{ getPoids()

    function getPoids() {
        return  $this->_poids;
    }

    // }}}

    // {{{ setPoids()

    function setPoids($poids) {
        $this->_poids = $this->corriger_caracteres($poids);
    }

    // }}}



    // {{{ getIntitule()

    function getIntitule() {
        return  $this->_intitule;
    }

    // }}}

    // {{{ setIntitue()

    function setIntitule($intitule) {
        $this->_intitule = $this->corriger_caracteres($intitule);
    }

    // }}}

    // {{{ create()

    function create() {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_profil : create()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "INSERT INTO ".$GLOBALS['table_prefix']."_profils (".PROFIL_ALL_FIELDS.") VALUES "
                ."(".$this->_poids.", "
                ."'".$db->quoteString($this->_intitule)."') ";

         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_profil : create()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ delete()

    function delete($poids) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_profil : delete()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_profils WHERE poids = $poids";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_profil : delete()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ update()

    function update() {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_profil : update()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "UPDATE ".$GLOBALS['table_prefix']."_profils "
                ."SET poids = ".$this->_poids.", "
                ."intitule = '".$db->quoteString($this->_intitule)."' "
                ."WHERE poids = ".$this->_poids;

         

        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_profil : update()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ load()

    function load($poids) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_profil : load()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = 'SELECT'.PROFIL_ALL_FIELDS.'FROM '.$GLOBALS['table_prefix'].'_profils WHERE poids =' .  $poids;
         
        
        //echo '<br />' . $query . '<br />';
        
        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_profil : load()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
            if ($row = $result->fetchRow()) {
                $this->_fetchData($row);
            } else {
                return PEAR::raiseError("[".get_class($this)." Db_profil : load(".$poids.")] Aucune action ne correspond pas  ce nom!", null,
                                    null, null, null, null, false);
            }
            $result->free();
        }
    }

    // }}}

    // {{{ _fetchData()

    function _fetchData($row) {
        $this->setPoids($row['poids']);
        $this->setIntitule($row['intitule']);
    }

    // }}}

    // {{{ getAllProfils()

    function &getAllProfils() {
        $profils = array();
        $db = &$this->_getDB();


        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_profil : getAllProfils()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

		$query = "SELECT " . PROFIL_ALL_FIELDS . " FROM ".$GLOBALS['table_prefix']."_profils";

		//echo $query .'<br />';

		$result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_profil : getAllProfils()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $result->fetchRow()) {
            $resultProfil = &BD_profil::factory($this->getDbParameters(), $this->getDbOptions());
            $resultProfil->_fetchData($row);
            $profils[] = &$resultProfil;
        }
        $result->free();
        return $profils;
    }

    // }}}

    // {{{ getProfilForIntitule($intitule)

    function &getProfilForIntitule($intitule) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_profil : getProfilForIntitule()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

		$query = "SELECT ".PROFIL_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_profils WHERE intitule='$intitule'";
		 
		//echo '<br>' . $query . '<br>';
		$result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_profil : getProfilForIntitule()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

        if ($row = $result->fetchRow()) {
            $resultProfil = &BD_profil::factory($this->getDbParameters(), $this->getDbOptions());
            $resultProfil->_fetchData($row);
        }
        $result->free();
        return $resultProfil;
    }

    // }}}


    // {{{ getSumOfPoids($intitule)

    function &getSumOfPoids() {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_profil : getSumOfPoids()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

		$query = "SELECT SUM(poids) as sum FROM ".$GLOBALS['table_prefix']."_profils";
		 
		//echo '<br>' . $query . '<br>';
		$result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_profil : getSumOfPoids()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

        if ($row = $result->fetchRow()) {
            return $row['sum'];            
        }
        $result->free();
        return 0;
    }

    // }}}

}