<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Erwan LE BESCOND <elebescond@clever-age.com>                |
// +----------------------------------------------------------------------+
//
// Base class for Referer business persistence abstraction.
// $Id$

if (defined("_BD_REFERER")) return;
define("_BD_REFERER", "1");

require_once "PEAR.php";
require_once "DB.php";
require_once dirname(__FILE__)."/metier.php";

define("REFERER_ALL_FIELDS", " date_heure, visites, maj ");


/**
 * BD_referer is a base class for referer business persistence abstraction implementations, and must be
 * inherited by all such.
 * @package	BD
 * @author  Antoine Angnieux <aangenieux@clever-age.com>
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @access	public
 */
class BD_referer extends BD_metier {
    // {{{ properties

    /**
    * RefererMd5.
    * @var     int
    * @access  private
    */
    var $_RefererMd5;

    /**
    * date.
    * @var     Date
    * @access  private
    */
    var $_date;

    /**
    * referer.
    * @var    String
    * @access  private
    */
    var $_referer;

    /**
    * visites.
    * @var    int
    * @access  private
    */
    var $_visites;

    /**
    * visitesJour.
    * @var    int
    * @access  private
    */
    var $_visitesJour;

    /**
    * maj.
    * @var    Date
    * @access  private
    */
    var $_maj;

    // }}}

    // {{{ factory()

    function &factory($dbParameters = null, $dbOptions = null) {

        if(file_exists(dirname(__FILE__)."/".$dbParameters->_dbEngine."/referer_".$dbParameters->_dbEngine.".php") == false) {
            include_once(dirname(__FILE__)."/common/referer_common.php");
            $classname = "BD_referer_common";
        }
        else {
            include_once(dirname(__FILE__)."/".$dbParameters->_dbEngine."/referer_".$dbParameters->_dbEngine.".php");
            $classname = "BD_referer_".$dbParameters->_dbEngine;
        }
        if (!class_exists($classname)) {
            return PEAR::raiseError("Cannot instanciate class $classname", null,
                                    null, null, null, null, false);
        }

        $obj =& new $classname;
        $result = $obj->setDbParameters($dbParameters);
        if ($dbOptions != null) {
            $obj->setDbOptions($dbOptions);
        }
        if (PEAR::isError($result)) {
            return $result;
        } else {
            return $obj;
        }
    }

    // }}}

    // {{{ constructor

    /**
     * DB_referer constructor.
     *
     * @access public
     */

    function BD_referer() {
    }

    // }}}

    // {{{ getRefererMd5()

    /**
     * Returns the RefererMD5
     * @return  int
     * @access  public
     */

    function getRefererMd5() {
        return $this->_refererMd5;
    }

    // }}}

    // {{{ setRefererMd5()

    /**
     * Sets the RefererMD5
     * @param  int
     * @access  public
     */

    function setRefererMd5($refererMd5) {
        $this->_refererMd5 = $this->corriger_caracteres($refererMd5);
    }

    // }}}

    // {{{ getDate()

    /**
     * Returns the date of creation
     * @return  Date
     * @access  public
     */

    function getDate() {
        return $this->_date;
    }

    // }}}

    // {{{ setDate()

    /**
     * Sets the date of creation
     * @param  Date
     * @access  public
     */

    function setDate($date) {
        $this->_date = $date;
    }

    // }}}

    // {{{ getReferer()

    /**
     * Returns the referers
     * @return  String
     * @access  public
     */

    function getReferer() {
        return $this->_referer;
    }

    // }}}

    // {{{ setReferer()

    /**
     * Sets the referers
     * @param  String
     * @access  public
     */

    function setReferer($referer) {
        $this->_referer = $this->corriger_caracteres($referer);
    }

    // }}}

    // {{{ getVisites()

    /**
     * Returns the number of visits
     * @return  int
     * @access  public
     */

    function getVisites() {
        return $this->_visites;
    }

    // }}}

    // {{{ setVisites()

    /**
     * Sets the number of visits
     * @param  int
     * @access  public
     */

    function setVisites($visites) {
        $this->_visites = $visites;
    }

    // }}}

    // {{{ getVisitesJour()

    /**
     * Returns the number of visits at the current day
     * @return  int
     * @access  public
     */

    function getVisitesJour() {
        return $this->_visitesJour;
    }

    // }}}

    // {{{ setVisiteJour()

    /**
     * Sets the number of visits at the current day
     * @param  int
     * @access  public
     */

    function setVisitesJour($visitesJour) {
        $this->_visitesJour = $visitesJour;
    }

    // }}}

    // {{{ getMaj()

    /**
     * Returns the last update Date
     * @return  date
     * @access  public
     */

    function getMaj() {
        return $this->_maj;
    }

    // }}}

    // {{{ setMaj()

    /**
     * Returns the last update Date
     * @return  date
     * @access  public
     */

    function setMaj($maj) {
        $this->_maj = $maj;
    }

    // }}}

    // {{{ create()

    /**
     * This method is used to create a new referer in the database
     * @access public
     */

    function create() {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_referer : create()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $maDate = new Date();
	    $this->setDate($maDate->getDate(DATE_FORMAT_ISO));

        $query = "INSERT INTO ".$GLOBALS['table_prefix']."_referers (".REFERER_ALL_FIELDS.") VALUES "

                ."('".$db->quoteString($this->_refererMd5)."', "
                ."('".$db->quoteString($this->_date)."', "
                ."('".$db->quoteString($this->_referer)."', "
                ."(".$this->_visites.", "
                ."(".$this->_visiteJour.", "
                ."'".$db->quoteString($this->_maj)."')";

        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_referer : create()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ delete()

    function delete($refererMd5) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_referer : delete()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_referers WHERE referer_md5 = '$refererMd5'";

        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_referer : delete()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ update()

    /**
     * This method is used to update this referer in the database
     * @access public
     */

    function update() {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_referer : update()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $maDate = new Date();
	    $this->setMajDate($maDate->getDate(DATE_FORMAT_ISO));

        $query = "UPDATE ".$GLOBALS['table_prefix']."_referers "
                ."SET referer_md5 = '".$db->quoteString($this->_refererMd5)."', "
                ."date_heure = '".$db->quoteString($this->_date)."', referer = '".$db->quoteString($this->_referer)."', "
                ."visites = ".$this->_visites.", visite_jour = ".$this->_visiteJour.", "
                ."maj = '".$db->quoteString($this->_maj)."' "
                ."WHERE date_heure = '".$db->quoteString($this->_date)."'";

        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_referer : update()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ load()

    /**
     * This method is used to load a forum from the database
     * @access  public
     * @param   int $refererMd5 of referer to load
     */

    function load($refererMd5) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_referer : load()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT".REFERER_ALL_FIELDS."FROM ".$GLOBALS['table_prefix']."_referers WHERE referer_md5 = '$refererMd5'";

        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_referer : load()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
            if ($row = $result->fetchRow()) {

                $maDate = new Date($row['maj']);
                $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

                $this->_fetchData($row);
            } else {
                return PEAR::raiseError("[".get_class($this)." DB_referer : load(".$refererMd5.")] Aucun referer ne correspond pas  ce refererMd5!", null,
                                    null, null, null, null, false);
            }
            $result->free();
        }
    }

    // }}}

    // {{{ _fetchData()

    /**
     * This method is used to fetch result set fields into the object fields
     *
     * @param   $row    resultset row
     * @access  private
     */

    function _fetchData($row) {
        $this->setRefererMd5($row['referer_md5']);
        $this->setDate($row['date_heure']);
        $this->setVisites($row['visites']);
        $this->setVisitesJour($row['visites_jour']);
        $this->setMaj($row['maj']);
    }

    // }}}

    // {{{ deleteTempReferersForReferersMd5($referer_vus)

    function deleteTempReferersForReferersMd5($referer_vus) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_referer : deleteTempReferersForReferersMd5()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_referers_temp WHERE referer_md5 IN (".join(",",$referer_vus).")";

        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_referer : deleteTempReferersForReferersMd5()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ resetOneDay()

    function resetOneDay() {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_referer : resetOneDay()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "UPDATE ".$GLOBALS['table_prefix']."_referers SET visites_jour=0";

        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_referer : resetOneDay()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ getAllArticleVisites($limit)

    /**
        * Returns an array of Visite.
        *
        * @return an array of Visite.
        * @access public
        */

    function getAllArticleVisites($limit) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_referer : getAllArticleVisites()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT visites FROM ".$GLOBALS['table_prefix']."_referers_articles ORDER BY visites";


        $result = $db->limitQuery($query, intval($limit * 100), 1);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_referer : getAllArticleVisites()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
            $visites = 1;
        if($row = $result->fetchRow()) {
            $visites = $row['visites'];
        }
        $result->free();
        return $visites;
    }

    // }}}

    // {{{ getAllVisites($limit)

    /**
     * Returns an array of Visites
     *
     * @return an array of Visites.
     * @access public
     */

    function getAllVisites($limit) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_referer : getAllVisites()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT visites FROM ".$GLOBALS['table_prefix']."_referers ORDER BY visites";
 
        $result = $db->limitQuery($query, intval($limit * 100), 1);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_referer : getAllVisites()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

        $visites = 1;
        if($row = $result->fetchRow()) {
            $visites = $row['visites'];
        }
        $result->free();
        return $visites;
    }

    // }}}

    // {{{ howManyArticleId()

    function howManyArticleId() {
        $howManyArticleId = 0;
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_referer : howManyArticleId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

		$query = "SELECT COUNT(DISTINCT id_article) AS count FROM ".$GLOBALS['table_prefix']."_referers_articles";
 
		$result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_referer : howManyArticleId()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        if ($row = $result->fetchRow()) {
            $howManyArticleId = intval($row["count"]);
        }
        $result->free();
        return $howManyArticleId;
    }


    // }}}

    // {{{ updateVisiteForReferersMd5($visites, $referers)
    /**
     * Additional param for actualization's date.
     */
    function updateVisiteForReferersMd5($visites, $referers, $date='') {
        $db = &$this->_getDB();

        if(!$date){
           $date = date("Y-m-d", time() - 24 * 3600);
        }

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_referer : updateVisiteForReferersMd5()]".
                $db->getMessage()."", null, null, null, null, null, false);
        }


         $query = "UPDATE ".$GLOBALS['table_prefix']."_referers
                SET visites = ".$GLOBALS['table_prefix']."_referers.visites + ".intval($visites).",
                    visites_jour = ".$GLOBALS['table_prefix']."_referers.visites_jour + ".intval($visites).",
                    maj='".date("Y-m-d H:i:s")."',
                    date_heure='".$date."' 
                WHERE ".$GLOBALS['table_prefix']."_referers.referer_md5 IN (".join(', ', $referers).")";


//         $query = "UPDATE ".$GLOBALS['table_prefix']."_referers SET visites = visites + ".intval($visites).", visites_jour = visites_jour + ".intval($visites)." WHERE referer_md5 IN (".join(', ', $referers).")";
        //echo "<br><br>\n\n$query\n<br><br>";

        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_referer : updateVisiteForReferersMd5()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}
    // {{{ getAllTempReferersForTypeAndReferer($type, $referer_vus)

    function getAllTempReferersForTypeAndReferer($type, $referer_vus) {
        $referers = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_referer : getAllTempReferersForTypeAndReferer()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

		$where = (is_array($referer_vus)) ? "AND referer_md5 IN (".join(',',$referer_vus).")" : "";

	    $query = 'SELECT COUNT(DISTINCT ip) AS visites, id_objet, referer, referer_md5 AS md5 '.
		    'FROM '.$GLOBALS['table_prefix'].'_referers_temp WHERE type_referer=\'' . $type . '\'' . $where . ' GROUP BY id_objet, referer, referer_md5';
	    /*
	    $query = "SELECT COUNT(DISTINCT ip) AS visites, id_objet, referer, HEX(referer_md5) AS md5 ".
		    "FROM ".$GLOBALS['table_prefix']."_referers_temp WHERE type='$type' $where GROUP BY id_objet, referer_md5";
	    */
 
		$result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_referer : getAllTempReferersForTypeAndReferer()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $result->fetchRow()) {
            $row['md5'] = $row['md5'];
            $referers[] = $row;
        }
        $result->free();
        return $referers;
    }

    // }}}

    // {{{ updateVisiteArticleForReferersMd5($visites, $referer_vus)

    function updateVisiteArticleForReferersMd5($visites, $where, $date='') {
        $db = &$this->_getDB();

        if(!$date){
            $date = date("Y-m-d");
        }

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_referer : updateVisiteArticleForReferersMd5()]".
                $db->getMessage()."", null, null, null, null, null, false);
        }

        $query = "UPDATE ".$GLOBALS['table_prefix']."_referers_articles
            SET visites = ".$GLOBALS['table_prefix']."_referers_articles.visites + $visites,
            maj='".date("Y-m-d H:i:s")."'
            WHERE ".join("AND ", $where)." AND
            ".$GLOBALS['table_prefix']."_referers_articles.date_heure='".$date."'";


//         $query = "UPDATE ".$GLOBALS['table_prefix']."_referers_articles SET visites = visites + $visites WHERE ".join(' OR ', $where);
        //echo "\n<br><br>\n$query\n";

        $result = $db->query($query);


        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_referer : updateVisiteArticleForReferersMd5()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ addRefererTemp($log_ip, $log_referer, $referer_md5, $log_type, $log_id_num)

    function addRefererTemp($log_ip, $log_referer, $referer_md5, $log_type, $log_id_num) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_referer : addRefererTemp()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }


        $query = 'SELECT ip, referer_md5, type_referer, id_objet FROM '.$GLOBALS['table_prefix'].'_referers_temp WHERE ip=\'' . $log_ip . '\' AND referer_md5=\'' . $referer_md5 . '\' AND type_referer=\''.$log_type.'\' AND id_objet=' . $log_id_num;

 

        //echo "<br><br>$query<br><br>";

        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_referer : addRefererTemp()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

        if($result->numRows() == 0) {
            $query = 'INSERT INTO '.$GLOBALS['table_prefix'].'_referers_temp (ip, referer, referer_md5, type_referer, id_objet) VALUES (\''.$log_ip.'\', \''.$log_referer.'\', \''.$referer_md5.'\', \''.$log_type.'\', '.$log_id_num.')';
     
            //echo '<br>' . $query . '<br>';
            $result = $db->query($query);
            if (DB::isError($result)) {
                return PEAR::raiseError("[".get_class($this)." DB_referer : addRefererTemp()] ".$result->getMessage()."", null,
                    null, null, null, null, false);
            }
        }
    }

    // }}}

    // {{{ addArticleReferer($referer_insert)

    function addArticleReferer($referer_insert) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_referer : addArticleReferer()] "
                .$db->getMessage()."", null,
                null, null, null, null, false);
        }

            while(list(, $monRefererInsert) = each($referer_insert)) {

                $query = "SELECT id_article, referer_md5 FROM "
                         .$GLOBALS['table_prefix']."_referers_articles "
                         ." WHERE id_article=".$monRefererInsert['id_article']
                         ." AND referer_md5=".$monRefererInsert['referer_md5'];

            $result = $db->query($query);

            if (DB::isError($result)) {
                return PEAR::raiseError("[".get_class($this)." DB_referer : addArticleReferer()] "
                    .$result->getMessage()."", null,
                    null, null, null, null, false);
            }

            /*
             * Commented $db->quoteString for referer, because it was unecessary here
             */
            if($result->numRows() == 0) {
                $query = "INSERT INTO "
                         .$GLOBALS['table_prefix']."_referers_articles (date_heure, referer,
                            referer_md5, id_article, visites, maj)"
                         ." VALUES (".$monRefererInsert['date_heure'].","
                         //.$db->quoteString($monRefererInsert['referer']).","
                         .$monRefererInsert['referer'].","
                         .$monRefererInsert['referer_md5'].","
                         .$monRefererInsert['id_article'].","
                         .$monRefererInsert['visites'].",'"
                         .date("Y-m-d H:i:s")."')";
//                 echo "<br><br>\n\n$query\n<br><br>";

                $result = $db->query($query);
                if (DB::isError($result)) {
                    return PEAR::raiseError("[".get_class($this)." DB_referer : addArticleReferer()] ".$result->getMessage()."".$query, null,
                        null, null, null, null, false);
                }
            }
        }
    }

    // {{{ addReferer($referer_insert)

    function addReferer($referer_insert) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_referer : addReferer()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        while(list(, $monRefererInsert) = each($referer_insert)) {
            $query = "SELECT referer_md5 FROM "
                     .$GLOBALS['table_prefix']."_referers WHERE referer_md5=".$monRefererInsert['referer_md5']."";


            //echo "<br><br>\n\n$query\n<br><br>";

            $result = $db->query($query);

            if (DB::isError($result)) {
                return PEAR::raiseError("[".get_class($this)." DB_referer : addReferer()  $query ] ".$result->getMessage()."", null,
                    null, null, null, null, false);
            }

            if($result->numRows() == 0) {
                $query = "INSERT INTO ".$GLOBALS['table_prefix']."_referers "
                           ."(date_heure, referer, referer_md5, visites, visites_jour) VALUES ("
                           .$monRefererInsert['date_heure'].","
                           ."'".$db->quoteString($monRefererInsert['referer'])."',"
                           .$monRefererInsert['referer_md5'].","
                           .$monRefererInsert['visites1'].","
                           .$monRefererInsert['visites2'].")";


                //echo "<br><br>\n\n$query\n<br><br>";

                $result = $db->query($query);
                if (DB::isError($result)) {
                    return PEAR::raiseError("[".get_class($this)." DB_referer : addReferer()   $query ] ".$result->getMessage()."", null,
                        null, null, null, null, false);
                    echo "<br><br>\n\n$query\n<br><br>";
                }
            }
        }
    }
    // }}}

    // {{{ getAllForVisitesJour()

    function &getAllForVisitesJour() {
        $referers = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_referer : getAllForVisitesJour()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

                $query = "SELECT referer_md5, date_heure, visites, visites_jour, maj FROM ".$GLOBALS['table_prefix']."_referers ".
                "WHERE visites_jour > 0 ".
                "GROUP BY referer_md5, date_heure, visites, visites_jour, maj ORDER BY visites_jour DESC";
    
            //echo "<br><br>$query<br><br>";

                $result = $db->limitQuery($query , 0, 800);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_referer : getAllForVisitesJour()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $result->fetchRow()) {
            $resultReferer = &BD_referer::factory($this->getDbParameters(), $this->getDbOptions());
            $resultReferer->_fetchData($row);
            $referers[] = &$resultReferer;
        }
        $result->free();
        return $referers;
    }

    // }}}

    // {{{ getAllArticleReferersForArticleId($id_article)

    /**
     * Returns an array of Article Referers
     *
     * @return an array of Article Referers.
     * @access public
     */

    function getAllArticleReferersForArticleId($id_article) {
        $visites = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_referer : getAllArticleReferersForArticleId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT * FROM ".$GLOBALS['table_prefix']."_referers_articles WHERE id_article=$id_article ORDER BY visites";
 
        $result = $db->limitQuery($query, 0, 100);

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_referer : getAllArticleReferersForArticleId()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

        while($row = $result->fetchRow()) {
            $visites[] = $row;
        }
        $result->free();

        return $visites;
    }

    // }}}

    // {{{ getAllReferers()

    /**
     * Returns an array of Article Referers
     *
     * @return an array of Article Referers.
     * @access public
     */

    function getAllReferers() {
        $visites = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_referer : getAllReferers()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT * FROM ".$GLOBALS['table_prefix']."_referers ORDER BY visites";
 
        $result = $db->limitQuery($query, 0, 100);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_referer : getAllReferers()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

        if($row = $result->fetchRow()) {
            $visites = $row;
        }
        $result->free();
        return $visites;
    }

    // }}}

    // {{{ getAllTempReferer($nb_referers)

    function getAllTempReferer($nb_referers) {
        $referers = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return $db;
        }

        $query = "SELECT COUNT(DISTINCT ip) AS visites, referer, referer_md5 AS md5 FROM ".$GLOBALS['table_prefix']."_referers_temp GROUP BY referer, referer_md5";
        //$query = "SELECT COUNT(DISTINCT ip) AS visites, referer, referer_md5 AS md5 FROM ".$GLOBALS['table_prefix']."_referers_temp GROUP BY referer_md5";
		//$query = "SELECT COUNT(DISTINCT ip) AS visites, referer, HEX(referer_md5) AS md5 FROM ".$GLOBALS['table_prefix']."_referers_temp GROUP BY referer_md5";
 
		//echo "<br><br>$query<br><br>";

		$result = $db->limitQuery($query, 0, $nb_referers);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_referer : getAllTempReferer()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $result->fetchRow()) {
            $row['md5'] = $row['md5'];
            $referers[] = $row;
        }
        $result->free();
        return $referers;
    }

    // }}}

    // {{{ deleteForOptimize($visites_min)

    function deleteForOptimize($visites_min) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_referer : deleteForOptimize()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $maDate = new Date();
        $maDate->subtractSeconds(intval(7*24*3600));
        $maDate2 = new Date();
        $maDate2->subtractSeconds(intval(30*24*3600));

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_referers WHERE (date_heure < '" . $maDate->getDate(DATE_FORMAT_ISO) . "'  AND visites <= $visites_min) OR (date_heure < '" . $maDate2->getDate(DATE_FORMAT_ISO) . "')";

        //echo '<br>'.$query.'<br>';

        //$query = "DELETE FROM ".$GLOBALS['table_prefix']."_referers WHERE (date < DATE_SUB(NOW(),INTERVAL 7 DAY) AND visites <= $visites_min) OR (date < DATE_SUB(NOW(),INTERVAL 30 DAY))";

 
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_referer : deleteForOptimize()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ deleteArticleRefererForOptimize($visites_min)

    function deleteArticleRefererForOptimize($visites_min) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_referer : deleteArticleRefererForOptimize()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $maDate = new Date();
        $maDate->subtractSeconds(intval(7*24*3600));
        $maDate2 = new Date();
        $maDate2->subtractSeconds(intval(30*24*3600));
        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_referers_articles WHERE (date_heure < '" . $maDate->getDate(DATE_FORMAT_ISO) . "' AND visites <= $visites_min) OR (date_heure < '" . $maDate2->getDate(DATE_FORMAT_ISO) . "')";

        //$query = "DELETE FROM ".$GLOBALS['table_prefix']."_referers_articles WHERE (date < DATE_SUB(NOW(),INTERVAL 7 DAY) AND visites <= $visites_min) OR (date < DATE_SUB(NOW(),INTERVAL 30 DAY))";

 
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_referer : deleteArticleRefererForOptimize()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ getAllRefererForTypeSinceXsec($duree, $type)

    function getAllRefererForTypeSinceXsec($duree, $type) {
        $visites = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_referer : getAllRefererForTypeSinceXsec()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $maDate = new Date();
        $maDate->subtractSeconds($duree);

		$query = 'SELECT COUNT(*) as count,id_objet FROM '.$GLOBALS['table_prefix'].'_referers_temp WHERE maj > \'' . $maDate->getDate(DATE_FORMAT_ISO) . '\' AND type_referer=\'' . $type . '\' GROUP BY id_objet';
		//$query = "SELECT COUNT(*) as count,id_objet FROM ".$GLOBALS['table_prefix']."_referers_temp WHERE maj > DATE_SUB(NOW(), INTERVAL $duree SECOND) AND type='$type' GROUP BY id_objet";
 
		$result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_referer : getAllRefererForTypeSinceXsec()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $result->fetchRow()) {
            $visites[] = $row;
        }
        $result->free();
        return $visites;
    }

    // }}}
}