<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Erwan LE BESCOND <elebescond@clever-age.com>                 |
// | Author: Olivier Mansour                                              |
// | Version $Id$                                                       |
// +----------------------------------------------------------------------+
//
// Base class for Rubrique business persistence abstraction.
// $Id$


require_once (dirname(__FILE__)."/metier.php");

//2004-04-29, Maciek: require_once dirname(__FILE__)."/../../inc_filtres.php3";
//require_once dirname(__FILE__)."/../../inc_meta.php3"; // pas sur que ce soit indispensable ?
require_once dirname(__FILE__)."/../utils/meta.php";

define("RUBRIQUE_ALL_FIELDS", " id_rubrique, id_parent, titre, descriptif, texte, id_secteur, maj, export, "
                            ."id_import, statut, date_heure, extra, lang, langue_choisie ");

/**
 * BD_rubrique is a base class for rubrique business persistence abstraction implementations, and must be
 * inherited by all such.
 * @package	BD
 * @author  Antoine Angnieux <aangenieux@clever-age.com>
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @access	public
 */
class BD_rubrique extends BD_metier {

    // {{{ properties

    /**
     * Rubrique ID.
     * @var     int
     * @access  private
     */
    var $_rubriqueId;

    /**
     * Parent ID.
     * @var     int
     * @access  private
     */
    var $_parentId;

    /**
     * Title.
     * @var     String
     * @access  private
     */
    var $_titre;

    /**
     * Description.
     * @var     String
     * @access  private
     */
    var $_descriptif;

    /**
     * Text.
     * @var     String
     * @access  private
     */
    var $_texte;

    /**
     * Sector ID.
     * @var     int
     * @access  private
     */
    var $_secteurId;

    /**
     * Update Date.
     * @var     Date
     * @access  private
     */
    var $_majDate;

    /**
     * Export.
     * @var     String
     * @access  private
     */
    var $_export;

    /**
     * Import ID.
     * @var     int
     * @access  private
     */
    var $_importId;

    /**
     * Statut.
     * @var     String
     * @access  private
     */
    var $_statut;

    /**
     * Date.
     * @var     Date
     * @access  private
     */
    var $_date;

    /**
     * Extra fields.
     * @var     String
     * @access  private
     */
    var $_extra;

    /**
     * Lang.
     * @var     String
     * @access  private
     */
    var $_lang;

    /**
     * Lang functions activation.
     * @var     String
     * @access  private
     */
    var $_langue_choisie;


    /**
    * isLoaded
    * nous dit si l'objet est charg ou pas
    * @access private
    */
    var $_isLoaded = false;

    /**
    * _secteursHisto
    * historique des secteurs pour cet instance d'objet
    * @access private
    * @var Array
    **/
    var $_secteursHisto = array();

    /**
     * _langHisto
     * historique des langues pour cet instance d'objet
     * @access private
     * @var Array
    **/
    var $_langHisto = array();

    /**
    * _statutsHisto
    * historique des statuts pour cet instance d'objet
    * @access private
    * @var Array
    **/
    var $_statutsHisto = array();

    /**
    * _parentsHisto
    * historique des parents pour cet instance d'objet
    * @access private
    * @var Array
    **/
    var $_parentsHisto = array ();

    /**
    * _datesHisto
    * historique des dates pour cet instance d'objet
    * @access private
    * @var Array
    **/
    var $_datesHisto = array ();

    // }}}

    // {{{ factory()
    function &factory($dbParameters = null, $dbOptions = null) {

        if(file_exists(dirname(__FILE__)."/".$dbParameters->_dbEngine."/rubrique_".$dbParameters->_dbEngine.".php") == false) {
            include_once(dirname(__FILE__)."/common/rubrique_common.php");
            $classname = "BD_rubrique_common";
        }
        else {
            include_once(dirname(__FILE__)."/".$dbParameters->_dbEngine."/rubrique_".$dbParameters->_dbEngine.".php");
            $classname = "BD_rubrique_".$dbParameters->_dbEngine;
        }

        if (!class_exists($classname)) {
            return PEAR::raiseError("Cannot instanciate class $classname", null,
                                    null, null, null, null, false);
        }

        $obj =& new $classname;
        $result = $obj->setDbParameters($dbParameters);
        if ($dbOptions != null) {
            $obj->setDbOptions($dbOptions);
        }
        if (PEAR::isError($result)) {
            return $result;
        } else {
            return $obj;
        }
    }

    // }}}

    // {{{ constructor

    /**
     * DB_rubrique constructor.
     *
     * @access public
     */

    function BD_rubrique() {
    }

    // }}}

    // {{{ getRubriqueId()

    /**
     * Returns the Rubrique ID
     * @return  int
     * @access  public
     */

    function getRubriqueId() {
        return $this->_rubriqueId;
    }

    // }}}

    // {{{ setRubriqueId()

    /**
     * Sets the Rubrique ID
     * @param   int
     * @access  public
     */

    function setRubriqueId($rubriqueId) {

        $this->_rubriqueId = $rubriqueId;
    }

    // }}}

    // {{{ getParentId()

    /**
     * Returns the Parent ID
     * @return  int
     * @access  public
     */

    function getParentId() {
        return $this->_parentId;
    }

    // }}}

    // {{{ setParentId()

    /**
     * Sets the Parent ID
     * @param   int
     * @access  public
     */

    function setParentId($parentId) {
        if (isset($this->_parentId) and ($this->_parentId != $parentId) ) {
            // on sauvegarde ce parent
            $this->_parentsHisto[] = $this->_parentId;
        }
        $this->_parentId = $parentId;
    }

    // }}}

    // {{{ getTitre()

    /**
     * Returns the rubrique title
     * @return  String
     * @access  public
     */

    function getTitre() {
        return $this->_titre;
    }

    // }}}

    // {{{ setTitre()

    /**
     * Sets the rubrique title
     * @param   String
     * @access  public
     */

    function setTitre($titre) {
        $this->_titre = $this->corriger_caracteres($titre);
    }

    // }}}

    // {{{ getDescriptif()

    /**
     * Returns the rubrique description
     * @return  String
     * @access  public
     */

    function getDescriptif() {
        return $this->_descriptif;
    }

    // }}}

    // {{{ setDescriptif()

    /**
     * Sets the rubrique description
     * @param   String
     * @access  public
     */

    function setDescriptif($descriptif) {
        $this->_descriptif = $this->corriger_caracteres($descriptif);
    }

    // }}}

    // {{{ getTexte()

    /**
     * Returns the rubrique text
     * @return  String
     * @access  public
     */

    function getTexte() {
        return $this->_texte;
    }

    // }}}

    // {{{ setTexte()

    /**
     * Sets the rubrique text
     * @param   String
     * @access  public
     */

    function setTexte($texte) {
        $this->_texte = $this->corriger_caracteres($texte);
    }

    // }}}

    // {{{ getSecteurId()

    /**
     * Returns the Sector ID
     * @return  int
     * @access  public
     */

    function getSecteurId() {
        return $this->_secteurId;
    }

    // }}}

    // {{{ setSecteurId()

    /**
     * Sets the Sector ID
     * @param   int
     * @access  public
     */

    function setSecteurId($secteurId) {
        if (isset($this->_secteurId) and ($this->_secteurId != $secteurId) ) {
            // on sauvegarde ce secteur
            $this->_secteursHisto[] = $this->_secteurId;
        }
        $this->_secteurId = $secteurId;
    }

    // }}}

    // {{{ getMajDate()

    /**
     * Returns the rubrique update date
     * @return  Date
     * @access  public
     */

    function getMajDate() {
        return $this->_majDate;
    }

    // }}}

    // {{{ setMajDate()

    /**
     * Sets the rubrique update date
     * @param   Date
     * @access  public
     */

    function setMajDate($majDate) {
        $this->_majDate = $majDate;
    }

    // {{{ getExport()

    /**
     * Returns the rubrique export
     * @return  String
     * @access  public
     */

    function getExport() {
        return $this->_export;
    }

    // }}}

    // {{{ setExport()

    /**
     * Sets the rubrique export
     * @param   String
     * @access  public
     */

    function setExport($export) {
        $this->_export = $this->corriger_caracteres($export);
    }

    // }}}

    // {{{ getImportId()

    /**
     * Returns the Import ID
     * @return  int
     * @access  public
     */

    function getImportId() {
        return $this->_importId;
    }

    // }}}

    // {{{ setImportId()

    /**
     * Sets the Import ID
     * @param   int
     * @access  public
     */

    function setImportId($importId) {
        $this->_importId = $importId;
    }

    // }}}

    // {{{ getStatut()

    /**
     * Returns the rubrique Statute
     * @return  String
     * @access  public
     */

    function getStatut() {

        return $this->_statut;
    }

    // }}}

    // {{{ setStatut()

    /**
     * Sets the rubrique statute
     * @param   String
     * @access  public
     */
    function setStatut($statut) {
        if (isset($this->_statut) and ($statut != $this->_statut)) {
            // on sauvegarde ce statut
            $this->_statutsHisto[] = $this->_statut;
        }
        $this->_statut = $this->corriger_caracteres($statut);
    }

    // }}}

    // {{{ getDate()

    /**
     * Returns the rubrique date
     * @return  Date
     * @access  public
     */

    function getDate() {
        return $this->_date;
    }

    // }}}

    // {{{ setDate()

    /**
     * Sets the rubrique date
     * @param   Date
     * @access  public
     */

    function setDate($date) {
        if (isset($this->_date) and ($this->_date != $date) ) {
            // on sauvegarde cette date
            $this->_datesHisto[] = $this->_date;
        }
        $this->_date = $date;
    }

    // }}}

    // {{{ getExtra()

    /**
     * Returns the extar fields
     * @return  String
     * @access  public
     */

    function getExtra() {
        return $this->_extra;
    }

    // }}}

    // {{{ setExtra()

    /**
     * Sets the extra fields
     * @param   String
     * @access  public
     */

    function setExtra($extra) {
        $this->_extra = $extra;
    }

    // }}}

    // {{{ getLang()

    /**
     * Returns the lang fields
     * @return  String
     * @access  public
     */

    function getLang() {
        //return $this->corriger_null($this->_lang);
        return $this->_lang;
    }

    // }}}

    // {{{ setLang()

    /**
     * Sets the lang fields
     * @param   String
     * @access  public
     */

    function setLang($lang) {
        $this->_lang = $lang;
        $this->_langHisto[] = $this->_lang;
    }

    // }}}

    // {{{ getLangChoisie()

    /**
     * get Lang functions activation.
     * @var     String
     * @access  private
     */

    function getLangChoisie() {
        return $this->_langChoisie;
    }

    // }}}

    // {{{ setLangChoisie()


    /**
     * Set Lang functions activation.
     * @var     String
     * @access  private
     */

    function setLangChoisie($langChoisie) {
        $this->_langChoisie = $langChoisie;
    }

    // }}}

    // {{{ create()

    function create() {
        $db = &$this->_getDB();

        if (DB::isError($db)) {

            return PEAR::raiseError("[".get_class($this)." DB_rubrique : create()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $string_prefix = $GLOBALS['table_prefix']."_rubriques";
        $rubriqueId = $db->nextId($string_prefix, true);
        if (DB::isError($rubriqueId)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : create()] ".$rubriqueId->getMessage()."", null,
                null, null, null, null, false);
        }

        $this->_rubriqueId = $rubriqueId;

        //if ($this->_date == "NOW()") $dateValue = "NOW()"; else $dateValue = "'".$db->quoteString($this->_date)."'";

        if($this->_secteurId == null) $this->_secteurId = 0;
        if($this->_importId == null) $this->_importId = 0;

        $maDate = new Date();
	    $this->setDate($maDate->getDate(DATE_FORMAT_ISO));

        //Modification fxlacroix@clever-age.com
        if($this->_langChoisie==NULL) $this->_langChoisie='non';
        //Fin de modification

    	if($this->_statut==NULL) $this->_statut='prive';


        if (($this->_secteurId == null) or ($this->_secteurId = 0)) { // je n'ai pas le secteur
            $this->_secteurId = $this->findSectorId();
        }

        // choix de la langue
        if(!isset($this->_lang)) {
            require_once dirname(__FILE__)."/../../include/utils/meta.php";
            if ($this->getParentId() == 0) {
                $this->setLang(lire_meta('langue_site'));
            } else {
                $rubriqueMetier = &recuperer_instance_rubrique();
                $rubriqueMetier->load($this->getParentId());
                $this->setLang($rubriqueMetier->getLang());
                unset ($rubriqueMetier);
            }
        }
		
		if($this->_rubriqueId==$this->_parentId){
			// die("erreur dans include/BD/rubrique.php -> function create() : id_parent doit tre diffrent de id_rubrique!!");
            return PEAR::raiseError("[".get_class($this)."erreur dans include/BD/rubrique.php -> function create() : id_parent (".$this->_parentId.
                ") doit tre diffrent de id_rubrique (".$this->_rubriqueId.")", null,
                null, null, null, null, false);
		}
        $query = "INSERT INTO ".$GLOBALS['table_prefix']."_rubriques (".RUBRIQUE_ALL_FIELDS.") VALUES "
                ."(".$this->_rubriqueId.", "
                ."".$this->_parentId.", "
                ."'".$db->quoteString($this->_titre)."', "
                ."'".$db->quoteString($this->_descriptif)."', "
                ."'".$db->quoteString($this->_texte)."', "
                ."".$this->_secteurId.", "
                ."'".$db->quoteString($this->_majDate)."', "
                ."'".$db->quoteString($this->_export)."', "
                ."".$this->_importId.", "
                ."'".$db->quoteString($this->_statut)."', "
                ."'".$db->quoteString($this->_date)."', "
                ."'".$db->quoteString($this->_extra)."', "
                ."'".$db->quoteString($this->_lang)."', "
                ."'".$db->quoteString($this->_langChoisie)."')";

        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : create()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

        $this->_isLoaded = true;

        if (($this->getStatut() == 'publie') or ($this->getStatut() == 'pub-archi') or ($this->getStatut() == 'archi')) {
            // mets  jour le statut du pere
            $rubriqueMetier = &recuperer_instance_rubrique();
            $rubriqueMetier->load($this->_parentId);
            $statut = $rubriqueMetier->getStatutFromRubrique($this->_parentId);
            if ($statut != $rubriqueMetier->getStatut()) {
                $rubriqueMetier->setStatut($statut);
                $rubriqueMetier->update();
            }
        }

    }

    // }}}

    // {{{ update()

    function update() {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : update()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        //if ($this->_date == 'NOW()') $dateValue = 'NOW()'; else $dateValue = "'".$db->quoteString($this->_date)."'";

        $maDate = new Date();
	    $this->setMajDate($maDate->getDate(DATE_FORMAT_ISO));

        // on recalcule le secteur ... tant pis
        $this->setSecteurId($this->findSectorId());

        // Gestion des articles postdats
        $this->checkForPostDated();
		
		if(($this->_rubriqueId==$this->_parentId)&&($this->_rubriqueId!="")&&($this->_parentId!="")){
			// die("erreur dans include/BD/rubrique.php -> update() : id_parent doit tre diffrent de id_rubrique!!");
            return PEAR::raiseError("[".get_class($this)."erreur dans include/BD/rubrique.php -> function create() : id_parent (".$this->_parentId.
                ") doit tre diffrent de id_rubrique (".$this->_rubriqueId.")", null,
                null, null, null, null, false);
		}

        $query = "UPDATE ".$GLOBALS['table_prefix']."_rubriques "
                ."SET id_rubrique = ".$this->_rubriqueId.", "
                ."id_parent = ".$this->_parentId.", titre = '".$db->quoteString($this->_titre)."', "
                ."descriptif = '".$db->quoteString($this->_descriptif)."', texte = '".$db->quoteString($this->_texte)."', "
                ."id_secteur = ".$this->_secteurId.", maj = '".$db->quoteString($this->_majDate)."', "
                ."export = '".$db->quoteString($this->_export)."', id_import = ".$this->_importId.", "
                ."statut = '".$db->quoteString($this->_statut)."', date_heure = '".$db->quoteString($this->_date)."', "
                ."extra = '".$db->quoteString($this->_extra)."', lang = '".$db->quoteString($this->_lang)."', "
                ."langue_choisie = '".$db->quoteString($this->_langChoisie)."' WHERE id_rubrique = ".$this->_rubriqueId;


        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : update()] ".$result->getMessage()."", null,
                null, null, null, null, false);;
        }

        // Redfinition de la langue des enfants si ncessaire
        // EN ATTENTE DE CONFIRMATION       if ( count($this->_langHisto) ) { $this->propagateLang(); }

        
        // Mise  jour des objets lis
        $this->updateRelatedObjects();


    }

    // }}}

    // {{{ load()

    function load($idRubrique) {
        if ( $idRrubrique < 0 ) { return; }

        if (($this->_isLoaded) and ($this->_rubriqueId == $idRubrique)) return; // la rubrique est charge
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : load()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }


        $query = "SELECT ".RUBRIQUE_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_rubriques WHERE id_rubrique = $idRubrique";

        //echo '<br>' . $query . '<br>';



        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : load()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
            if ($row = $result->fetchRow()) {

                $maDate = new Date($row['maj']);
                $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

                $this->_fetchData($row);
            } else {
                return PEAR::raiseError("[".get_class($this)." DB_rubrique : load($idRubrique)] Aucune rubrique ne correspond pas a cet ID!", null,
                                    null, null, null, null, false);
            }
            $result->free();
        }
        $this->_isLoaded = true;
    }

    // }}}

    // {{{ delete()

    function delete($idRubrique) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : delete()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_rubriques WHERE id_rubrique = $idRubrique";

        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : delete()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ deleteMajDate($myDate)

    /**
     * This method is used to delete all headings former to mydate
     * @access  public
     */

    function deleteMajDate($myDate) {
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : deleteMajDate()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $dateTmp = new Date($myDate);
        $myDate = $dateTmp->getDate(DATE_FORMAT_ISO);

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_rubriques WHERE maj < '$myDate'";


        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : deleteMajDate()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ _fetchData()

    function _fetchData($row) {
        $this->setRubriqueId($row['id_rubrique']);
        $this->setParentId($row['id_parent']);
        $this->setTitre($row['titre']);
        $this->setDescriptif($row['descriptif']);
        $this->setTexte($row['texte']);
        $this->setSecteurId($row['id_secteur']);
        $this->setMajDate($row['maj']);
        $this->setExport($row['export']);
        $this->setImportId($row['id_import']);
        $this->setStatut($row['statut']);
        $this->setDate($row['date_heure']);
        $this->setLang($row['lang']);
        $this->setExtra($row['extra']);
        $this->setLangChoisie($row['langue_choisie']);
    }

    // }}}

    // {{{ deleteAlreadyManagedRubrique($rubriqueId, $auteurId)

    function deleteAlreadyManagedRubrique($rubriqueId, $auteurId) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : deleteAlreadyManagedRubrique()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $allForParentId = $this->getAllForParentId($rubriqueId);
        while (list(, $maRubrique) = each($allForParentId)) {
            $query = "DELETE FROM ".$GLOBALS['table_prefix']."_auteurs_rubriques WHERE id_auteur=$auteurId AND id_rubrique=".$maRubrique->getRubriqueId();

            $result = $db->query($query);
            if (DB::isError($result)) {
                return PEAR::raiseError("[".get_class($this)." DB_rubrique : deleteAlreadyManagedRubrique()] ".$result->getMessage()."", null,
                    null, null, null, null, false);
            }
            $this->deleteAlreadyManagedRubrique($maRubrique->getRubriqueId(), $auteurId);
        }
    }

    // }}}


    // {{{ addAuteur()

     /**
     * This method is used to attach an author to this rubrique
     * @param   int $authorId autor to attach
     * @access  public
     */
    function addAuteur($auteurId) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : addAuteur()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $result = $this->deleteAlreadyManagedRubrique($this->getRubriqueId(), $auteurId);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : addAuteur()] ".$result->getMessage()."", null,
            null, null, null, null, false);
        }

        $query = "INSERT INTO ".$GLOBALS['table_prefix']."_auteurs_rubriques (id_auteur, id_rubrique) VALUES ($auteurId, ".$this->_rubriqueId.")";


        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : addAuteur()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

    }

    // }}}

    // {{{ deleteAuteurs()

    /**
     * This method is used to delete all authors attached to this rubrique
     * @access  public
     */
    function deleteAuteurs() {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : deleteAuteurs()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_auteurs_rubriques WHERE id_rubrique = ".$this->_rubriqueId;

        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : deleteAuteurs()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ deleteForRubriqueIdAndAuteurId()

     /**
     * This method is used to delete a given author attached to this rubrique
     * @param   int $authorId author to delete
     * @access  public
     */
    function deleteForRubriqueIdAndAuteurId($authorId) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : deleteForRubriqueIdAndAuteurId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_auteurs_rubriques WHERE id_auteur=$authorId AND id_rubrique = ".$this->_rubriqueId;

        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : deleteForRubriqueIdAndAuteurId()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ deleteAuteur()

     /**
     * This method is used to delete a given author attached to all rubrique
     * @param   int $authorId author to delete
     * @access  public
     */
    function deleteAuteur($authorId) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : deleteAuteur()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_auteurs_rubriques WHERE id_auteur=$authorId";

        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : deleteAuteur()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ deleteAllAuteurIdsExceptRubriqueIds($rubriques)

     /**
     * This method is used to delete authors not attached to a list of rubriqueIds
     * @param   int list of rubriqueIds
     * @access  public
     */
    function deleteAllAuteurIdsExceptRubriqueIds($rubriques) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : deleteAllAuteurIdsExceptRubriqueIds()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_auteurs_rubriques WHERE id_rubrique NOT IN ($rubriques)";

        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : deleteAllAuteurIdsExceptRubriqueIds()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ deleteAllMotIdsExceptRubriqueIds($rubriques)

     /**
     * This method is used to delete mots not attached to a list of rubriqueIds
     * @param   int list of rubriqueIds
     * @access  public
     */
    function deleteAllMotIdsExceptRubriqueIds($rubriques) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : deleteAllMotIdsExceptRubriqueIds()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_mots_rubriques WHERE id_rubrique NOT IN ($rubriques)";

        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : deleteAllMotIdsExceptRubriqueIds()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ getSecteurs()

    function getSecteurs() {
        $enfants = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : getSecteurs()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT id_rubrique FROM ".$GLOBALS['table_prefix']."_rubriques WHERE id_parent=0";

        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : getSecteurs()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $result->fetchRow()) {    $enfants[] = $row['id_rubrique'];}
        $result->free();
        return $enfants;
    }

    // {{{ getFirstRubrique()

    function getFirstRubrique($parentId) {
        $my_rubrique = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : getFirstRubrique()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT * FROM ".$GLOBALS['table_prefix']."_rubriques WHERE id_parent=$parentId ORDER BY titre";


        //echo "<br><br>$query<br><br>";

        $result = $db->limitQuery($query, 0 , 1);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : getFirstRubrique()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        while($row = $result->fetchRow()) {    $my_rubrique = $row['id_rubrique'];}
        $result->free();
        return $my_rubrique;
    }

    // {{{ getAllRubriqueId()

    function getAllRubriqueId() {
        $rubriques = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : getAllRubriqueId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT id_rubrique FROM ".$GLOBALS['table_prefix']."_rubriques";


        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : getAllRubriqueId()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $result->fetchRow()) {    $rubriques[] = $row['id_rubrique'];}
        $result->free();
        return $rubriques;
    }

    // }}}
    
    
    // {{{ getAllEnfantIdsForParentIds($rubriques)

    function getAllEnfantIdsForParentIds($rubriques) {
        $enfants = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : getAllEnfantIdsForParentIds()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT id_rubrique FROM ".$GLOBALS['table_prefix']."_rubriques WHERE id_parent IN ($rubriques)";


        //echo '<br>' . $query . '<br>';
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : getAllEnfantIdsForParentIds()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $result->fetchRow()) {    $enfants[] = $row['id_rubrique'];}
        $result->free();
        return $enfants;
    }

    // {{{ getRubriqueIdsForParentId($generation)

    function getRubriqueIdsForParentId($generation) {
        $lesfils = array();

        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : getRubriqueIdsForParentId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT id_rubrique FROM ".$GLOBALS['table_prefix']."_rubriques WHERE id_parent IN ($generation)";

        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : getRubriqueIdsForParentId()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    	$lesfils = array();
    	while ($row = $result->fetchRow())  {
            $lesfils[] = $row['id_rubrique'];
        }
        $result->free();
        return $lesfils;
    }

    // }}}

    // {{{ getTotalVis($parentId,$total_vis,$nombre_vis)

    function getTotalVis($parentId,$total_vis,$nombre_vis) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : getTotalVis()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

	 	$query = "SELECT id_rubrique FROM ".$GLOBALS['table_prefix']."_rubriques WHERE id_parent=$parentId";

    	$result = $db->query($query);
    	if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : getTotalVis()] ".$result->getMessage()."", null,
                null, null, null, null, false);
    	}

    	while ($row = $result->fetchRow()) {
    	    $id_rubrique = $row['id_rubrique'];
            if ($nombre_vis[$id_rubrique]>$total_vis) $total_vis=$nombre_vis[$id_rubrique];
    	}
        $result->free();
        return($total_vis);
    }

    // }}}

    // {{{ getRubriqueIdForParentId($parentId)

    function getRubriqueIdForParentId($parentId) {
        $rubriques = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : getRubriqueIdForParentId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

	 	$query = "SELECT id_rubrique FROM ".$GLOBALS['table_prefix']."_rubriques WHERE id_parent=$parentId";

    	$result = $db->query($query);
    	if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : getRubriqueIdForParentId()] ".$result->getMessage()."", null,
                null, null, null, null, false);
    	}

        while ($row = $result->fetchRow()) {
            $resultRubrique = &BD_rubrique::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultRubrique->_fetchData($row);
            $rubriques[] = &$resultRubrique;
        }
        $result->free();
        return($rubriques);
    }

    // }}}


/*
    // {{{ getRubriqueIdForParentIdAndNotInRubriqueId($r)

    function getRubriqueIdForParentIdAndNotInRubriqueId($r) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : getRubriqueIdForParentIdAndNotInRubriqueId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

	 	$query = "SELECT id_rubrique FROM ".$GLOBALS['table_prefix']."_rubriques WHERE id_parent IN ($r) AND id_rubrique NOT IN ($r)";

    	$result = $db->query($query);
    	if (!DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : getRubriqueIdForParentIdAndNotInRubriqueId()] ".$result->getMessage()."", null,
                null, null, null, null, false);
    	}
        $result->free();
    }

    // }}}
*/

    // {{{ getParentIdsForRubriqueIdsAndParentIds($rubriques, $rubriques_publiques)

    function getParentIdsForRubriqueIdsAndParentIds($rubriques, $rubriques_publiques) {
        $parents = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : getParentIdsForRubriqueIdsAndParentIds()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

	 	$query = "SELECT DISTINCT id_parent FROM ".$GLOBALS['table_prefix']."_rubriques WHERE (id_rubrique IN ($rubriques)) AND (id_parent NOT IN ($rubriques_publiques))";

    	//echo '<br>' . $query . '<br>';
    	$result = $db->query($query);
    	if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : getParentIdsForRubriqueIdsAndParentIds()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    	while ($row = $result->fetchRow())  {
            if ($row['id_parent'])  $parents[] = $row['id_parent'];
        }
        $result->free();
        return $parents;
    }

    // }}}

    // {{{ getAllForParentId($leparent, $critere)

    /**
     * Returns an array of Rubrique depending
     * on $leparent order by $order.
     *
     *
     * @return Array of Rubrique
     * @param $leparent
     * @param $critere
     * @access public
     */

    function &getAllForParentId($leparent, $critere = null) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : getAllForParentId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT ".RUBRIQUE_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_rubriques WHERE id_parent=$leparent";
        //die($critere);
        if($critere != null) $query .= " ORDER BY $critere";
        //echo $query;

        //echo "$query<br>";


        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : getAllForParentId()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultRubrique = &BD_rubrique::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultRubrique->_fetchData($row);
            $result[] = &$resultRubrique;

    	}
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ getAllDistinctRubriqueForStatut($statut,$post_dates)

    function &getAllDistinctRubriqueForStatut($statut,$post_dates = 'non') {
        $rubriqueIds = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : getAllDistinctRubriqueForStatut()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        if ($post_dates != "non") {
	    	$query = "SELECT DISTINCT id_rubrique FROM ".$GLOBALS['table_prefix']."_articles WHERE statut = '$statut'";
	    }
	    else {
    		$maDate = new Date();
    		$query = "SELECT DISTINCT id_rubrique FROM ".$GLOBALS['table_prefix']."_articles WHERE statut = '$statut' AND date_heure <= '" . $maDate->getDate(DATE_FORMAT_ISO) . "'";
    	}

        //echo "$query<br>";


        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : getAllDistinctRubriqueForStatut()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $rubriqueIds[] = $row['id_rubrique'];
        }

        $queryResult->free();
        return $rubriqueIds;
    }

    // }}}

    // {{{ getArticleIdsForRubriqueIdAndStatut($rubriqueId, $statut1, $statut2, $statut3)

    /**
     * Returns an array of Article Ids
     *
     * @return Array of Article Ids
     * @param $rubriqueId
     * @param $statut1
     * @param $statut2
     * @param $statut3
     * @access public
     */

    function &getArticleIdsForRubriqueIdAndStatut($rubriqueId, $statut1, $statut2, $statut3, $statut4) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : getArticleIdsForRubriqueIdAndStatut()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT id_article FROM ".$GLOBALS['table_prefix']."_articles WHERE id_rubrique=$rubriqueId AND (statut='$statut1' OR statut='$statut2' OR statut='$statut3' OR statut='$statut4')";

        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : getArticleIdsForRubriqueIdAndStatut()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) $result[] = $row['id_article'];

        $queryResult->free();

        return $result;
    }

    // }}}

    // {{{ getBreveIdsForRubriqueIdAndStatut($rubriqueId, $statut1, $statut2)

    /**
     * Returns an array of Breve Ids
     *
     * @return Array of Breve Ids
     * @param $rubriqueId
     * @param $statut1
     * @param $statut2
     * @access public
     */

    function &getBreveIdsForRubriqueIdAndStatut($rubriqueId, $statut1, $statut2) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : getBreveIdsForRubriqueIdAndStatut()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT id_breve FROM ".$GLOBALS['table_prefix']."_breves WHERE id_rubrique=$rubriqueId AND (statut='$statut1' OR statut='$statut2')";

        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : getBreveIdsForRubriqueIdAndStatut()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) $result[] = $row['id_breve'];

        $queryResult->free();

        return $result;
    }

    // }}}

    // {{{ getSyndicIdsForRubriqueIdAndStatut($rubriqueId, $statut1, $statut2)

    /**
     * Returns an array of Syndic Ids
     *
     * @return Array of Syndic Ids
     * @param $rubriqueId
     * @param $statut1
     * @param $statut2
     * @access public
     */

    function &getSyndicIdsForRubriqueIdAndStatut($rubriqueId, $statut1, $statut2) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : getSyndicIdsForRubriqueIdAndStatut()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT id_syndic FROM ".$GLOBALS['table_prefix']."_syndic WHERE id_rubrique=$rubriqueId AND (statut='$statut1' OR statut='$statut2')";

        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : getSyndicIdsForRubriqueIdAndStatut()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) $result[] = $row['id_syndic'];

        $queryResult->free();

        return $result;
    }

    // }}}

    // {{{ getAllSecteurs()

    function &getAllSecteurs() {
        $enfants =  array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : getAllSecteurs()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT ".RUBRIQUE_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_rubriques WHERE id_parent=0";

        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : getAllSecteurs()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultRubrique = &BD_rubrique::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultRubrique->_fetchData($row);
            $enfants[] = &$resultRubrique;

        }
        $queryResult->free();
        return $enfants;
    }

    // {{{ isManagedByAuteurId($id_auteur)

    function isManagedByAuteurId($id_rubrique, $id_auteur) {

        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : isManagedByAuteurId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
		$allRubriques = $this->getRubriqueIdForAuteurIdExceptRoot($id_auteur);
	    if(PEAR::isError($allRubriques)) {
	        return $allRubriques;
        }
	    if(sizeOf($allRubriques) == 0) return true;

        $query = "SELECT lien.id_rubrique, id_parent FROM ".$GLOBALS['table_prefix']."_auteurs_rubriques lien, ".$GLOBALS['table_prefix']."_rubriques WHERE lien.id_auteur=$id_auteur AND lien.id_rubrique=".$GLOBALS['table_prefix']."_rubriques.id_rubrique";

        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : isManagedByAuteurId()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

        $rubriqueMetier = &recuperer_instance_rubrique();
        while ($row = $queryResult->fetchRow()) {
            $loadOK = $rubriqueMetier->load($id_rubrique);
            if(PEAR::isError($loadOK)) { /// la rubrique n'existe pas ... ?
                // return false;
                return true; // elle n'existe pas donc on y accede quand meme ;-) 
            }

            if($rubriqueMetier->getRubriqueId() == $row['id_rubrique']) return true;
            else {
                while($rubriqueMetier->getParentId() != 0) {
                    $loadOK = $rubriqueMetier->load($rubriqueMetier->getParentId());
                    if(PEAR::isError($loadOK)) { /// le parent n'existe pas ... ?
                        return false;
                    }
                    if($rubriqueMetier->getRubriqueId() == $row['id_rubrique']) return true;
                }
            }
        }
        return false;
    }

    // }}}

    // {{{ isAuthorizedToManageAuteur($id_auteur_master, $id_auteur_slave)

    function isAuthorizedToManageAuteur($id_auteur_master, $id_auteur_slave) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : isAuthorizedToManageAuteur()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $allRubriquesMaster = $this->getRubriqueIdForAuteurIdExceptRoot($id_auteur_master);
	    if(PEAR::isError($allRubriquesMaster)) {
	        return $allRubriquesMaster;
        }
	    if(sizeOf($allRubriquesMaster) == 0) return true;

        $allRubriquesSlave = $this->getRubriqueIdForAuteurIdExceptRoot($id_auteur_slave);
	    if(PEAR::isError($allRubriquesSlave)) {
	        return $allRubriquesSlave;
        }
        if(sizeOf($allRubriquesSlave) == 0) return false;

        while (list(, $maRubriqueId) = each($allRubriquesSlave)) {
            if(!$this->isManagedByAuteurId($maRubriqueId->getRubriqueId(), $id_auteur_master)) return false;
        }
        return true;
    }

    // }}}

    // {{{ getRubriqueManagementForAuteurId($id_auteur)

    /**
     * 
     *
     * @return Array of Rubrique
     * @param $leparent
     * @param $critere
     * @access public
     */

    function &getRubriqueManagementForAuteurId($id_auteur) {
        $result = array();
        
        if (!$id_auteur) return $result;
        
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : getRubriqueManagementForAuteurId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT rubriques.* FROM ".$GLOBALS['table_prefix']."_auteurs_rubriques lien, 
            ".$GLOBALS['table_prefix']."_rubriques rubriques WHERE lien.id_auteur=$id_auteur AND lien.id_rubrique=rubriques.id_rubrique";

        //echo $query;
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : getRubriqueManagementForAuteurId()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultRubrique = &BD_rubrique::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultRubrique->_fetchData($row);
            $result[] = &$resultRubrique;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ getRubriqueIdForAuteurIdExceptRoot($auteurId)

    /**
     * Returns an array of Rubrique_id
     *
     * @return Array of Rubrique_id
     * @param $auteurId
     * @access public
     */

    function &getRubriqueIdForAuteurIdExceptRoot($auteurId) {
        // On gre une variable static pour viter d'executer inutilement cette mthode pour chaque rubrique
        static $result;

        if(isset($result[$auteurId])) return $result[$auteurId];
        $result[$auteurId] = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : getRubriqueIdForAuteurIdExceptRoot()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT id_rubrique FROM ".$GLOBALS['table_prefix']."_auteurs_rubriques WHERE id_auteur=$auteurId AND id_rubrique!=0";

        //echo $query.'<br><br>';

        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : getRubriqueIdForAuteurIdExceptRoot()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        // on construit un tableau de resultat d'objet rubrique ... certe on ne charge que l'id
        while ($row = $queryResult->fetchRow()) {
            //$resultRubrique = &BD_rubrique::factory($this->getDbParameters(), $this->getDbOptions());
            $resultRubrique = &recuperer_instance_rubrique();
            if (! (PEAR::isError($resultRubrique->load($row['id_rubrique'])))) {
                // ? maj ? 
                // $maDate = new Date($row['maj']); 
                // $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);
                // $resultRubrique->_fetchData($row);
                $result[$auteurId][] = &$resultRubrique;
            }
        }
        $queryResult->free();

        return $result[$auteurId];
    }

    // }}}

    // {{{ getRubriqueIdsForAuteurId($auteurId)

    /**
     * Returns an array of Rubrique_id
     *
     * @return Array of Rubrique_id
     * @param $auteurId
     * @access public
     */

    function &getRubriqueIdsForAuteurId($auteurId) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : getRubriqueIdForAuteurIdExceptRoot()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT id_rubrique FROM ".$GLOBALS['table_prefix']."_auteurs_rubriques WHERE id_auteur=$auteurId";

        //echo $query.'<br><br>';

        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : getRubriqueIdForAuteurIdExceptRoot()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultRubrique = &BD_rubrique::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultRubrique->_fetchData($row);
            $result[] = &$resultRubrique;
        }
        $queryResult->free();
        return $result;
    }

    // }}}



    // {{{ getAuteurIdsForRubriqueId($rubriqueId)

    /**
     * Returns an array of Author.
     *
     *
     * @return Array of Author
     * @param $rubriqueId
     * @access public
     */

    function &getAuteurIdsForRubriqueId($rubriqueId) {
        $auteurs = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : getAuteurIdsForRubriqueId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT id_auteur FROM ".$GLOBALS['table_prefix']."_auteurs_rubriques WHERE id_rubrique=$rubriqueId";

        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : getAuteurIdsForRubriqueId()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $queryResult->fetchRow()) $auteurs[] = $row['id_auteur'];
        $queryResult->free();
        return $auteurs;
    }

    // }}}

    // {{{ getAllAuteurRubrique()

    /**
     * Returns an array
     *
     * @return Array
     * @access public
     */

    function &getAllAuteurRubrique() {
        $rub_restreinte = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : getAllAuteurRubrique()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        $query = "SELECT * FROM ".$GLOBALS['table_prefix']."_auteurs_rubriques";


        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : getAllAuteurRubrique()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow())
    		    $rub_restreinte[$row['id_auteur']] .= ','.$row['id_rubrique'];

        $queryResult->free();

        return $rub_restreinte;
    }

    // }}}

    // {{{ howManyRubriqueForLien($conf_mot)

    function HowManyRubriqueForMot($conf_mot)    {
        $howManyRubrique = 0;
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : HowManyRubriqueForMot()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

		$query = "SELECT COUNT(*) as cnt FROM ".$GLOBALS['table_prefix']."_mots_rubriques lien, ".$GLOBALS['table_prefix']."_rubriques rubrique "
                . " WHERE lien.id_mot=$conf_mot AND rubrique.id_rubrique=lien.id_rubrique";


		$result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : HowManyRubriqueForMot()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        if ($row = $result->fetchRow()) {
            $howManyRubrique = intval($row["cnt"]);
        }
        $result->free();
        return $howManyRubrique;
    }

    // }}}

    // {{{ getRubriqueStats()

    /**
     * This method computes statistics on articles stored in this Rubrique
     *
     * @return  int representing the stat
     * @access  public
     */

    function getRubriqueStats($criteria) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : getRubriqueStats()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT SUM(".$criteria.") AS cnt FROM ".$GLOBALS['table_prefix']."_articles WHERE id_rubrique=".$this->_rubriqueId."";
        $result = $db->getOne($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : getRubriqueStats()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

        return $result;
    }

    // }}}

    // {{{ hasRubriqueId()

    function hasRubriqueId() {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : hasRubriqueId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT id_rubrique FROM ".$GLOBALS['table_prefix']."_rubriques";


        $result = $db->limitQuery($query, 0, 1);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : hasRubriqueId()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        $hasRubriqueId = ($result->numRows() > 0);
        $result->free();
        return $hasRubriqueId;
    }

    // }}}


    // {{{ updateSecteursForRubriques()
    
    /**
    * mets a jours le secteur d'une liste de rubrique
    * @param int id_secteur le secteur
    * @param string rubriques_totales la liste des rubriques a utiliser dans le IN SQL 
    * @author olivier
    * @access public
    **/
    function updateSecteursForRubriques($id_secteur,$rubriques_totales) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : updateSecteursForRubriques()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "UPDATE ".$GLOBALS['table_prefix']."_rubriques SET id_secteur=$id_secteur WHERE id_rubrique IN ($rubriques_totales)";


        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : updateSecteursForRubriques()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

/*
    // {{{ updateDateForRubriques($date_rubrique,$id_rubrique)

    function updateDateForRubriques($date_rubrique,$id_rubrique) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : updateDateForRubriques()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $maDate = new Date($date_rubrique);

        $query = "UPDATE ".$GLOBALS['table_prefix']."_rubriques SET date_heure='" . $maDate->getDate(DATE_FORMAT_ISO) . "' WHERE id_rubrique=$id_rubrique";

        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : updateDateForRubriques()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ updateStatutForNotInRubriques($statut,$rubriques_publiques)

    function updateStatutForNotInRubriques($statut,$rubriques_publiques) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : updateStatutForNotInRubriques()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "UPDATE ".$GLOBALS['table_prefix']."_rubriques SET statut='$statut' WHERE id_rubrique NOT IN ($rubriques_publiques)";

        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : updateStatutForNotInRubriques()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ updateStatutForRubriques($statut,$rubriques_publiques)

    function updateStatutForRubriques($statut,$rubriques_publiques) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : updateStatutForRubriques()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "UPDATE ".$GLOBALS['table_prefix']."_rubriques SET statut='$statut' WHERE id_rubrique IN ($rubriques_publiques)";

        //echo '<br>' . $query . '<br>';
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : updateStatutForRubriques()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}
*/
    // {{{ getParentAndGrandParentForRubriqueId($id_rubrique)

    /**
     * Returns an array with Parent and Grand Parent
     *
     * @return Array of Rubrique_id
     * @param $auteurId
     * @access public
     */

    function &getParentAndGrandParentForRubriqueId($id_rubrique) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : getParentAndGrandParentForRubriqueId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT a.id_parent AS ida, b.id_parent AS idb ".
			"FROM ".$GLOBALS['table_prefix']."_rubriques a LEFT JOIN ".$GLOBALS['table_prefix']."_rubriques b ON (b.id_rubrique = a.id_parent) ".
			"WHERE a.id_rubrique = $id_rubrique";


        //echo $query;
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : getParentAndGrandParentForRubriqueId()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        if ($row = $queryResult->fetchRow()) {
            $result = $row;
        }
        $queryResult->free();
        return $result;
    }

    // {{{ getAllDocumentsLies($id_article, $mode)

    /**
     * Returns an array of Document.
     *
     *
     * @return Array of Document
     * @param $id_article
     * @access public
     */

    function &getAllDocumentsLies($id_rubrique, $mode, $docs_exclus = "", $id_doublons = null) {
        $documentIds = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : getAllDocumentLies()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT docs.id_document FROM ".$GLOBALS['table_prefix']."_documents docs, ".$GLOBALS['table_prefix']."_documents_rubriques l WHERE l.id_rubrique=$id_rubrique AND l.id_document=docs.id_document ".$docs_exclus." AND docs.mode_spip='$mode'";
        if ($id_doublons) $query .= " AND docs.id_document NOT IN (".$id_doublons.") ";
        $query .= " ORDER BY docs.id_document";

        //echo "<br>$query<br>";


        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : getAllDocumentLies()] ".$queryResult->getMessage(), null,
                null, null, null, null, false);
        }

    while ($row = $queryResult->fetchRow()) {
        $documentIds[] = $row['id_document'];
    }
    $queryResult->free();
    return $documentIds;
    }

    // }}}

    // {{{ deleteAllAuteurIdsExceptAuteurIds($auteurs)

    function deleteAllAuteurIdsExceptAuteurIds($auteurs)  {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : deleteAllAuteurIdsExceptAuteurIds()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_auteurs_rubriques WHERE id_auteur NOT IN ($auteurs)";


        //echo $query.'<br>';
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : deleteAllAuteurIdsExceptAuteurIds()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

	// {{{ isArchiveHelp($rubriqueId)

	function isArchiveHelp($rubriqueId)  {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubriquee : isArchive()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "select id_rubrique, statut from ".$GLOBALS['table_prefix']."_rubriques where id_parent=$rubriqueId";


        //echo '<br>' . $query . '<br>';

        $result = $db->query($query);
        while ($row = $result->fetchRow()) {
			if($row['statut'] != 'archi') {
				return false;
			}
			else {
				if($this->isArchive($row['id_rubrique']) == false) return false;
			}
        }
        return true;
	}

    // {{{ isArchive($rubriqueId)

    function isArchive($rubriqueId, $rubriquesNonArchivees = array())  {
        if(in_array($rubriqueId, $rubriquesNonArchivees) == true) return false;

        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubriquee : isArchive()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "select id_rubrique, statut from ".$GLOBALS['table_prefix']."_rubriques where id_parent=$rubriqueId";

        $result = $db->query($query);
        while ($row = $result->fetchRow()) {
			if($this->isArchive($row['id_rubrique'], $rubriquesNonArchivees) == false)	return false;
        }

        $articleMetier = &recuperer_instance_article();
        $articles = $articleMetier->getAllForRubriqueId($rubriqueId);
        $articlesArchi = $articleMetier->getAllForRubriqueId($rubriqueId, 'archi');

        if(sizeof($articles) == sizeof($articlesArchi)) return true;
        else return false;
    }

    // }}}

    // {{{ getRubriqueidsForStatut($statut)

    function &getRubriqueidsForStatut($statut) {
        $rubriqueIds = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : getRubriqueidsForStatut()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }


	    $query = "SELECT DISTINCT id_rubrique FROM ".$GLOBALS['table_prefix']."_rubriques WHERE statut = '$statut'";



	    //echo "$query<br>";

        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : getRubriqueidsForStatut()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $rubriqueIds[] = $row['id_rubrique'];
        }

        $queryResult->free();
        return $rubriqueIds;
    }

    // }}}

    // {{{ addBookmarks($id_auteur)

	function addBookmark($id_auteur) {

		$db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : addBookmark()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = 'INSERT INTO '.$GLOBALS['table_prefix'].'_bookmarks (id_auteur, id_objet, type_bookmark) VALUES (' . $id_auteur . ',' . $this->getRubriqueId() . ', \'rubrique\')';



		//echo '<br>' . $query . '<br>';

        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : addBookmark()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

	}

	// }}}

    // {{{ deleteBookmark($id_auteur)

	function deleteBookmark($id_auteur) {

		$db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : deleteBookmark()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = 'DELETE FROM '.$GLOBALS['table_prefix'].'_bookmarks WHERE id_auteur=' . $id_auteur . ' AND id_objet=' . $this->getRubriqueId() . ' AND type_bookmark=\'rubrique\'';


		//echo '<br>' . $query . '<br>';

        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : deleteBookmark()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

	}

	// }}}

    // {{{ isBookmark($id_auteur)

    function isBookmark($id_auteur) {

        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : isBookmark()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = 'SELECT COUNT(*) as cnt FROM '.$GLOBALS['table_prefix'].'_bookmarks WHERE id_auteur=' . $id_auteur . ' AND id_objet=' . $this->getRubriqueId() . ' AND type_bookmark=\'rubrique\'';


        //echo '<br>' . $query . '<br>';

        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : isBookmark()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        if ($row = $result->fetchRow()) {
            if($row["cnt"] > 0) return true;
        }
        return false;

    }

    // }}}

	// {{{ loadForParentAndLang()

    /**
     * This method return the child rubrique for a given father and language
     * @param	int		$idParent
     * @param	String	$lang
     * @return	BD_Rubrique
     */

    function loadForParentAndLang($idParent, $lang) {
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : loadForParentAndLang()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }


        $query = 'SELECT '.RUBRIQUE_ALL_FIELDS.' FROM '.$GLOBALS['table_prefix'].'_rubriques  WHERE lang='.$db->quote($spip_lang).' AND id_parent='.$id_parent;

        //echo '<br>' . $query . '<br>';


        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : loadForParentAndLang()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
            if ($row = $result->fetchRow()) {

                $maDate = new Date($row['maj']);
                $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

                $this->_fetchData($row);
            } else {
                return PEAR::raiseError("[".get_class($this)." DB_rubrique : loadForParentAndLang($idParent, $lang)] Aucune rubrique ne correspond pas  cet ID!", null,
                                    null, null, null, null, false);
            }
            $result->free();
        }
    }

	// }}}

	// {{{ getAllMotherLang()

    /**
     * This method return la langue des rubriques mere pour chaque rubrique fille
     * @return	Array
     */

    function getAllMotherLang() {

        $rubriques = array();

        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : getAllMotherLang()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT fille.id_rubrique AS id_rubrique, mere.lang AS lang FROM ".$GLOBALS['table_prefix']."_rubriques " .
                "AS fille, ".$GLOBALS['table_prefix']."_rubriques AS mere WHERE fille.id_parent = mere.id_rubrique " .
                        "AND fille.langue_choisie != 'oui' AND mere.lang<>'' AND mere.lang<>fille.lang";


        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : getAllMotherLang()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
            while ($row = $result->fetchRow()) {
                $rubriques[] = $row;
            }
        }

        return $rubriques;

    }

	// }}}

    // {{{ updateLangForSector($langue_site)

	function updateLangForSector($langue_site) {

		$db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : updateLangForSector()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "UPDATE ".$GLOBALS['table_prefix']."_rubriques SET lang='$langue_site', langue_choisie='non' WHERE id_parent='0' AND langue_choisie != 'oui'";


        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : updateLangForSector()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

	}

	// }}}

	// {{{ getAllLang()

    /**
     * This method return la liste des langues utilises
     * @return	Array
     */

    function getAllLang() {

        $langs = array();

        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : getAllLang()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT lang FROM ".$GLOBALS['table_prefix']."_rubriques WHERE lang != '' GROUP BY lang";


        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : getAllLang()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
            while ($row = $result->fetchRow()) {
                $langs[] = $row;
            }
        }

        return $langs;

    }

	// }}}

	// {{{ getAllRubriqueOrderBy()

    /**
     * This method return la liste des rubriques
     * @return	Array
     */

    function getAllRubriqueOrderBy($critere = "titre") {

        $rubriques = array();

        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : getAllRubriqueOrderBy()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT " . RUBRIQUE_ALL_FIELDS . " FROM ".$GLOBALS['table_prefix']."_rubriques ORDER BY $critere";
        //echo $query . '<br />';


        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : getAllRubriqueOrderBy()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
            while ($row = $result->fetchRow()) {
                $resultRubrique = &BD_rubrique::factory($this->getDbParameters(), $this->getDbOptions());

                $maDate = new Date($row['maj']);
                $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

                $resultRubrique->_fetchData($row);
                $rubriques[] = &$resultRubrique;
            }
            $result->free();
        }

        return $rubriques;

    }

	// }}}

	// {{{ getAllForLangAndParentId($spip_lang, $id_parent)

    /**
     * This method return la liste des rubriques
     * @return	Array
     */

    function getAllForLangAndParentId($spip_lang, $id_parent) {

        $rubriques = array();

        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : getAllForLangAndParentId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT " . RUBRIQUE_ALL_FIELDS . " FROM ".$GLOBALS['table_prefix']."_rubriques WHERE lang='$spip_lang' AND id_parent=$id_parent";


        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : getAllForLangAndParentId()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
            while ($row = $result->fetchRow()) {
                $resultRubrique = &BD_rubrique::factory($this->getDbParameters(), $this->getDbOptions());

                $maDate = new Date($row['maj']);
                $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

                $resultRubrique->_fetchData($row);
                $rubriques[] = &$resultRubrique;
            }
            $result->free();
        }

        return $rubriques;

    }

	// }}}

	// {{{ getLangUsed()

    /**
     * This method return la liste des langues utilises par les rubriques.
     * @return	Array
     */

    function &getLangUsed() {
        $langues = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : getLangUsed()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT DISTINCT lang FROM ".$GLOBALS['table_prefix']."_rubriques WHERE statut='publie' OR statut='pub_archi'";


		$queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : getLangUsed()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

    while ($row = $queryResult->fetchRow()) {
        $langues[] = $row['lang'];
    }
    $queryResult->free();
    return $langues;
    }

    // }}}

	// {{{ checkStatutPubArchiForRubriquePere($rubriqueIds)

	function checkStatutPubArchiForRubriquePeres($rubriqueIds)  {
        //$rubriquesIds = array();
        $rubriquesIds = explode(",", $rubriqueIds);

        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : checkStatutPubArchiForRubriquePere()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        while (list (, $rubriqueId) = each($rubriquesIds)) {
            $rubriqueFils = &recuperer_instance_rubrique();
            $loadOK = $rubriqueFils->load($rubriqueId);
            if(PEAR::isError($loadOK)) {
                return PEAR::raiseError("[".get_class($this)." DB_rubrique : checkStatutPubArchiForRubriquePere)] ".$loadOK->getMessage()."", null,
                null, null, null, null, false);
            }
            else {
                if ($rubriqueFils->getParentId() != 0) {
                    $rubriquePere = &recuperer_instance_rubrique();
                    $loadOK = $rubriquePere->load($rubriqueFils->getParentId());
                    $rubriquePere->updateStatutPubArchiForRubriquePere();
                }
            }

        }
	}

/*
	// {{{ updateStatutPubArchiForRubriquePere()

	function updateStatutPubArchiForRubriquePere()  {

	    if ( ($this->getStatut() == 'publie') || ($this->getStatut() == 'archi') ) {
	        $this->updateStatutForRubriques('pub_archi', $this->getRubriqueId());
            if ($this->getParentId() != 0) {
                $rubriquePere = &recuperer_instance_rubrique();
                $loadOK = $rubriquePere->load($this->getParentId());
                $rubriquePere->updateStatutPubArchiForRubriquePere();
            }
	    }

	}
*/
	// {{{ getHierarchie($rubriqueId)

    /**
    * @abstract renvoie la hierarchie jusqu'au secteur
    * attention : il reste la racine dans la pile !!!!
    **/

	function getHierarchie($rubriqueId = 0) {
		// echo 'getHierarchie de '.$rubriqueId."<br />\n";
		$hierarchie[] = $rubriqueId;

		$db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : getHierarchie()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($rubriqueId != 0) {

			$query = 'SELECT id_parent FROM '.$GLOBALS['table_prefix'].'_rubriques WHERE id_rubrique = ' . $rubriqueId;

			$queryResult = $db->query($query);

        	if (DB::isError($queryResult)) {
				return PEAR::raiseError("[".get_class($this)." DB_rubrique : getHierarchie()] ".$queryResult->getMessage()."", null,
					null, null, null, null, false);
        	}

	    	if ($row = $queryResult->fetchRow()) {
				$rubriqueId = $row['id_parent'];
	    	} else {
                return PEAR::raiseError("[".get_class($this)." DB_rubrique : getHierarchie()] La rubrique ".$rubriqueId." n'a pas de parent", null, null, null, null, null, false);
            }
	    	$hierarchie[] = $rubriqueId;
	    }
        // je d?pile pour ne pas avoir id_rubrique = 0
        //array_pop ($hierarchie);
        // ... apparement c'est ncessaire
	    //var_dump ($hierarchie);
	    return $hierarchie;

	}

	// }}}

    // {{{

    /**
    * @abstract renvoi un tableau avec les rubriques filles
    * @author olivier erwan
    * @return array d'ID de rubrique
    **/

    function getChildren($id_rubrique = -1) {
    
        if ($id_rubrique== -1) $id_rubrique = $this->getRubriqueId(); 
    
        $rubriqueIds = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : getChildren()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "select id_rubrique from ".$GLOBALS['table_prefix']."_rubriques where id_parent = ".$id_rubrique;
        $queryResult = $db->query($query);
        if (DB::isError($queryResult)) {
                return PEAR::raiseError("[".get_class($this)." DB_rubrique : getChildren()] ".$queryResult->getMessage()."", null,
                    null, null, null, null, false);
            }
        while ($row = $queryResult->fetchRow()) {
            $rubriqueIds[] = $row['id_rubrique'];
        }
        foreach ($rubriqueIds as $rub) {
            $rubriqueIds = array_merge ($this->getChildren ($rub), $rubriqueIds);
        }
        return $rubriqueIds;
    }

    // }}}



	// {{{ getStatutFromRubrique($id_rubrique)
    /**
    * recalcul le statut d'une rubrique, selon le statuts des objets qu'elle contient
    **/
    // TODO : cette mthode ne gre pas les documents
	function &getStatutFromRubrique($id_rubrique) {
		$rubriqueIds = array();
		$db = &$this->_getDB();

		if (DB::isError($db)) {
			return PEAR::raiseError("[".get_class($this)." DB_rubrique : getStatutFromRubrique()] ".$db->getMessage()."", null,
			null, null, null, null, false);
		}
        $objets = array ('articles', 'breves', 'syndic');
        $rubriqueStatuts = array ();
        foreach ($objets as $type) {
		  $query = 'SELECT DISTINCT statut FROM '.$GLOBALS['table_prefix']."_".$type." WHERE id_rubrique = '$id_rubrique'";
          // TODO grer les articles avec une date de publication dans le futur selon la meta qui va bien 
          if ( (lire_meta('post_dates')) == 'non' ) { 
              if ($type == 'articles') {
                $today = new Date();
                $query .= ' and date_heure < \''.$today->getDate().'\'';
              }
           }
		  //echo "$query \n<br>";
		  $queryResult = $db->query($query);
		  if (DB::isError($queryResult)) {
			 return PEAR::raiseError("[".get_class($this)." DB_rubrique : getStatutFromRubrique()] ".$queryResult->getMessage()."", null,
			null, null, null, null, false);
		  }

		  while ($row = $queryResult->fetchRow()) {
		   	  $rubriqueStatuts[] = $row['statut'];
		  }
		  $queryResult->free();
        }
        
        // on va cherche les statuts des rubriques filles
		$rubriqueStatutChildren=$this->getStatutFromRubriqueChildren($id_rubrique);
		if(is_array($rubriqueStatutChildren) && is_array($rubriqueStatuts))
		{
			$rubriqueStatuts = array_merge($rubriqueStatuts,$rubriqueStatutChildren);
		}
		return $this->getIfChangeStatutFromRubrique($rubriqueStatuts);
	}


    // }}}

	// {{{ getDateFromRubrique ($id_rubrique)
    /** calcule la date d'une rubrique selon les dates des objets qu'elle contient
    * @author olivier erwann
    * @access public
    * @return object date
    **/

    function getDateFromRubrique ($id_rubrique) {
            
        // TODO : pourquoi ajouter cette ligne enclenche une recursivite infinie ? :-( 
        // $this->load($id_rubrique);
        
        // if ($dateParent == null ) $dateParent = new Date('1970-01-01 00:00:00');
        $dateRubrique = new Date('1970-01-01 00:00:00');

        // breves
        //echo 'breves'."\n";
        require_once dirname(__FILE__)."/inc_breve_factory.php";
        $breveMetier = &recuperer_instance_breve();
        $dateBreve = $breveMetier->getMaxDateHeure($id_rubrique, 'publie');
        if(PEAR::isError($dateBreve)) {
            die($dateBreve->getMessage());
        }
        else {
            if (Date::compare($dateBreve, $dateRubrique) == 1) $dateRubrique = $dateBreve;
        }

        // site reference le plus recent
        //-------------- Modification elebescond@clever-age.com -----------------
        //echo 'sites'."\n";;
        require_once dirname(__FILE__)."/inc_syndic_factory.php";
        $syndicMetier = &recuperer_instance_syndic();
        $dateSyndic = $syndicMetier->getMaxDateHeure($id_rubrique, 'publie');
        if(PEAR::isError($dateSyndic)) {
            die($dateSyndic->getMessage());
        }
        else {
            if (Date::compare($dateSyndic, $dateRubrique) == 1) $dateRubrique = $dateSyndic;
        }


        include_once dirname(__FILE__)."/../utils/meta.php";
        // articles post-dates
        $post_dates = lire_meta("post_dates");
        //-------------- Modification elebescond@clever-age.com -----------------
        require_once dirname(__FILE__)."/inc_article_factory.php";
        $articleMetier = &recuperer_instance_article();
        $dateArticle = $articleMetier->getMaxDateHeure($id_rubrique, 'publie', $post_dates);
        //echo 'max date article '.$dateArticle->getDate().' '."\n";
        if(PEAR::isError($dateArticle)) {
            die($dateArticle->getMessage());
        }
        else {
            if (Date::compare($dateArticle, $dateRubrique) == 1) $dateRubrique = $dateArticle;
        }

        //echo 'docs'."\n";
        require_once dirname(__FILE__)."/inc_document_factory.php";
        $documentMetier = &recuperer_instance_document();
        $dateDocument = $documentMetier->getMaxDateHeure($id_rubrique);
        if(PEAR::isError($dateDocument)) {
            die($dateDocument->getMessage());
        }
        else {
            if (Date::compare($dateDocument, $dateRubrique) == 1) $dateRubrique = $dateDocument;
        }



        //$rubriqueMetier = &recuperer_instance_rubrique();
        // echo 'rubriques'."\n";
        $allRubriques = $this->getRubriqueIdForParentId($id_rubrique); // rcupre les filles
        if(PEAR::isError($allRubriques)) {
            die($allRubriques->getMessage());
        }
        
        //while(list(, $maRubrique) = each($allRubriques)) {
        foreach ($allRubriques as $maRubrique) {
            // echo $maRubrique->getRubriqueId().'<-----'.$id_rubrique."\n";
            if ($maRubrique->getRubriqueId() != $id_rubrique) {
                // echo "\$dateRubriqueFille = \$this->getDateFromRubrique(".$maRubrique->getRubriqueId().");";
                $dateRubriqueFille = $this->getDateFromRubrique($maRubrique->getRubriqueId());
                if (Date::compare($dateRubriqueFille, $dateRubrique) == 1) $dateRubrique = $dateRubriqueFille;
            // $dateRubrique = calculer_dates_rubriques($maRubrique->getRubriqueId(), $dateRubrique);
            }
        }

        /*
        echo 'date de $id_rubrique : '.$id_rubrique." \n";
        echo $dateRubrique->getDate()." \n\n";
        */

        return $dateRubrique;


    }


    // }}}


    // }}}
    // {{{ getStatutFromRubriqueChildren($id_rubrique)

	/** GCH - corrections omansour - elebescond
	** retourne les diffrents statuts des rubriques enfants de la rubrique
	**/

	function &getStatutFromRubriqueChildren($id_rubrique) {
		$rubriqueIds = array();
        $rubStatuts = array();
		$db = &$this->_getDB();

        // liste des rubriques filles
        $filles = $this->getChildren($this->_rubriqueId);
        if ((count($filles) == 0) or (!is_array($filles))) return $rubStatuts; // on sort si pas de rubriquess filles

        $rubriques = join ($filles, ', ');

		$query = 'SELECT statut FROM '.$GLOBALS['table_prefix']."_rubriques WHERE id_rubrique IN ($rubriques)";
		$queryResult = $db->query($query);
		if (DB::isError($queryResult)) {
			return PEAR::raiseError("[".get_class($this)." DB_rubrique : getStatutFromRubriqueChildren()] ".$queryResult->getMessage()."", null,
			null, null, null, null, false);
		}

		while ($row = $queryResult->fetchRow()) {
			$rubStatuts[] = $row['statut'];
            // $rubriqueIds[] = $row['id_rubrique'];
		}
        $rubStatuts = array_unique($rubStatuts); // TODO  faire en SQL non ?


		$queryResult->free();

		return $rubStatuts;
	}


    // {{{ getIfChangeStatutFromRubrique($id_rubrique)
	/** GCH
	** retourne le statut de la rubrique en fonction des statuts des articles
	**/
	function &getIfChangeStatutFromRubrique($rubriqueStatuts) {
		if(is_array($rubriqueStatuts))
		if(in_array("archi",$rubriqueStatuts) && !in_array("publie",$rubriqueStatuts))
		return "archi";
		elseif(in_array("archi",$rubriqueStatuts) && in_array("publie",$rubriqueStatuts))
		return "pub_archi";
		/******* Modification MAPPING guillaume.grason@diplomatie.gouv.fr *******/
		elseif(!in_array("archi",$rubriqueStatuts) && (in_array("publie",$rubriqueStatuts) || in_array("mappe",$rubriqueStatuts)))
		return "publie";
		elseif(!in_array("archi",$rubriqueStatuts) && !in_array("publie",$rubriqueStatuts) && !in_array("mappe",$rubriqueStatuts))
		return "prive";
		/*
		elseif(!in_array("archi",$rubriqueStatuts) && in_array("publie",$rubriqueStatuts))
		return "publie";
		elseif(!in_array("archi",$rubriqueStatuts) && !in_array("publie",$rubriqueStatuts))
		return "prive";
		*/
		/******* Fin Modification MAPPING guillaume.grason@diplomatie.gouv.fr *******/
		elseif(!in_array("archi",$rubriqueStatuts) && in_array("publie",$rubriqueStatuts))
		return "publie";
		elseif(!in_array("archi",$rubriqueStatuts) && !in_array("publie",$rubriqueStatuts))
		return "prive";
	}

	// }}}


    // {{{ updateAgoraCacheForParent($idUser)

    /** Creates the session cache of rubriqueIDs for the author in
    * the session object of the currently connected user.
    * If the update was not possible, this function fails silently.
    * @author maciek@clever-age.com
    * @param   String Id of the author
    * @param   If leparent is 0 the cache will be completely reinitialized
    * @access  public
    */
    function updateAgoraCacheForParent($idUser, $leparent = 0, $updateDate = true)
    {

        // TODO pas la peine si l'auteur n'est pas restreint .. mais on le fait quand mme :-(

        if ($updateDate)
                $generationDate = time();

        if ($leparent == 0)
        {
            $_SESSION['AgoraRubriquesCache'] = array();
        }

        $allRubriquesByParentId = $this->getAllForParentId($leparent, "titre");
        if(PEAR::isError($allRubriquesByParentId)) {
            //XXX Write the error to the logs.
            return $allRubriquesByParentId;
        }

        //$authorization = &recuperer_instance_authorization();
        while (list(,$rubriqueMetier) = each($allRubriquesByParentId)) {
            $my_rubrique = $rubriqueMetier->getRubriqueId();
            //there is no need to update the date here:
            $this->updateAgoraCacheForId($idUser, $my_rubrique);

            //XXX we could optimise this even further and call it only if
            //the parent has been authorized
            $this->updateAgoraCacheForParent($idUser, $my_rubrique, false);
        }

        if ($updateDate)
            $_SESSION['AgoraRubriquesCache']['LastCacheUpdate'] = $generationDate;
    }

    // }}}

    // {{{ updateAgoraCacheForId($idUser)

    /** Checks if the user has the right to the rubrique and
    * updates the cache accordingly.
    * @author maciek@clever-age.com
    * @param   String ID of the author
    * @param   int ID of the rubrique
    * @return  true if the user has the right, false otherwise
    * @access  public
    */
    function updateAgoraCacheForId($idUser, $idRubrique)
    {
        $ret = false;
        if ($this->isManagedByAuteurId($idRubrique, $idUser))
        {
            $ret = true;
            $_SESSION['AgoraRubriquesCache'][$idRubrique] = $idRubrique;
        }
        else
        {
            //attention! comportement modifie par rapport au code ANPE initial!
            $_SESSION['AgoraRubriquesCache'][$idRubrique] = 0;
        }
        return $ret;
    }

    // }}}

    // {{{ updateAgoraCacheForTimeout($idUser)

    /** Updates the currently used session cache of rubriqueIDs for rubriques
    * modified after the current cache date.
    * If the update was not possible, this function fails silently.
    *
    * @author maciek@clever-age.com
    * @param   String ID of the author
    * @access  private
    */

    function updateAgoraCacheForTimeout($idUser) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            //XXX Write the error to the logs.
            return;
        }

        $maDate = new Date($_SESSION['AgoraRubriquesCache']['LastCacheUpdate']);

        $_SESSION['AgoraRubriquesCache']['LastCacheUpdate'] = time();


        $query = 'SELECT id_rubrique FROM '.$GLOBALS['table_prefix'].'_rubriques '
                    .'WHERE date_heure > "'.$maDate->getDate(DATE_FORMAT_ISO).'" '
                    .'OR maj > "'.$maDate->getDate(DATE_FORMAT_ISO).'"';

        $result = $db->query($query);
        if (DB::isError($result)) {
            //XXX Write the error to the logs.
            return;
        }
        while ($row = $result->fetchRow())
        {
            $my_rubrique = $row['id_rubrique'];
            $this->updateAgoraCacheForId($idUser, $my_rubrique);
        }
        $result->free();
    }
    // }}}

    // {{{ getNbRubriqueTotal() {

    /** Return the number of rubriques in the database
     * @author	avialet@clever-age.com
     * @access	private
     */
     function getNbRubriqueTotal() {
     	$db = &$this->_getDB();

     	if (DB::isError($db)) {
			return PEAR::raiseError("[".get_class($this)." DB_rubrique : getNbRubriqueTotal()] ".$db->getMessage()."", null,
			null, null, null, null, false);
		}
		$query = 'SELECT COUNT(id_rubrique) AS nbRubriques FROM '.$GLOBALS['table_prefix']."_rubriques ";
		$queryResult = $db->query($query);
		if (DB::isError($queryResult)) {
			return PEAR::raiseError("[".get_class($this)." DB_rubrique : getNbRubriqueTotal()] ".$queryResult->getMessage()."", null,
			null, null, null, null, false);
		}

		while ($row = $queryResult->fetchRow()) {
			$nbRubriques = $row['nbRubriques'];
		}

		$queryResult->free();
		return $nbRubriques;
     }
    // }}}

    // {{{

    /** trouve (comme il peut) le secteur d'une rubrique
    * @author olivier
    * @access public
    * @return int secteur_id
    **/

    function findSectorId() {
        if ($this->_parentId == 0) return $this->_rubriqueId;
        // on trouve le secteur
        $hierarchie = $this->getHierarchie($this->getParentId());
        array_pop ($hierarchie); // je dpile pour virer le 0
        $secteur =  $hierarchie[count($hierarchie)-1];
        $secteur = trim ($secteur);
        if (($secteur == 0) or ($secteur == '') ) {
            return $this->_rubriqueId;
        } else {
            return $secteur;
        }
    }

    // }}}


    // {{{

    /** mets  jour tous les secteurs des objets pour la rubrique et descend dans les sous rubriques
    * @author olivier
    * @access public
    **/
    function updateObjectsForSector ($id_rubrique = 0) {
        $this->load($id_rubrique);

        $rubriques = array ();
        $rubriques[] = $this->_rubriqueId;
        $rubriques = array_merge ($rubriques, $this->getChildren($id_rubrique));
        $rubriques = join ($rubriques, ', '); // formatage de la liste de rubriques pour la mthode updateSecteursForRubriques

        // mise  jour des objets de la rubrique
        require_once dirname(__FILE__)."/inc_article_factory.php";
        $articleMetier = &recuperer_instance_article();
        $updateSecteursForRubriques = $articleMetier->updateSecteursForRubriques($this->_secteurId, $rubriques);
        if(PEAR::isError($updateSecteursForRubriques)) {
            die($updateSecteursForRubriques->getMessage());
        }
        require_once dirname(__FILE__)."/inc_breve_factory.php";
        $breveMetier = &recuperer_instance_breve();
        $updateSecteursForRubriques = $breveMetier->updateSecteursForRubriques($this->_secteurId, $rubriques);
        if(PEAR::isError($updateSecteursForRubriques)) {
            die($updateSecteursForRubriques->getMessage());
        }
        $rubriqueMetier = &recuperer_instance_rubrique();
        $updateSecteursForRubriques = $rubriqueMetier->updateSecteursForRubriques($this->_secteurId, $rubriques);
        if(PEAR::isError($updateSecteursForRubriques)) {
            die($updateSecteursForRubriques->getMessage());
        }
        require_once dirname(__FILE__)."/inc_syndic_factory.php";
        $syndicMetier = &recuperer_instance_syndic();
        $updateSecteursForRubriques = $syndicMetier->updateSecteursForRubriques($this->_secteurId, $rubriques);
        if(PEAR::isError($updateSecteursForRubriques)) {
            die($updateSecteursForRubriques->getMessage());
        }
    }

    // }}}


    // {{{ updateStatutOfHierarchie
    /** mets  jour le statut d'une rubrique et de sa hierarchie
    * @author olivier
    * @access public
    **/
/*
    function updateStatutOfHierarchie($id_rubrique) {
        //$this->load($id_rubrique);

        // on rcupere la hierarchie
        $rubriques = $this->getHierarchie($id_rubrique); // attention, il y a la racine dans le getHierarchie
        array_unshift ($rubriques, $id_rubrique);

        foreach ($rub as $rubriques) { // on va remonter la hierarchie
             $rubriqueMetier = &recuperer_instance_rubrique();
             $rubriqueMetier->load($id_rubrique);
             $statut = $rubriqueMetier->getStatutFromRubrique($id_rubrique);
             if ($statut != $rubriqueMetier->getStatut()) {
                 $rubriqueMetier->setStatut($statut);
                 $rubriqueMetier->update();
             }
             unset ($rubriqueMetier);
        }

    }

    // }}}
*/

    /** Renvoie les ids de toutes les breves lies  la rubriques
     * @return array
     */
    function &getBreveIds() {
        $db =& $this->_getDB();
        $q = "SELECT id_breve FROM ". $GLOBALS['table_prefix'] . "_breves WHERE id_rubrique='". $this->_rubriqueId ."';";
        $res = $db->query( $q );
        if ( DB::isError($res) ) {
			return PEAR::raiseError( "[".get_class($this)." DB_rubrique : ".__FUNCTION__."()] ".$res->getMessage()."",
                                     null, null, null, null, null, false );
		} else {
            $ret = array();
            while( $row = $res->fetchRow() ) { $ret[] = $row['id_breve']; }
            return $ret;
        }
    }

    /** Renvoie les ids de toutes les breves lies  la rubriques
     * @return array
     */
    function &getSyndicIds() {
        $db =& $this->_getDB();
        $q = "SELECT id_syndic FROM ". $GLOBALS['table_prefix'] . "_syndic WHERE id_rubrique='". $this->_rubriqueId ."';";
        $res = $db->query( $q );
        if ( DB::isError($res) ) {
			return PEAR::raiseError( "[".get_class($this)." DB_rubrique : ".__FUNCTION__."()] ".$res->getMessage()."",
                                     null, null, null, null, null, false );
		} else {
            $ret = array();
            while( $row = $res->fetchRow() ) { $ret[] = $row['id_syndic']; }
            return $ret;
        }
    }

    /** Renvoie les ids de toutes les breves lies  la rubriques
     * @return array
     */
    function &getArticleIds() {
        $db =& $this->_getDB();
        $q = "SELECT id_article FROM ". $GLOBALS['table_prefix'] . "_articles WHERE id_rubrique='". $this->_rubriqueId ."';";
        $res = $db->query( $q );
        if ( DB::isError($res) ) {
			return PEAR::raiseError( "[".get_class($this)." DB_rubrique : ".__FUNCTION__."()] ".$res->getMessage()."",
                                     null, null, null, null, null, false );
		} else {
            $ret = array();
            while( $row = $res->fetchRow() ) { $ret[] = $row['id_article']; }
            return $ret;
        }
    }

    /** Redfinis la langue des lments contenus, si cela est ncessaire
     */
    function propagateLang() {

        // Mise  jour des articles
        if ( $art_ids = $this->getArticleIds() ) {
            foreach ( $art_ids as $art_id ) {
                $art =& recuperer_instance_article();
                $art->load( $art_id );
                $art->setLang( $this->getLang() );
                $art->update();
            }
            unset( $art_ids );
        }


        // Mise  jour des brves
        if ( $brv_ids = $this->getBreveIds() ) {
            foreach ( $brv_ids as $brv_id ) {
                $brv =& recuperer_instance_breve();
                $brv->load( $brv_id );
                $brv->setLang( $this->getLang() );
                $brv->update();
            }
            unset( $brv_ids );
        }

        // Mise  jour des rubriques filles (tout ceci est donc rcursif)
        if( $rub_ids = $this->getChildren( $this->getRubriqueId() ) ) {
            foreach ( $rub_ids as $rub_id ) {
                $rub =& recuperer_instance_rubrique();
                $rub->load( $rub_id );
                $rub->setLang( $this->getLang() );
                $rub->update();
            }
            unset( $rub_ids );
        }

    }

    // {{{ checkForPostDated

    /** Gestion du cas particuliers des articles post-dats
     * @return        bool           True si le statut de la rubrique  chang
     */
    function checkForPostDated() {
        //        if ( count($this->getBreveIds()) || count($this->getSyndicIds()) ) { return; }
        require_once dirname(__FILE__) . '/inc_article_factory.php';
        $statut = $this->getStatut();
        foreach ( $this->getArticleIds() as $art_id ) {
            $art =& recuperer_instance_article();
            $art->load( $art_id );

            if ( ! $art->isPostDated() && $art->getStatut() == 'publie' ) {
                $statut = 'publie';
            }
        }

        if ( $this->getStatut() != $statut ) {
            $this->setStatut($statut);
            return true;
        }
    }
    
    // }}}
    
    // {{{ checkForExpired
    
    /** Gestion du cas particuliers des articles ayant expirs - mets  jours les articles
     * @return        bool           True si le statut de la rubrique  chang
     */
    function checkForExpired() {
        require_once dirname(__FILE__) . '/inc_article_factory.php';
        $statut = $this->getStatut();
        $update = false;
        foreach ( $this->getArticleIds() as $art_id ) {
            $art =& recuperer_instance_article();
            $art->load( $art_id );
            if ( $art->isExpired() && $art->getStatut() == 'publie' ) {
                // j'ai besoin des metas
                include_once (dirname(__FILE__).'/../utils/meta.php');
                $art->setStatut(lire_meta ('statut_article_expire')); 
                $art->update();
                $update = true;
            }
        }

		// il faut recalculer la rubrique
		if ($update) {
            $this->checkStatutDateAndUpdate($this->getRubriqueId());
            return true;
		} else {
            return false; 
        }
		
    }
    
    // }}}
    
    
    
    // {{{ updateRelatedObjects
    
    /** mise a jours des related objects particuliers a la rubrique
    * @author olivier
    */
    function updateRelatedObjects() {
        // recalcul des secteurs si ncessaire
        if  ((count($this->_secteursHisto)) > 0)  {
            $this->updateObjectsForSector($this->_rubriqueId);
        }
        
        $rubriqueMetier = &recuperer_instance_rubrique();
        if ($this->getParentId() > 0) {
            $rubriqueMetier->load($this->getParentId()); // charge la rubrique parente
            $rubriqueMetier->checkStatutDateAndUpdate($rubriqueMetier->getRubriqueId());
        }

        // si la rubrique a t dplace on update les(le) vieux parents 
        if (count($this->_parentsHisto)) {
            foreach ($this->_parentsHisto as $rubId) {
                $update =  false;
                $rubriqueMetier->load($rubId);
                if (PEAR::isError($rubriqueMetier)) {
                    die ($rubriqueMetier->getMessage());
                }
                $rubriqueMetier->checkStatutDateAndUpdate($rubriqueMetier->getRubriqueId());
            }
        }
    }
    
    // }}}
    
    
    // {{{
    
    /** vrifie le statut et la date de la rubrique et les change si besoins   
    * @author olivier
    * @access private ?
    * @return mixed bool si la rubrique a t update ou Pear Error
    **/
    
    function checkStatutDateAndUpdate ($id_rubrique = 0) {
        $this->load($id_rubrique);
        $update = false;    
        
        // check & maj
        
        // statut
        $statut = $this->getStatutFromRubrique($this->getRubriqueId());
        if ($statut != $this->getStatut()) {
            $this->setStatut($statut);
            $update = true;
        }
    
        // date 
        $dateCalcul = $this->getDateFromRubrique($this->getRubriqueId());
        $dateRubrique = new Date ($this->getDate());
        if (Date::compare($dateCalcul, $dateRubrique) != 0) {
            $this->setDate($dateCalcul->getDate());
            $update = true;
        }
    
        
        if ($update) {
            $load_return = $this->update();
        }
        
        if (PEAR::isError($load_return)) {
            return $load_return; 
        } else {
            return $update;
        }
                
    }
    
    // }}}
    
    
    // {{{

    function getUrl( $edit = false ) {
        if ($edit) {
            include_once (dirname(__FILE__).'/../utils/meta.php');
            return lire_meta('adresse_site').'/ecrire/naviguer.php3?id_rubrique=' . $this->getRubriqueId();
        } else {
            die ('je ne sais pas encore faire');
        }
    }
    
    // }}}
    
    
}
?>
