<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Erwan LE BESCOND <elebescond@clever-age.com>                |
// +----------------------------------------------------------------------+
//
// Base class for Rubrique List Data abstraction.
//

/**
 * BD_rubriqueListData is a base class for rubrique lists data database abstraction implementations, and must be
 * inherited by all such.
 */
if (defined("_BD_RUBRIQUELISTDATA")) return;
    define("_BD_RUBRIQUELISTDATA", "1");

require_once "PEAR.php";
require_once "DB.php";
require_once dirname(__FILE__)."/objectlistdata.php";
require_once (dirname(__FILE__)."/inc_rubrique_factory.php");
require_once dirname(__FILE__)."/inc_listdata_querytypes_constants.php";

/**
 * This class implements data lists for Rubique business data type
 * @package	BD
 * @author  Antoine Angnieux <aangenieux@clever-age.com>
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @access	public
 */
class BD_rubriqueListData extends BD_objectListData {

    /**
     * Create a new rubrique list data object for the specified database parameters
     * passed
     *
     * @param BD_parameters $dbParameters database configuration object
     *
     * @return mixed a newly created RubriqueListData object, or a PEAR error code on
     * error
     *
     * access public
     */

    function &factory($dbParameters = null) {
        if(file_exists(dirname(__FILE__)."/".$dbParameters->_dbEngine."/rubriquelistdata_".$dbParameters->_dbEngine.".php") == false) {
            include_once(dirname(__FILE__)."/common/rubriquelistdata_common.php");
            $classname = "BD_rubriquelistdata_common";
        }
        else {
            include_once(dirname(__FILE__)."/".$dbParameters->_dbEngine."/rubriquelistdata_".$dbParameters->_dbEngine.".php");
            $classname = "BD_rubriqueListData_".$dbParameters->_dbEngine;
        }

        if (!class_exists($classname)) {
            return PEAR::raiseError("Cannot instanciate class $classname", null,
                                    null, null, null, null, false);
        }

        $obj =& new $classname;
        $result = $obj->setDbParameters($dbParameters);
        if (PEAR::isError($result)) {
            return $result;
        } else {
            return $obj;
        }
    }

    // {{{ constructor

    /**
     * Constructor.
     *
     * @access public
     */

    function BD_rubriqueListData() {
        $par = get_parent_class(get_parent_class($this));
        $this->$par();
    }

    // }}}


    // {{{ getHTMLList($titre_table, $requete, $affrub=false)

    /**
     * returns the HTML List for the various rubrique data lists implementations
     * This method should <b>NEVER<b> be overloaded, otherwise EXTRA-EXTRA-CARE is required
     * while overloading this method.
     *
     * @return String reprensenting the generated HTML list navigation
     * @param $queryType int representing the desired query type (refer to inc_listdata_query_types_contants.php)
     * @param $params array containing the query parameters
     * @param $countQuery boolean : if set to true, the returned query is a count result query for the specified query type.
     * @access public
     */

    function displayHTMLList($titre_table, $queryType, $params = array(), $firstElement=0, $lastElement=0) {
        global $connect_id_auteur;
	    global $spip_lang_rtl;

        $copyParams = $params;

        $tranches = $this->_getHTMLNavigation($queryType, $params, 2);

        $requete = $this->_getQuery($queryType, false, $copyParams);

        if (strlen($tranches)) {

		    debut_cadre_relief("rubrique-24.gif");

		    if ($titre_table) {
    			echo "<p><table width=100% cellpadding=0 cellspacing=0 border=0 background=''>";
			    echo "<tr><td width=100% background=''>";
			    echo "<table width=100% cellpadding=3 cellspacing=0 border=0>";
			    echo "<tr bgcolor='#333333'><td width=100% colspan=2><font face='Verdana,Arial,Helvetica,sans-serif' size=3 color='#FFFFFF'>";
			    echo "<b>$titre_table</b></font></td></tr>";
		    }
		    else {
    			echo "<p><table width=100% cellpadding=3 cellspacing=0 border=0 background=''>";
		    }

		    echo $tranches;

            $db = &$this->_getDB();
            if (DB::isError($db)) {
                die("Impossible d'obternir une connexion  la base de donnes! ".$db->getMessage());
            }

		    if ($this->_getQueryIsLimited()) {
                $limitStart = $this->_getLimitStart();
                $limitCount = $this->_getLimitCount();
                $result = $db->limitQuery($requete, $limitStart, $limitCount, $copyParams);
            } else {
                if($lastElement > 0) {
                    $result = $db->limitQuery($requete, $firstElement, $lastElement, $copyParams);
                }
                else {
                    $result = $db->query($requete, $copyParams);
                }
            }

            if (DB::isError($result)) {
                die("la requete a choue! ".$result->getMessage());
            }

		    $table = '';
            while ($row = $result->fetchRow()) {
			    $vals = '';

                if($queryType == RUBRIQUES_FORUM_MESSAGE) {
                    $id_rubrique = $row['id_rubrique'];
    			    $forumMetier = &recuperer_instance_forum();
					$nbMessageTotal = $forumMetier->howManyForumForRubriqueId($id_rubrique) . ' message(s)';

    			    $tous_id[] = $id_rubrique;
    			    $titre = $row['titre'];

                    $authorization = &recuperer_instance_authorization('controlerForum', $GLOBALS['connect_id_auteur'], array('id_rubrique' => $id_rubrique));
                    if($authorization->isAuthorizedAction()) {
                        $s = "<b><a href=\"naviguer.php3?coll=$id_rubrique\">";
    			        $puce = "puce$spip_lang_rtl.gif";
    			        $s .= "<img src=\"$puce\" alt=\"- \" border=\"0\"> ";
    			        $s .= typo($titre);
                        $forumMetier = &recuperer_instance_forum();
                        $nbMessProp = $forumMetier->howManyForumForRubriqueIdAndStatuts($id_rubrique, "'prop'");

    			        $s .= "<td align='right' colspan=1><img src=\"img_pack/puce-orange.gif\" alt='"._T('message_attente_validation')."' width=\"13\" height=\"14\" border=\"0\">&nbsp;<a href='controle_forum_suite.php3?affType=discussion&affMessage[]=publie,prop&vierge=1&id_current_forum=$id_rubrique&type_forum=rubrique'>$nbMessProp message(s) en attente</a></td>";
    			        $s .= "<tr><td align=center colspan=3>";

                        $nbMessPublie = $forumMetier->howManyForumForRubriqueIdAndStatuts($id_rubrique, "'publie'");
                        $s .= "<img src=\"img_pack/puce-verte.gif\" alt='"._T('message_publie')."' width=\"13\" height=\"14\" border=\"0\">&nbsp;<a href='controle_forum_suite.php3?affType=discussion&affMessage[]=publie&vierge=1&id_current_forum=$id_rubrique&type_forum=rubrique'>$nbMessPublie mess</a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
                        $nbMessOff = $forumMetier->howManyForumForRubriqueIdAndStatuts($id_rubrique, "'off'");
                        $s .= "<img src=\"img_pack/puce-rouge.gif\" alt='"._T('message_off')."' width=\"13\" height=\"14\" border=\"0\">&nbsp;<a href='controle_forum_suite.php3?affType=discussion&affMessage[]=publie,off&vierge=1&id_current_forum=$id_rubrique&type_forum=rubrique'>$nbMessOff mess</a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
                        $nbMessPoubelle = $forumMetier->howManyForumForRubriqueIdAndStatuts($id_rubrique, "'poubelle'");
                        $s .= "<img src=\"img_pack/puce-poubelle.gif\" alt='"._T('message_poubelle')."' width=\"13\" height=\"14\" border=\"0\">&nbsp;<a href='controle_forum_suite.php3?affType=discussion&affMessage[]=publie,poubelle&vierge=1&id_current_forum=$id_rubrique&type_forum=rubrique'>$nbMessPoubelle mess</a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";

                        $s .= "</td></tr>";
    			        $vals[] = $s;

    			        $s = "<div align=\"right\">";
    			        $s .= "</div>";
    			        $vals[] = $s;
    			        $table[] = $vals;
                    }
                }
                else {
    			    $id_rubrique = $row['id_rubrique'];
    			    $tous_id[] = $id_rubrique;
    			    $titre = $row['titre'];

    			    $s = "<b><a href=\"naviguer.php3?coll=$id_rubrique\">";
    			    $puce = "puce$spip_lang_rtl.gif";
    			    $s .= "<img src=\"$puce\" alt=\"- \" border=\"0\"> ";
    			    $s .= typo($titre);
    			    $s .= "</A></b>";
    			    $vals[] = $s;

    			    $s = "<div align=\"right\">";
    			    $s .= "</div>";
    			    $vals[] = $s;
    			    $table[] = $vals;
    			}
		    }
		    $result->free();

		    $largeurs = array('', '');
		    $styles = array('arial2', 'arial2');
		    afficher_liste($largeurs, $table, $styles);

		    if ($titre_table) echo "</TABLE></TD></TR>";
		    echo "</TABLE>";
		    fin_cadre_relief();
	    }
	    return $tous_id;
    }

    // }}}

    // {{{ _fillQueries()

    /**
     * This methods fill the query associative arrays with SQL 92 compliant
     * queries. Each driver that requires specific SQL querying must implement
     * the _adaptQueriesToDriver() method.
     * @access  private
     * @see     _adaptQueriesToDriver()
     */
    function _fillQueries() {
        $this->_queries[RUBRIQUES_BY_LINK] = "SELECT rubrique.* FROM ".$GLOBALS['table_prefix']."_rubriques rubrique, ".$GLOBALS['table_prefix']."_mots_rubriques lien WHERE lien.id_mot=? "
                                        . "AND lien.id_rubrique=rubrique.id_rubrique ORDER BY rubrique.titre";
        $this->_queriesCount[RUBRIQUES_BY_LINK] = "SELECT COUNT(*) FROM ".$GLOBALS['table_prefix']."_rubriques rubrique, ".$GLOBALS['table_prefix']."_mots_rubriques lien WHERE lien.id_mot=? "
                                        . "AND lien.id_rubrique=rubrique.id_rubrique";

        $this->_queries[RUBRIQUES_RECHERCHE] = "SELECT * ".
                                                "FROM ".$GLOBALS['table_prefix']."_rubriques WHERE <!spipRUBRIQUE_CONSTRUCTION_RECHERCHEspip!> ORDER BY maj DESC";
        $this->_queriesCount[RUBRIQUES_RECHERCHE] = "SELECT count(id_rubrique) ".
                                                    "FROM ".$GLOBALS['table_prefix']."_rubriques WHERE  <!spipRUBRIQUE_CONSTRUCTION_RECHERCHEspip!>";

        $this->_queries[RUBRIQUES_RECHERCHE_INT] = "SELECT objet.id_rubrique, objet.titre, objet.date_heure, objet.statut, SUM(idx.points) AS points ".
                                                    "FROM ".$GLOBALS['table_prefix']."_rubriques objet, ".$GLOBALS['table_prefix']."_index_rubriques idx ".
                                                    "WHERE objet.id_rubrique = idx.id_rubrique AND idx.hash IN (!) AND objet.id_rubrique NOT IN (!) GROUP BY objet.id_rubrique, objet.titre, objet.date_heure, objet.statut ORDER BY points DESC";
        $this->_queriesCount[RUBRIQUES_RECHERCHE_INT] = "SELECT COUNT(*) ".
                                                    "FROM ".$GLOBALS['table_prefix']."_rubriques objet, ".$GLOBALS['table_prefix']."_index_rubriques idx ".
                                                    "WHERE objet.id_rubrique = idx.id_rubrique AND idx.hash IN (!) AND objet.id_rubrique NOT IN (!)";

        $this->_queries[RUBRIQUES_FORUM_MESSAGE] = "SELECT ".$GLOBALS['table_prefix']."_rubriques.* FROM ".$GLOBALS['table_prefix']."_rubriques, ".$GLOBALS['table_prefix']."_forum WHERE ".$GLOBALS['table_prefix']."_forum.id_rubrique=".$GLOBALS['table_prefix']."_rubriques.id_rubrique ORDER BY ".$GLOBALS['table_prefix']."_forum.date_heure DESC";
        // A VERIFIER, BIZARRERIE!
        //$this->_queries[RUBRIQUES_FORUM_MESSAGE] = "SELECT DISTINCT(".$GLOBALS['table_prefix']."_rubriques.id_rubrique), ".$GLOBALS['table_prefix']."_rubriques.titre, ".$GLOBALS['table_prefix']."_rubriques.date_heure, ".$GLOBALS['table_prefix']."_rubriques.statut FROM ".$GLOBALS['table_prefix']."_rubriques, ".$GLOBALS['table_prefix']."_forum WHERE ( (".$GLOBALS['table_prefix']."_rubriques.id_rubrique = ".$GLOBALS['table_prefix']."_forum.id_rubrique) ) ORDER BY ".$GLOBALS['table_prefix']."_rubriques.date_heure";
        $this->_queriesCount[RUBRIQUES_FORUM_MESSAGE] = "SELECT count(id_forum) FROM ".$GLOBALS['table_prefix']."_rubriques, ".$GLOBALS['table_prefix']."_forum WHERE ".$GLOBALS['table_prefix']."_forum.id_rubrique=".$GLOBALS['table_prefix']."_rubriques.id_rubrique GROUP BY ".$GLOBALS['table_prefix']."_forum.id_rubrique";

        /*
        $this->_queries[RUBRIQUES_FORUM_MESSAGE_PROP] = "SELECT count(id_forum) AS count, ".$GLOBALS['table_prefix']."_rubriques.* FROM ".$GLOBALS['table_prefix']."_rubriques, ".$GLOBALS['table_prefix']."_forum WHERE ".$GLOBALS['table_prefix']."_forum.id_rubrique=".$GLOBALS['table_prefix']."_rubriques.id_rubrique AND ".$GLOBALS['table_prefix']."_forum.statut IN ('prop') GROUP BY ".$GLOBALS['table_prefix']."_forum.id_rubrique ORDER BY ".$GLOBALS['table_prefix']."_forum.date_heure DESC";
        $this->_queriesCount[RUBRIQUES_FORUM_MESSAGE_PROP] = "SELECT count(id_forum) AS count FROM ".$GLOBALS['table_prefix']."_rubriques, ".$GLOBALS['table_prefix']."_forum WHERE ".$GLOBALS['table_prefix']."_forum.id_rubrique=".$GLOBALS['table_prefix']."_rubriques.id_rubrique AND ".$GLOBALS['table_prefix']."_forum.statut IN ('prop') GROUP BY ".$GLOBALS['table_prefix']."_forum.id_rubrique";
        */
    }

    // }}}
}
?>