<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Erwan LE BESCOND <elebescond@clever-age.com>                 |
// +----------------------------------------------------------------------+
//
// Base class for Service.
//

if (defined("_SERVICE")) return;
    define("_SERVICE", "1");

require_once "PEAR.php";
require_once "DB.php";

require_once dirname(__FILE__)."/metier.php";



/**
 * service is a base class for service persistence abstraction implementations, and must be
 * inherited by all such.
 * @package	BD
 * @author  Antoine Angnieux <aangenieux@clever-age.com>
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @access	public
 *
 */
class Service extends BD_metier {

    // {{{ factory()
    function &factory($dbParameters = null, $dbOptions = null) {

        if(file_exists(dirname(__FILE__)."/".$dbParameters->_dbEngine."/service_".$dbParameters->_dbEngine.".php") == false) {
            include_once(dirname(__FILE__)."/common/service_common.php");
            $classname = "service_common";
        }
        else {
            include_once(dirname(__FILE__)."/".$dbParameters->_dbEngine."/service_".$dbParameters->_dbEngine.".php");
            $classname = "service_".$dbParameters->_dbEngine;
        }

        if (!class_exists($classname)) {
            return PEAR::raiseError("Cannot instanciate class $classname", null,
                                    null, null, null, null, false);
        }

        $obj =& new $classname;
        $result = $obj->setDbParameters($dbParameters);
        if ($dbOptions != null) {
            $obj->setDbOptions($dbOptions);
        }
        if (PEAR::isError($result)) {
            return $result;
        } else {
            return $obj;
        }
    }

    // }}}

    // {{{ constructor

    /**
     * service constructor.
     *
     * @access public
     */

    function service() {
    }

    // }}}

    // {{{ getLock($nom, $timeout = 0)

    /**
     * unlock AGORA.
     *
     *
     * @return  mixed   boolean or PEAR::Error object
     * @param $nom
     * @param $timeout
     * @access public
     */

    function getLock($nom, $timeout = 0) {
        return PEAR::raiseError("[".get_class($this)." service : getLock()] PAS D'IMPLEMENTAION DE CETTE METHODE", null,
                null, null, null, null, false);
    }

    // }}}

    // {{{ releaseLock($nom)

    /**
     * unlock AGORA.
     *
     *
     * @return  mixed   void or PEAR::Error object
     * @param $nom
     * @access public
     */

    function releaseLock($nom) {
        return PEAR::raiseError("[".get_class($this)." service : releaseLock()] PAS D'IMPLEMENTAION DE CETTE METHODE", null,
                null, null, null, null, false);
    }

    // }}}

}
?>