<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Erwan LE BESCOND <elebescond@clever-age.com>                |
// +----------------------------------------------------------------------+
//
// Base class for Setting business persistence abstraction.
//
if (defined("_BD_SETTING")) return;
    define("_BD_SETTING", "1");

require_once "PEAR.php";
require_once "DB.php";
require_once dirname(__FILE__)."/metier.php";
require_once dirname(__FILE__)."/../../inc_filtres.php3";
require_once dirname(__FILE__)."/../../inc_meta.php3";

define("SETTING_ALL_FIELDS", ' set_name, set_value ');

/**
 * BD_setting is a base class for settings of newsletter business persistence abstraction implementations, and must be
 * inherited by all such.
 * @package	BD
 * @author  Antoine Angnieux <aangenieux@clever-age.com>
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @access	public
 */
class BD_setting extends BD_metier {

    // {{{ properties

	var $_name;
	var $_value;


    // }}}

    // {{{ factory()
    function &factory($dbParameters = null, $dbOptions = null) {
        if(file_exists(dirname(__FILE__)."/".$dbParameters->_dbEngine."/setting_".$dbParameters->_dbEngine.".php") == false) {
            include_once(dirname(__FILE__)."/common/setting_common.php");
            $classname = "BD_setting_common";
        }
        else {
            include_once(dirname(__FILE__)."/".$dbParameters->_dbEngine."/subscriber_".$dbParameters->_dbEngine.".php");
            $classname = "BD_setting_".$dbParameters->_dbEngine;
        }

        if (!class_exists($classname)) {
            return PEAR::raiseError("Cannot instanciate class $classname", null,
                                    null, null, null, null, false);
        }

        $obj =& new $classname;

        $result = $obj->setDbParameters($dbParameters);
        if ($dbOptions != null) {
            $obj->setDbOptions($dbOptions);
        }
        if (PEAR::isError($result)) {
            return $result;
        } else {
            return $obj;
        }
    }

    // }}}

    // {{{ constructor

    /**
     * DB_setting constructor.
     *
     * @access public
     */

    function BD_setting() {
    }

    // }}}

    // {{{ getName()

    function getName() {
        return $this->_name;
    }

    // }}}

    // {{{ setName()

    function setName($name) {
        $this->_name = $name;
    }

    // }}}

    // {{{ getValue()

    function getValue() {
        return stripslashes($this->_value);
    }

    // }}}

    // {{{ setValue()

    function setValue($value) {
         $this->_value = addslashes(corriger_caracteres($value));
    }

    // }}}

    // {{{ create()

    function create() {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_setting : create()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $string_prefix = $GLOBALS['table_prefix']."_cm_settings";
        $settingId = $db->nextId($string_prefix, true);

        $this->_id = $settingId;

        $query = 'INSERT INTO '.$GLOBALS['table_prefix'].'_cm_settings ('.SETTING_ALL_FIELDS.') VALUES '
                ."('".$this->_name."', "
                ."'".$this->_value."') ";

         

        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_setting : create()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ update()

    function update() {
        $db = &$this->_getDB();
		if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_setting : update()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        $query = "UPDATE ".$GLOBALS['table_prefix']."_cm_settings SET "
				."sub_name = '".$this->_name."'"
				.", sub_value = '".$this->_value."'"
            	." WHERE sub_id = ".$this->_id;

         

		//echo '<br>' . $query . '<br>';

        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_setting : update()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

    }

    // }}}

    // {{{ load()

    function load($name) {
        $db = &$this->_getDB();
		if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_setting : load()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT".SETTING_ALL_FIELDS."FROM ".$GLOBALS['table_prefix']."_cm_settings WHERE set_name = '$name'";
		//echo '<br>' . $query .  '<br>';
         
        $result = $db->query($query);

        if (DB::isError($result)) {
            return $result;
        } else {
            if ($row = $result->fetchRow()) {
                $this->_fetchData($row);
            } else {
                return PEAR::raiseError("[".get_class($this)." DB_setting : load($name)] Aucun parametre avec ce nom!", null,
                                    null, null, null, null, false);
            }
            $result->free();
        }
    }

    // }}}

    // {{{ delete()

    function delete($name) {
        $db = &$this->_getDB();

		if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_setting : delete()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_cm_settings WHERE set_name = '$name'";

         
        $result = $db->query($query);
        if (DB::isError($result)) {
                return PEAR::raiseError("[".get_class($this)." DB_setting : delete($name)] Aucun parametre avec ce nom!", null,
                                    null, null, null, null, false);
        }

    }

    // }}}

    // {{{ getAllSetting()

    function &getAllSetting() {
        $settings = array();
        $db = &$this->_getDB();


        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_setting : getAllSetting()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

		$query = "SELECT " . SETTING_ALL_FIELDS . " FROM ".$GLOBALS['table_prefix']."_cm_settings";
         
		$result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_setting : getAllSetting()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $result->fetchRow()) {
            $resultSetting = &BD_setting::factory($this->getDbParameters(), $this->getDbOptions());
            $resultSetting->_fetchData($row);
            $settings[] = &$resultSetting;
        }
        $result->free();
        return $settings;
    }

    // }}}

    // {{{ _fetchData()

    function _fetchData($row) {
        $this->setName($row['set_name']);
        $this->setValue($row['set_value']);
    }

    // }}}

}
?>