<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Erwan LE BESCOND <elebescond@clever-age.com>                 |
// +----------------------------------------------------------------------+
//
// Base class for Signature business persistence abstraction.
//

if (defined("_BD_SIGNATURE")) return;
    define("_BD_SIGNATURE", "1");

require_once "PEAR.php";
require_once "DB.php";
require_once dirname(__FILE__)."/metier.php";

define("SIGNATURE_ALL_FIELDS", " id_signature, id_article, date_time, nom_email, ad_email, nom_site, url_site, message, statut, maj ");

/**
 * BD_signature is a base class for mot business persistence abstraction implementations, and must be
 * inherited by all such.
 * @package	BD
 * @author  Antoine Angnieux <aangenieux@clever-age.com>
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @access	public
 */
class BD_signature extends BD_metier {

    // {{{ properties

    /**
     * Signature ID.
     * @var     int
     * @access  private
     */
    var $_signatureId;

    /**
     * Article ID.
     * @var     int
     * @access  private
     */
    var $_articleId;

    /**
     * Date Time.
     * @var     Date
     * @access  private
     */
    var $_dateTime;

    /**
     * email name.
     * @var     String
     * @access  private
     */
    var $_nomEmail;

    /**
     * email ad.
     * @var     String
     * @access  private
     */
    var $_adEmail;

    /**
     * Site name.
     * @var     String
     * @access  private
     */
    var $_nomSite;

    /**
     * Site url.
     * @var     String
     * @access  private
     */
    var $_urlSite;

    /**
     * Site message.
     * @var     String
     * @access  private
     */
    var $_message;

    /**
     * Statut.
     * @var     String
     * @access  private
     */
    var $_statut;

    /**
     * Update Date.
     * @var     Date
     * @access  private
     */
    var $_majDate;


    // }}}

    // {{{ factory()

    /**
     * This method is a factory static method. It should be used to get any
     * specific implementation instace of Signature business data type.
     * @param   BD_parameters DB connection parameters
     * @access public
     */
    function &factory($dbParameters, $dbOptions = null) {

        if(file_exists(dirname(__FILE__)."/".$dbParameters->_dbEngine."/signature_".$dbParameters->_dbEngine.".php") == false) {
            include_once(dirname(__FILE__)."/common/signature_common.php");
            $classname = "BD_signature_common";
        }
        else {
            include_once(dirname(__FILE__)."/".$dbParameters->_dbEngine."/signature_".$dbParameters->_dbEngine.".php");
            $classname = "BD_signature_".$dbParameters->_dbEngine;
        }

        if (!class_exists($classname)) {
            return PEAR::raiseError("Cannot instanciate class $classname", null,
                                    null, null, null, null, false);
        }

        $obj =& new $classname;
        $result = $obj->setDbParameters($dbParameters);
        if ($dbOptions != null) {
            $obj->setDbOptions($dbOptions);
        }
        if (PEAR::isError($result)) {
            return $result;
        } else {
            return $obj;
        }
    }

    // }}}

    // {{{ constructor

    /**
     * DB_signature constructor.
     *
     * @access public
     */

    function BD_signature() {
    }

    // }}}

    // {{{ getSignatureId()

    /**
     * Returns the Signature ID
     * @return  int
     * @access  public
     */

    function getSignatureId() {
        return $this->_signatureId;
    }

    // }}}

    // {{{ setSignatureId()

    /**
     * Sets the Signature ID
     * @param   int
     * @access  public
     */

    function setSignatureId($signatureId) {
        $this->_signatureId = $signatureId;
    }

    // }}}

    // {{{ getArticleId()

    /**
     * Returns the article ID
     * @return  int
     * @access  public
     */

    function getArticleId() {
        return $this->_articleId;
    }

    // }}}

    // {{{ setArticle()

    /**
     * Sets the Article ID
     * @param   int
     * @access  public
     */

    function setArticleId($articleId) {
        $this->_articleId = $articleId;
    }

    // }}}

    // {{{ getDateTime()

    /**
     * Returns the DateTime
     * @return  Date
     * @access  public
     */

    function getDateTime() {
        return $this->_dateTime;
    }

    // }}}

    // {{{ setDateTime()

    /**
     * Sets the DateTime
     * @param   Date
     * @access  public
     */

    function setDateTime($dateTime) {
        $this->_dateTime = $dateTime;
    }

    // }}}

    // {{{ getEmailName()

    /**
     * Returns the Email name
     * @return  String
     * @access  public
     */

    function getNomEmail() {
        return $this->_nomEmail;
    }

    // }}}

    // {{{ setNomEmail()

    /**
     * Sets the Email name
     * @param   String
     * @access  public
     */

    function setNomEmail($nomEmail) {
        $this->_nomEmail = corriger_caracteres($nomEmail);
    }

    // }}}

    // {{{ getAdEmail()

    /**
     * Returns the adEmail
     * @return  String
     * @access  public
     */

    function getAdEmail() {
        return $this->_adEmail;
    }

    // }}}

    // {{{ setAdEmail()

    /**
     * Sets the adEmail
     * @param   String
     * @access  public
     */

    function setAdEmail($adEmail) {
        $this->_adEmail = corriger_caracteres($adEmail);
    }

    // }}}

    // {{{ getNomSite()

    /**
     * Returns the Site name
     * @return  String
     * @access  public
     */

    function getNomSite() {
        return $this->_nomSite;
    }

    // }}}

    // {{{ setNomSite()

    /**
     * Sets the Site name
     * @param   String
     * @access  public
     */

    function setNomSite($nomSite) {
        $this->_nomSite = corriger_caracteres($nomSite);
    }

    // }}}

    // {{{ getUrlSite()

    /**
     * Returns the URL
     * @return  String
     * @access  public
     */

    function getUrlSite() {
        return $this->_urlSite;
    }

    // }}}

    // {{{ setUrlSite()

    /**
     * Sets the URL
     * @param   String
     * @access  public
     */

    function setUrlSite($urlSite) {
        $this->_urlSite = corriger_caracteres($urlSite);
    }

    // }}}

    // {{{ getMessage()

    /**
     * Returns the message
     * @return  String
     * @access  public
     */

    function getMessage() {
        return $this->_message;
    }

    // }}}

    // {{{ setMessage()

    /**
     * Sets the message
     * @param   String
     * @access  public
     */

    function setMessage($message) {
        $this->_message = corriger_caracteres($message);
    }

    // }}}

    // {{{ getStatut()

    /**
     * Returns the statut
     * @return  String
     * @access  public
     */

    function getStatut() {
        return $this->_statut;
    }

    // }}}

    // {{{ setStatut()

    /**
     * Sets the statut
     * @param   String
     * @access  public
     */

    function setStatut($statut) {
        $this->_statut = corriger_caracteres($statut);
    }

    // }}}

    // {{{ getMajDate()

    /**
     * Returns the word update date
     * @return  Date
     * @access  public
     */

    function getMajDate() {
        return $this->_majDate;
    }

    // }}}

    // {{{ setMajDate()

    /**
     * Sets the word update date
     * @param   Date
     * @access  public
     */

    function setMajDate($majDate) {
        $this->_majDate = $majDate;
    }

    // }}}

    // }}}

    // {{{ create()

    function create() {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_signature : create()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $string_prefix = $GLOBALS['table_prefix']."_signatures";
        $signatureId = $db->nextId($string_prefix, true);

        if (DB::isError($signatureId)) {
            return PEAR::raiseError("[".get_class($this)." DB_signature : create()] ".$signatureId->getMessage()."", null,
                null, null, null, null, false);
        }

        $this->_signatureId = $signatureId;

        //if ($this->_dateTime == "NOW()") $dateValue = "NOW()"; else $dateValue = "'".$db->quoteString($this->_dateTime)."'";

        $maDate = new Date();
	    $this->setDateTime($maDate->getDate(DATE_FORMAT_ISO));

        if($this->_articleId == null)   $this->_articleId = 0;

        $query = "INSERT INTO ".$GLOBALS['table_prefix']."_signatures (".SIGNATURE_ALL_FIELDS.") VALUES "
                ."(".$this->_signatureId.", "
                ."".$this->_articleId.", "
                //.$dateValue.", "
                ."'".$db->quoteString($this->_dateTime)."', "
                ."'".$db->quoteString($this->_nomEmail)."', "
                ."'".$db->quoteString($this->_adEmail)."', "
                ."'".$db->quoteString($this->_nomSite)."', "
                ."'".$db->quoteString($this->_urlSite)."', "
                ."'".$db->quoteString($this->_message)."', "
                ."'".$db->quoteString($this->_statut)."', "
                ."'".$db->quoteString($this->_majDate)."')";

         

        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_signature : create()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ update()

    function update() {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_signature : update()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        //if ($this->_dateTime == "NOW()") $dateValue = "NOW()"; else $dateValue = "'".$db->quoteString($this->_dateTime)."'";

        $maDate = new Date();
	    $this->setMajDate($maDate->getDate(DATE_FORMAT_ISO));

        $query = "UPDATE ".$GLOBALS['table_prefix']."_signatures "
                ."SET id_signature = ".$this->_signatureId.", "
                ."id_article = ".$this->_articleId.", date_time = '".$db->quoteString($this->_dateTime)."', "
                ."nom_email = '".$db->quoteString($this->_nomEmail)."', ad_email = '".$db->quoteString($this->_adEmail)."', "
                ."nom_site = '".$db->quoteString($this->_nomSite)."', url_site = '".$db->quoteString($this->_urlSite)."', "
                ."message = '".$db->quoteString($this->_message)."', statut = '".$db->quoteString($this->_statut)."', "
                ."maj = '".$db->quoteString($this->_majDate)."' "
                ."WHERE id_signature = ".$this->_signatureId;

         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_signature : update()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

    }

    // }}}

    // {{{ load()

    function load($idSignature) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_signature : load()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT ".SIGNATURE_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_signatures WHERE id_signature = $idSignature";

         
        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_signature : load()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
            if ($row = $result->fetchRow()) {

                $maDate = new Date($row['maj']);
                $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

                $this->_fetchData($row);
            } else {
                return PEAR::raiseError("[".get_class($this)." DB_signature : load($idSignature)] Aucune signature ne correspond pas  cet ID!", null,
                                    null, null, null, null, false);
            }
            $result->free();
        }
    }

    // }}}

    // {{{ delete()

    function delete($idSignature) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_signature : delete()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_signatures WHERE id_signature = $idSignature";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_signature : delete()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ _fetchData()

    function _fetchData($row) {
        $this->setSignatureId($row['id_signature']);
        $this->setArticleId($row['id_article']);
        $this->setDateTime($row['date_time']);
        $this->setNomEmail($row['nom_email']);
        $this->setAdEmail($row['ad_email']);
        $this->setnomSite($row['nom_site']);
        $this->setUrlSite($row['url_site']);
        $this->setMessage($row['message']);
        $this->setStatut($row['statut']);
        $this->setmajDate($row['maj']);
    }

    // }}}

    // {{{ deleteMajDate($myDate)

    /**
     * This method is used to delete all signatures former to mydate
     * @access  public
     */

    function deleteMajDate($myDate) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_signature : deleteMajDate()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $dateTmp = new Date($mydate);
        $mydate = $dateTmp->getDate(DATE_FORMAT_ISO);

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_signatures WHERE maj < '$myDate'";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_signature : deleteMajDate()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ getAllSignatureIds()

    function getAllSignatureIds() {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_signature : getAllSignatureIds()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT id_signature FROM ".$GLOBALS['table_prefix']."_signatures";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_signature : getAllSignatureIds()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $result->fetchRow()) {    $signatureIds[] = $row['id_signature'];}
        $result->free();
        return $signatureIds;
    }

    // }}}

    // {{{ getAllForStatut($val_confirm)

    /**
     * Returns an array of Signature.
     *
     *
     * @return Array of Signature
     * @param $val_confirm
     * @access public
     */

    function &getAllForStatut($val_confirm) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_signature : getAllForStatut()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT ".SIGNATURE_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_signatures WHERE statut='$val_confirm'";
         
        //echo "<br>$query<br>";        
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_signature : getAllForStatut()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultSignature = &BD_signature::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultSignature->_fetchData($row);

            $result[] = &$resultSignature;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ hasStatut()

    /**
     * This method tests whether or not signatures contains this statut
     * @return  boolean
     * @access  public
     */
    function hasStatut($passw) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_signature : hasStatut()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT statut FROM ".$GLOBALS['table_prefix']."_signatures WHERE statut='$passw'";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_signature : hasStatut()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        $hasStatut = ($result->numRows() > 0);
        $result->free();
        return $hasStatut;
    }

    // }}}

    // {{{ hasArticleIdAndAdEmailAndStatut($id_article, $ad_email, $statut)

    /**
     * This method tests whether or not signatures contains a articleid, ademail and statut
     * @return  boolean
     * @access  public
     */
    function hasArticleIdAndAdEmailAndStatut($id_article, $ad_email, $statut) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_signature : hasArticleIdAndAdEmailAndStatut()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT ".SIGNATURE_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_signatures WHERE id_article=$id_article AND ad_email='$email' AND statut='$statut'";
         
        //echo $query;
        
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_signature : hasArticleIdAndAdEmailAndStatut()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        $hasArticleIdAndAdEmailAndStatut = ($result->numRows() > 0);
        $result->free();
        return $hasArticleIdAndAdEmailAndStatut;
    }

    // }}}

    // {{{ hasArticleIdAndUrlSiteAndStatut($id_article, $site, $statut)

    /**
     * This method tests whether or not signatures contains a articleid, ademail and statut
     * @return  boolean
     * @access  public
     */
    function hasArticleIdAndUrlSiteAndStatut($id_article, $site, $statut) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_signature : hasArticleIdAndUrlSiteAndStatut()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT ".SIGNATURE_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_signatures WHERE id_article=$id_article AND url_site='$site' AND statut='$statut'";
        
         
        //echo '<br>' . $query . '<br>';

        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_signature : hasArticleIdAndUrlSiteAndStatut()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        $hasArticleIdAndUrlSiteAndStatut = ($result->numRows() > 0);
        $result->free();
        return $hasArticleIdAndUrlSiteAndStatut;
    }

    // }}}

    // {{{ hasArticleIdAndUrlSiteAndStatuts($id_article, $site, $statut1, $statut2)

    /**
     * This method tests whether or not signatures contains a articleid, ademail and statut
     * @return  boolean
     * @access  public
     */
    function hasArticleIdAndUrlSiteAndStatuts($id_article, $site, $statut1, $statut2) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_signature : hasArticleIdAndUrlSiteAndStatuts()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT ".SIGNATURE_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_signatures WHERE id_article=$id_article AND url_site='$site' AND (statut='$statut1' OR statut='$statut2')";
         
        //echo '<br>' . $query . '<br>';

        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_signature : hasArticleIdAndUrlSiteAndStatuts()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        $hasArticleIdAndUrlSiteAndStatuts = ($result->numRows() > 0);
        $result->free();
        return $hasArticleIdAndUrlSiteAndStatuts;
    }

    // }}}

    // {{{ howManyArticles($id_article)

    /**
     * This method returns the number of published articles
     * @return  int
     * @access  public
     */
    function howManyArticles($id_article) {
        $howManyArticles = 0;
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_signature : howManyArticles()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

		$query = "SELECT COUNT(*) AS nb FROM ".$GLOBALS['table_prefix']."_signatures WHERE id_article=$id_article";

        $result = $db->getOne($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_signature : howManyArticles()] ".$results->getMessage()."", null,
                null, null, null, null, false);
        } else {
            $howManyArticles = $result;
        }

        return $howManyArticles;
    }

    // }}}

    // {{{ howManySignatureForStatutsAndDateTime($statut1, $statut2, $id_article)

    /**
     * This method returns the number of signature
     * @return  int
     * @access  public
     */
    function howManySignatureForStatutsAndDateTime($statut1, $statut2, $id_article = null) {
        $howManySignatures = 0;
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_signature : howManySignatureForStatutsAndDateTime()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

		$maDate = new Date();
		$maDate->subtractSeconds(intval(180*24*3600));
		$query = "SELECT COUNT(*) AS cnt FROM ".$GLOBALS['table_prefix']."_signatures WHERE (statut='$statut1' OR statut='$statut1') AND date_time > '" . $maDate->getDate(DATE_FORMAT_ISO) . "'";
		//$query = "SELECT COUNT(*) AS cnt FROM ".$GLOBALS['table_prefix']."_signatures WHERE (statut='$statut1' OR statut='$statut1') AND date_time>DATE_SUB(NOW(),INTERVAL 180 DAY)";

        if($id_article != null) $query .= " AND id_article=$id_article";

        $result = $db->getOne($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_signature : howManySignatureForStatutsAndDateTime()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
            $howManySignatures = $result;
        }

        return $howManySignatures;
    }

    // }}}

    // {{{ getAllForStatutsAndArticleId($statut1, $statut2, $debut, $id_article)

    /**
     * This method returns an array of signature
     * @return  int
     * @access  public
     */
    function &getAllForStatutsAndArticleId($statut1, $statut2, $debut, $id_article = null) {
        $result= array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_signature : getAllForStatutsAndArticleId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

		$query = "SELECT ".SIGNATURE_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_signatures WHERE (statut='publie' OR statut='poubelle')";
        if($id_article != null) $query .= " AND id_article=$id_article";
		$query .= " ORDER BY date_time DESC";
         
        //echo $query;

        $queryResult = $db->limitQuery($query, $debut, 10);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_signature : getAllForStatutsAndArticleId()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $queryResult->fetchRow()) {
            $resultSignature = &BD_signature::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultSignature->_fetchData($row);

            $result[] = &$resultSignature;
        }
        $queryResult->free();

        return $result;
    }

    // }}}



    // {{{ deleteForStatutsAndDateTime($statut1, $statut2)

     /**
     * This method is used to delete $statut1 and $statut2 signatures
     * @access  public
     */
    function deleteForStatutsAndDateTime($statut1, $statut2) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_signature : deleteForStatutsAndDateTime()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        $maDate = new Date();
		$maDate->subtractSeconds(intval(10*24*3600));

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_signatures WHERE NOT (statut='$statut1' OR statut='$statut2') AND date_time < '" . $maDate->getDate(DATE_FORMAT_ISO) . "'";
        //$query = "DELETE FROM ".$GLOBALS['table_prefix']."_signatures WHERE NOT (statut='$statut1' OR statut='$statut2') AND date_time<DATE_SUB(NOW(),INTERVAL 10 DAY)";
        
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_signature : deleteForStatutsAndDateTime()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

}
?>