<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Franois Xavier LACROIX <fxlacroix@clever-age.com>           |
// +----------------------------------------------------------------------+
//
// Classe sondage
//

if (defined("_BD_SONDAGE")) return;
    define("_BD_SONDAGE", "1");

require_once "PEAR.php";
require_once "DB.php";
require_once dirname(__FILE__)."/metier.php";
require_once dirname(__FILE__)."/inc_sondage_factory.php";


define("SONDAGE", "id_article, actif, affichage_public");

/**
 * Gestion de la table des sondages (link)
  * @author  Franois Xavier LACROIX <fxlacroix@clever-age.com>
 * @access  public
 */

 class BD_sondage extends BD_metier {
 
    /**
     * $_id_article id.
     * @var    BiGint
     * @access  private
     */
    var $_id_article ;

    /**
     * $_actif.
     * @var     Char(3)
     * @access  private
     */
    var $_actif ;

    /**
     * $_affichage_public
     * @var     Char(3)
     * @access  private
     */
    var $_affichage_public;

  /**
     * DB_sondage constructor.
     *
     * @access public
     */
    // {{{ bdSondage
    function bdSondage() {
    }

    // }}}


    // {{{ getIdArticle()
    function getIdArticle() {
        return $this->_id_article;
    }

    // }}}


    // {{{ setIdArticle()
    function setIdArticle($id_article) {
        $this->_id_article = $id_article;
    }

    // }}}

      // {{{ getActif()
    function getActif() {
        return $this->_actif;
    }

    // }}}


    // {{{ setActif()
    function setActif($actif) {
        $this->_actif = $actif;
    }

    // }}}

    // {{{ getAffichagePublic()
    function getAffichagePublic() {
        return $this->_affichage_public;
    }

    // }}}


    // {{{ setAffichagePublic()
    function setAffichagePublic($affichage_public) {
        $this->_affichage_public = $affichage_public;
    }

    // }}}

    // {{{ Create()
    //Fonction de cration d'un objet dans la table ".$GLOBALS['table_prefix']."_cm_lists_subscribers

    function create() {
       
       //print_r($this);
       
        $db = &$this->_getDB();
    if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_sondage : create()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        if($this->_id_article == null) $this->_id_article = 0;
        if($this->_actif == null) $this->_actif ="" ;
        if($this->_affichage_public == null) $this->_affichage_public = "";
        

         $query = "INSERT INTO ".$GLOBALS['table_prefix']."_sondages  (".SONDAGE.") VALUES "
                ."('".$this->_id_article."', "
                ."'".$this->_actif."', "
                ."'".$this->_affichage_public."')";

        //echo"<br />$query<br><br />";

        $result = $db->query($query);
         if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_sondage : create()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}


        // {{{ load_lst()
        //load_lst() charge un objet de la base par son identifiant lst_id
    
     function loadArticle($id_article) {
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_sondage : loadArticle()] ".$db->getMessage()."", null,
                null, null, null, null, false);
            }

        $query = "SELECT ".SONDAGE." FROM ".$GLOBALS['table_prefix']."_sondages WHERE id_article = $id_article";
         
        $result = $db->query($query);
            
      if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_sondage : loadArticle()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
            if ($row = $result->fetchRow()) {

                $this->_id_article = $row['id_article'];
                $this->_actif = $row['actif'];
                $this->_affichage_public = $row['affichage_public'];

            } else {
                return PEAR::raiseError("[".get_class($this)." DB_sondage : loadArticle()] Aucuns liens associs!", null,
                                    null, null, null, null, false);
            }
            $result->free();
        }

    }
    // }}}
    
    
    // {{{ parametrerSondage()
   //parametrerSondage() verifie les reponse et ajuste la configuration du sondage
    function parametrerSondage($id_article){
        
    $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_sondage : loadArticle()] ".$db->getMessage()."", null,
                null, null, null, null, false);
            }

        $query = "SELECT actif, affichage_public FROM ".$GLOBALS['table_prefix']."_sondages WHERE id_article = $id_article";
         
        $result = $db->query($query);    
      
          if (DB::isError($result)) {
                return PEAR::raiseError("[".get_class($this)." DB_sondage : loadArticle()] ".$result->getMessage()."", null,
                    null, null, null, null, false);
            } else {
                    if ($result->numRows()) {
                            $row = $result->fetchRow();
                            $actif_affiche[0] = $row['actif'];
                            //Bizarre ce $tab!!!
			    //$tab[1] = $row['affichage_public'];
			    $actif_affiche[1] = $row['affichage_public'];
                            
                        } else {
                            $actif_affiche[0] = 'oui';
                            $actif_affiche[1] = 'non';
                            $db->query("INSERT INTO ".$GLOBALS['table_prefix']."_sondages (id_article, actif, affichage_public) VALUES ($id_article, 'oui', 'non')");
                        }
                    return($actif_affiche);
            }
    }

    // {{{ modifierProfile()
   //modifierProfile() modifie les paramtres du sondage
    function modifierProfile($actif,$affichage_public,$id_article){
        
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_sondage : modifierProfile()] ".$db->getMessage()."", null,
                null, null, null, null, false);
            }        
        
        
         $query = "UPDATE ".$GLOBALS['table_prefix']."_sondages SET actif = '$actif', affichage_public = '$affichage_public' WHERE id_article = $id_article";
          
         $result = $db->query($query);
            
         if (DB::isError($result)) {
                return PEAR::raiseError("[".get_class($this)." DB_sondage : modifierProfile()] ".$result->getMessage()."", null,
                    null, null, null, null, false);
            }
    }


  // }}}


      
        // {{{ factory()  
    //Fonction factory pour l'instanciation de l'objet
    
     function &factory($dbParameters, $dbOptions = null) {

        if(file_exists(dirname(__FILE__)."/".$dbParameters->_dbEngine."/sondage_".$dbParameters->_dbEngine.".php") == false) {
            include_once(dirname(__FILE__)."/common/sondage_common.php");
            $classname = "BD_sondage";
        }
        else {
            include_once(dirname(__FILE__)."/".$dbParameters->_dbEngine."/sondage_".$dbParameters->_dbEngine.".php");
            $classname = "BD_sondage_".$dbParameters->_dbEngine;
        }

        if (!class_exists($classname)) {
            return PEAR::raiseError("Cannot instanciate class $classname", null,
                null, null, null, null, false);
        }

        $obj =& new $classname;
        $result = $obj->setDbParameters($dbParameters);
        if ($dbOptions != null) {
            $obj->setDbOptions($dbOptions);
        }
        if (PEAR::isError($result)) {
            return $result;
        } else {
            return $obj;
        }
    }
  
   // }}}

  
     
 }
