<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Franois Xavier LACROIX <fxlacroix@clever-age.com>           |
// +----------------------------------------------------------------------+
//
// Classe sondage _ reponse
//

if (defined("_BD_SONDAGE_REPONSE")) return;
    define("_BD_SONDAGE_REPONSE", "1");

require_once "PEAR.php";
require_once "DB.php";
require_once dirname(__FILE__)."/metier.php";
require_once dirname(__FILE__)."/inc_sondage_reponse_factory.php";

define("SONDAGE_REPONSE", "id_article, id_reponse, texte_reponse, vote");

/**
 *  * Gestion des reponses aux sondage
  * @author  Franois Xavier LACROIX <fxlacroix@clever-age.com>
 * @access  public
 */
 
 class BD_sondage_reponse extends BD_metier {
 
    /**
     * $_id_article id.
     * @var    BiGint
     * @access  private
     */
    var $_id_article ;

    /**
     * $_id_reponse.
     * @var    BiGint
     * @access  private
     */
    var $_id_reponse ;

    /**
     * texte_reponse
     * @var     int
     * @access  private
     */
    var $_texte_reponse;

    /**
     * vote
     * @var     string
     * @access  private
     */
    var $_vote;

  /**
     * DB_sondage_reponse constructor.
     *
     * @access public
     */
    
    // {{{ bdSubscriberLink
    function bdSondageReponse() {
    }

    // }}}

 
    // {{{ getIdArticle()
    function getIdArticle() {
        return $this->_id_article;
    }

    // }}}


    // {{{ setIdArticle()
    function setIdArticle($id) {
        $this->_id_article = $id;
    }

    // }}}

      // {{{ getIdReponse()
    function getIdReponse() {
        return $this->_id_reponse;
    }

    // }}}


    // {{{ setIdReponse()
    function setIdReponse($id_reponse) {
        $this->_id_reponse = $id_reponse;
    }

    // }}}
    



      // {{{ getTexteReponse()
    function getTexteReponse() {
        return $this->_texte_reponse;
    }

    // }}}


    // {{{ setTexteReponse()
    function setTexteReponse($texte_reponse) {
        $this->_texte_reponse = $texte_reponse;
    }

    // }}}.
    
          // {{{ getVote()
    function getVote() {
        return $this->_vote;
    }

    // }}}


    // {{{ setVote()
    function setVote($vote) {
        $this->_vote = $vote;
    }

    // }}}    
    
    
    // {{{ Create()
    //Fonction de cration d'un objet dans la table ".$GLOBALS['table_prefix']."_cm_lists_subscribers

    function create() {
       
       //print_r($this);
       
        $db = &$this->_getDB();
    if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_sondage_reponse : create()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        if($this->_id_article == null) $this->_id_article = 0;
        if($this->_id_reponse == null) $this->_id_reponse = 0;
        if($this->_texte_reponse == null) $this->_texte_reponse = "";
        if($this->_vote == null) $this->_vote = 0;
        

         $query = "INSERT INTO ".$GLOBALS['table_prefix']."_sondages_reponses (".SONDAGE_REPONSE.") VALUES "
                ."('".$this->_id_article."', "
                ."'".$this->_id_reponse."', "
                ."'".$this->_texte_reponse."', "
                ."'".$this->_vote."')";

        //echo"<br />$query<br><br />";

        $result = $db->query($query);
         if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_sondage_reponse : create()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    
        // {{{ load_lst()
        //load_lst() charge un objet de la base par son identifiant lst_id
    
     function loadIdArticle($id_article) {
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_sondage_reponse : loadIdArticle()] ".$db->getMessage()."", null,
                null, null, null, null, false);
            }

        $query = "SELECT ".SUBSCRIBERS_LINK." FROM ".$GLOBALS['table_prefix']."_sondages_reponses WHERE id_article = $id_article";
         
        $result = $db->query($query);
            
      if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_sondage_reponse : loadIdArticle()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
            if ($row = $result->fetchRow()) {

                $this->_id_article = $row['id_article'];
                $this->_id_reponse = $row['id_reponse'];
                $this->_texte_reponse = $row['texte_reponse'];
                $this->_vote = $row['vote'];

            } else {
                return PEAR::raiseError("[".get_class($this)." DB_sondage_reponse : loadIdArticle()] Aucuns liens associs!", null,
                                    null, null, null, null, false);
            }
            $result->free();
        }

    }
    
     // }}}

     // {{{ selectMaxIdReponse()
    //La fonction selectMaxIdReponse() ajoute la nouvelle valeur avec le bon id_reponse (donc recherche du maximum)
    
     function selectMaxIdReponse($id_article,$ajout_reponse) {

        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_sondage_reponse : selectMaxIdReponse()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
       $query = "SELECT MAX(id_reponse) as max FROM ".$GLOBALS['table_prefix']."_sondages_reponses WHERE id_article = $id_article";
       $result = $db->query($query);
            
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_sondage_reponse : selectMaxIdReponse() ] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }            
        else{
            $max = $result->fetchRow();
            $id_reponse = $max['max'];
            while (list(, $reponse) = each($ajout_reponse)) {
			/* ajout Yannick Lepetit le 15/03/2005 pour le problme d'apostrophe dans les rponses */
			$reponse = addslashes($reponse);
			/* fin d'ajout Y. Lepetit */
                if ($reponse != '') {
                    $id_reponse++;
                     $query = "INSERT INTO ".$GLOBALS['table_prefix']."_sondages_reponses (id_article, id_reponse, texte_reponse) VALUES ($id_article, $id_reponse, '$reponse')";
                     $result = $db->query($query);
                }
            }
        }

    }
  
   // }}}

 // {{{ selectMaxIdReponse()
    //La fonction selectMaxIdReponse() ajoute la nouvelle valeur avec le bon id_reponse (donc recherche du maximum)
    
     function verificationDoublon($id_article,$ajout_reponse) {

        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_sondage_reponse : verificationDoublon()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
       $query = "SELECT ".SONDAGE_REPONSE." FROM ".$GLOBALS['table_prefix']."_sondages_reponses WHERE id_article = $id_article AND texte_reponse='$ajout_reponse'";
       $result = $db->query($query);

        if ($row = $result->fetchRow()) {
            return(false);    
        }
        else{
            return(true);
        }            

    }
 
   // }}}


  // {{{ listerReponse()
    //La fonction listerReponse() liste les reponse associ a un sondage (id_article) class par texte_reponse
    
     function listerReponse($id_article) {

        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_sondage_reponse : listerReponse()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
     $query = "SELECT id_reponse, texte_reponse FROM ".$GLOBALS['table_prefix']."_sondages_reponses WHERE id_article = $id_article ORDER BY texte_reponse";
     
     //echo $query;
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_sondage_reponse : listerReponse() ] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        else{
         
         if ($result->numRows()) {
            $compteur=0;
            while ($row = $result->fetchRow()) {
                $tab_rep[$compteur][0] = $row['id_reponse'];
                $tab_rep[$compteur][1] = $row['texte_reponse'];
                $compteur++;
            }
            return($tab_rep);  
         }
        }
    }
  
   // }}}

     // {{{ deletearticleReponse()
    //La fonction deletearticleReponse() supprimer un objet de la base par son id_article et son id_reponse
     function deleteArticleReponse($id_article,$supp_reponse) {

        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_sondage_reponse : deleteArticleReponse()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
     $query = "DELETE FROM ".$GLOBALS['table_prefix']."_sondages_reponses WHERE id_article = $id_article AND id_reponse = $supp_reponse";
     
     //echo $query;
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_sondage_reponse : deleteArticleReponse() ] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }
  
   // }}}



    // {{{ modifierVote()
   //modifierVote() modifie les paramtres du sondage reponse 
    function modifierVote($id_article,$vote){
        
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_sondage_reponse : modifierVote()] ".$db->getMessage()."", null,
                null, null, null, null, false);
            }        
        
        
         $query = "UPDATE ".$GLOBALS['table_prefix']."_sondages_reponses SET votes = $vote WHERE id_article = $id_article";
          
         $result = $db->query($query);
            
         if (DB::isError($result)) {
                return PEAR::raiseError("[".get_class($this)." DB_sondage_reponse : modifierVote()] ".$result->getMessage()."", null,
                    null, null, null, null, false);
            }
    }


  // }}}


    // {{{ calculNbReponse()
   //calculNbReponse() calcul le nombre de reponse pour le sondage de l'article $id_article
    function calculNbReponse($id_article){
        
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_sondage_reponse : calculNbReponse()] ".$db->getMessage()."", null,
                null, null, null, null, false);
            }        
        
         //Modification fxlacroix@clever-age.com (as nb)
        $result = $db->query("SELECT COUNT(*) as nb FROM ".$GLOBALS['table_prefix']."_sondages_reponses WHERE id_article = $id_article");
        //Fin de modification
        $nbReponses = $result->fetchRow();
        $nbReponses = $nbReponses['nb'];
            
         if (DB::isError($result)) {
                return PEAR::raiseError("[".get_class($this)." DB_sondage_reponse : calculNbReponse()] ".$result->getMessage()."", null,
                    null, null, null, null, false);
            }
            
        return($nbReponses);
            
    }


  // }}}


   // {{{ calculNbVote()
   //calculNbVote() calcul le nombre de vote pour le sondage de l'article $id_article
    function calculNbVote($id_article,$vote){
        
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_sondage_reponse : calculNbReponse()] ".$db->getMessage()."", null,
                null, null, null, null, false);
            }        
        
         //Modification fxlacroix@clever-age.com (as nb)
        $query = "SELECT id_reponse, votes FROM ".$GLOBALS['table_prefix']."_sondages_reponses WHERE id_article = $id_article";
         
         $result = $db->query($query);
            
         if (DB::isError($result)) {
                return PEAR::raiseError("[".get_class($this)." DB_sondage_reponse : calculNbReponse()] ".$result->getMessage()."", null,
                    null, null, null, null, false);
            }
         else{
                if ($result->numRows()) {
                    while ($row = $result->fetchRow()) {
                        $vote[$row['id_reponse']] = $row['votes'];
                        $vote['somme'] += $row['votes'];
                    }
                }
           }
           
           return($vote);
    }


  // }}}





        // {{{ factory()  
    //Fonction factory pour l'instanciation de l'objet
    
     function &factory($dbParameters, $dbOptions = null) {

        if(file_exists(dirname(__FILE__)."/".$dbParameters->_dbEngine."/sondage_reponse_".$dbParameters->_dbEngine.".php") == false) {
            include_once(dirname(__FILE__)."/common/sondage_reponse_common.php");
            $classname = "BD_sondage_reponse";
        }
        else {
            include_once(dirname(__FILE__)."/".$dbParameters->_dbEngine."/sondage_reponse_".$dbParameters->_dbEngine.".php");
            $classname = "BD_sondage_reponse_".$dbParameters->_dbEngine;
        }

        if (!class_exists($classname)) {
            return PEAR::raiseError("Cannot instanciate class $classname", null,
                null, null, null, null, false);
        }

        $obj =& new $classname;
        $result = $obj->setDbParameters($dbParameters);
        if ($dbOptions != null) {
            $obj->setDbOptions($dbOptions);
        }
        if (PEAR::isError($result)) {
            return $result;
        } else {
            return $obj;
        }
    }
  
   // }}}

  
     
 }
