<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Franois Xavier LACROIX <fxlacroix@clever-age.com>           |
// +----------------------------------------------------------------------+
//
// Classe sondage _ vote
//

if (defined("_BD_SONDAGE_VOTE")) return;
    define("_BD_SONDAGE_VOTE", "1");

require_once "PEAR.php";
require_once "DB.php";
require_once dirname(__FILE__)."/metier.php";
require_once dirname(__FILE__)."/inc_sondage_vote_factory.php";

define("SONDAGE_VOTE", "vote, actif, id_article,email_votant,date_time,id_reponse,statut");
/**
 * Gestion des votes aux sondage
  * @author  Franois Xavier LACROIX <fxlacroix@clever-age.com>
 * @access  public
 */

 class BD_sondage_vote extends BD_metier {
 
      /**
     * id_article id.
     * @var    BiGint
     * @access  private
     */
    var $_id_article ;

    /**
     * email_votant.
     * @var    Char
     * @access  private
     */
    var $_email_votant ;

    /**
     * date_time
     * @var     DATE
     * @access  private
     */
    var $_date_time;

    /**
     * id_reponse
     * @var     BiGint
     * @access  private
     */
    var $_id_reponse;

    /**
     * statut
     * @var     char
     * @access  private
     */
    var $_statut;
    
  /**
     * DB_sondage_vote constructor.
     *
     * @access public
     */
    // {{{ bdSondageVote
    function bdSondageVote() {
    }

    // }}}


    // {{{ getIdArticle()
    function getIdArticle() {
        return $this->_id_article;
    }

    // }}}


    // {{{ setIdArticle()
    function setIdArticle($id_article) {
        $this->_id_article = $id_article;
    }

    // }}}

    // {{{ getEmail()
    function getEmail() {
        return $this->_email_votant;
    }

    // }}}


    // {{{ setEmail()
    function setEmail($email) {
        $this->_email_votant = $email;
    }

    // }}}

    // {{{ getDateTime()
    function getDateTime() {
        return $this->_date_time;
    }

    // }}}


    // {{{ setDateTime()
    function setDateTime($date) {
        $this->_date_time = $date;
    }

    // }}}


    // {{{ getIdReponse()
    function getIdReponse() {
        return $this->_id_reponse;
    }

    // }}}


    // {{{ setIdReponse()
    function setIdReponse($id_reponse) {
        $this->_id_reponse = $id_reponse;
    }

    // }}}

    // {{{ getStatut()
    function getStatut() {
        return $this->_statut;
    }

    // }}}


    // {{{ setStatut()
    function setStatut($statut) {
        $this->_statut = $statut;
    }

    // }}}

    // {{{ Create()
    //Fonction de cration d'un objet dans la table ".$GLOBALS['table_prefix']."_sondages_votes

    function create() {
       
       //print_r($this);
       
        $db = &$this->_getDB();
    if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_sondage_vote : create()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        if($this->_id_article == null) $this->_id_article = 0;
        if($this->_email_votant == null) $this->_email_votant = "";
        if($this->_date_time == null) $this->_date_time = "";
        if($this->_id_reponse == null) $this->_id_reponse = 0;
        if($this->_statut == null) $this->_statut = "";


         $query = "INSERT INTO ".$GLOBALS['table_prefix']."_sondages_votes (".SONDAGE_VOTE.") VALUES "
                ."('".$this->_id_article."', "
                ."'".$this->_email_votant."', "
                ."'".$this->_date_time."', "
                ."'".$this->_id_reponse."', "                
                ."'".$this->_statut."')";
   
        //echo"<br />$query<br><br />";

        $result = $db->query($query);
         if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_sondage_vote : create()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

   
        // {{{ loadIdArticle()
        //loadIdArticle() charge un objet de la base par son identifiant id_article
    
     function loadIdArticle($lst_id) {
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_sondage_vote : loadIdArticle()] ".$db->getMessage()."", null,
                null, null, null, null, false);
            }

        $query = "SELECT ".SUBSCRIBERS_LINK." FROM ".$GLOBALS['table_prefix']."_cm_lists_subscribers WHERE lst_id = $lst_id";
         
        $result = $db->query($query);
            
      if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_sondage_vote : loadIdArticle()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
            if ($row = $result->fetchRow()) {

                $this->_id_article = $row['id_article'];
                $this->_email_votant = $row['email_votant'];
                $this->_date_time = $row['date_time'];
                $this->_id_reponse = $row['id_reponse'];
                $this->_statut = $row['statut'];
                
            } else {
                return PEAR::raiseError("[".get_class($this)." DB_sondage_vote : loadIdArticle()] Aucuns liens associs!", null,
                                    null, null, null, null, false);
            }
            $result->free();
        }

    }
    
     // }}}


     // {{{ deleteArticleVote()
    //La fonction deletearticleReponse() supprimer un objet de la base par son id_article et son id_reponse
    
     function deleteArticleVote($id_article) {
        
        if($id_article =='') $lst_id =$this->getIdArticle();

        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_sondage_vote : deleteArticleVote()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
     $query = "DELETE FROM ".$GLOBALS['table_prefix']."_sondages_votes WHERE id_article = $id_article";
     
     //echo $query;
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_sondage_vote : deleteArticleVote() ] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }
  
   // }}}

     
        // {{{ factory()  
    //Fonction factory pour l'instanciation de l'objet
    
     function &factory($dbParameters, $dbOptions = null) {

        if(file_exists(dirname(__FILE__)."/".$dbParameters->_dbEngine."/sondage_vote_".$dbParameters->_dbEngine.".php") == false) {
            include_once(dirname(__FILE__)."/common/sondage_vote_common.php");
            $classname = "BD_sondage_vote";
        }
        else {
            include_once(dirname(__FILE__)."/".$dbParameters->_dbEngine."/sondage_vote_".$dbParameters->_dbEngine.".php");
            $classname = "BD_sondage_vote_".$dbParameters->_dbEngine;
        }

        if (!class_exists($classname)) {
            return PEAR::raiseError("Cannot instanciate class $classname", null,
                null, null, null, null, false);
        }

        $obj =& new $classname;
        $result = $obj->setDbParameters($dbParameters);
        if ($dbOptions != null) {
            $obj->setDbOptions($dbOptions);
        }
        if (PEAR::isError($result)) {
            return $result;
        } else {
            return $obj;
        }
    }
  
   // }}}

  
     
 }
